new Vue({
    el: '#appTipoDocumentos',
    data: {
        titulo: '',
        accion: '',
        tipoDocumentos: {},
        dataForm: { 'id': '', 'codigo': '', 'descripcion': '', 'predeterminado': 0 },
        errorForm: [],
    },
    created() {
        this.obtenerTipoDeDocumentos();
    },
    methods: {
        obtenerTipoDeDocumentos() {
            axios.get('tipodocumentos/obtenerTipoDeDocumentos').then(response => {
                this.tipoDocumentos = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_tipo_documento').reset();
            this.dataForm.id = '';
            this.dataForm.codigo = '';
            this.dataForm.predeterminado = 0;
            this.dataForm.descripcion = '';
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Agregar Tipo de Documento';
            this.accion = 'Guardar';
            $('#modal_documento').modal('show');
            $('#modal_documento').on('shown.bs.modal', function () {
                $('#tipodoccodigo').trigger('focus');
            });
        },
        ver(id, codigo, descripcion, predeterminado) {
            this.errorForm = [];
            this.dataForm.id = id;
            this.dataForm.codigo = codigo;
            this.dataForm.descripcion = descripcion;
            this.dataForm.predeterminado = predeterminado;
            this.titulo = 'Editar Tipo de Documento';
            this.accion = 'Actualizar';
            $('#modal_documento').modal('show');
        },
        editarGuardar: function (e) {

            this.errorForm = [];

            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es requerido');
            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Descripción es requerido');
            if (!Number.isInteger(Number(this.dataForm.predeterminado)))
                this.errorForm.push('El campo Predeterminado es requerido');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'tipodocumentos/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal_documento').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Tipo de documento actualizado correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Tipo de documento registrado correctamente', 'success');
                            }
                            this.obtenerTipoDeDocumentos();
                            this.resetearFormulario();
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en operación', 'danger');
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        modificarEstatus(id) {
            axios.get('tipodocumentos/modificarEstatus/' + id).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerTipoDeDocumentos();
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Tipo de Documento',
                text: "¿Estás seguro de eliminar el tipo de documento " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('tipodocumentos/eliminar/' + id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerTipoDeDocumentos();
                                notificacion('fa fa-trash', 'Tipo de documento eliminado', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});