Vue.component('v-select', VueSelect.VueSelect)

new Vue({
    el: '#appStockTransferencia',
    data: {
        optionsProductos: [],
        dataForm: { 'ptr_id': '', 'alm_origen': '', 'alm_destino': '', 'observaciones': '', 'producto': '', 'cantidad': 1 },
        errorForm: [],
        cargando: false,
        transferencia_detalle: '',
        transferencia_producto_detalle: []
    },
    methods: {
        obtenerProductos() {
            axios.get('stock/obtenerProductos/' + Number(this.dataForm.alm_origen)).then(response => {
                this.optionsProductos = response.data;
            }).catch(e => notificacion())
        },
        guardar() {

            this.errorForm = [];

            if (!this.dataForm.alm_origen)
                this.errorForm.push('El campo Almacén Origen es obligatorio.');
            if (!this.dataForm.alm_destino)
                this.errorForm.push('El campo Almacén Destino es obligatorio.');
            if (!this.dataForm.producto)
                this.errorForm.push('El campo Producto es obligatorio.');
            if (!this.dataForm.cantidad)
                this.errorForm.push('El campo Cantidad es obligatorio.');
            if (this.dataForm.alm_origen && this.dataForm.alm_destino) {
                if (this.dataForm.alm_origen === this.dataForm.alm_destino) {
                    this.errorForm.push('El almacén de destino no puede ser el mismo almacén de origen.');
                }
            }

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'stock/guardar_transferencia',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.dataForm.ptr_id = response.data;
                        if (this.dataForm.ptr_id) {
                            this.obtenerDetalleTransferencia();
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => {
                    notificacion()
                }).finally(() => this.cargando = false);
            }
        },
        obtenerDetalleTransferencia() {
            axios.get('stock/obtenerDetalleTransferencia/' + Number(this.dataForm.ptr_id)).then(response => {
                if (response.data.errors == null) {
                    this.transferencia_detalle = response.data.transferencia_detalle;
                    this.transferencia_producto_detalle = response.data.transferencia_producto_detalle;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => this.cargando = false);
        },
        procesarTransferencia() {
            this.cargando = true;
            axios.get('stock/procesarTransferencia/' + Number(this.dataForm.ptr_id)).then(response => {
                if (response.data.errors == null) {
                    if (response.data = true) {
                        location.href = `${baseURL}stock/detalle_transferencia/${this.dataForm.ptr_id}`;
                    } else {
                        notificacion('fa fa-ban', 'Estatus', 'Error en proceso', 'danger');
                    }
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => this.cargando = false);
        }
    }
});