new Vue({
    el: '#appStockTransferenciaDetalle',
    data: {
        ptr_id: document.getElementById('id_ptr').value,
        transferencia_detalle: '',
        transferencia_producto_detalle: [],
        cargando: 'is-loading is-loading-lg',
        btn_load: 'false'
    },
    created() {
        this.obtenerDetalleTransferencia();
    },
    methods: {
        obtenerDetalleTransferencia() {
            axios.get('stock/obtenerDetalleTransferencia/' + Number(this.ptr_id)).then(response => {
                if (response.data.errors == null) {
                    this.transferencia_detalle = response.data.transferencia_detalle;
                    this.transferencia_producto_detalle = response.data.transferencia_producto_detalle;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => this.cargando = '');
        },
        procesarTransferencia() {
            Swal.fire({
                title: '¿Procesar transferencia?',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    this.btn_load = true;
                    axios.get('stock/aprobarTransferencia/' + this.ptr_id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data = true) {
                                notificacion('fa fa-info', '', 'Transferencia realizada exitosamente', 'info');
                                location.href = baseURL + 'productos';
                            } else {
                                notificacion('fa fa-ban', '', 'Error al denegar', 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                            }
                        }
                    }).catch(e => notificacion()).finally(() => this.btn_load = false);
                }
            });
        },
        negarTransferencia() {
            Swal.fire({
                title: '¿Negar transferencia?',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    this.btn_load = true;
                    axios.get('stock/negarTransferencia/' + this.ptr_id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data = true) {
                                notificacion('fa fa-trash', '', 'Transferencia negada', 'danger');
                                location.href = baseURL + 'productos';
                            } else {
                                notificacion('fa fa-ban', '', 'Error al denegar', 'danger');
                            }
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => this.btn_load = false);
                }
            });
        }
    }
});