Vue.component("v-select", VueSelect.VueSelect);

moment.locale("es", {
  months: "Enero_Febrero_Marzo_Abril_Mayo_Junio_Julio_Agosto_Septiembre_Octubre_Noviembre_Diciembre".split("_"),
  monthsShort: "Enero._Feb._Mar_Abr._May_Jun_Jul._Ago_Sept._Oct._Nov._Dec.".split("_"),
  weekdays: "Domingo_Lunes_Martes_Miercoles_Jueves_Viernes_Sabado".split("_"),
  weekdaysShort: "Dom._Lun._Mar._Mier._Jue._Vier._Sab.".split("_"),
  weekdaysMin: "Do_Lu_Ma_Mi_Ju_Vi_Sa".split("_"),
  calendar: {
    sameDay: function () {
      return "[hoy a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    nextDay: function () {
      return "[mañana a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    nextWeek: function () {
      return "dddd [a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    lastDay: function () {
      return "[ayer a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    lastWeek: function () {
      return "[el] dddd [pasado a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    sameElse: "L",
  },
});

new Vue({
  el: "#appSMS",
  data: {
    sms: [],
    email: [],
    clientes: [],
    selected_cli: [],
    clientesBuscar: [],
    contactos: [],
    mensajes: [],
    bitacora: [],
    cargando: false,
    emailDesign: "",
    errorForm: [],
    mostrarRangosFechaIntervalos: true,
    variables: [],
    intervalos: [],
    msjSimple:[],
    msjservicios:[],
    msjdocumentos:[],
    emailSimple:[],
    emailservicios:[],
    emaildocumentos:[]
  },
  created() {
    this.obtenerSMS();
    this.obtenerEMAIL();
  },
  mounted() {
    document.getElementById("cliFechaDesde").value = moment().format("YYYY-MM-DD");

    let self = this;

    $("#modalEMAIL").on("hidden.bs.modal", function (e) {
      self.errorForm = [];
      document.getElementById("formEMAIL").reset();
      document.getElementById("emailID").value = "";
      self.emailDesign = "";
    });

    $("#modalSMS").on("hidden.bs.modal", function (e) {
      self.errorForm = [];
      document.getElementById("formSMS").reset();
      document.getElementById("smsID").value = "";
      document.getElementById("caracteresSMS").innerHTML = 0;
    });

    $("#modalCliente").on("hidden.bs.modal", function (e) {
      self.resetearFormClienteMensaje();
    });
  },
  methods: {
    async obtenertodosmsj(){
      axios
        .get("sms/obtenerMensajesTodos")
        .then((response) => {
          this.msjSimple=response.data.mensajes;
          this.msjservicios=response.data.servicios;
          this.msjdocumentos=response.data.documentos;
          this.enviarmsjsimples();
          this.enviarmsjservicios();
          this.enviarmsjdocumentos();
        })
        .catch((e) => notificacion())
        .finally(() => {
         
        });
    },
    async obtenertodosemail(){
      axios
        .get("sms/obtenerEmailTodos")
        .then((response) => {
          this.emailSimple=response.data.mensajes;
          this.emailservicios=response.data.servicios;
          this.emaildocumentos=response.data.documentos;
          this.enviaremailsimples();
          this.enviaremailservicios();
          this.enviaremaildocumentos();
        })
        .catch((e) => notificacion())
        .finally(() => {
         
        });
    },
    async enviarmsjsimples(){
      if (Object.keys(this.msjSimple).length > 0) {
        for (let item of this.msjSimple) {
          await axios
            .get("sms/cronSMSmensajes/" + item.id)
            .then((response) => {
              if (response.data==true) {
                notificacion("fa fa-check", "", item.cliente + " Mensaje enviado", "success");
              }else{
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-times", "Informacion", response.data.errors[i]+" del cliente "+item.cliente, "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
             
            });
        }
      }
    },
    async enviarmsjservicios(){
      if (Object.keys(this.msjservicios).length > 0) {
        for (let item of this.msjservicios) {
          await axios
            .get("sms/cronSMSservicios/" + item.id)
            .then((response) => {
              if (response.data==true) {
                notificacion("fa fa-check", "", item.cliente + " Mensaje enviado", "success");
              }else{
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-times", "Informacion", response.data.errors[i]+" del cliente "+item.cliente, "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
             
            });
        }
      }
    },
    async enviarmsjdocumentos(){
      if (Object.keys(this.msjdocumentos).length > 0) {
        for (let item of this.msjdocumentos) {
          await axios
            .get("sms/cronSMSdocumentos/" + item.id)
            .then((response) => {
              if (response.data==true) {
                notificacion("fa fa-check", "", item.cliente + " Mensaje enviado", "success");
              }else{
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-times", "Informacion", response.data.errors[i]+" del cliente "+item.cliente, "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
             
            });
        }
      }
    },
    async enviaremailsimples(){
      if (Object.keys(this.emailSimple).length > 0) {
        for (let item of this.emailSimple) {
          await axios
            .get("sms/cronEMAILmensajes/" + item.id)
            .then((response) => {
              if (response.data==true) {
                notificacion("fa fa-check", "", item.cliente + " Email enviado", "success");
              }else{
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-times", "Informacion", response.data.errors[i]+" del cliente "+item.cliente, "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
             
            });
        }
      }
    },
    async enviaremailservicios(){
      if (Object.keys(this.emailservicios).length > 0) {
        for (let item of this.emailservicios) {
          await axios
            .get("sms/cronEMAILservicios/" + item.id)
            .then((response) => {
              if (response.data==true) {
                notificacion("fa fa-check", "", item.cliente + " Email enviado", "success");
              }else{
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-times", "Informacion", response.data.errors[i]+" del cliente "+item.cliente, "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
             
            });
        }
      }
    },
    async enviaremaildocumentos(){
      if (Object.keys(this.msjdocumentos).length > 0) {
        for (let item of this.msjdocumentos) {
          await axios
            .get("sms/cronEMAILdocumentos/" + item.id)
            .then((response) => {
              if (response.data==true) {
                notificacion("fa fa-check", "", item.cliente + " Email enviado", "success");
              }else{
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-times", "Informacion", response.data.errors[i]+" del cliente "+item.cliente, "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
             
            });
        }
      }
    },
    async obtenerSMS() {
      $("#tabla_sms").DataTable().destroy();
      axios
        .get("sms/obtenerSMS")
        .then((response) => {
          this.sms = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          $("#tabla_sms").DataTable({
            retrieve: true,
            order: [],
          });
        });
    },
    async obtenerEMAIL() {
      $("#tabla_email").DataTable().destroy();
      axios
        .get("sms/obtenerEMAIL")
        .then((response) => {
          this.email = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          $("#tabla_email").DataTable({
            retrieve: true,
            order: [],
          });
        });
    },
    async guardarSMS() {
      this.errorForm = [];

      let formSMS = document.getElementById("formSMS");

      let formData = new FormData(formSMS);

      axios({
        method: "post",
        url: "sms/guardarSMS",
        data: formData,
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data === true) {
              this.obtenerSMS();
              if (formData.get("smsID")) {
                $("#modalSMS").modal("hide");
                notificacion("fa fa-info", "Actualización", "Actualizacion exitoso", "info");
              } else {
                notificacion("fa fa-check", "Registro", "Registro exitoso", "success");
              }
              document.getElementById("formSMS").reset();
              document.getElementById("smsID").value = "";
            }
          } else {
            this.errorForm = response.data.errors;
          }
        })
        .catch((e) => notificacion());
    },
    modalSMS(){
      $("#modalSMS").modal("show");
      this.variables=[];
    },
    modalEMAIL(){
      $("#modalEMAIL").modal("show");
      this.variables=[];
    },
    verSMS(sms) {
      document.getElementById("smsID").value = sms.id;
      document.getElementById("smsTitulo").value = sms.titulo;
      document.getElementById("smsCuerpo").value = sms.cuerpo;
      document.getElementById("smsModulo").value = sms.modulo;

      if (sms.modulo == 2) {
        this.variables = ["$servicio", "$estatus_nuevo"];
      } else if (sms.modulo!= 2 && sms.modulo!=1) {
        this.variables = ['$documentos','$monto','$total_documentos'];
      }else{
        this.variables = [];
      }

      $("#modalSMS").modal("show");
    },
    async cambiarEstatusSMS(sms) {
      axios
        .get("sms/cambiarEstatusSMS/" + sms.id)
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data === true) {
              sms.estatus = !sms.estatus;
            } else {
              notificacion("fa fa-ban", "Error", "Error al cambiar estatus", "danger");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    async guardarEMAIL() {
      this.errorForm = [];

      let formEMAIL = document.getElementById("formEMAIL");

      let formData = new FormData(formEMAIL);

      axios({
        method: "post",
        url: "sms/guardarEMAIL",
        data: formData,
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data === true) {
              this.obtenerEMAIL();
              if (formData.get("emailID")) {
                $("#modalEMAIL").modal("hide");
                notificacion("fa fa-info", "Actualización", "Actualizacion exitoso", "info");
              } else {
                notificacion("fa fa-check", "Registro", "Registro exitoso", "success");
              }
              document.getElementById("formEMAIL").reset();
              document.getElementById("emailID").value = "";
              this.emailDesign = "";
            }
          } else {
            this.errorForm = response.data.errors;
          }
        })
        .catch((e) => notificacion());
    },
    verEMAIL(email) {
      document.getElementById("emailID").value = email.id;
      document.getElementById("emailTitulo").value = email.titulo;
      document.getElementById("emailCuerpo").value = email.cuerpo;
      document.getElementById("emailModulo").value = email.modulo;
      this.emailDesign = email.cuerpo;

      if (email.modulo == 2) {
        this.variables = ["$servicio", "$estatus_nuevo"];
      } else if (email.modulo!= 2 && email.modulo!=1) {
        this.variables =  ['$documentos','$monto','$total_documentos'];
      }else{
        this.variables = [];
      }
      $("#modalEMAIL").modal("show");
    },
    async cambiarEstatusEMAIL(email) {
      axios
        .get("sms/cambiarEstatusEMAIL/" + email.id)
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data === true) {
              email.estatus = !email.estatus;
            } else {
              notificacion("fa fa-ban", "Error", "Error al cambiar estatus", "danger");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    eliminarEMAIL(email) {
      Swal.fire({
        title: "Eliminar EMAIL",
        text: "¿Estás seguro de querer eliminar la plantilla del email " + email.titulo + " ?",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#aaa",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Eliminar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("sms/eliminarSMS/" + email.id)
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  const posicion = this.email.findIndex((item) => item.id == email.id);
                  this.email.splice(posicion, 1);
                  notificacion("fa fa-trash", "Email eliminado", email.titulo.toUpperCase(), "danger");
                } else {
                  notificacion("fa fa-ban", "Error al eliminar", email.titulo.toUpperCase(), "danger");
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion());
        }
      });
    },
    eliminarSMS(sms) {
      Swal.fire({
        title: "Eliminar SMS",
        text: "¿Estás seguro de querer eliminar la plantilla del sms " + sms.titulo + " ?",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#aaa",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Eliminar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("sms/eliminarSMS/" + sms.id)
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  const posicion = this.sms.findIndex((item) => item.id == sms.id);
                  this.sms.splice(posicion, 1);
                  notificacion("fa fa-trash", "SMS eliminado", sms.titulo.toUpperCase(), "danger");
                } else {
                  notificacion("fa fa-ban", "Error al eliminar", sms.titulo.toUpperCase(), "danger");
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion());
        }
      });
    },
    mensajeDeTexto(event) {
      document.getElementById("caracteresSMS").innerHTML = event.target.value.length;
    },
    emailDesignHTML(event) {
      this.emailDesign = event.target.value;
    },
    onSearch(search, loading) {
      if (search.trim().length > 3) {
        loading(true);
        this.search(loading, search, this);
      }
    },
    search: _.debounce((loading, search, vm) => {
      axios
        .get("sms/buscarCliente/", {
          params: {
            buscar: search,
          },
        })
        .then((response) => {
          vm.clientesBuscar = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => loading(false));
    }, 350),
    buscarContactos() {
      axios
        .get("sms/obtenerContactos/" + this.selected_cli.id)
        .then((response) => {
          this.contactos = response.data;
        })
        .catch((e) => notificacion());
    },
    vaciarSelectContactoMensaje() {
      document.getElementById("cliModulo").selectedIndex = 0;
      document.getElementById("cliMensaje").selectedIndex = 0;
      this.mensajes = [];
    },
    buscarMensajesSegunTipo() {
      const tipo = document.getElementById("cliTipoMensaje").value;
      const modulo = document.getElementById("cliModulo").value;

      if (modulo == 2) {
        this.mostrarRangosFechaIntervalos = false;
      } else {
        this.mostrarRangosFechaIntervalos = true;
      }

      if (tipo && modulo) {
        axios
          .get("sms/buscarMensajesSegunTipo/", {
            params: {
              tipo: tipo,
              modulo: modulo,
            },
          })
          .then((response) => {
            this.mensajes = response.data;
          })
          .catch((e) => notificacion());
      } else {
        this.mensajes = [];
      }
    },
    resetearFormClienteMensaje() {
      this.errorForm = [];
      document.getElementById("formCliente").reset();
      document.getElementById("cliID").value = "";
      //document.getElementById("cliIntervaloNum").innerHTML = 1;
      this.clientesBuscar = [];
      this.selected_cli = {};
      this.contactos = [];
      this.mensajes = [];
      this.mostrarRangosFechaIntervalos = true;
    },
    async obtenerContactosMensajes() {
      $("#tabla_clientes").DataTable().destroy();
      await axios
        .get("sms/obtenerContactosMensajes")
        .then((response) => {
          this.clientes = response.data;
        })
        .catch((e) => notificacion());
      $("#tabla_clientes").DataTable({
        responsive: true,
        retrieve: true,
        order: [],
        columnDefs: [
          { visible: false, targets: 3 },
          { visible: false, targets: 4 },
        ],
        dom: "Bfrtip",
        buttons: [
          {
            extend: "colvis",
            text: "Columnas",
            columns: [3, 4],
          },
        ],
      });
    },
    guardarContactoMensaje() {
      this.errorForm = [];

      const formCliente = document.getElementById("formCliente");
      const formData = new FormData(formCliente);

      axios({
        method: "post",
        url: "sms/guardarContactoMensaje",
        data: formData,
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data === true) {
              this.obtenerContactosMensajes();
              if (formData.get("cliID")) {
                $("#modalCliente").modal("hide");
                notificacion("fa fa-info", "Actualización", "Actualizacion exitoso", "info");
              } else {
                notificacion("fa fa-check", "Registro", "Registro exitoso", "success");
              }
              this.resetearFormClienteMensaje();
            }
          } else {
            this.errorForm = response.data.errors;
          }
        })
        .catch((e) => notificacion());
    },
    async eliminarContactoMensaje(cm) {
      const result = await Swal.fire({
        title: "Eliminar Contacto/Mensaje",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#aaa",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Eliminar",
      }).then((result) => result.value);

      if (result) {
        $("#tabla_clientes").DataTable().destroy();
        await axios
          .get("sms/eliminarContactoMensaje/" + cm.id)
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                const posicion = this.clientes.findIndex((item) => item.id == cm.id);
                this.clientes.splice(posicion, 1);
                notificacion("fa fa-trash", "", "Eliminado", "danger");
              } else {
                notificacion("fa fa-ban", "", "Error al eliminar", "warning");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
        $("#tabla_clientes").DataTable({
          responsive: true,
          retrieve: true,
          order: [],
          columnDefs: [
            { visible: false, targets: 3 },
            { visible: false, targets: 4 },
          ],
          dom: "Bfrtip",
          buttons: [
            {
              extend: "colvis",
              text: "Columnas",
              columns: [3, 4],
            },
          ],
        });
      }
    },
    async verMensajeContacto(msj) {
      const datos = await axios
        .get("sms/verMensajeContacto/" + msj.id)
        .then((response) => {
          this.clientesBuscar = response.data.cliente;
          this.contactos = response.data.contactos;
          this.mensajes = response.data.mensajes;
          this.selected_cli = {
            id: response.data.cliente[0].id,
            cliente: response.data.cliente[0].cliente,
            dni: response.data.cliente[0].dni,
          };
          return response.data;
        })
        .catch((e) => notificacion());

      document.getElementById("cliID").value = msj.id;
      document.getElementById("cliContacto").value = datos.id_contacto;
      document.getElementById("cliTipoMensaje").value = datos.id_tipo;
      document.getElementById("cliModulo").value = datos.modulo;
      document.getElementById("cliMensaje").value = datos.id_mensaje;
      document.getElementById("cliFechaDesde").value = datos.fecha_desde;
      document.getElementById("cliFechaHasta").value = datos.fecha_hasta;
      document.getElementById("cliIntervalo").value = datos.intervalo;
      document.getElementById("cliIntervaloNum").innerHTML = datos.intervalo;
      if (datos.modulo == 2) {
        this.mostrarRangosFechaIntervalos = false;
      } else {
        this.mostrarRangosFechaIntervalos = true;
      }
      $("#modalCliente").modal("show");
    },
    async cronSMS() {
      axios.defaults.timeout = 9000000;
      const btn = document.getElementById("cronSMS");
      btn.disabled = true;
      btn.classList.add("is-loading");
      axios
        .get("sms/cronSMS")
        .then((response) => {
          console.log(response.data)
          if (response.data.errors) {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          } else {
            notificacion("fa fa-info", "", "Proceso ejecutado", "info");
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          btn.disabled = false;
          btn.classList.remove("is-loading");
        });
    },
    async cronEMAIL() {
      axios.defaults.timeout = 9000000;
      const btn = document.getElementById("cronEMAIL");
      btn.disabled = true;
      btn.classList.add("is-loading");
      axios
        .get("sms/cronEMAIL")
        .then((response) => {
          if (response.data.errors) {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          } else {
            notificacion("fa fa-info", "", "Proceso ejecutado", "info");
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          btn.disabled = false;
          btn.classList.remove("is-loading");
        });
    },
    async obtenerBitacora() {
      $("#tabla_bitacora").DataTable().destroy();
      axios
        .get("sms/bitacora")
        .then((response) => {
          this.bitacora = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          $("#tabla_bitacora").DataTable({
            retrieve: true,
            order: [],
          });
        });
    },
    verDetalleMensaje(row) {
      document.getElementById("detalleTitulo").innerHTML = row.titulo;
      document.getElementById("detalleCuerpo").innerHTML = row.cuerpo;
      document.getElementById("detalleDestinatario").innerHTML = row.contacto;
      document.getElementById("detalleFecha").innerHTML = row.fecha;
      $("#modalDetalle").modal("show");
    },
    tipoModulo(tipo) {
      let ver = "";
      if (tipo == 1) {
        ver = "Mensajes";
      } else if (tipo == 2) {
        ver = "Servicios";
      } else {
        ver = "Documentos";
      }
      return ver;
    },
    selectModulo(event) {
      const tipo = event.target.value;
      if (tipo == 2) {
        this.variables = ["$servicio", "$estatus_nuevo"];
      } else if (tipo != 2 && tipo!=1) {
        this.variables = ['$documentos','$monto','$total_documentos'];
      }else{
        this.variables = [];
      }
    },
    colocarVariable(variable, tipo) {
      const area_texto = tipo == 2 ? document.getElementById("emailCuerpo") : document.getElementById("smsCuerpo");
      area_texto.focus();
      const texto = area_texto.value;
      const fin_texto = texto.length;

      let inicio = area_texto.selectionStart;
      let fin = area_texto.selectionEnd;

      inicio = texto.slice(0, inicio);
      fin = texto.slice(fin, fin_texto);

      if (tipo == 2) {
        variable = "<strong>" + variable + "</strong>";
      }

      area_texto.value = inicio + variable + fin;
    },
    tiempo() {
      this.intervalos = [];
      let fechaDesde = document.getElementById("cliFechaDesde").value;
      const fechaHasta = document.getElementById("cliFechaHasta").value;
      let intervalo = document.getElementById("cliIntervalo").value;
      const divTiempo = document.getElementById("divTiempo");

      let [anioD, mesD, diaD] = fechaDesde.split("-");
      let [anioH, mesH, diaH] = fechaHasta.split("-");

      newDateFechaDesde = new Date([anioD, mesD, diaD]);
      newDateFechaHasta = new Date([anioH, mesH, diaH]);
      copiaNewDateFechaDesde = newDateFechaDesde;

      if (fechaDesde && fechaHasta && intervalo) {
        intervalo = parseInt(intervalo);

        if (newDateFechaDesde.getTime() <= newDateFechaHasta.getTime()) {
          dias = moment(fechaHasta).diff(moment(fechaDesde), "days");

          if (dias == 0) {
            this.intervalos.push(moment(fechaDesde).format("DD-MM-YYYY"));
          } else {
            this.intervalos.push(moment(fechaDesde).format("DD-MM-YYYY"));

            for (let i = 0; i < dias; i++) {
              copiaNewDateFechaDesde.setDate(copiaNewDateFechaDesde.getDate() + intervalo);
              if (copiaNewDateFechaDesde.getTime() >= newDateFechaHasta.getTime()) {
                break;
              }
              this.intervalos.push(moment(copiaNewDateFechaDesde).format("DD-MM-YYYY"));
            }
          }
        }
      }

      //moment(value).format("DD-MM-YYYY");

      //fecha = fecha_desde.getTime();
      //timeFechaHasta = fecha_hasta.getTime();

      //fecha = moment(fecha_desde).add(1, "days");

      //console.log(moment(fecha).format());

      /*
      while (fecha <= timeFechaHasta) {
        fecha = moment(fecha).add(1, "days")  ;
      }var resultado = fechauno.getTime() === fechados.getTime();

      moment().diff(moment());
      if (!fecha_hasta) {
        divTiempo.innerHTML = "Indefinido";
      } else {
        divTiempo.innerHTML = moment(fecha_hasta).diff(moment(fecha_desde), "days");
      }

      for (const i of intervalo) {
      }

      moment().add(1, "days").calendar();

      this.intervalos;*/
    },
  },
});
