Vue.component('v-select', VueSelect.VueSelect);
var currentFocus;

new Vue({
  el: "#appPuntodeVenta",
  data: {
    id_factura: document.getElementById('id_fac').value,
    mes: 0,
    nuevos: [],
    pendientes: [],
    completados: [],
    cargando_cne:false,
    id_orden_temporal: "",
    filtro: 1,
    lineas: [],
    documento: document.getElementById('id_tipo').value,
    formDocumentos: { 'id_factura': '', 'descripcion': '', 'documento': '' ,'tipo':''},
    documentosAdjunto:[],
    clientes: [],
    selected_cli: '',
    dataForm: {
      'tipo': '',
      'cli_tipodoc': 2,
      'cli_dni': '',
      'cli_razon_social': '',
      'cli_fecha_nac': '',
      'cli_email': '',
      'cli_telefono': '',
      'cli_telefono_2': '',
      'cli_direccion': '',
      'cli_contribuyente': '',
      'cli_estatus': '',
      'cli_fecha_reg': '',
      'cli_genero': '',
      'cli_paisid': '',
      'cli_estado': '',
      'cli_ciudad': '',
      'cli_codpostal': '',
      'cli_descuento': '',
      'cli_razonsocial': '',
      'cli_natural': true,
      'cli_grupid': '',
      'cli_observaciones': ''
    },
    errorForm: [],
    clienteEncontrado: true,
    carrito: [],
    money: {
      locale: '',
      decimal: '.',
      thousands: ',',
      prefix: '',
      suffix: '',
      precision: 2,
      masked: false /* doesn't work with directive */
    },
    moneyPagar: {
      locale: '',
      decimal: '.',
      thousands: ',',
      prefix: '',
      suffix: '',
      precision: 2,
      masked: false
    },
    almacen_predeterminado: '',
    divisa_predeterminada: '',
    divisa_nombre: '',
    almacen_nombre: '',
    cuenta_nombre: '',
    metodo_nombre: '',
    almacenes: [],
    divisas: [],
    factura: [],
    monto: 0,
    restante_original: 0,
    articulosTotal: 0,
    exentos: 0,
    total_pagado: 0,
    total_pagado_div: 0,
    descuento: 0,
    restante: 0,
    subtotal: 0,
    total: 0,
    total_pagar: 0,
    neto: 0,
    iva: 0,
    desc_monto: 0,
    cambio_divisa: [],
    descuento_producto: 0,
    clave: '',
    empleado_autorizado: '',
    unique: '',
    serie: '',
    observaciones: '',
    divisa_pagar: '',
    metodo_pagar: '',
    cuenta_pagar: '',
    abonos: [],
    cuentas: [],
    metodos_de_pagos: [],
    div_conv_factor: '',
    restante_original: '',
    factor_divisas: [],
    cargando: false,
    estatus: 0,
    toggleBarcode: false,
    observacion_anular: '',
    referencia: '',
    generar_credito: false,
    cargando_documento:false,
    credito: [],
    monto_credito: 0,
    cant_document_pendiente: 0,
    monto_document_pendiente: 0,
    mont_p:0,
    cliente: '',
    loader_correo: false,
    creditos: [],
    select_credito: '',
    ver_contenedor_campos_pagar: true,
    grupo: '',
    precio_producto: 0,
    unique_preciop: '',
    agente_cliente: false,
    emp_agente: 0,
    nuevo_agente:0,
    emp_agente_nombre: '',
    num_documento: 0,
    prodCompuestos: [],
    serie_predeterminada: '',
    sucursal_predeterminada: '',
    sucursales_empleado: [],
    series_empleado: [],
    sucursal: '',
    disabled: false,
    compra_dolares: false,
    cuenta_compradolares: '',
    pagomovil: 0,
    ComprarDolares:[],
    agente_seleccionado: { id: '', nombres: '', apellidos: '' },
    iva_integrar:0,
    campos: [{cm:''}] ,
    numeroCampos:1,
    moneyBs: {
      decimal: ',',
      thousands: '.',
      prefix: '',
      suffix: '',
      precision: 2,
      masked: false
  },
  tipoci:2,
  array_agente:[],
  captado_agent:'',
  redesSociales:[],
  form_redes:'',
  form_descripcion:'',
  form_id:'',
  cargando_lineas:'',
  empresa:[],
  tel_cli:'',
  fecha_c:'',
  email_c:'',
  dir_c:'',
  telefono_c:'',
  rif_c:'',
  nombre_c:''
  },
  created() {
    if (this.id_factura > 0) {

      axios
        .get("ptv/obtenerSucursalesEmpleado")
        .then((response) => {
          this.sucursales_empleado = response.data.sucursales;
        })
        .catch((e) => notificacion());

      axios.get('ptv/verFactura',
        {
          params: {
            factura: this.id_factura,
            tipo: this.documento
          },
        }
      ).then(response => {
        this.factura = response.data.carrito.factura;
        this.tel_cli=response.data.telefono;

        if (document.getElementById('id_tipo').value == 1) {
          this.sucursal_predeterminada = response.data.factura.ne_surcid;
          this.emp_agente = response.data.factura.ne_empagente;
          this.array_agente=response.data.agente_selecc;
          this.captado_agent=this.array_agente.empagent_captado;
        }

        if (document.getElementById('id_tipo').value == 2) {
          this.sucursal_predeterminada = response.data.factura.fm_surcid;
          this.emp_agente = response.data.factura.fm_empagente;
          this.array_agente=response.data.agente_selecc;
          this.captado_agent=this.array_agente.empagent_captado;
        }

        if (document.getElementById('id_tipo').value == 3) {
          this.sucursal_predeterminada = response.data.factura.pre_surcid;
        }

        if (document.getElementById('id_tipo').value == 4) {
          this.sucursal_predeterminada = response.data.factura.pe_surcid;
        }

        this.series_empleado = response.data.series;
        this.almacenes = response.data.almacenes;
        this.serie_predeterminada = this.factura.id_serie;

        this.disabled = true;

        this.selected_cli = { 'id': response.data.cliente.cli_id, 'cliente': response.data.cliente.cli_razon_social, 'dni': response.data.cliente.cli_dni }

        this.cliente = response.data.cliente;
        this.dataFormCliente = {}
        this.carrito = response.data.carrito.data_carrito;

        this.cant_document_pendiente = response.data.doc_pendientes;
        this.monto_document_pendiente = response.data.total_doc_pendientes.divisas_totales;
         this.mont_p=response.data.total_doc_pendientes.total;

        this.divisas = response.data.divisas;
        this.almacen_predeterminado = this.factura.id_almacen;
        this.divisa_predeterminada = this.factura.id_divisa;
        this.todosProductos();

        this.moneyPagar.locale = this.money.locale = response.data.carrito.divisa.locale;
        this.moneyPagar.prefix = this.money.prefix = response.data.carrito.divisa.symbol + ' ';
        this.moneyPagar.decimal = this.money.decimal = response.data.carrito.divisa.decimal;
        this.moneyPagar.thousands = this.money.thousands = response.data.carrito.divisa.thousands;
        this.moneyPagar.precision = this.money.precision = response.data.carrito.divisa.precision;
        this.cambio_divisa = response.data.carrito.cambio_divisa;

        this.articulosTotal = response.data.carrito.articulos_cantidad;
        this.exentos = response.data.carrito.cantarticulos_exentos;
        this.subtotal = Number(response.data.carrito.subtotal).toFixed(this.money.precision);
        this.descuento = Number(response.data.carrito.descuento).toFixed(this.money.precision);
        this.neto = Number(response.data.carrito.neto).toFixed(this.money.precision);
        this.iva = Number(response.data.carrito.iva).toFixed(this.money.precision);
        this.total = Number(response.data.carrito.total).toFixed(this.money.precision);
        this.restante_original = Number(response.data.carrito.restante).toFixed(this.money.precision);
        this.restante = Number(response.data.carrito.restante).toFixed(this.money.precision);
        this.observaciones = response.data.carrito.observaciones;
        this.estatus = response.data.carrito.factura.estatus;

        if (this.estatus == 3) {
          document.getElementById('guardarFactura').disabled = true;
          document.getElementById('opcionesFactura').disabled = true;
          document.getElementById('cancelarFactura').disabled = true;
          document.getElementById('inputbuscarlineas').disabled = true;
          //document.getElementById('menuCliente').disabled = true
        }
        if (this.estatus == 1) {
          //document.getElementById('menuCliente').disabled = true
        }
        this.num_documento = response.data.carrito.factura.correlativo;
        this.credito = response.data.carrito.creditos;
        for (var i = 0, l = this.credito.length; i < l; i++) {
          this.monto_credito = convertir_a_float(String(this.monto_credito)) + convertir_a_float(String(this.credito[i]['monto']));
        }
        this.obtenerCreditosFactura();
        this.credito = '';

        this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);

        this.total_pagado = Number(response.data.carrito.total_pagado).toFixed(this.money.precision);
        this.abonos = response.data.carrito.abonos;
        this.ComprarDolares=response.data.ComprarDolares;
        this.iva_integrar=response.data.integrar_iva;

        this.obtenerAgente();
        this.obtenerDocumentos();
        this.obtenerRedesSociales();
        this.empresa=response.data.empresa;
        
        if (this.documento == 3 || this.documento == 4) {
          document.getElementById('cancelarFactura').disabled = true;
        }

      }).catch(e => notificacion())
    } else {
      axios.get('ptv/crearFactura').then(response => {
        this.divisas = response.data.divisas;
        this.divisa_facturar = response.data.divisa_facturar;
        this.divisa_master = response.data.divisa_master;
        this.obtenerSucursalesEmpleado();

        if (response.data.crear_nota == true) {
          this.documento = 1;
        } else {
          this.documento = 3;
        }

        this.iva_integrar=response.data.integrar_iva;
        //document.getElementById('divisa').disabled = true;
        this.divisa_predeterminada = this.divisa_master.id;

        this.moneyPagar.locale = this.money.locale = this.divisa_master.locale;
        this.moneyPagar.prefix = this.money.prefix = this.divisa_master.symbol + " ";
        this.moneyPagar.decimal = this.money.decimal = this.divisa_master.decimal;
        this.moneyPagar.thousands = this.money.thousands = this.divisa_master.thousands;
        this.moneyPagar.precision = this.money.precision = this.divisa_master.precision;

        this.carrito = [];
        this.cambio_divisa = [];
        this.articulosTotal = 0;
        this.exentos = 0;
        this.subtotal = 0;
        this.descuento = 0;
        this.neto = 0;
        this.iva = 0;
        this.total = 0;
        this.desc_monto = 0;
        this.num_documento = 0000;

      }).catch(e => notificacion());
    }
  },
  methods: {
    deleteValue: function(index) {
      this.campos.splice(index, 1);
      this.numeroCampos=this.numeroCampos-1;
      //this.$emit('input', this.campos);
    },
    addValue: function() {
      this.campos.push( { cm:''} );
      this.numeroCampos=this.numeroCampos+1;
      //this.$emit('input', this.campos);
      console.log(this.campos);
    },
    borrarSeleccionCredito() {
      //   if(this.compra_dolares==true){
      this.compra_dolares = false;
      // }
    },
    borrarSeleccionCompra() {
      //   if(this.compra_dolares==true){
      this.generar_credito = false;
      axios({
        method: 'post',
        url: 'ptv/pagomovil',
        data: {
          id_factura: this.id_factura,
          tipo: this.documento,
          monto: this.monto
        },
        transformRequest: serializar(),
      }).then(response => {
        this.pagomovil = parseFloat(response.data).toFixed(2);
      })
        .catch((e) => notificacion());

      // }
    },
    obtenerSucursalesEmpleado() {
      axios
        .get("ptv/obtenerSucursalesEmpleado")
        .then((response) => {
          this.sucursales_empleado = response.data.sucursales;
          this.sucursal_predeterminada = response.data.id;

          if (response.data.desactivar == true) {
            this.disabled = true
          }
          if (this.sucursal_predeterminada != 0) {
            axios
              .get("ptv/obtenerSeriesAlmacenesEmpleado/" + this.sucursal_predeterminada)
              .then((response) => {
                this.almacenes = response.data.almacenes;
                this.almacen_predeterminado = response.data.id_alm;
                this.series_empleado = response.data.series;
                this.serie_predeterminada = response.data.id_ser;

                this.todosProductos();
              })
              .catch((e) => notificacion());
          }
        })
        .catch((e) => notificacion());
    },
    obtenerSeriesEmpleado() {
      axios
        .get("ptv/obtenerSeriesAlmacenesEmpleado/" + this.sucursal_predeterminada)
        .then((response) => {
          this.almacenes = response.data.almacenes;
          this.almacen_predeterminado = response.data.id_alm;
          this.series_empleado = response.data.series;
          this.serie_predeterminada = response.data.id_ser;

          this.todosProductos();
        })
        .catch((e) => notificacion());
    },
    comboProductosCompuestos(producto) {
      axios.get('ptv/obtenerProductosCompuestos/' + producto.id).then(response => {
        if (response.data != false) {
          this.prodCompuestos = response.data;
          $('#modal_productoscompuesto').modal('show');
          console.log(response.data)
        }
      }).catch(e => notificacion());
    },
    tipoDocumento() {
      axios.get('ptv/cambiarDocumento',
        {
          params: {
            id_cliente: this.selected_cli.id,
            tipo: this.documento
          },
        }
      ).then(response => {
        if (response.data == true) {
          if (this.documento == 2) {
            this.divisa_predeterminada = this.divisa_facturar.id;
            this.moneyPagar.locale = this.money.locale = this.divisa_facturar.locale;
            this.moneyPagar.prefix = this.money.prefix = this.divisa_facturar.symbol + " ";
            this.moneyPagar.decimal = this.money.decimal = this.divisa_facturar.decimal;
            this.moneyPagar.thousands = this.money.thousands = this.divisa_facturar.thousands;
            this.moneyPagar.precision = this.money.precision = this.divisa_facturar.precision;
            document.getElementById('divisa').disabled = true;
          } else {
            this.divisa_predeterminada = this.divisa_master.id;
            this.moneyPagar.locale = this.money.locale = this.divisa_master.locale;
            this.moneyPagar.prefix = this.money.prefix = this.divisa_master.symbol + " ";
            this.moneyPagar.decimal = this.money.decimal = this.divisa_master.decimal;
            this.moneyPagar.thousands = this.money.thousands = this.divisa_master.thousands;
            this.moneyPagar.precision = this.money.precision = this.divisa_master.precision;
            document.getElementById('divisa').disabled = false;
          }
          this.carrito = [];
          this.todosProductos();
          this.articulosTotal = 0;
          this.exentos = 0;
        }
      }).catch(e => notificacion());

    },
    todosProductos() {
      if (this.divisa_predeterminada != null && this.almacen_predeterminado != null) {
        axios.get('ptv/todosProductos',
          {
            params: {
              divisa: this.divisa_predeterminada,
              almacen: this.almacen_predeterminado
            },
          }
        ).then(response => {
          this.lineas = response.data;
        }).catch(e => notificacion());
      }
    },
    obtenerBalanceComprarDolares() {
        axios.get('ptv/obtenerBalanceComprarDolares',
          {
            params: {
              id_factura: this.id_factura,
              tipo: this.documento,
            },
          }
        ).then(response => {
          this.ComprarDolares= response.data;
        }).catch(e => notificacion());
    },
    buscarCategoria(id) {
      if (this.divisa_predeterminada != null && this.almacen_predeterminado != null) {
        axios.get('ptv/busquedaCategoria',
          {
            params: {
              buscar: id,
              divisa: this.divisa_predeterminada,
              almacen: this.almacen_predeterminado
            },
          }
        ).then(response => {
          this.lineas = response.data;
        }).catch(e => notificacion())
      }
    },
    buscarLineas(event) {
      if (event.target.value) {
        if (this.toggleBarcode == false) {
          this.cargando_lineas = 'is-loading is-loading-lg';
          this.bus_li(event.target.value, this);
        }
      }
    },
    focusBuuscar() {
      document.getElementById("inputbuscarlineas").focus();
    },
    bus_li: _.debounce((value, vm) => {
      axios.get('ptv/buscarLineas', {
        params: {
          buscar: value,
          divisa: vm.divisa_predeterminada,
          almacen: vm.almacen_predeterminado,
          filtro: vm.filtro
        }
      }).then(response => {
        if (response.data.length > 0) {
          vm.lineas = response.data;
        } else {
          vm.lineas = [];
        }
      }).catch(e => notificacion()).finally(() => vm.cargando_lineas = '');
    }, 350),
    modal_buscar_cliente() {
      if (this.documento > 0) {
        this.clientes = [];
        this.dataForm.ruta = this.documento;
        this.errorForm = [];
        $('#modal_buscar_cliente').modal('show');
        $('#modal_buscar_cliente').on('shown.bs.modal', function () {
          $('#tututut > div > div > input').trigger('focus')
        });
      } else {
        notificacion('fa fa-ban', 'Advertencia', 'Seleccione el tipo de documento', 'warning');
      }

    },
    actualizarPrecio() {
      let precio = convertir_a_float(this.precio_producto);
      console.log(precio)
      if (this.id_factura && precio > 0 && this.unique_preciop && this.selected_cli.id) {
        axios({
          method: "post",
          url: "ptv/actualizarPrecio",
          data: {
            id_cliente: this.selected_cli.id,
            unique: this.unique_preciop,
            precio: precio,
            descuento_global: this.descuento,
            id_factura: this.id_factura,
            tipo: this.documento,
            empleado: this.empleado_autorizado,
            clave: this.clave,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;

              Object.keys(response.data.carrito).forEach((key, i) => {
                this.carrito[key].neto = response.data.carrito[key].neto;
                this.carrito[key].total = response.data.carrito[key].total;
                this.carrito[key].precio = response.data.carrito[key].precio;
              });

              this.cambio_divisa = response.data.cambio_divisa;

              this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    modal_opciones() {
      $('#modal_opciones').modal('show');
    },
    modal_adjunto() {
      $('#modal_adjunto').modal('show');
    },
    modal_whatsapp(){
      let mensaje=this.empresa.emp_nombrecorto+' le recuerda que tiene '+this.cant_document_pendiente+' facturas pendientes por un monto de ';
      let mont=this.mont_p;

      let mens=mensaje+mont+', agradecemos que cumpla con sus compromisos de pago.';
      window.open('https://api.whatsapp.com/send?phone=+58'+this.tel_cli+'&text='+mens);
    },
    modal_cambiarPrecio(unique, precio) {
      this.precio_producto = precio;
      this.unique_preciop = unique;
      $('#modal-precio').modal('show');
    },
    modalCliente(row) {
      if (this.selected_cli.id > 0 && this.id_factura > 0) {
        $('#modal_cliente').modal('show');
          this.fecha_c=this.cliente.cli_fecha_nac;
          this.email_c=this.cliente.cli_email;
          this.dir_c=this.cliente.cli_direccion;
          this.telefono_c=this.cliente.cli_telefono;
          this.rif_c=this.cliente.cli_dni;
          this.nombre_c=this.cliente.cli_razon_social;
      }
    },
    modalCorreoPre() {
      if (this.selected_cli.id > 0 && this.id_factura > 0) {
        $('#modal_correopre').modal('show');
        $('#modal_correopre').on('shown.bs.modal', function () {
          //$('#nombre_divisa').trigger('focus');
        });
      }
    },
    enviarDocumento() {

        this.errorForm = [];

        this.formDocumentos.id_factura = this.id_factura;

        if (!this.formDocumentos.descripcion)
            this.errorForm.push('El campo Descripción es obligatorio.');

        if (!this.formDocumentos.documento)
            this.errorForm.push('El Documento obligatorio.');
        
        this.formDocumentos.tipo= this.documento;

        if (this.errorForm.length == 0) {
            this.cargando_documento = true;
            axios({
                method: 'post',
                url: 'ptv/enviarDocumento',
                data: this.formDocumentos,
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerDocumentos();
                        notificacion('fa fa-check', 'Enviado', 'documento cargado exitosamente', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion()).finally(() => this.cargando_documento = false);
        } else {
            let total_errores = this.errorForm.length
            for (let i = 0; i < total_errores; i++) {
                notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
            }
        }
    },
    handleFileUpload() {
      this.formDocumentos.documento = this.$refs.file.files[0];
  },
    obtenerDocumentos() {
         axios({
          method: 'post',
          url: 'ptv/obtnerDocumentos/',
          data: {
            id_factura: this.id_factura,
            tipo: this.documento
          },
          transformRequest: serializar(),
      }).then(response => {
          this.documentosAdjunto = response.data;
      });
    },
    enviarcorreopre() {

      this.errorForm = [];

      let de = document.getElementById('cor_emaildep').value;
      let para = document.getElementById('cor_emailparap').value;
      let copia = document.getElementById('cor_emailcopiap').value;
      let firma = document.getElementById('cor_emailfirmap').value;

      if (!de)
        this.errorForm.push('El campo De es obligatorio.');
      if (!para)
        this.errorForm.push('El campo Para es obligatorio.');

      if (de && para) {
        if (!validaEmail(de))
          this.errorForm.push('El Correo Electrónico ' + de + ' no es válido.');
        if (!validaEmail(para))
          this.errorForm.push('El Correo Electrónico ' + para + ' no es válido.');
      }

      if (this.errorForm.length == 0) {

        this.loader_correo = true;

        axios({
          method: 'post',
          url: 'ptv/enviarFacturapre',
          data: {
            id_factura: this.id_factura,
            de: de,
            para: para,
            copia: copia,
            firma: firma,
            tipo: this.documento
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            if (response.data) {
              notificacion('fa fa-check', 'Enviado', response.data, 'success');
            }
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => this.loader_correo = false);
      } else {
        let total_errores = this.errorForm.length
        for (let i = 0; i < total_errores; i++) {
          notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
        }
      }
    },
    modalCorreo() {
      if (this.selected_cli.id > 0 && this.id_factura > 0) {
        $('#modal_pagar').modal('hide');
        $('#modal_correo').modal('show');
        $('#modal_correo').on('shown.bs.modal', function () {
          //$('#nombre_divisa').trigger('focus');
        });
      }
    },
    enviarFactura() {

      this.errorForm = [];

      let de = document.getElementById('cor_emailde').value;
      let para = document.getElementById('cor_emailpara').value;
      let copia = document.getElementById('cor_emailcopia').value;
      let firma = document.getElementById('cor_emailfirma').value;
      let tipo = this.documento;

      if (!de)
        this.errorForm.push('El campo De es obligatorio.');
      if (!para)
        this.errorForm.push('El campo Para es obligatorio.');

      if (de && para) {
        if (!validaEmail(de))
          this.errorForm.push('El Correo Electrónico ' + de + ' no es válido.');
        if (!validaEmail(para))
          this.errorForm.push('El Correo Electrónico ' + para + ' no es válido.');
      }

      if (this.errorForm.length == 0) {

        this.loader_correo = true;

        axios({
          method: 'post',
          url: 'ptv/eniviarFactura',
          data: {
            id_factura: this.id_factura,
            de: de,
            para: para,
            copia: copia,
            firma: firma,
            tipo: tipo,
            document: this.documento
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            if (response.data) {
              notificacion('fa fa-check', 'Enviado', response.data, 'success');
            }
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => this.loader_correo = false);
      } else {
        let total_errores = this.errorForm.length
        for (let i = 0; i < total_errores; i++) {
          notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
        }
      }
    },
    modal_nota() {
      $('#modal_nota').modal('show');
    },
    modal_agente() {
      $('#modal_agente').modal('show');
    },
    modal_imprimir() {
      $('#modal_pagar').modal('hide');
      $('#modal-imprimir').modal('show');

    },
    obtenerAgente() {
      axios
        .get("ptv/obtenerAgenteCliente/" + Number(this.emp_agente))
        .then((response) => {
          if (response.data != false) {
            this.agente_cliente = true;
            this.agente_seleccionado.id = this.emp_agente;
            this.agente_seleccionado.nombres = response.data.einfo_nombres + " " + response.data.einfo_apellidos;
          }
        })
        .catch((e) => notificacion());
    },
    obtenerAgenteCliente() {

      if (this.id_factura > 0 && this.documento == 1) {
        axios({
          method: "post",
          url: "ptv/chequearAgente",
          data: {
            id_cliente: this.selected_cli.id,
            tipo: this.documento,
            id_agente: this.emp_agente,
            factura: this.id_factura
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              notificacion('fa fa-check', 'Actualizacion', 'Agente seleccionado exitosamente', 'success');
              this.obtenerAgente();
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
      if (this.id_factura > 0 && this.documento == 2) {
        notificacion('fa fa-ban', 'Lo siento', 'La factura no puede ser modificada', 'warning');
      }
      if (this.id_factura == 0) {
        axios
          .get("ptv/obtenerAgenteCliente/" + Number(this.emp_agente))
          .then((response) => {
            if (response.data != false) {
              this.agente_cliente = true;
              this.agente_seleccionado.id = this.emp_agente;
              this.agente_seleccionado.nombres = response.data.einfo_nombres + " " + response.data.einfo_apellidos;
            }
          })
          .catch((e) => notificacion());
      }
    },
    actualizar_agente(){
      axios({
          method: "post",
          url: "ptv/actualizar_agente",
          data: {
              id_cliente: this.selected_cli.id,
              agente_anterior: this.emp_agente,
              factura: this.id_factura,
              id_agente:this.nuevo_agente,
              tipo: this.documento,
          },
          transformRequest: serializar(),
      })
          .then((response) => {
              if (response.data.errors == null) {
                  notificacion('fa fa-check', 'Actualizacion', 'Agente seleccionado exitosamente', 'success');
                 
                    $('#modal_act').modal('hide');
                    this.emp_agente=this.nuevo_agente;
                    this.obtenerAgente();

              } else {
                  let total_errores = response.data.errors.length;
                  for (let i = 0; i < total_errores; i++) {
                      notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                  }
              }
          })
          .catch((e) => notificacion());
  },
  modal_actualizar_agente() {
      $('#modal_act').modal('show');
      this.nuevo_agente=0;
  },
    imprimir(id) {
      axios.get('ptv/imprimir', {
        params: {
          id_factura: Number(this.id_factura),
          tipo: this.documento,
          impresora: id,
        }
      }).then(response => {
        console.log(response.data);
        if (response.data.data.errors == null) {
          fetch(response.data.ip_puerto, {
            method: 'POST',
            body: JSON.stringify(response.data.data)
          }).then((j) => {
            if (j.ok) {
              notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
            } else {
              notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
            }
          }).catch((error) => {
            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
          });
        } else {
          let total_errores = response.data.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());
    },
    modal_pagar() {
      this.divisa_pagar = this.divisa_predeterminada;
      this.monto = 0.00;
      this.total_pagar = this.total;
      this.total_pagado_div = this.total_pagado;
      this.referencia = '';
      this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
      this.obtenerMetodosSegunDivisa();
      this.obtenerCreditos();

      if (this.estatus == 2) {
        axios({
          method: 'post',
          url: 'ptv/ventaEnEspera',
          data: {
            'id_serie': this.serie_predeterminada,
            'id_sucursal': this.sucursal_predeterminada,
            'id_cliente': this.selected_cli.id,
            'observaciones': this.observaciones,
            'descuento_global': this.descuento,
            'id_factura': this.id_factura,
            'tipo': this.documento
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data != null) {
            this.total_pagar = this.total;
            this.total_pagado_div = this.total_pagado;
            this.obtenerMetodosSegunDivisa();
            $('#modal_pagar').modal({ show: true, backdrop: 'static', keyboard: false });
          }
        }).catch(e => notificacion()).finally(() => this.cargando = false);
      } else {
        $('#modal_pagar').modal({ show: true, backdrop: 'static', keyboard: false });
      }
    },
    obtenerMetodosSegunDivisa() {
      this.errorForm = [];
      this.metodos_de_pagos = '';
      this.metodo_pagar = '';
      this.cuentas = [];

      if (!this.divisa_pagar)
        this.errorForm.push('La divisa es requerida');

      if (this.errorForm.length == 0) {
        axios({
          method: 'post',
          url: 'ptv/obtenerMetodosSegunDivisa',
          data: {
            'id_factura': this.id_factura,
            'id_divisa': this.divisa_pagar,
            'tipo': this.documento
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            if (response.data) {
              this.moneyPagar.locale = response.data.divisa.locale;
              this.moneyPagar.prefix = response.data.divisa.symbol + ' ';
              this.moneyPagar.decimal = response.data.divisa.decimal;
              this.moneyPagar.thousands = response.data.divisa.thousands;
              this.moneyPagar.precision = response.data.divisa.precision;

              this.metodos_de_pagos = response.data.data_metodos;
              this.metodo_pagar = response.data.metodo;
              this.div_conv_factor = monedaDecimal(response.data.factor,'en-US',2);
              this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
              this.restante = parseFloat(response.data.restante * response.data.factor).toFixed(this.moneyPagar.precision);
              this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
              this.total_pagar = parseFloat(this.total * response.data.factor).toFixed(this.moneyPagar.precision);
              this.total_pagado_div = parseFloat(this.total_pagado * response.data.factor).toFixed(this.moneyPagar.precision);
              //this.monto = this.restante;
              this.factor_divisas = response.data.total_divisas;

              this.obtenerCuentasSegunMetodo();
            }
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => {

        });
      }
    },
    obtenerCuentasSegunMetodo() {
      this.errorForm = [];
      this.cuenta_pagar = '';
      this.cuentas = [];
      this.divisa_nombre = '';
      this.almacen_nombre = '';
      this.cuenta_nombre = '';
      this.metodo_nombre = '';

      if (!this.metodo_pagar)
        this.errorForm.push('EL Método de Pago es requerido');

      if (this.errorForm.length == 0) {
        axios({
          method: 'post',
          url: 'ptv/obtenerCuentasSegunMetodo',
          data: { 'id_metodo': this.metodo_pagar, 'tipo': this.documento },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            if (response.data.data_metodos.length > 0) {
              if(this.divisa_pagar==response.data.divisa){
                this.cuentas = response.data.data_metodos;
                this.cuenta_pagar = response.data.metodo;
  
                this.obtenerNombres(this.divisa_pagar, this.almacen_predeterminado);
                this.obtenerNombreCuenta();
              }else{
                notificacion('fa fa-ban', 'Advertencia', "Error la divisa no coincide con la divisa seleccionada.", 'warning');
              }
            }
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion());
      }
    },
    obtenerNombreCuenta() {
      axios.get("ptv/nombreCuenta/" + this.cuenta_pagar).then((response) => {
        this.cuenta_nombre = response.data.cuenta;
        this.metodo_nombre = response.data.metodo;
      });
    },
    obtenerNombres(id_divisa, id_almacen) {
      axios.get("notasdeentrega/nombreDivisa/" + id_divisa).then((response) => {
        this.divisa_nombre = response.data;
      });

      axios.get("notasdeentrega/nombreAlmacen/" + id_almacen).then((response) => {
        this.almacen_nombre = response.data;
      });
    },
    pagar() {
      Swal.fire({
        title: "<strong>¿Continuar con el pago?</strong>",
        html:
          "Divisa: <strong>" + this.divisa_nombre + "</strong><br>Monto:  <strong>" + this.monto + "<strong>",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        confirmButtonText: "SI",
        confirmButtonAriaLabel: "SI",
        cancelButtonText: "NO",
        cancelButtonAriaLabel: "NO",
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#aaa",
      }).then((result) => {
        if (result.value) {
          axios({
            method: 'post',
            url: 'ptv/comprobarFactura',
            data: {
              'id_factura': this.id_factura,
              'tipo': this.documento
            },
            transformRequest: serializar(),
          }).then(response => {
            if (response.data.errors == null) {
              this.errorForm = [];
              this.estatus = 2;

              if (!this.ver_contenedor_campos_pagar) {
                axios.get('ptv/pagarConCredito', {
                  params: {
                    id_fac: this.id_factura,
                    id_credito: this.select_credito,
                    tipo: this.documento
                  }
                }).then(response => {
                  console.log(response.data);
                  if (response.data.errors == null) {
                    if (response.data) {
                      this.monto = 0.00;
                      this.abonos = response.data.abonos;
                      this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                      this.restante = parseFloat(response.data.restante * convertir_a_float(String(this.div_conv_factor))).toFixed(this.moneyPagar.precision);
                      this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                      this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                      //this.monto = this.restante;
                      if (response.data.pagado) {
                        notificacion('fa fa-check', 'Advertencia', 'Pagado en su totalidad', 'success');
                        this.estatus = 1;
                        // document.getElementById('menuCliente').disabled = true
                      } else {
                        notificacion('fa fa-check', 'Pago', 'Pago exitoso', 'success');
                      }
                    }
                  } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                      notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                  }
                  this.obtenerCreditos();
                  this.monto = 0;
                  this.ver_contenedor_campos_pagar = true;
                  document.getElementById('pagarmonto').disabled = false;
                }).catch(e => notificacion()).finally(() => {
                  let input_pagar = document.getElementById('pagarmonto');
                  document.getElementById('pagarmonto').disabled = false;
                  document.getElementById('pagarmonto').value = '';
                });
              } else {

                if (!this.divisa_pagar)
                  this.errorForm.push('El campo Divisa es obligatorio');
                if (!this.metodo_pagar)
                  this.errorForm.push('El campo Método es obligatorio');
                if (!this.cuenta_pagar)
                  this.errorForm.push('El campo Cuenta es obligatorio');
                if (!this.monto)
                  this.errorForm.push('El campo Monto es obligatorio');

                if (this.errorForm.length == 0) {
                  this.cargando = true;
                  axios({
                    method: 'post',
                    url: 'ptv/pagar',
                    data: {
                      id_factura: this.id_factura,
                      tipo: this.documento,
                      id_divisa: this.divisa_pagar,
                      id_metodo_divisa: this.metodo_pagar,
                      id_cuenta_metodo: this.cuenta_pagar,
                      monto: this.monto,
                      credito: this.generar_credito,
                      referencia: this.referencia,
                      compra_dolares: this.compra_dolares,
                      cuenta_pagod:JSON.stringify(this.campos),
                      factor: convertir_a_float(String(this.div_conv_factor))
                    },
                    transformRequest: serializar(),
                  }).then(response => {
                    if (response.data.errors == null) {
                      if (response.data) {
                        this.monto = 0.00;
                        this.abonos = response.data.abonos;
                        this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                        this.restante = parseFloat(response.data.restante * convertir_a_float(String(this.div_conv_factor))).toFixed(this.moneyPagar.precision);
                        this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                        this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);


                        if(this.compra_dolares==true){
                          this.obtenerBalanceComprarDolares();
                        }
                        //this.total_pagado_div = parseFloat(response.data.total_pagado * div_conv_factor).toFixed(this.moneyPagar.precision);
                        if (response.data.pagado) {
                          notificacion('fa fa-check', 'Advertencia', 'Pagado en su totalidad', 'success');
                          this.estatus = 1;
                          // document.getElementById('menuCliente').disabled = true
                        } else {
                          notificacion('fa fa-check', 'Pago', 'Pago exitoso', 'success');
                        }
                      }
                    } else {
                      let total_errores = response.data.errors.length
                      for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                      }
                    }
                  }).catch(e => {
                    notificacion();
                  }).finally(() => {
                    this.cargando = false;
                    this.monto = 0;
                    this.referencia = '';
                    this.obtenerCreditosFactura();
                    this.obtenerCreditos();
                  });
                } else {
                  let total_errores = this.errorForm.length
                  for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                  }
                }
              }
            } else {
              this.estatus = 1;
              let total_errores = response.data.errors.length
              for (let i = 0; i < total_errores; i++) {
                notificacion('fa fa-ban', 'Advertencia5', response.data.errors[i], 'warning');
              }
            }
          }).catch(e => notificacion());
        }
      });
    },
    obtenerCreditosFactura() {
      axios({
        method: 'post',
        url: 'ptv/obtenerCreditosFactura',
        data: {
          'id_factura': this.id_factura,
          'tipo': this.documento
        },
        transformRequest: serializar(),
      }).then(response => {
        this.credito = response.data;
        for (var i = 0, l = this.credito.length; i < l; i++) {
          this.monto_credito = convertir_a_float(String(this.monto_credito)) + convertir_a_float(String(this.credito[i]['monto']));
        }
      }).catch(e => notificacion());
    },
    obtenerCreditos() {
      axios.get('ptv/obtenerCreditos/' + this.selected_cli.id).then(response => {
        this.creditos = response.data;
      }).catch(e => notificacion()).finally(() => { });
    },
    pagarConCredito() {

      if (this.select_credito) {
        axios.get('ptv/obtenerFactor', {
          params: {
            id_factura: this.id_factura,
            id_credito: this.select_credito,
            tipo: this.documento
          }
        }).then(response => {
          if (response.data.errors == null) {
            this.monto = Number(response.data).toFixed(2);
            this.ver_contenedor_campos_pagar = false;
            document.getElementById('pagarmonto').disabled = true;
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => { });
      } else {
        this.monto = 0;
        this.ver_contenedor_campos_pagar = true;
        document.getElementById('pagarmonto').disabled = false;
      }
    },
    colocarEnMonto() {
      this.monto_conv = this.monto = Number(this.restante).toFixed(this.moneyPagar.precision);
    },
    guardarCliente() {

      this.errorForm = [];

      if (!this.dataForm.cli_tipodoc)
        this.errorForm.push('El campo Tipo de Documento es obligatorio.');
      if (!this.dataForm.cli_telefono)
        this.errorForm.push('El campo Teléfono es obligatorio.');
      if (!this.dataForm.cli_direccion)
        this.errorForm.push('El campo Dirección es obligatorio.');
      if (!this.dataForm.cli_dni)
        this.errorForm.push('El campo Número de Documento es obligatorio.');
      if (!this.dataForm.cli_razon_social)
        this.errorForm.push('El campo Razón Social es obligatorio.');
      if (this.dataForm.cli_email) {
        if (!validaEmail(this.dataForm.cli_email))
          this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
      }

      this.dataForm.tipo = this.documento;

      if (this.errorForm.length == 0) {
        this.cargando = true;
        axios({
          method: 'post',
          url: 'ptv/guardarCliente',
          data: this.dataForm,
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            this.selected_cli = {
              'id': response.data.id,
              'cliente': response.data.cliente,
              'dni': response.data.dni
            };
            $('#modal_buscar_cliente').modal('hide');
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => {
          this.cargando = false;
        });
      }
    },
    onSearch(search, loading) {
      if (search) {
        loading(true);
        this.search(loading, search, this);
        //this.ocultoBoton();
      }
    },
    search: _.debounce((loading, search, vm) => {
      axios.get('notadecredito/buscarCliente', {
        params: {
          'buscar': search
        }
      }).then(response => {
        if (response.data.length > 0) {
          vm.clientes = response.data;
          vm.clienteEncontrado = true;
        } else {
          vm.clientes = [];
          if (!isNaN(search)) {
            vm.dataForm.cli_dni = 'V'+search;
          } else {
            vm.dataForm.cli_dni = '';
          }
          vm.clienteEncontrado = false;
        }
      }).catch(e => notificacion()).finally(() => {
        loading(false);
      });
    }, 350),
    seleccioncliente() {
      $('#modal_buscar_cliente').modal('hide');
      //  if (this.id_factura > 0) {
      axios.get('ptv/cambiarCliente', {
        params: {
          id_cliente: this.selected_cli.id,
          id_factura: this.id_factura,
          tipo: this.documento,
        }
      }).then(response => {
        if (response.data.errors == null) {
          if (response.data.url == '') {
            this.clientes = [];
            this.carrito = [];
            this.cliente = this.selected_cli;
            this.cant_document_pendiente = response.data.doc_pendientes;
            this.monto_document_pendiente = response.data.total_doc_pendientes.divisas_totales;
            this.mont_p=response.data.total_doc_pendientes.total;
            this.articulosTotal = 0;
            this.exentos = 0;
            //this.obtenerAgenteCliente();
          } else {
            location.href = response.data.url;
          }
        } else {
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());

    },
    agregarProductoBarcode(producto) {
      if (this.divisa_predeterminada && producto && this.almacen_predeterminado && this.estatus != 3) {
        axios({
          method: 'post',
          url: 'ptv/agregarProductoBarcode',
          data: {
            'id_factura': this.id_factura,
            'id_producto': producto,
            'tipo': this.documento,
            'id_almacen': this.almacen_predeterminado,
            'id_divisa': this.divisa_predeterminada,
            'descuento_global': this.descuento,
            'id_cliente': this.selected_cli.id
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            this.articulosTotal = response.data.articulos_cantidad;
            this.exentos = response.data.cantarticulos_exentos;
            this.subtotal = response.data.subtotal;
            this.descuento = response.data.descuento;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total;
            this.carrito = response.data.carrito;

            this.cambio_divisa = response.data.cambio_divisa;

            this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);

          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => {
          document.getElementById('inputbuscarlineas').value = '';
        });
      }
    },
    seleccionarProducto(event) {

      if (event.key == 'Enter') {

        event.preventDefault();

        if (this.toggleBarcode == true) {
          this.agregarProductoBarcode(event.target.value);
          document.getElementById('inputbuscarlineas').value = '';
        } else {

        }
      }
    },
    agregarProducto(id_producto, id_almacen) {
      if (this.divisa_predeterminada && id_producto && id_almacen && this.estatus != 3 && this.toggleBarcode == false) {
        axios({
          method: 'post',
          url: 'ptv/agregarProducto',
          data: {
            'id_factura': this.id_factura,
            'id_producto': id_producto,
            'tipo': this.documento,
            'id_almacen': id_almacen,
            'id_divisa': this.divisa_predeterminada,
            'descuento_global': this.descuento,
            'id_cliente': this.selected_cli.id
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            this.articulosTotal = response.data.articulos_cantidad;
            this.exentos = response.data.cantarticulos_exentos;
            this.subtotal = response.data.subtotal;
            this.descuento = response.data.descuento;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total;
            this.carrito = response.data.carrito;

            this.cambio_divisa = response.data.cambio_divisa;

            this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => {
          document.getElementById('inputbuscarlineas').value = '';
        });
      } else {
        if (this.toggleBarcode == true) {
          this.agregarProductoBarcode(id_producto);
          document.getElementById("inputbuscarlineas").value = '';
        }
      }
    },
    predeterminarDivisa() {
      axios.get('ptv/predeterminarDivisa', {
        params: {
          id_divisa: this.divisa_predeterminada,
          id_factura: this.id_factura,
          id_cliente: this.selected_cli.id,
          tipo: this.documento,
          descuento: this.descuento
        }
      }).then(response => {
        if (response.data.errors == null) {
          if (Object.keys(response.data.divisa).length > 0) {
            this.money.locale = response.data.divisa.locale;
            this.money.prefix = response.data.divisa.symbol + ' ';
            this.money.decimal = response.data.divisa.decimal;
            this.money.thousands = response.data.divisa.thousands;
            this.money.precision = response.data.divisa.precision;
          }
          if (Object.keys(response.data.data_carrito).length > 0) {
            this.articulosTotal = response.data.data_carrito.articulos_cantidad;
            this.exentos = response.data.data_carrito.cantarticulos_exentos;
            this.subtotal = response.data.data_carrito.subtotal;
            this.descuento = response.data.data_carrito.descuento;
            this.neto = response.data.data_carrito.neto;
            this.iva = response.data.data_carrito.iva;
            this.total = response.data.data_carrito.total;
            this.carrito = response.data.data_carrito.carrito;

            this.cambio_divisa = response.data.data_carrito.cambio_divisa;

            this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);
          }
          this.todosProductos();
        } else {
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());
    },
    actualizarCantidad(unique, event) {
      let cantidad = convertir_a_float(event.target.value);
      if (event.target.value && cantidad > 0 && this.errorForm.length == 0) {
        axios({
          method: 'post',
          url: 'ptv/actualizarCantidad',
          data: {
            id_producto: unique,
            cantidad: event.target.value,
            descuento_global: this.descuento,
            id_factura: this.id_factura,
            id_cliente: this.selected_cli.id,
            tipo: this.documento
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            this.articulosTotal = response.data.articulos_cantidad;
            this.exentos = response.data.cantarticulos_exentos;
            this.subtotal = response.data.subtotal;
            this.descuento = response.data.descuento;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total;
            this.restante = response.data.total;

            this.cambio_divisa = response.data.cambio_divisa;

            this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);

            if (response.data.restante == 0) {
              this.estatus = 1;
            }
            Object.keys(response.data.carrito).forEach((key, i) => {
              this.carrito[key].neto = response.data.carrito[key].neto;
              this.carrito[key].total = response.data.carrito[key].total;
            });
          } else {
            if (response.data.cantidad > 0) {
              event.target.value = response.data.cantidad;
            }
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion());
      }
    },
    modalDescuento(unique, descuento) {
      if (this.id_factura == 0 && this.documento > 0) {
        this.empleado_autorizado = '';
        this.clave = '';
        this.descuento_producto = descuento;
        this.unique = unique;
        $('#modal-descuento').modal();
      }
      if (this.id_factura > 0 && this.documento == 1) {
        this.empleado_autorizado = '';
        this.clave = '';
        this.descuento_producto = descuento;
        this.unique = unique;
        $('#modal-descuento').modal();
      }

    },
    modalDescuentoGlobal() {
      if (this.id_factura == 0 && this.documento > 0) {
        this.empleado_autorizado = '';
        this.clave = '';
        $('#modal-descuento-global').modal();
      }
      if (this.id_factura > 0 && this.documento == 1) {
        this.empleado_autorizado = '';
        this.clave = '';
        $('#modal-descuento-global').modal();
      }
    },
    aplicarDescuentoAdicional() {
      if (!isNaN(this.descuento) && this.descuento >= 0) {
        axios({
          method: 'post',
          url: 'ptv/aplicarDescuentoAdicional',
          data: {
            'descuento': this.descuento,
            'id_cliente': this.selected_cli.id,
            'id_factura': this.id_factura,
            'empleado': this.empleado_autorizado,
            'clave': this.clave,
            'tipo': this.documento,
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            this.articulosTotal = response.data.articulos_cantidad;
            this.exentos = response.data.cantarticulos_exentos;
            this.subtotal = response.data.subtotal;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total;
            this.restante = response.data.total;
            this.descuento = response.data.descuento;

            this.cambio_divisa = response.data.cambio_divisa;

            this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => {
          this.empleado_autorizado = '';
          this.clave = '';
          $('#modal-descuento-global').modal('hide');
        })
      }
    },
    autorizarDescuentoProducto() {
      if (this.empleado_autorizado && this.clave && this.selected_cli.id && this.unique) {
        axios({
          method: 'post',
          url: 'ptv/autorizarDescuentoProducto',
          data: {
            'id_cliente': this.selected_cli.id,
            'id_factura': this.id_factura,
            'unique': this.unique,
            'empleado': this.empleado_autorizado,
            'clave': this.clave,
            'descuento': this.descuento_producto,
            'descuento_global': this.descuento,
            'tipo': this.documento,
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            this.articulosTotal = response.data.articulos_cantidad;
            this.exentos = response.data.cantarticulos_exentos;
            this.subtotal = response.data.subtotal;
            this.descuento = response.data.descuento;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total;
            this.carrito = response.data.carrito;

            this.cambio_divisa = response.data.cambio_divisa;

            this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => {
          this.empleado_autorizado = '';
          this.clave = '';
          this.unique = '';
          $('#modal-descuento').modal('hide');
        })
      }
    },
    guardarFactura() {
      let document = "";
      if (this.documento == 1) {
        document = "Nota de Entrega";
      }
      if (this.documento == 2) {
        document = "Factura";
      }
      if (this.documento == 3) {
        document = "Presupuesto";
      }
      if (this.documento == 4) {
        document = "Pedido";
      }
      Swal.fire({
        title: "<strong>¿Continuar?</strong>",
        html:
          "Documento: <strong>" + document + " en ventas",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        confirmButtonText: "SI",
        confirmButtonAriaLabel: "SI",
        cancelButtonText: "NO",
        cancelButtonAriaLabel: "NO",
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#aaa",
      }).then((result) => {
        if (result.value) {
          this.guardando();
        }
      });
    },
    guardando() {
      this.errorForm = [];

      if (this.carrito.length == 0)
        this.errorForm.push('No ha seleccinado algún producto para la compra');
      if (!this.serie_predeterminada)
        this.errorForm.push('Debe seleccionar una serie');

      if (this.selected_cli.id && this.errorForm.length == 0) {
        this.cargando = true;
        axios({
          method: 'post',
          url: 'ptv/ventaEnEspera',
          data: {
            'id_serie': this.serie_predeterminada,
            'id_sucursal': this.sucursal_predeterminada,
            'id_cliente': this.selected_cli.id,
            'observaciones': this.observaciones,
            'descuento_global': this.descuento,
            'id_factura': this.id_factura,
            'tipo': this.documento,
            'agente': this.emp_agente,
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            location.href = response.data;
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion()).finally(() => this.cargando = false);
      } else {
        let total_errores = this.errorForm.length
        for (let i = 0; i < total_errores; i++) {
          notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
        }
      }
    },
    factor_b(){
      let rest = convertir_a_float(String(this.restante_original));
      let factor = convertir_a_float(String(this.div_conv_factor));
      let fact= rest*factor;
      this.restante=fact;
      this.total_pagar = parseFloat(this.total * factor).toFixed(this.moneyPagar.precision);
      this.total_pagado_div = parseFloat(this.total_pagado * factor).toFixed(this.moneyPagar.precision);
    },
    eliminarProducto(unique) {
      if (this.selected_cli.id && unique) {
        axios({
          method: 'post',
          url: 'ptv/eliminarProducto',
          data: {
            'unique': unique,
            'id_cliente': this.selected_cli.id,
            'tipo': this.documento,
            'descuento_global': this.descuento,
            'id_factura': this.id_factura,
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            this.articulosTotal = response.data.articulos_cantidad;
            this.exentos = response.data.cantarticulos_exentos;
            this.subtotal = response.data.subtotal;
            this.descuento = response.data.descuento;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total;
            this.carrito = response.data.carrito;

            this.cambio_divisa = response.data.cambio_divisa;

            this.desc_monto = convertir_a_float(String(this.neto)) * (convertir_a_float(String(this.descuento)) / 100);
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion());
      }
    },
    modalAnular() {
      if (this.id_factura > 0) {
        $('#modal_anular').modal();
        $('#modal_anular').on('shown.bs.modal', function () {
          $('#observacion_anular').trigger('focus')
        });
      } else {
        location.href = '';
      }
    },
    anular() {
      Swal.fire({
        title: '<strong>¿Seguro que desea anular?</strong>',
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        cancelButtonColor: '#aaa',
        confirmButtonColor: '#3085d6',
        confirmButtonText: 'Aceptar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.value) {
          axios.get('ptv/anularFactura', {
            params: {
              id_factura: this.id_factura,
              descripcion: this.observacion_anular,
              'tipo': this.documento,
            }
          }).then(response => {
            if (response.data.errors == null) {
              if (response.data !== false) {
                location.href = response.data;
              } else {
                notificacion('fa fa-ban', 'Error', 'Error al anular Nota de Entrega', 'danger');
              }
            } else {
              let total_errores = response.data.errors.length
              for (let i = 0; i < total_errores; i++) {
                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
              }
            }
          }).catch(e => notificacion()).finally(() => this.cargando = false);
        }
      });
    },
    eliminarPago(id) {
      axios({
        method: 'post',
        url: 'ptv/eliminarPago',
        data: { 'id_factura': this.id_factura, 'tipo': this.documento, 'id': id },
        transformRequest: serializar(),
      }).then(response => {
        if (response.data.errors == null) {
          if (response.data) {
            this.abonos = response.data.abonos;
            this.restante_original = Number(response.data.restante).toFixed(this.money.precision);
            this.restante = parseFloat(response.data.restante * convertir_a_float(String(this.div_conv_factor))).toFixed(this.money.precision);
            this.total_pagado = Number(response.data.total_pagado).toFixed(this.money.precision);
            //this.monto = this.restante;
            notificacion('fa fa-trash', 'Eliminado', 'Pago eliminado', 'danger');
          }
        } else {
          this.divisa_pagar = '';
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());
    },
    moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
      if (Object.keys(this.carrito).length > 0) {
        let monto_ = convertir_a_float(String(num).toString());
        return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
      }
    },
    actualizarDetalles() {

      this.errorForm = [];

      let dataFormClienteDetalle = {
          'id': this.selected_cli.id,
          'cli_dni': this.rif_c,
          'cli_razon_social':this.nombre_c,
          'cli_fecha_nac':this.fecha_c,
          'cli_email': this.email_c,
          'cli_telefono': this.telefono_c,
          'cli_direccion': this.dir_c,
          'id_agente':this.emp_agente,
          'id_captado':this.captado_agent,
          'factura':this.id_factura,
          'tipo':this.documento
      };

      if (!dataFormClienteDetalle.cli_dni)
          this.errorForm.push('El campo Número de Documento es obligatorio.');
      if (!dataFormClienteDetalle.cli_direccion)
          this.errorForm.push('El campo Dirección es obligatorio');
      if (!dataFormClienteDetalle.cli_razon_social)
          this.errorForm.push('El campo Razón Social es obligatorio.');

      if (this.errorForm.length == 0) {
          this.cargando = true;
          axios({
              method: 'post',
              url: 'ptv/guardarDetallesCliente',
              data: dataFormClienteDetalle,
              transformRequest: serializar(),
          }).then(response => {
              if (response.data.errors == null) {
                  if (response.data == true) {
                      notificacion('fa fa-edit', '', 'Actualización exitosa', 'info');
                  }
              } else {
                  let total_errores = response.data.errors.length
                  for (let i = 0; i < total_errores; i++) {
                      notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                  }
              }
          }).catch(e => notificacion()).finally(() => this.cargando = false);
      } else {
          let total_errores = this.errorForm.length
          for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
          }
      }
    },
    cne() {
      let dataFormcne = {
          'tipo': this.dataForm.cli_tipodoc,
          'cli_dni': this.dataForm.cli_dni
      };
      document.getElementById('btncne').disabled = true;
          axios({
              method: 'post',
              url: 'ptv/cne',
              data: dataFormcne,
              transformRequest: serializar(),
          }).then(response => {
              if (response.data.error == 0) {
                 // if (response.data == true) {
                    console.log(response.data);
                    
                      this.dataForm.cli_razon_social=response.data.apellidos+' '+response.data.nombres;
                      this.dataForm.cli_direccion=response.data.direccion;
                 // }
              } else {
                 notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
              }
              document.getElementById('btncne').disabled = false;
          }).catch(e => notificacion()).finally();
    },
    obtenerRedesSociales() {
      axios.get('clientes/obtenerRedesSociales/' + this.selected_cli.id).then(response => {
          this.redesSociales = response.data;
      }).catch(e => notificacion());
  },
  editarGuardarRedes() {

      this.errorForm = [];

      if (!this.form_redes)
          this.errorForm.push('Seleccione el tipo de red social obligatorio.');

      if (!this.form_descripcion)
          this.errorForm.push('Agregue la descripcion de la red social obligatorio.');

      if (this.errorForm.length == 0) {
          axios({
              method: 'post',
              url: 'clientes/guardarRedes',
              data: {
                  'tipo':this.form_redes,
                  'descripcion':this.form_descripcion,
                  'id':this.selected_cli.id,
                  'rd':this.form_id
              },
              transformRequest: serializar(),
          }).then(response => {
              if (response.data.errors == null) {
                 this.obtenerRedesSociales();
                 this.form_descripcion='';
                 this.form_id='';
                 this.form_redes='';
              } else {
                  this.errorForm = response.data.errors;
              }
          }).catch(e => notificacion());
      }
  },
  verRedes(redes) {
      this.errorForm = [];
      this.form_redes = redes.clird_type;
      this.form_descripcion = redes.clird_descripcion;
      this.form_id = redes.clird_id;
  },
  eliminarRedes(redes) {

      this.errorForm = [];

      Swal.fire({
          title: 'Eliminar Red social',
          text: "¿Estás seguro que deseas eliminar la red social " + redes.clird_type + " ?",
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#aaa',
          cancelButtonText: 'Cancelar',
          confirmButtonText: 'Eliminar'
      }).then((result) => {
          if (result.value) {
              axios.get('clientes/eliminarRedes/' + redes.clird_id).then(response => {
                  if (response.data.errors == null) {
                      if (response.data == true) {
                          let posicion = this.redesSociales.findIndex(item => item.id == redes.clird_id);
                          this.redesSociales.splice(posicion, 1);
                          notificacion('fa fa-trash', 'Red social eliminada', redes.clird_descripcion.toUpperCase(), 'danger');
                      } else {
                          notificacion('fa fa-ban', 'Error al eliminar', redes.clird_descripcion.toUpperCase(), 'danger');
                      }
                  } else {
                      this.errorForm = response.data.errors;
                  }
              }).catch(e => notificacion()).finally(() => {
                  this.form_redes = '';
                  this.form_descripcion = '';
                  this.form_id='';
              })
          }
      });
  },
  ocultoBoton(){
   let a = document.getElementById("dni").value.length;
   if(a>=7 && this.dataForm.cli_tipodoc==2){
     document.getElementById("btncne").disabled = false;
   }else{
     document.getElementById('btncne').disabled = true;
   }
  },
  formatearSelect(){
    this.dataForm.cli_dni='';
  },
  activarBoton(){  
    if(this.dataForm.cli_tipodoc==2){
      document.getElementById("btncne").disabled = false;
    }
   }
  },
  computed: {
    balance() {
      let total = convertir_a_float(String(this.restante));
      let monto = convertir_a_float(String(this.monto));
      let balance_ = (total - monto);
      if (balance_ <= 0) {
        balance_ = 0;
      }
      return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision);
    },
    costo() {
      let sum=0;
      if (Object.keys(this.carrito).length > 0) {
        Object.keys(this.carrito).forEach((key, i) => {
          let costo=parseFloat(this.carrito[key].costo);
          let cantidad=parseFloat(this.carrito[key].cantidad);
          sum+=costo*cantidad;
          if (sum <= 0) {
            sum = 0;
          }
        });
     }
      return this.moneda(sum, this.money.locale, this.money.prefix, this.money.precision);
    },
    balance_n() {
      let total = convertir_a_float(String(this.restante));
      let monto = convertir_a_float(String(this.monto));
      let balance_ = (total - monto);
      if (balance_ <= 0) {
        balance_ = 0;
      }
      return balance_;
    },
    diferencia_n() {
      let total = convertir_a_float(String(this.restante));
      let monto = convertir_a_float(String(this.monto));
      let balance_ = (total - monto);
      return balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0;
    },
    diferencia() {
      let total = convertir_a_float(String(this.restante));
      let monto = convertir_a_float(String(this.monto));
      let balance_ = (total - monto);
      balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0
      return this.moneda(balance_, this.money.locale, this.money.prefix, this.money.precision);
    }
  }

});