moment.locale("es", {
  months: "Enero_Febrero_Marzo_Abril_Mayo_Junio_Julio_Agosto_Septiembre_Octubre_Noviembre_Diciembre".split("_"),
  monthsShort: "Enero._Feb._Mar_Abr._May_Jun_Jul._Ago_Sept._Oct._Nov._Dec.".split("_"),
  weekdays: "Domingo_Lunes_Martes_Miercoles_Jueves_Viernes_Sabado".split("_"),
  weekdaysShort: "Dom._Lun._Mar._Mier._Jue._Vier._Sab.".split("_"),
  weekdaysMin: "Do_Lu_Ma_Mi_Ju_Vi_Sa".split("_"),
  calendar: {
    sameDay: function () {
      return "[hoy a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    nextDay: function () {
      return "[mañana a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    nextWeek: function () {
      return "dddd [a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    lastDay: function () {
      return "[ayer a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    lastWeek: function () {
      return "[el] dddd [pasado a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    sameElse: "L",
  },
});
new Vue({
  el: "#appListas",
  data: {
    nueva_lista: "",
    id_tab: document.getElementById("id_tab").value,
    id_tarea_html: document.getElementById("id_tarea_html").value,
    abrirModal: document.getElementById("abrirModal").value,
    listas: [],
    checklist: [],
    tarea: {
      descripcion: null,
      id_lista: "",
      id_tarea: "",
      nombre_tarea: "",
      nombre_lista: "",
      creado:null
    },
    searchMiembros: [],
    miembros: [],
    searchClientes: [],
    cliente: [],
    fecha: "",
    hora: "",
    recordatorio: "",
    seleccion_documento: "",
    errorForm: [],
    archivo: "",
    upload_imagen: "",
    adjuntos: {
      enlaces: [],
      archivos: [],
    },
    comentarios: [],
    historicoTablero: [],
    favorito: 0,
    icon: "",
    listafn: [],
    loader_correo: false,
    clientem:false,
    id_plant:0,
    tipoci:2,
    clidni:'',
    natural:true
  },
  created() {
    if(this.id_tab>0){
      this.obtenerListas();
      this.obtenerHistoricoTablero();
    }

    if (this.abrirModal > 0) {
      this.modalTarjeta(this.abrirModal);
    }
  },
  mounted() {
    document.getElementById("nueva_lista").focus();
    if (document.getElementById("id_favorito").value == 1) {
      this.icon = "fas fa-star";
      this.favorito = 1;
    } else {
      this.icon = "far fa-star";
      this.favorito = 0;
    }
  },
  methods: {
    guardarCliente() {

      this.errorForm = [];
console.log(document.getElementById('cli_tipodoc').value)
      if (document.getElementById('cli_tipodoc').value=="")
          this.errorForm.push('El campo Tipo de Documento es obligatorio.');
      if (document.getElementById('cli_telefono').value=="")
          this.errorForm.push('El campo Teléfono es obligatorio.');
      if (document.getElementById('cli_direccion').value=="")
          this.errorForm.push('El campo Dirección es obligatorio.');
      if (document.getElementById('cli_dni').value=="")
          this.errorForm.push('El campo Número de Documento es obligatorio.');
      if (document.getElementById('cli_razon_social').value=="")
          this.errorForm.push('El campo Razón Social es obligatorio.');
      if (document.getElementById('cli_email').value=="") {
          if (!validaEmail(document.getElementById('cli_email').value))
              this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
      }

      (this.natural)? true : false;

      if (this.errorForm.length == 0) {
          this.cargando = true;
          axios({
              method: 'post',
              url: 'servicios/guardarCliente',
              data: {
                'cli_tipodoc':document.getElementById('cli_tipodoc').value,
                'cli_telefono':document.getElementById('cli_telefono').value,
                'cli_direccion':document.getElementById('cli_direccion').value,
                'cli_dni':document.getElementById('cli_dni').value,
                'cli_razon_social':document.getElementById('cli_razon_social').value,
                'cli_email':document.getElementById('cli_email').value,
                'cli_natural':document.getElementById('cli_natural').value
              },
              transformRequest: serializar(),
          }).then(response => {
              if (response.data.errors == null) {
                if (response.data.estatus==true) {
                  notificacion('fa fa-check', 'Guardado', 'Cliente guardado', 'success');
                  this.agregarCliente(response.data.id);
                  this.clientem=false;
                } else {
                    notificacion('fa fa-ban', 'Error', 'Error al guardar', 'warning');
                }
              } else {
                  let total_errores = response.data.errors.length
                  for (let i = 0; i < total_errores; i++) {
                      notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                  }
              }
          }).catch(e => notificacion()).finally(() => {
              this.cargando = false;
          });
      }else{
        for (let i = 0; i < this.errorForm.length; i++) {
            notificacion('fa fa-ban', 'Advertencia',this.errorForm[i], 'warning');
        }
    }
  },
    formatearSelect(){
      this.clidni='';
    },
    Addcliente(cu){
      this.clientem=(cu==true)?false:true;
    },
    obtenerListas() {
      axios
        .get("servicios/obtenerTabListas/" + this.id_tab)
        .then((response) => {
          this.listas = response.data;
          console.log(response.data)
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargarSortable();
          if (this.id_tarea_html) {
            this.modalTarjeta(this.id_tarea_html, null);
          }
        });
    },
    agregarLista(event) {
      if (this.nueva_lista) {
        let orden = this.listas.length;
        axios({
          method: "post",
          url: "servicios/agregarLista",
          data: {
            id: this.id_tab,
            nombre: event.target.value,
            orden: orden,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data !== null) {
                this.listas.push({
                  id: response.data,
                  nombre: this.nueva_lista,
                  orden: orden,
                  tareas: [],
                });
                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => {
            notificacion();
          })
          .finally(() => {
            this.nueva_lista = "";
            this.cargarSortable();
          });
      }
    },
    agregarTarea(lista, event) {
      if (lista && event.target.value) {
        let ev = event.target.value;

        let posicion_lista = this.listas.findIndex((element) => element.id == lista.id);
        let orden = lista.tareas.length;

        axios({
          method: "post",
          url: "servicios/agregarTarea",
          data: {
            id_tab: this.id_tab,
            id: lista.id,
            nombre: event.target.value,
            orden: orden,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data !== null) {
                this.obtenerListas();
                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => {
            notificacion();
          })
          .finally(() => {
            event.target.value = "";
            this.cargarSortable();
          });
      }
    },
    imprimirTicket(id) {
            axios.get('servicios/imprimirTicket', {
                params: {
                    id: id,
                }
            }).then(response => {
               
                if (response.data.errors == null) {
                    if (response.data !== false) {
                      fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            
                            if (j.ok) {
                                notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                        });
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());

        },
    preEditarTarea(tarea) {
      let titulo_tarea = document.getElementById("titulo_tarea" + tarea.id);
      let titulo_tarea_hidden = document.getElementById("titulo_tarea_hidden" + tarea.id);

      titulo_tarea.style.display = "none";
      titulo_tarea_hidden.style.display = "block";
      titulo_tarea_hidden.focus();

      titulo_tarea_hidden.addEventListener("blur", () => {
        titulo_tarea.style.display = "inline-block";
        titulo_tarea_hidden.style.display = "none";
      });
    },
    editarTarea(tarea, event) {
      let titulo_tarea_hidden = event.target;

      if (!titulo_tarea_hidden.value) {
        alert("El titulo es obligatorio");
      } else {
        axios({
          method: "post",
          url: "servicios/editarTarea",
          data: {
            id_tab: this.id_tab,
            tarea: tarea.id,
            nombre: titulo_tarea_hidden.value,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                tarea.nombre = titulo_tarea_hidden.value;
                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            titulo_tarea_hidden.blur();
            titulo_tarea_hidden.style.display = "none";
            document.getElementById("titulo_tarea" + tarea.id).style.display = "inline-block";
          });
      }
    },
    guardarPosicionListas() {
      if (this.listas) {
        axios({
          method: "post",
          url: "servicios/guardarPosicionListas",
          data: {
            id_tab: this.id_tab,
            listas: this.listas,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                notificacion("fa fa-check", "", "Posición actualizada", "success");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
              this.obtenerListas();
            }
          })
          .catch((e) => notificacion());
      }
    },
    preEditarLista(lista, event) {
      let titulo_visible = event.target;
      let titulo_hidden = document.getElementById("titulo_lista_hidden" + lista.id);

      titulo_visible.style.display = "none";
      titulo_hidden.style.display = "block";
      titulo_hidden.focus();

      titulo_hidden.addEventListener("blur", () => {
        titulo_visible.style.display = "inline-block";
        titulo_hidden.style.display = "none";
      });
    },
    editarLista(lista, event) {
      let titulo = event.target;
      if (!titulo.value) {
        alert("El titulo es obligatorio");
      } else {
        axios({
          method: "post",
          url: "servicios/editarLista",
          data: {
            lista: lista.id,
            nombre: titulo.value,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                lista.nombre = titulo.value;
                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            titulo.blur();
            titulo.style.display = "none";
            document.querySelector(".titulo_lista").style.display = "inline-block";
          });
      }
    },
    eliminarLista(lista) {
      Swal.fire({
        title: "<strong>¿Eliminar Lista?</strong>",
        text: "¿Estás seguro de eliminar la lista " + lista.nombre + " ?",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("servicios/eliminarLista/" + lista.id)
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  this.obtenerListas();
                  notificacion("fa fa-trash", "", "Lista eliminada", "danger");
                  this.obtenerHistoricoTablero();
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion());
        }
      });
    },
    preEditarChecklist(checklist) {
      let titulo_checklist_hidden = document.getElementById("titulo_checklist_hidden" + checklist.id);
      document.getElementById("titulo_checklist" + checklist.id).style.display = "none";
      titulo_checklist_hidden.style.display = "block";
      titulo_checklist_hidden.focus();
      titulo_checklist_hidden.addEventListener("blur", () => {
        document.getElementById("titulo_checklist" + checklist.id).style.display = "block";
        document.getElementById("titulo_checklist_hidden" + checklist.id).style.display = "none";
      });
    },
    editarChecklist(checklist) {
      let text_nombre = document.getElementById("titulo_checklist_hidden" + checklist.id).value;
      axios({
        method: "post",
        url: "servicios/editarChecklist",
        data: {
          id_tab: this.id_tab,
          checklist: checklist.id,
          nombre: text_nombre,
        },
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              document.getElementById("titulo_checklist" + checklist.id).innerHTML =
                '<i class="fas fa-check-double"></i> ' + text_nombre;
              this.obtenerHistoricoTablero();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          document.getElementById("titulo_checklist" + checklist.id).style.display = "block";
          document.getElementById("titulo_checklist_hidden" + checklist.id).style.display = "none";
        });
    },
    guardarPosicionTareas(tareas) {
      if (tareas) {
        axios({
          method: "post",
          url: "servicios/guardarPosicionTareas",
          data: {
            id_tab: this.id_tab,
            tareas: tareas,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                notificacion("fa fa-check", "", "Posición actualizada", "success");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
              this.obtenerListas();
            }
          })
          .catch((e) => notificacion());
      }
    },
    async guardarMovimientoTareas(list_id, tareas) {
      if (list_id && tareas) {
        await axios({
          method: "post",
          url: "servicios/guardarMovimientoTareas",
          data: {
            id_tab: this.id_tab,
            list_id: list_id,
            tareas: tareas,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                notificacion("fa fa-check", "", "Posición actualizada", "success");
                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
              this.obtenerListas();
            }
          })
          .catch((e) => notificacion());
      }
    },
    modalTarjeta(tar, event) {
      if (
        event == null ||
        event.target.className == "kanban-item sortable-drag" ||
        event.target.className == "kanban-title" ||
        event.target.className == "kanban-badges"
      ) {
        axios
          .get("servicios/obtenerChecklist/" + tar)
          .then((response) => {
            this.tarea.descripcion = response.data.tarea_descripcion;
            this.tarea.id_lista = response.data.lista_id;
            this.tarea.nombre_lista = response.data.lista_nombre;
            this.tarea.id_tarea = response.data.tarea_id;
            this.tarea.nombre_tarea = response.data.tarea_nombre;
            this.tarea.creado=response.data.tarea_empcreado;
            this.fecha = response.data.tarea_fecha_ven;
            this.hora = response.data.tarea_hora_ven;
            this.recordatorio = response.data.tarea_recordatorio;
            this.checklist = response.data.checklist;
          })
          .catch((e) => notificacion())
          .finally(() => {
            this.cargarPorcentaje();
            this.obtenerComentarios();
            $("#modalTarjeta").modal("show");
            this.obtenerMiembros(this.tarea.id_tarea);
            this.obtenerCliente(this.tarea.id_tarea);
            this.obtenerAdjuntos(this.tarea.id_tarea);
            this.obtenerFactNota(this.tarea.id_tarea)
            console.log(this.tarea.id_tarea)
            cerrarPopup();
          });
      }
    },
    obtenerAdjuntos(id) {
      axios
        .get("servicios/obtenerAdjuntos/" + id)
        .then((response) => {
          this.adjuntos.enlaces = response.data.enlaces;
          this.adjuntos.archivos = response.data.archivos;
        })
        .catch((e) => notificacion());
    },
    obtenerHistoricoTablero() {
      axios
        .get("servicios/obtenerHistoricoTablero/" + this.id_tab)
        .then((response) => {
          if (Array.isArray(response.data) && response.data.length > 0) {
            this.historicoTablero = response.data;
          }
        })
        .catch((e) => notificacion());
    },
    modalcheck() {
      let inputchecklist = document.getElementById("inputChecklist");
      let elpopup = document.getElementById("popup");
      let el = document.getElementById("checklist");

      if (elpopup.style.display == "inline-block") {
        elpopup.style.display = "none";
      } else {
        function getOffset(el) {
          const rect = el.getBoundingClientRect();
          return {
            left: rect.left + window.scrollX,
            top: rect.top + window.scrollY,
          };
        }

        let izquierdo = getOffset(el).left;
        let arriba = getOffset(el).top;

        elpopup.style.left = izquierdo + "px";
        elpopup.style.top = arriba + 41 + "px";

        elpopup.style.display = "inline-block";

        inputchecklist.focus();
      }
    },
    agregarChecklist() {
      document.getElementById("popup").style.display = "none";

      let orden = this.checklist.length;
      let plantilla = document.getElementById("inputChecklist").value;

      this.tarea.id_lista;

      if (plantilla == "" || plantilla == 0) {
        axios({
          method: "post",
          url: "servicios/agregarChecklist",
          data: {
            id_tab: this.id_tab,
            tarea: this.tarea.id_tarea,
            nombre: "Actividades",
            orden: orden,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data !== false) {
                this.checklist.push({
                  id: response.data,
                  nombre: "Actividades",
                  orden: orden,
                  items: [],
                });
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      } else {
        axios({
          method: "post",
          url: "servicios/agregarPlantilla",
          data: {
            id_tab: this.id_tab,
            tarea: this.tarea.id_tarea,
            orden: orden,
            plantilla: plantilla,
            nombre: document.getElementById('inputChecklist').value
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.checklist = response.data;

              let total = 0;
              this.checklist.forEach((element) => {
                total += element.items.length;
              });

              let posicion_lista = this.listas.findIndex((element) => element.id == this.tarea.id_lista);
              let posicion_tarea = this.listas[posicion_lista].tareas.findIndex(
                (element) => element.id == this.tarea.id_tarea
              );
              this.listas[posicion_lista].tareas[posicion_tarea].check.total = total;
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }

      this.obtenerHistoricoTablero();
    },
    eliminarChecklist(checklist_id) {
      axios
        .get("servicios/eliminarChecklist", {
          params: {
            id_tab: this.id_tab,
            checklist_id: checklist_id,
          },
        })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              let posicion_checklist = this.checklist.findIndex((element) => element.id == checklist_id);

              let total_listos = 0;
              let total = 0;

              this.checklist[posicion_checklist]["items"].forEach((element) => {
                if (element.estatus == 1) {
                  total_listos += 1;
                }
                total += 1;
              });

              let posicion_lista = this.listas.findIndex((element) => element.id == this.tarea.id_lista);
              let posicion_tarea = this.listas[posicion_lista].tareas.findIndex(
                (element) => element.id == this.tarea.id_tarea
              );
              this.listas[posicion_lista].tareas[posicion_tarea].check.listos =
                parseInt(this.listas[posicion_lista].tareas[posicion_tarea].check.listos) - total_listos;
              this.listas[posicion_lista].tareas[posicion_tarea].check.total =
                parseInt(this.listas[posicion_lista].tareas[posicion_tarea].check.total) - total;
              this.checklist.splice(posicion_checklist, 1);

              notificacion("fa fa-trash", "", "Checklist eliminado", "danger");

              this.obtenerHistoricoTablero();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargarPorcentaje();
        });
    },
    preAgregarItem(checklist_id) {
      if (checklist_id) {
        let posicion_checklist = this.checklist.findIndex((element) => element.id == checklist_id);
        let orden = this.checklist[posicion_checklist]["items"].length;
        this.checklist[posicion_checklist]["items"].push({
          id: "",
          descripcion: null,
          estatus: false,
          orden: orden,
          creado: "",
          actualizado: "",
        });
        /*document.addEventListener("click", function (e) {
          let textarea_item = document.getElementById("textarea_item");
          if (textarea_item) {
            textarea_item.select();
          }
        });*/
      }
    },
    preEditarItem(item_id) {
      let span_textarea_item = document.getElementById("span_textarea_item" + item_id);
      span_textarea_item.style.display = "none";
      let div_textarea_item = document.getElementById("div_textarea_item" + item_id);
      div_textarea_item.style.display = "block";
      let textarea_item = document.getElementById("textarea_item" + item_id);
      textarea_item.focus();
      textarea_item.addEventListener("blur", () => {
        setTimeout(() => {
          span_textarea_item.style.display = "block";
          div_textarea_item.style.display = "none";
        }, 100);
      });
    },
    agregarItem(checklist_id, item) {
      let descripcion = document.getElementById("textarea_item" + item.id).value;

      let posicion_checklist = this.checklist.findIndex((element) => element.id == checklist_id);
      let posicion_item = this.checklist[posicion_checklist]["items"].findIndex((element) => element.id == item.id);

      if ((checklist_id, item, descripcion)) {
        axios({
          method: "post",
          url: "servicios/agregarItem",
          data: {
            id_tab: this.id_tab,
            checklist_id: checklist_id,
            item: {
              id: item.id,
              descripcion: descripcion,
              estatus: false,
              orden: item.orden,
            },
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == false) {
                this.checklist[posicion_checklist]["items"].splice(posicion_item, 1);
              } else {
                if (item.id == "") {
                  this.checklist[posicion_checklist].items[posicion_item].id = response.data.id;
                  this.checklist[posicion_checklist].items[posicion_item].descripcion = descripcion;
                  this.checklist[posicion_checklist].items[posicion_item].creado = response.data.creado;
                  this.checklist[posicion_checklist].items[posicion_item].actualizado = response.data.actualizado;
                  let posicion_lista = this.listas.findIndex((element) => element.id == this.tarea.id_lista);
                  let posicion_tarea = this.listas[posicion_lista].tareas.findIndex(
                    (element) => element.id == this.tarea.id_tarea
                  );
                  this.listas[posicion_lista].tareas[posicion_tarea].check.total =
                    parseInt(this.listas[posicion_lista].tareas[posicion_tarea].check.total) + 1;
                  notificacion("fa fa-ban", "", "Item registrado", "success");
                } else {
                  this.checklist[posicion_checklist]["items"][posicion_item]["creado"] = response.data.creado;
                  this.checklist[posicion_checklist]["items"][posicion_item]["actualizado"] = response.data.actualizado;
                  notificacion("fa fa-info", "", "Item actualizado", "info");
                }
                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => {
            this.checklist[posicion_checklist]["items"][posicion_item].splice(posicion_item, 1);
            notificacion();
          })
          .finally(() => {
            this.cargarPorcentaje();
          });
      }
    },
    modificarEstatusItem(id, event) {
      axios({
        method: "post",
        url: "servicios/modificarEstatusItem",
        data: {
          id_tab: this.id_tab,
          id: id,
          estatus: event.target.checked,
        },
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == false) {
              notificacion("fa fa-ban", "Advertencia", "Error al actualizar check", "danger");
            } else {
              let posicion_lista = this.listas.findIndex((element) => element.id == this.tarea.id_lista);
              let posicion_tarea = this.listas[posicion_lista].tareas.findIndex(
                (element) => element.id == this.tarea.id_tarea
              );
              if (event.target.checked == true) {
                this.listas[posicion_lista].tareas[posicion_tarea].check.listos =
                  parseInt(this.listas[posicion_lista].tareas[posicion_tarea].check.listos) + 1;
              } else {
                this.listas[posicion_lista].tareas[posicion_tarea].check.listos =
                  parseInt(this.listas[posicion_lista].tareas[posicion_tarea].check.listos) - 1;
              }
              this.obtenerHistoricoTablero();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargarPorcentaje();
        });
    },
    eliminarItem(checklist_id, id_item) {
      if (id_item) {
        axios
          .get("servicios/eliminarItem", {
            params: {
              id_tab: this.id_tab,
              id_item: id_item,
            },
          })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                let posicion_checklist = this.checklist.findIndex((element) => element.id == checklist_id);
                let posicion_item = this.checklist[posicion_checklist]["items"].findIndex(
                  (element) => element.id == id_item
                );
                let posicion_lista = this.listas.findIndex((element) => element.id == this.tarea.id_lista);
                let posicion_tarea = this.listas[posicion_lista].tareas.findIndex(
                  (element) => element.id == this.tarea.id_tarea
                );

                if (this.checklist[posicion_checklist]["items"][posicion_item].estatus == true) {
                  this.listas[posicion_lista].tareas[posicion_tarea].check.listos =
                    parseInt(this.listas[posicion_lista].tareas[posicion_tarea].check.listos) - 1;
                }

                this.listas[posicion_lista].tareas[posicion_tarea].check.total =
                  parseInt(this.listas[posicion_lista].tareas[posicion_tarea].check.total) - 1;
                this.checklist[posicion_checklist]["items"].splice(posicion_item, 1);

                notificacion("fa fa-trash", "", "Item eliminado", "danger");

                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            this.cargarPorcentaje();
          });
      } else {
        let posicion_checklist = this.checklist.findIndex((element) => element.id == checklist_id);
        this.checklist[posicion_checklist]["items"].pop();
      }
    },
    actualizarDescripcionTarea(event) {
      if (event.target.value) {
        axios({
          method: "post",
          url: "servicios/modificarDescripcionTarea",
          data: {
            id_tab: this.id_tab,
            id: this.tarea.id_tarea,
            descripcion: event.target.value,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                let posicion_lista = this.listas.findIndex((element) => element.id == this.tarea.id_lista);
                let posicion_tarea = this.listas[posicion_lista].tareas.findIndex(
                  (element) => element.id == this.tarea.id_tarea
                );
                this.listas[posicion_lista].tareas[posicion_tarea].descripcion = event.target.value;
                notificacion("fa fa-info", "", "Descripcion actualizada", "info");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            this.tarea.descripcion = event.target.value;
            if (document.getElementById("span_descripcion_tarea" + this.tarea.id_tarea)) {
              let span_descripcion_tarea = document.getElementById("span_descripcion_tarea" + this.tarea.id_tarea);
              span_descripcion_tarea.style.display = "block";
              let texarea_descripcion_tarea = document.getElementById(
                "texaera_descripcion_tarea" + this.tarea.id_tarea
              );
              texarea_descripcion_tarea.style.display = "none";
            }
          });
      }
    },
    modalMiembros() {
      let inputMiembros = document.getElementById("inputMiembros");
      let elpopup = document.getElementById("popupMiembros");
      let el = document.getElementById("tabmiembros");

      if (elpopup.style.display == "inline-block") {
        elpopup.style.display = "none";
      } else {
        function getOffset(el) {
          const rect = el.getBoundingClientRect();
          return {
            left: rect.left + window.scrollX,
            top: rect.top + window.scrollY,
          };
        }

        let izquierdo = getOffset(el).left;
        let arriba = getOffset(el).top;

        elpopup.style.left = izquierdo + "px";
        elpopup.style.top = arriba + 41 + "px";

        elpopup.style.display = "inline-block";

        inputMiembros.select();
      }
    },
    buscarMiembros(event) {
      if (event.target.value) {
        if (event.target.value.length > 2) {
          axios
            .get("servicios/buscarMiembros", {
              params: {
                buscar: event.target.value,
                tarea: this.tarea.id_tarea,
              },
            })
            .then((response) => {
              if (response.data.length > 0) {
                this.searchMiembros = response.data;
              } else {
                this.searchMiembros = [];
              }
            })
            .catch((e) => notificacion());
        } else {
          this.searchMiembros = [];
        }
      }
    },
    agregarMiembro(miembro) {
      if (miembro) {
        axios({
          method: "post",
          url: "servicios/agregarMiembro",
          data: {
            id_tab: this.id_tab,
            tarea: this.tarea.id_tarea,
            miembro: miembro,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                this.searchMiembros = [];
                this.obtenerMiembros(this.tarea.id_tarea);
              }
            } else {
              this.searchMiembros = [];
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            document.getElementById("inputMiembros").value = "";
          });
      }
    },
    obtenerMiembros(id_tarea) {
      axios
        .get("servicios/obtenerMiembros/" + Number(id_tarea))
        .then((response) => {
          this.miembros = response.data;
        })
        .catch((e) => notificacion());
    },
    eliminarMiembro(id) {
      axios
        .get("servicios/eliminarMiembro", {
          params: {
            id_tab: this.id_tab,
            id_miembro: id,
          },
        })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              this.obtenerMiembros(this.tarea.id_tarea);
            } else {
              notificacion("fa fa-times", "", "Error al eliminar miembro", "danger");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    modalClientes() {
      let inputClientes = document.getElementById("inputClientes");
      let elpopup = document.getElementById("popupCliente");
      let el = document.getElementById("tabcliente");

      if (elpopup.style.display == "inline-block") {
        elpopup.style.display = "none";
      } else {
        function getOffset(el) {
          const rect = el.getBoundingClientRect();
          return {
            left: rect.left + window.scrollX,
            top: rect.top + window.scrollY,
          };
        }

        let izquierdo = getOffset(el).left;
        let arriba = getOffset(el).top;

        elpopup.style.left = izquierdo + "px";
        elpopup.style.top = arriba + 41 + "px";

        elpopup.style.display = "inline-block";

        inputClientes.select();
      }
    },
    buscarClientes(event) {
      if (event.target.value) {
        if (event.target.value.length > 2) {
          axios
            .get("servicios/buscarClientes", {
              params: {
                buscar: event.target.value,
              },
            })
            .then((response) => {
              if (response.data.length > 0) {
                this.searchClientes = response.data;
              } else {
                this.searchClientes = [];
              }
            })
            .catch((e) => notificacion());
        } else {
          this.searchClientes = [];
        }
      }
    },
    agregarCliente(cliente) {
      if (cliente) {
        axios({
          method: "post",
          url: "servicios/agregarCliente",
          data: {
            id_tab: this.id_tab,
            tarea: this.tarea.id_tarea,
            cliente: cliente,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                this.searchClientes = [];
                this.obtenerCliente(this.tarea.id_tarea);
              }
            } else {
              this.searchClientes = [];
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            document.getElementById("inputClientes").value = "";
          });
      }
    },
    obtenerCliente(id_tarea) {
      axios
        .get("servicios/obtenerCliente/" + escape(id_tarea))
        .then((response) => {
          this.cliente = response.data;
        })
        .catch((e) => notificacion());
    },
    eliminarCliente(id) {
      axios
        .get("servicios/eliminarCliente", {
          params: {
            id_tab: this.id_tab,
            id_tarea: this.tarea.id_tarea,
          },
        })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              this.cliente = "";
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    modalVencimiento() {
      let fecha_ven = document.getElementById("fecha_ven");
      let elpopup = document.getElementById("popupVencimiento");
      let el = document.getElementById("tabvencimiento");

      if (elpopup.style.display == "inline-block") {
        elpopup.style.display = "none";
      } else {
        function getOffset(el) {
          const rect = el.getBoundingClientRect();
          return {
            left: rect.left + window.scrollX,
            top: rect.top + window.scrollY,
          };
        }

        let izquierdo = getOffset(el).left;
        let arriba = getOffset(el).top;

        elpopup.style.left = izquierdo + "px";
        elpopup.style.top = arriba + 41 + "px";

        elpopup.style.display = "inline-block";

        fecha_ven.focus();
      }
    },
    modalAdjunto() {
      let elpopup = document.getElementById("popupAdjunto");
      let el = document.getElementById("tabadjunto");

      if (elpopup.style.display == "inline-block") {
        elpopup.style.display = "none";
      } else {
        function getOffset(el) {
          const rect = el.getBoundingClientRect();
          return {
            left: rect.left + window.scrollX,
            top: rect.top + window.scrollY,
          };
        }

        let izquierdo = getOffset(el).left;
        let arriba = getOffset(el).top;

        elpopup.style.left = izquierdo + "px";
        elpopup.style.top = arriba + 41 + "px";

        elpopup.style.display = "inline-block";
      }
    },
    modalDocumento() {
      let elpopup = document.getElementById("popupDocumento");
      let el = document.getElementById("tabdocumento");

      if (elpopup.style.display == "inline-block") {
        elpopup.style.display = "none";
      } else {
        function getOffset(el) {
          const rect = el.getBoundingClientRect();
          return {
            left: rect.left + window.scrollX,
            top: rect.top + window.scrollY,
          };
        }

        let izquierdo = getOffset(el).left;
        let arriba = getOffset(el).top;

        elpopup.style.left = izquierdo + "px";
        elpopup.style.top = arriba + 41 + "px";

        elpopup.style.display = "inline-block";
      }
    },
    generarDocumento() {
      let cliente = this.cliente.id;
      let seleccion = this.seleccion_documento;
      if (seleccion.trim().length > 0 && cliente.trim().length > 0) {
        location.href = baseURL + seleccion + '/nuevaFactura/' + cliente + '/?tab=' + this.tarea.id_tarea;
      } else {
        notificacion("fa fa-ban", "Advertencia", "Debe seleccionar un documento", "warning");
      }
    },
    guardarEnlace() {
      let enlace = document.getElementById("inputEnlace").value;
      let enlace_nombre = document.getElementById("inputEnlaceNombre").value;

      if (enlace) {
        axios({
          method: "post",
          url: "servicios/guardarEnlace",
          data: {
            id_tab: this.id_tab,
            tarea: this.tarea.id_tarea,
            enlace: enlace,
            enlace_nombre: enlace_nombre,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                this.obtenerAdjuntos(this.tarea.id_tarea);
                document.getElementById("popupAdjunto").style.display = "none";
                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    handleFileUpload() {
      this.archivo = this.$refs.file.files[0];

      if (this.archivo) {
        this.upload_imagen = "is-loading is-loading-lg";
        axios({
          method: "post",
          url: "servicios/subirArchivoTarea",
          data: {
            id_tab: this.id_tab,
            tarea: this.tarea.id_tarea,
            archivo: this.archivo,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                this.obtenerAdjuntos(this.tarea.id_tarea);
                document.getElementById("popupAdjunto").style.display = "none";
                this.obtenerHistoricoTablero();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => {
            notificacion();
          })
          .finally(() => (this.upload_imagen = ""));
      }
    },
    guardarVencimiento() {
      axios({
        method: "post",
        url: "servicios/guardarVencimiento",
        data: {
          id_tab: this.id_tab,
          tarea: this.tarea.id_tarea,
          fecha: this.fecha,
          hora: this.hora,
          recordatorio: this.recordatorio,
        },
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              let posicion_lista = this.listas.findIndex((element) => element.id == this.tarea.id_lista);
              let posicion_tarea = this.listas[posicion_lista].tareas.findIndex(
                (element) => element.id == this.tarea.id_tarea
              );
              this.listas[posicion_lista].tareas[posicion_tarea].fecha_ven = this.fecha;
              document.getElementById("popupVencimiento").style.display = "none";
              this.obtenerHistoricoTablero();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    modalCorreo(servicio) {
      $("#modalTarjeta").modal("hide");
      $('#modal_correo').modal('show');

      this.id_plant=servicio;
    },
    eliminarTarea(tarea, lista) {
      Swal.fire({
        title: "<strong>¿Eliminar Tarea?</strong>",
        text: "¿Estás seguro de eliminar la tarea " + tarea.nombre + " ?",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("servicios/eliminarTarea", {
              params: {
                id_tab: this.id_tab,
                id_tarea: tarea.id,
              },
            })
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  lista.tareas.splice(tarea.orden, 1);
                  lista.tareas.forEach((item, index) => {
                    item.orden = index;
                  });
                  this.obtenerHistoricoTablero();
                  notificacion("fa fa-trash", "", "Tarea eliminada", "danger");
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion());
        }
      });
    },
    agregarComentario() {
      let comentario = document.getElementById("agregar_comentario");

      let posicion_lista = this.listas.findIndex((element) => element.id == this.tarea.id_lista);
      let posicion_tarea = this.listas[posicion_lista].tareas.findIndex((element) => element.id == this.tarea.id_tarea);

      if (comentario.value && comentario.value.trim().length > 0 && this.tarea.id_tarea) {
        axios({
          method: "post",
          url: "servicios/guardarComentario",
          data: {
            comentario: comentario.value,
            tarea: this.tarea.id_tarea,
          },
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                this.listas[posicion_lista].tareas[posicion_tarea].total_comentarios += 1;
                this.obtenerComentarios();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            comentario.value = "";
          });
      }
    },
    obtenerComentarios() {
      axios.get("servicios/obtenerComentarios/" + this.tarea.id_tarea).then((response) => {
        this.comentarios = response.data;
      });
    },
    obtenerFactNota(id) {
      axios.get("servicios/obtenerFactNota/" + id).then((response) => {
        this.listafn = response.data;
      });
    },
    activarTexareaDescripcion() {
      let texarea_descripcion_tarea = document.getElementById("texaera_descripcion_tarea" + this.tarea.id_tarea);
      texarea_descripcion_tarea.style.display = "block";
    },
    preEditarDescripcion() {
      let span_descripcion_tarea = document.getElementById("span_descripcion_tarea" + this.tarea.id_tarea);
      span_descripcion_tarea.style.display = "none";
      let texarea_descripcion_tarea = document.getElementById("texaera_descripcion_tarea" + this.tarea.id_tarea);
      texarea_descripcion_tarea.style.display = "block";
      texarea_descripcion_tarea.focus();
      texarea_descripcion_tarea.addEventListener("blur", () => {
        span_descripcion_tarea.style.display = "block";
        texarea_descripcion_tarea.style.display = "none";
      });
    },
    cargarPorcentaje() {
      let total = 0;
      let porcentaje = 0;
      let total_completado = 0;

      this.checklist.forEach((element) => {
        total = element.items.length;
        porcentaje = 0;
        total_completado = 0;

        if (total > 0) {
          element.items.forEach((item) => {
            if (item.estatus == 1) {
              total_completado += 1;
            }
          });
        }

        if (total > 0) {
          porcentaje = Math.round((total_completado * 100) / total);
        }

        document.getElementById("titleProgress" + element.id).innerText = porcentaje + "%";
        document.getElementById("progressbar" + element.id).style.width = porcentaje + "%";
      });
    },
    cargarSortable() {
      let board = document.getElementById("listas_tareas");

      new Sortable(board, {
        group: "listas-tareas",
        animation: 150,
        draggable: ".kanban-board",
        handle: ".kanban-board-header",
        filter: ".ignore-sort",
        forceFallback: true,
        onUpdate: (evento) => {
          this.listas.splice(evento.newIndex, 0, this.listas.splice(evento.oldIndex, 1)[0]);
          this.listas.forEach((elemento, index) => {
            this.listas[index]["orden"] = index;
          });
          this.guardarPosicionListas();
        },
      });

      [].forEach.call(
        board.querySelectorAll(".tareas-drag"),
        function (el) {
          new Sortable(el, {
            group: "tareas",
            animation: 150,
            filter: ".ignore-sort",
            onUpdate: (evento) => {
              let lista_posicion = evento.item.attributes["data-lista-posicion"].value;
              this.listas[lista_posicion]["tareas"].splice(
                evento.newIndex,
                0,
                this.listas[lista_posicion]["tareas"].splice(evento.oldIndex, 1)[0]
              );
              this.listas[lista_posicion]["tareas"].forEach((elemento, index) => {
                this.listas[lista_posicion]["tareas"][index]["orden"] = index;
              });
              this.guardarPosicionTareas(this.listas[lista_posicion]["tareas"]);
            },
            onAdd: (evento) => {
              let from = evento.from.attributes["data-lista"].value;
              let from_posicion_lista = this.listas.findIndex((element) => element.id == from);

              let to = evento.to.attributes["data-lista"].value;
              let to_posicion_lista = this.listas.findIndex((element) => element.id == to);

              this.listas[to_posicion_lista]["tareas"].splice(
                evento.newIndex,
                0,
                this.listas[from_posicion_lista]["tareas"].splice(evento.oldIndex, 1)[0]
              );

              this.listas[to_posicion_lista]["tareas"].forEach((elemento, index) => {
                this.listas[to_posicion_lista]["tareas"][index]["orden"] = index;
              });

              this.listas[from_posicion_lista]["tareas"].forEach((elemento, index) => {
                this.listas[from_posicion_lista]["tareas"][index]["orden"] = index;
              });

              this.guardarMovimientoTareas(to, this.listas[to_posicion_lista]["tareas"]);

              if (this.listas[from_posicion_lista]["tareas"].length > 0) {
                this.guardarMovimientoTareas(from, this.listas[from_posicion_lista]["tareas"]);
              }
            },
          });
        },
        this
      );
    },
    preeditarComentario(comentario) {
      let comentario_ = document.getElementById("comentario" + comentario.id);
      let comentario_hidden = document.getElementById("comentario_hidden" + comentario.id);
      let textarea_comentario = document.getElementById("textarea_comentario" + comentario.id);

      comentario_.style.display = "none";
      comentario_hidden.style.display = "block";
      textarea_comentario.focus();

      if (!textarea_comentario.value) {
        textarea_comentario.value = comentario.descripcion;
      }

      textarea_comentario.addEventListener("blur", () => {
        setTimeout(() => {
          comentario_.style.display = "block";
          comentario_hidden.style.display = "none";
        }, 100);
      });
    },
    editarComentario(comentario) {
      let textarea_comentario = document.getElementById("textarea_comentario" + comentario.id);

      if (!textarea_comentario.value) {
        alert("EL comentario no puede quedar vacio");
      } else {
        axios({
          method: "post",
          url: "servicios/editarComentario",
          data: {
            id_tab: this.id_tab,
            id_com: comentario.id,
            descripcion: textarea_comentario.value,
          },
        }).then((response) => {
          if (response.data.errors == null) {
            if (response.data !== false) {
              comentario.descripcion = textarea_comentario.value;
              comentario.fecha = response.data.fecha;
              notificacion("fa fa-check", "", "Comentaio editado", "info");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        });
      }
    },
    cambiarFavorite() {
      axios({
        method: "post",
        url: "servicios/editarFavorito",
        data: {
          id_tab: this.id_tab,
          favorite: this.favorito == "1" ? 0 : 1,
        },
      }).then((response) => {
        if (response.data.errors == null) {
          if (response.data != false) {
            if (this.favorito == 1) {
              this.favorito = 0;
              this.icon = "far fa-star";
            } else {
              this.favorito = 1;
              this.icon = "fas fa-star";
            }
            notificacion("fa fa-check", "", "Actualizacion exitosa", "info");
          }
        } else {
          let total_errores = response.data.errors.length;
          for (let i = 0; i < total_errores; i++) {
            notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
          }
        }
      });
    },
    enviarCorreo() {

      this.errorForm = [];

      let para = document.getElementById('cor_emailpara').value;

      if (!para)
          this.errorForm.push('El campo Para es obligatorio.');

      if (para) {
          if (!validaEmail(para))
              this.errorForm.push('El Correo Electrónico ' + para + ' no es válido.');
      }

      if (this.errorForm.length == 0) {

          this.loader_correo = true;

          axios({
              method: 'post',
              url: 'servicios/enviarCorreo',
              data: {
                  id: this.id_plant,
                  para: para
              },
              transformRequest: serializar(),
          }).then(response => {
              if (response.data.errors == null) {
                  if (response.data) {
                      notificacion('fa fa-check', 'Enviado', response.data, 'success');
                  }else{
                     notificacion('fa fa-check', 'Enviado', response.data, 'success');
                  }
              } else {
                  let total_errores = response.data.errors.length
                  for (let i = 0; i < total_errores; i++) {
                      notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                  }
              }
          }).catch(e => notificacion()).finally(() => this.loader_correo = false);
      } else {
          let total_errores = this.errorForm.length
          for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
          }
      }
  },
    fechaCalendario: (value) => {
      return moment(value).calendar();
    },
    fechaNormal: (value) => {
      return moment(value).format("DD-MM-YYYY");
    },
    fechaHistorico: (value) => {
      return moment(value).format("dddd MM-YYYY");
    },
  },
  watch: {
    listas: {
      handler() {
        localStorage.setItem("listas", JSON.stringify(this.listas));
      },
      deep: true,
    },
  },
});

function cerrarPopup() {
  document.getElementById("popup").style.display = "none";
  document.getElementById("popupMiembros").style.display = "none";
  document.getElementById("popupVencimiento").style.display = "none";
  document.getElementById("popupCliente").style.display = "none";
  document.getElementById("popupAdjunto").style.display = "none";
  document.getElementById("popupDocumento").style.display = "none";
}
