Vue.component("v-select", VueSelect.VueSelect);
new Vue({
    el: '#AppProveedoreslista',
    data: {
        proveedores: [],
        errorForm: [],
        cargando_tabla: '',
        cargando:'',
        lista:[],
        money: {
            locale: "en-US",
            decimal: ".",
            thousands: ",",
            prefix: "$",
            suffix: "",
            precision: 2,
            masked: false /* doesn't work with directive */,
          },
        dataForm:{'id':'','file':''},
        dataFormProd:{'id':'','producto':'','precio':''},
        dataFormProv:{'id':''},
    },
    created() {
        this.obtenerProveedoreslista();
        this.obtenerProveedores();
    },
    methods: {
        checktodos(event) {
            for (let row of this.proveedores) {
                row.checked = event.target.checked;
            }
        },
        eliminarProveedores(){
          let seleccion = [];
          
          for (let row of this.proveedores) {
              if (row.checked == true) {
                seleccion.push(row.pprov_id);
              }
          }

          Swal.fire({
            title: "Eliminar proveedor (es)",
            text: "¿Estás seguro de eliminar todos estos proveedor (es) ["+seleccion+"] ?",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#aaa",
            confirmButtonText: "Eliminar",
            cancelButtonText: "Cancelar",
          }).then((result) => {
              if (result.value) {
                for (let row of this.proveedores) {
                    if (row.checked == true) {
                      axios
                        .get("proveedores/eliminarProveedores/" + row.pprov_id)
                        .then((response) => {
                          if (response.data.errors == null) {
                            if (response.data.eliminado == true) {
                              notificacion("fa fa-trash", "Producto eliminado", 'Eliminado '+response.data.producto, "danger");
                            } else {
                              notificacion("fa fa-ban", "Error al eliminar producto",'Eliminado '+response.data.producto, "danger");
                            }
                          } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                            }
                          }
                        })
                        .catch((e) => notificacion())
                        .finally(() => {
                        });
                    }
                }
                this.obtenerProveedoreslista();
              }
          });
         
        },
        handleFileUpload() {
            this.dataForm.file = this.$refs.file.files[0];
          },
        obtenerProveedoreslista() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#tabla_lista').DataTable().destroy();
            axios.get('proveedores/lista_proveedores').then(response => {
                    this.proveedores = response.data;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#tabla_lista').DataTable({
                    retrieve: true,
                    order: [],
                });
            });
        },
        obtenerProveedores() {
            axios.get('proveedores/proveedoresActivos').then(response => {
                    this.lista = response.data;
            }).catch(e => notificacion()).finally(() => {
            });
        },
        modal_csv() {
            $("#modal_csv").modal();
            $("#modal_csv").on("shown.bs.modal", function () {
            });
        },
        modal_producto(){
            $("#modal_producto").modal();
            $("#modal_producto").on("shown.bs.modal", function () {
            });
        },
        modal_proveedor(){
          $("#modal_proveedor").modal();
        },
        eliminarPorProveedor(){
          Swal.fire({
            title: "Eliminar productos",
            text: "¿Estás seguro de eliminar los productos de este proveedor?",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#aaa",
            confirmButtonText: "Eliminar",
            cancelButtonText: "Cancelar",
          }).then((result) => {
            if (result.value) {
              axios
                .get("proveedores/eliminarPorProveedor/" + this.dataFormProv.id)
                .then((response) => {
                  if (response.data.errors == null) {
                    if (response.data == true) {
                      this.obtenerProveedoreslista();
                      notificacion("fa fa-trash", "Productos eliminado", "Eliminado", "danger");
                    } else {
                      notificacion("fa fa-ban", "Error al eliminar producto", "Error", "danger");
                    }
                  } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                      notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                    }
                  }
                })
                .catch((e) => notificacion())
                .finally(() => {
                  this.dataFormProv.id="";
                  $("#modal_proveedor").modal();
                });
            }
          });
        },
        guardarCsv(){
            this.cargando=true;
            axios({
                method: "post",
                url: "proveedores/guardarCsv",
                data: this.dataForm,
                transformRequest: serializar(),
              }).then((response) => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-check', 'Guardado', 'Producto guardado correctamente', 'success');
                        $('#modal_csv').modal('hide');
                        this.dataForm.id='';
                        this.dataForm.file='';
                        this.obtenerProveedoreslista();
                    }
                } else {
                    for (let i = 0; i < response.data.errors.length; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            })
            .catch((e) => notificacion())
            .finally(() => {
                this.cargando=false;
            });
        },
        eliminar(id, nombre) {
            Swal.fire({
              title: "Eliminar producto",
              text: "¿Estás seguro de eliminar el producto " + nombre + " ?",
              showCancelButton: true,
              confirmButtonColor: "#3085d6",
              cancelButtonColor: "#aaa",
              confirmButtonText: "Eliminar",
              cancelButtonText: "Cancelar",
            }).then((result) => {
              if (result.value) {
                axios
                  .get("proveedores/eliminarProveedor/" + id)
                  .then((response) => {
                    if (response.data.errors == null) {
                      if (response.data == true) {
                        this.obtenerProveedoreslista();
                        notificacion("fa fa-trash", "Producto eliminado", nombre.toUpperCase(), "danger");
                      } else {
                        notificacion("fa fa-ban", "Error al eliminar producto", nombre.toUpperCase(), "danger");
                      }
                    } else {
                      let total_errores = response.data.errors.length;
                      for (let i = 0; i < total_errores; i++) {
                        notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                      }
                    }
                  })
                  .catch((e) => notificacion())
                  .finally(() => {
                  });
              }
            });
          },
        guardarProducto(){
            this.cargando=true;
            axios({
                method: "post",
                url: "proveedores/guardarProducto",
                data: this.dataFormProd,
                transformRequest: serializar(),
              }).then((response) => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-check', 'Guardado', 'Producto guardado correctamente', 'success');
                        this.dataFormProd.producto='';
                        this.dataFormProd.precio='';
                        this.obtenerProveedoreslista();
                    }
                } else {
                    for (let i = 0; i < response.data.errors.length; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            })
            .catch((e) => notificacion())
            .finally(() => {
                this.cargando=false;
            });
        },
        moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
              let monto_ = convertir_a_float(String(num).toString());
              return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
          },
    }
});