var fecha = new Date();

(function () {
    new Vue({
        el: '#AppEditarProveedor',
        data: {
            id_proveedor: document.getElementById('id_proveedor').value,
            dataForm: { 'id': '', 'codigo': '', 'nombre': '', 'razonsocial': '', 'tipoidfiscal': '', 'cifnif': '', 'personafisica': false, 'acreedor': false, 'idcontacto': '', 'telefono1': '', 'telefono2': '', 'email': '', 'web': '', 'serie': '', 'mpid': '', 'impid': '', 'subcuenta': '', 'regimeniva': '2', 'retencion': '', 'observaciones': '', 'pais': '', 'estado': '', 'ciudad': '', 'codigo_postal': '', 'direccion': '' },
            errorForm: [],
            cargando: false,
            facturas: [],
            facturasPendientes: [],
            facturasAnuladas: [],
            notasdeentrega: [],
            notasdeentregaPendientes: [],
            notasdeentregaAnuladas: [],
            cargando_tabla: '',
            anio: fecha.getFullYear(),
            abonos:[]
        },
        created() {
            axios.get('proveedores/proveedor/' + this.id_proveedor).then(response => {
                this.dataForm.id = response.data.id;
                this.dataForm.codigo = response.data.codigo;
                this.dataForm.nombre = response.data.proveedor;
                this.dataForm.razonsocial = response.data.razon_social;
                this.dataForm.tipoidfiscal = response.data.tipo_id_fiscal;
                this.dataForm.cifnif = response.data.identificacion;
                this.dataForm.personafisica = response.data.persona_fisica;
                this.dataForm.acreedor = response.data.acreedor;
                this.dataForm.idcontacto = response.data.contacto;
                this.dataForm.telefono1 = response.data.telefono1;
                this.dataForm.telefono2 = response.data.telefono2;
                this.dataForm.email = response.data.correo;
                this.dataForm.web = response.data.web;
                this.dataForm.serie = response.data.serie;
                this.dataForm.mpid = response.data.mpid;
                this.dataForm.impid = response.data.impid;
                this.dataForm.subcuenta = response.data.subcuenta;
                this.dataForm.regimeniva = response.data.regimen_iva;
                this.dataForm.retencion = response.data.retencion;
                this.dataForm.observaciones = response.data.observaciones;
                this.dataForm.pais = response.data.pais;
                this.dataForm.estado = response.data.estado;
                this.dataForm.ciudad = response.data.ciudad;
                this.dataForm.codigo_postal = response.data.codigo_postal;
                this.dataForm.direccion = response.data.direccion;
                
                this.obtenerAbonos();
            }).catch(e => notificacion());
        },
        methods: {
             obtenerAbonos() {
                let groupColumn = 2;
                $('#table_abonos').DataTable().destroy();
                axios
                  .get("proveedores/abonosProveedores/" + Number(this.id_proveedor))
                  .then((response) => {
                      this.abonos = response.data;
                  }).catch(e => notificacion()).finally(() => {
                    var table = $('#table_abonos').DataTable({
                        columnDefs: [{
                            visible: false,
                            targets: groupColumn
                        }],
                        order: [
                            [groupColumn, 'asc'],
                        ],
                        displayLength: 25,
                        drawCallback: function(settings) {
                            var api = this.api();
                            var rows = api.rows({
                                page: 'current'
                            }).nodes();
                            var last = null;
        
                            api
                                .column(groupColumn, {
                                    page: 'current'
                                })
                                .data()
                                .each(function(group, i) {
                                    if (last !== group) {
                                        $(rows)
                                            .eq(i)
                                            .before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
        
                                        last = group;
                                    }
                                });
                        },
                    });
        
                    // Order by the grouping
                    $('#table_abonos tbody').on('click', 'tr.group', function() {
                        var currentOrder = table.order()[0];
                        if (currentOrder[0] === groupColumn && currentOrder[1] === 'asc') {
                            table.order([groupColumn, 'desc']).draw();
                        } else {
                            table.order([groupColumn, 'asc']).draw();
                        }
                    });
                  });
              },
            obtenerFacturas() {
                this.cargando_tabla = 'is-loading is-loading-lg';
                $('#table_facturas_pagadas').DataTable().destroy();
                $('#table_facturas_pendientes').DataTable().destroy();
                $('#table_facturas_anuladas').DataTable().destroy();
                axios.get('proveedores/obtenerFacturas', {
                    params: {
                        proveedor: this.id_proveedor,
                        anio: this.anio
                    }
                }).then(response => {
                    this.facturas = response.data.pagas;
                    this.facturasPendientes = response.data.pendientes;
                    this.facturasAnuladas = response.data.anuladas;
                    console.log(this.facturas.length)
                }).catch(e => notificacion()).finally(() => {
                    this.cargando_tabla = '';
                    $('#table_facturas_pagadas').DataTable({
                        retrieve: true,
                        order: [],
                        "footerCallback": function (row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            pageTotal = api
                                .column(2, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                        }
                    });
                    $('#table_facturas_pendientes').DataTable({
                        order: [],
                        retrieve: true,
                        "footerCallback": function (row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            pageTotal = api
                                .column(4, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                            pageTotal = api
                                .column(3, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                            pageTotal = api
                                .column(2, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                        }
                    });
                    $('#table_facturas_anuladas').DataTable({
                        order: [],
                        retrieve: true,
                        "footerCallback": function (row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            pageTotal = api
                                .column(4, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                            pageTotal = api
                                .column(3, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                            pageTotal = api
                                .column(2, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                        }
                    });
                });
            },
            obtenerNotasdeEntrega() {
                this.cargando_tabla = 'is-loading is-loading-lg';
                $('#table_notasdeentrega_pagadas').DataTable().destroy();
                $('#table_notasdeentrega_pendientes').DataTable().destroy();
                $('#table_notasdeentrega_anuladas').DataTable().destroy();
                axios.get('proveedores/obtenerNotasdeEntrega', {
                    params: {
                        proveedor: this.id_proveedor,
                        anio: this.anio
                    }
                }).then(response => {
                    this.notasdeentrega = response.data.pagas;
                    this.notasdeentregaPendientes = response.data.pendientes;
                    this.notasdeentregaAnuladas = response.data.anuladas;
                    console.log(this.notasdeentrega.length)
                }).catch(e => notificacion()).finally(() => {
                    this.cargando_tabla = '';
                    $('#table_notasdeentrega_pagadas').DataTable({
                        order: [],
                        retrieve: true,
                        "footerCallback": function (row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            pageTotal = api
                                .column(2, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                        }
                    });
                    $('#table_notasdeentrega_pendientes').DataTable({
                        order: [],
                        retrieve: true,
                        "footerCallback": function (row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            pageTotal = api
                                .column(4, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                            pageTotal = api
                                .column(3, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                            pageTotal = api
                                .column(2, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                        }
                    });
                    $('#table_notasdeentrega_anuladas').DataTable({
                        order: [],
                        retrieve: true,
                        "footerCallback": function (row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            pageTotal = api
                                .column(4, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                            pageTotal = api
                                .column(3, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                            pageTotal = api
                                .column(2, { page: 'current' })
                                .data()
                                .reduce(function (a, b) {
                                    return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                                }, 0);

                            $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                        }
                    });
                });
            },
            guardar() {

                this.errorForm = [];

                if (!this.dataForm.codigo)
                    this.errorForm.push('El campo Código es obligatorio');
                if (!this.dataForm.nombre)
                    this.errorForm.push('El campo Nombre es obligatorio');
                if (!this.dataForm.razonsocial)
                    this.errorForm.push('El campo Razón Social es obligatorio');
                if (!this.dataForm.tipoidfiscal)
                    this.errorForm.push('El campo Tipo Id Fiscal es obligatorio');
                if (!this.dataForm.cifnif)
                    this.errorForm.push('El campo Número de Documento es obligatorio.');
                if (!this.dataForm.telefono1)
                    this.errorForm.push('El campo Teléfono es obligatorio.');
                if (!this.dataForm.pais)
                    this.errorForm.push('El campo País es obligatorio.');
                if (!this.dataForm.email) {
                    this.errorForm.push('El Correo Electrónico es obligatorio.');
                } else if (!validaEmail(this.dataForm.email)) {
                    this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
                }

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'proveedores/guardar',
                        data: this.dataForm,
                        transformRequest: serializar(),
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-edit', 'Actualización', 'Actualizacion exitosa', 'info');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion()).finally(() => this.cargando = false);
                }
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                return monedaMoneda(num, div_locale, div_simbolo, decimal);
            },
            decimal(num, div_locale, decimal = 2) {
                return monedaDecimal(num, div_locale, decimal);
            },
           /* fechaNormal: (value) => {
                return moment(value).format('DD/MM/YYYY, h:mm A');
            }*/
        }
    });
}());
