Vue.component("v-select", VueSelect.VueSelect);
Vue.component('treeselect', VueTreeselect.Treeselect);

let vue=new Vue({
  el: "#appProductos",
  data: {
    tarifas: [],
    productos: 0,
    productos_servicios: 0,
    productos_transferencia:0,
    errorForm: [],
    cargando: "",
    cargando_tabla_productos: "",
    loader_woocommerce: false,
    filtro: 1,
    lineas: [],
    cargando_lineas: "",
    optionsProveedores: [],
    optionsCategorias: [],
    stockbajo:0,
    stockvencido:0,
    stockDispo:0,
    proveedor_filtro:0,
    proveedorv_filtro:0,
    proveedors_filtro:0,
    categoria_filtro:0,
    productosAlmacenes: [],
    productoscategoria:[],
    cargando_tabla: 'is-loading is-loading-lg',
    sucursal_predeterminada: '',
    sucursales_empleado: [],
    sucursals: '',
    almacen_predeterminado: '',
    almacenes: [],
    disabled: false,
    stock: 0,
    almacen_nombre:'',
    actualizar_prec:'',
    productosprec:[],
    porcentaje_pre:0,
    money: {
      decimal: '.',
      thousands: ',',
      prefix: '',
      suffix: '',
      precision: 2,
      masked: false /* doesn't work with directive */
  },
  categoriafiltro:0,
  producto_woom:[],
  selectedProid:0,
  listSticketProd:[],
  listaCatid:[],
  selectedCategoriaid:0,
vc:{data:'ddddd'}
  },
  created() {
    this.obtenerProductos();
   this.obtenerProductosPrecio();

  axios.get('productos/obtenerDatosCrudForaneos').then(response => {
      this.optionsProveedores = response.data.proveedores;
      this.optionsCategorias=response.data.categorias;
  }).catch(e => notificacion());
  //this.obtenerListsProveedores();
  this.obtenerSucursalesEmpleado();

  },
  mounted() {
    $(document).ready(function () {
      $("#tabla_stock").DataTable({
        order: [],
        pageLength: 100,
        dom: "Blfrtip",
        buttons: [
          {
            extend: "excelHtml5",
            exportOptions: {
              stripHtml: false,
              orthogonal: "myExport"
            },
            title: "Stock" + moment().format("DD-MM-YYYY"),
          },
        ],
      });
    });
  },
  methods: {
    obtenerSeriesAlmacenesEmpleado() {
      axios
          .get("productos/obtenerSeriesAlmacenesEmpleado/" + this.sucursal_predeterminada)
          .then((response) => {
              this.almacenes = response.data.almacenes;
              this.almacen_predeterminado = response.data.id_alm;
              this.almacen_nombre=response.data.alm_nombre;
          })
          .catch((e) => notificacion());
  },
  obtenerAlmacennombre(almac){
   this.almacen_nombre=almac.alm_nombre;
  },
  checktodos(event) {
    for (let row of this.productoscategoria) {
        row.checked = event.target.checked;
    }
},
actualizarPrecioProdSelecciondo() {
  this.errorForm = [];
  this.cargando = true;
  this.cargando_tabla = 'is-loading is-loading-lg';
  let id_prod = [];

  for (let row of this.productoscategoria) {
      if (row.checked == true) {
        id_prod.push(row.id);
      }
  }

  axios({
      method: 'post',
      url: 'productos/actualizarPrecioProdSelecciondo',
      data: {
          porcentaje: this.porcentaje_pre,
          precio: this.actualizar_prec,
          productos: JSON.stringify(id_prod)
      },
      transformRequest: serializar(),
  }).then(response => {
      console.log(response.data);
      if (response.data.errors == null) {
          if (response.data == true) {
              notificacion('fa fa-check', 'Actualizacion', 'Se actualizo todo el precio', 'success');
          }
      } else {
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
      }
  }).catch(e => notificacion()).finally(() => {
      this.productoscategoria=[];
      this.cargando = false;
      this.cargando_tabla = '';
      $('#modal_actualizarprecio').modal('hide');
      this.buscarprecLote();
  })
},
SeleccionarCategoria(id){
    this.selectedCategoriaid=id;
    $('#modal_categoriaTarifa').modal('show');
},
SeleccionarCategoriacuadricula(id){
    this.selectedCategoriaid=id;
    this.listaCatid=[];
    $('#modal_categoriaTarifaCuadricula').modal('show');
},
 GenerarPdf(){
       this.cargando = true;
            axios({
                method: 'post',
                url: 'productos/listado_productosImagen_pdfCate',
                data: {
                    tarifa: this.selectedCategoriaid,
                    categ: JSON.stringify(this.listaCatid)
                },
                headers:{
                    'Content-Disposition':"attachment;filename=template.pdf",
                   'Content-Type':'application/pdf' 
                },
                responseType:'arraybuffer',
                transformRequest: serializar(),
            }).then(response => {
                const link=document.createElement('a');
                link.href=window.URL.createObjectURL(
                    new Blob([response.data])
                );
                link.setAttribute('download','listado_productos_precios.pdf');
                document.body.appendChild(link);
                link.click();
            }).catch(e => notificacion()).finally(() => {
                 this.cargando = false;
            })
        },
GenerarPdfcuadricula(){
       this.cargando = true;
            axios({
                method: 'post',
                url: 'productos/listado_cuadricula_pdfCate',
                data: {
                    tarifa: this.selectedCategoriaid,
                    categ: JSON.stringify(this.listaCatid)
                },
                headers:{
                    'Content-Disposition':"attachment;filename=template.pdf",
                   'Content-Type':'application/pdf' 
                },
                responseType:'arraybuffer',
                transformRequest: serializar(),
            }).then(response => {
                const link=document.createElement('a');
                link.href=window.URL.createObjectURL(
                    new Blob([response.data])
                );
                link.setAttribute('download','listado_productos_cuadriculas.pdf');
                document.body.appendChild(link);
                link.click();
            }).catch(e => notificacion()).finally(() => {
                 this.cargando = false;
            })
        },
  buscar: function(event) {

    if (this.almacen_predeterminado > 0) {
        this.errorForm = [];
        this.cargando = true;
        this.cargando_tabla = 'is-loading is-loading-lg';
        $("#tab_proalm").DataTable().destroy();

        axios.get('productos/obtenerStopAlmacen', {
            params: {
                almacen: this.almacen_predeterminado,
                stock: this.stock
            }
        }).then(response => {
            if (response.data.errors == null) {
                this.productosAlmacenes = response.data.productos;
            } else {
                this.errorForm = response.data.errors;
            }
        }).catch(e => notificacion()).finally(() => {
            this.cargando = false;
            this.cargando_tabla = '';

            $("#tab_proalm").DataTable({
              order: [],
              pageLength: 50,
              dom: "Blfrtip",
              buttons: [
                {
                  extend: "excelHtml5",
                  title: "Productos del Almacen: " +this.almacen_nombre+ ' ('+ moment().format("DD-MM-YYYY")+')',
                },
              ],
            });
        });
    }

},
  buscarprecLote: function(event) {
   // if (this.categoria_filtro > 0) {
      this.errorForm = [];
      this.cargando = true;
      this.cargando_tabla = 'is-loading is-loading-lg';
      $("#tab_precLote").DataTable().destroy();

      axios.get('productos/obtenerProductoCategoria', {
          params: {
              categoria: this.categoria_filtro
          }
      }).then(response => {
          if (response.data.errors == null) {
              this.productoscategoria = response.data.productos;
          } else {
              this.errorForm = response.data.errors;
          }
      }).catch(e => notificacion()).finally(() => {
          this.cargando = false;
          this.cargando_tabla = '';

          $("#tab_precLote").DataTable();
      });
    //}
  },
  obtenerSucursalesEmpleado() {
      axios
          .get("productos/obtenerSucursalesEmpleado")
          .then((response) => {
              this.sucursales_empleado = response.data.sucursales;
              this.sucursal_predeterminada = response.data.id;
              if (response.data.desactivar == true) {
                  this.disabled = true
              }
              this.obtenerSeriesAlmacenesEmpleado();
          })
          .catch((e) => notificacion());
  },
    obtenerListsProveedores(){
      this.stockbajo =[];
      $("#tabla_stock_bajo").DataTable().destroy();
      axios.get('productos/obtenerProductosStockBajoProv/' + this.proveedor_filtro).then(response => {
        this.stockbajo = response.data;
      })
        .catch((e) => notificacion())
        .finally(() => {
          $("#tabla_stock_bajo").DataTable({
            order: [],
            pageLength: 50,
            dom: "Blfrtip",
            buttons: [
              {
                extend: "excelHtml5",
                title: "Stock bajo " + moment().format("DD-MM-YYYY"),
              },
            ],
          });
        });
    },
    obtenerProductosSimples(){
      $('#productos-table').DataTable().destroy();

      let buttonCommon= {
        exportOptions: {
          columns: [0, 1, 2,4,5,6],
          orthogonal: "myExport",
          format: {
            body: function (data, row, column, node) {
              if (column === 4 || column === 5) {
                return convertir_a_float(data);
              } else {
              return data;
              }
            },
          },
        },
      };

      let num=0;
      let nm=this.tarifas.length;
      console.log(nm)
      let columns= [
        {width:"10%",
        targets:"0"},
        {width:"30%",
        targets:"1"},
        {width:"10%",
        targets:"2"},
        {width:"10%",
        targets:"3"},
        {width:"10%",
        targets:"4"},
        {width:"10%",
        targets:"5"},
        {width:"10%",
        targets:"6"},
        {width:"10%",
        targets:"7"},
    ];
    let m=7;
    for (let i = 0; i < nm; i++) {
      m=m+1;
      columns.push({width:"10%",
      targets:m});
    }

    let data_columna=[
      { data: 'pro_id',
          render:function (data,type,row) {
            if (type === 'myExport') {
              return row.pro_codigo;
            }else{
              return "<a href='"+baseURL+"productos/editar/"+row.pro_id+"'>"+row.pro_codigo+"</a>";
            }
          }
       },
       { data: 'pro_descripcion',
           render:function (data,type,row) {
          let text=row.pro_peso >0 ? " <a href='#' data-toggle='popover' title='Peso: "+row.pro_peso+" Kg' data-content='Peso: "+row.pro_peso+" Kg'><i style='font-size: 18px;color: #000;' class='fas fa-weight-hanging fa-fw'></i></a>": "";
          let text2=(row.envio==1)?"fas fa-check fa-fw":"fas fa-times fa-fw";
          let text3=(row.pro_peso >0)?"<i class='"+text2+"'></i>":" ";
          return row.pro_descripcion+text+" "+text3;
          }
       },
      { data: 'fa_nombre' },
      { data: 'pro_publico',
        render:function (data,type,row) {
          let text=row.pro_publico == 1 ? "wcicon-woo text-secondary": "";
          return "<i style='font-size: 25px;' class='"+text+"'></i>";
        }
      },
      { data: 'ps_cantidad' },
      { data: 'pro_costo' },
      { data: 'pro_precio' },
      //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
  ];
  for (let i = 0; i < nm; i++) {
    data_columna.push({data: 'pro_precio',
    render:function (data,type,row) {
      return row.tarifas[i].precio;
  } },);
  }

  data_columna.push( {
    data:'pro_id',
    render:function (data,type,row) {
        return "<button type='button' id='eliminar' class='eliminar btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fa fa-trash text-danger' style='padding: .65rem;'></i></button>&nbsp;<a class='btn btn-sm btn-secondary' href='"+baseURL+"productos/sticket_unproducto_pdf/"+row.pro_id+"' target='_new'><i class='fa fa-print' aria-hidden='true'></i><span class='d-none d-sm-inline-block'></span><a/>&nbsp;<a class='btn btn-sm btn-light' href='"+baseURL+"productos/sticket_unproducto_pdf_etiqueta/"+row.pro_id+"' target='_new'><i class='fa fa-barcode' aria-hidden='true'></i><span class='d-none d-sm-inline-block'></span><a/>";
    }
});

      var tabla=$('#productos-table').DataTable({
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'asc']],
          'deferRender':false,
          'retrieve':true,
          'lengthMenu':[[10,25,100,-1],[10,25,100,'Todos']],
          'pageLength':10,
          'dom': "Blfrtip",
          'buttons': [
              $.extend(true, {}, buttonCommon, {
                extend: "excelHtml5",
                title: "Lista de productos " + moment().format("DD-MM-YYYY"),
              }),
            ],
          'ajax':{
              'url':'productos/obtenerProductosTodosSimples',
              'data':{
                'productos': 'simples'
            },
          },
          'columnDefs': columns,
          'columns': data_columna,
      });
      
      $("#productos-table tbody").on('click','button.eliminar',function () {
          let tb=$('#productos-table').DataTable();
          var datos=tb.row($(this).parents("tr")).data();
          vue.eliminar(datos.pro_id, datos.pro_descripcion);
      });
    },
    obtenerProductosServicios(){
      $('#productos_servicios-table').DataTable().destroy();

      let buttonCommon= {
        exportOptions: {
          columns: [0, 1, 2],
          orthogonal: "myExport",
          format: {
            body: function (data, row, column, node) {
              if (column === 2) {
                return convertir_a_float(data);
              } else {
              return data;
              }
            },
          },
        },
      };

      var tabla=$('#productos_servicios-table').DataTable({
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'asc']],
          'deferRender':false,
          'retrieve':true,
          'lengthMenu':[[10,25,100,-1],[10,25,100,'Todos']],
          'pageLength':10,
          'dom': "Blfrtip",
          'buttons': [
              $.extend(true, {}, buttonCommon, {
                extend: "excelHtml5",
                title: "Servicios " + moment().format("DD-MM-YYYY"),
              }),
            ],
          'ajax':{
              'url':'productos/obtenerProductosTodosServicios',
              'data':{
                'productos': 'simples'
            },
          },
          'columns': [
              { data: 'pro_id',
                  render:function (data,type,row) {
                    if (type === 'myExport') {
                      return row.pro_codigo;
                    }else{
                      return "<a href='"+baseURL+"productos/editar/"+row.pro_id+"'>"+row.pro_codigo+"</a>";
                    }
                  }
               },
               { data: 'pro_descripcion'},
              { data: 'pro_precio' },
              {
                  data:'pro_id',
                  render:function (data,type,row) {
                      return "<button type='button' id='eliminar' class='eliminar btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fa fa-trash text-danger' style='padding: .65rem;'></i></button>";
                  }
              },
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
      
      $("#productos_servicios-table tbody").on('click','button.eliminar',function () {
          let tb=$('#productos_servicios-table').DataTable();
          var datos=tb.row($(this).parents("tr")).data();
          vue.eliminar(datos.pro_id, datos.pro_descripcion);
      });
    },
    obtenerProductosVencidosProv(){
      $('#tabla_vencidos').DataTable().destroy();

      let buttonCommon= {
        exportOptions: {
          columns: [0, 1, 2,3,4,5],
          orthogonal: "myExport",
          format: {
            body: function (data, row, column, node) {
              if (column === 3) {
                return convertir_a_float(data);
              } else {
              return data;
              }
            },
          },
        },
      };

      var tabla=$('#tabla_vencidos').DataTable({
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'asc']],
          'deferRender':false,
          'retrieve':true,
          'lengthMenu':[[10,25,100,-1],[10,25,100,'Todos']],
          'pageLength':10,
          'dom': "Blfrtip",
          'buttons': [
              $.extend(true, {}, buttonCommon, {
                extend: "excelHtml5",
                title: "Productos vencidos " + moment().format("DD-MM-YYYY"),
              }),
            ],
          'ajax':{
              'url':'productos/obtenerProductosVencido',
              'data':{
                'proveedor': this.proveedorv_filtro
            },
          },
          'columns': [
              { data: 'pro_id',
                  render:function (data,type,row) {
                    if (type === 'myExport') {
                      return row.pro_codigo;
                    }else{
                      return "<a href='"+baseURL+"productos/editar/"+row.pro_id+"'>"+row.pro_codigo+"</a>";
                    }
                  }
               },
               { data: 'pro_descripcion'},
              { data: 'alm_nombre' },
              { data: 'ps_cantidad'},
              { data: 'expedicion' },
              { data: 'vencimiento' }
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
    },
    obtenerProductosStockBajo(){
      $('#tabla_stock_bajo').DataTable().destroy();

      let buttonCommon= {
        exportOptions: {
          columns: [0, 1, 2,3,4,5,6,7],
          orthogonal: "myExport",
          format: {
            body: function (data, row, column, node) {
              if (column === 3 || column === 4 || column === 5 || column === 6 || column === 7 ) {
                return convertir_a_float(data);
              } else {
              return data;
              }
            },
          },
        },
      };

      var tabla=$('#tabla_stock_bajo').DataTable({
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'asc']],
          'deferRender':false,
          'retrieve':true,
          'lengthMenu':[[10,25,100,-1],[10,25,100,'Todos']],
          'pageLength':10,
          'dom': "Blfrtip",
          'buttons': [
              $.extend(true, {}, buttonCommon, {
                extend: "excelHtml5",
                title: "Stock bajo " + moment().format("DD-MM-YYYY"),
              }),
            ],
          'ajax':{
            'url':'productos/obtenerProductosStockBajo',
            'data':{
              'proveedor': this.proveedor_filtro
            },
          },
          'columns': [
              { data: 'pro_id',
                  render:function (data,type,row) {
                    if (type === 'myExport') {
                      return row.pro_codigo;
                    }else{
                      return "<a href='"+baseURL+"productos/editar/"+row.pro_id+"'>"+row.pro_codigo+"</a>";
                    }
                  }
               },
               { data: 'pro_descripcion'},
              { data: 'alm_nombre' },
              { data: 'ps_cantidad'
              },
              { data: 'ps_stockmin' },
              { data: 'ps_stockmax' },
              { data: 'ps_reservada' },
              {
                  data:'ps_pterecibir',
              },
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
    },
    obtenerProductosStockD(){
      $('#tabla_stock').DataTable().destroy();

      let buttonCommon= {
        exportOptions: {
          columns: [0, 1, 2,3,4,5,6,7],
          orthogonal: "myExport",
          format: {
            body: function (data, row, column, node) {
              if (column === 3 || column === 4 || column === 5 || column === 6 || column === 7 ) {
                return convertir_a_float(data);
              } else {
              return data;
              }
            },
          },
        },
      };

      var tabla=$('#tabla_stock').DataTable({
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'asc']],
          'deferRender':false,
          'retrieve':true,
          'lengthMenu':[[10,25,100,-1],[10,25,100,'Todos']],
          'pageLength':10,
          'dom': "Blfrtip",
          'buttons': [
              $.extend(true, {}, buttonCommon, {
                extend: "excelHtml5",
                title: "Stock " + moment().format("DD-MM-YYYY"),
              }),
            ],
          'ajax':{
            'url':'productos/obtenerProductosStockD',
            'data':{
              'proveedor': this.proveedors_filtro
            },
          },
          'columns': [
              { data: 'pro_id',
                  render:function (data,type,row) {
                    if (type === 'myExport') {
                      return row.pro_codigo;
                    }else{
                      return "<a href='"+baseURL+"productos/editar/"+row.pro_id+"'>"+row.pro_codigo+"</a>";
                    }
                  }
               },
               { data: 'pro_descripcion'},
              { data: 'alm_nombre' },
              { data: 'ps_cantidad'
              },
              { data: 'ps_stockmin' },
              { data: 'ps_stockmax' },
              { data: 'ps_reservada' },
              {
                  data:'ps_pterecibir',
              },
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
    },
    obtenerProductosTransferencia(){
      $('#table-transferencia').DataTable().destroy();

      let buttonCommontransf = {
        exportOptions: {
          columns: [0, 1, 2],
          orthogonal: "myExport",
          format: {
            body: function (data, row, column, node) {
              if (column === 0) {
                return convertir_a_float(data);
              } else {
                return data.replace(/<[^>]*>?/g, "");
              }
            },
          },
        },
      };

      var tabla=$('#table-transferencia').DataTable({
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'asc']],
          'deferRender':false,
          'retrieve':true,
          'lengthMenu':[[10,25,100,-1],[10,25,100,'Todos']],
          'pageLength':10,
          'dom': "Blfrtip",
          'buttons': [
              $.extend(true, {}, buttonCommontransf, {
                extend: "excelHtml5",
                title: "Transferencia de productos " + moment().format("DD-MM-YYYY"),
              }),
            ],
          'ajax':{
              'url':'productos/obtenerProductosTransferencia',
              'data':{
                'productos': 'transferencia'
            },
          },
          'columns': [
              { data: 'ptr_id'
               },
               { data: 'origen'},
              { data: 'destino' },
              {
                  data:'ptr_estatus',
                  render:function (data,type,row) {
                    let estatus='';
                    if(row.ptr_estatus==1){
                      estatus='<span class="text-warning">PENDIENTE</span>';
                    }
                    if(row.ptr_estatus==2){
                      estatus='<span class="text-success">PROCESADO</span>';
                    }
                    if(row.ptr_estatus==3){
                      estatus='<span class="text-danger">DENEGADO</span>';
                    }
                    if(row.ptr_estatus==0){
                      estatus='<span class="text-danger">DENEGADO</span>';
                    }

                      return estatus;
                  }
              },
              {data:'ptr_id',
              render:function (data,type,row) {
                return "<a href='"+baseURL+"stock/detalle_transferencia/"+row.ptr_id+"'><i class='fas fa-eye'></i></a>";
            }
            }
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
      
      $("#table-transferencia tbody").on('click','button.eliminar',function () {
          let tb=$('#table-transferencia').DataTable();
          var datos=tb.row($(this).parents("tr")).data();
          vue.eliminar(datos.pro_id, datos.pro_descripcion);
      });
    },
    modal_producto(){
      $('#modal_productosticket').modal('show');
    },
    Imprimirsticket(id){
      axios.get('productos/imprimir_sticket', {
        params: {
            prod: this.selectedProid,
            id_impresora: id
        }
    }).then(response => {
        console.log(response.data);
        if (response.data.data.errors == null) {
            fetch(response.data.ip_puerto, {
                method: 'POST',
                body: JSON.stringify(response.data.data)
            }).then((j) => {
                if (j.ok) {
                    notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                    $('#modal_productosticket').modal('hide');
                } else {
                    notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                }
            }).catch((error) => {
                notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
            });
        } else {
            let total_errores = response.data.data.errors.length
            for (let i = 0; i < total_errores; i++) {
                notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
            }
        }
    }).catch(e => notificacion());
    },
    obtenerProductos() {
      this.cargando_tabla_productos = "is-loading is-loading-lg";
      axios
        .get("productos/obtenerProductos")
        .then((response) => {
         // this.productos = response.data.productos;
          this.productos= response.data.productos;
          this.listSticketProd=response.data.lista;
          this.producto_woom=response.data.productos_wooc;
          console.log(this.producto_woom);
          this.productos_servicios = response.data.servicios;
          this.tarifas = response.data.tarifas;
          this.productos_transferencia=response.data.productos_transferencia;
          this.stockvencido=response.data.stockvencido;
          this.stockbajo=response.data.stockbajo;
          this.stockDispo=response.data.stock;
          this.obtenerProductosSimples();
          this.obtenerProductosVencidosProv();
          this.obtenerProductosServicios();
          this.obtenerProductosStockBajo();
          this.obtenerProductosTransferencia();
          this.obtenerProductosStockD();
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargando_tabla_productos = "";
        });
    },
    obtenerProductosPrecio() {
     // this.cargando_tabla_productos = "is-loading is-loading-lg";
     this.productosprec=[];
     $("#prec_table").DataTable().destroy();
    
      axios
        .get("productos/obtenerProductosprecio/"+this.categoriafiltro)
        .then((response) => {
          this.productosprec = response.data.productos;
        })
        .catch((e) => notificacion())
        .finally(() => {

          let buttonCommonServ = {
            exportOptions: {
              columns: [0, 1, 2,3,4],
              format: {
                body: function (data, row, column, node) {
                  if (column === 5) {
                    return convertir_a_float(data);
                  } else {
                    return data.replace(/<[^>]*>?/g, "");
                  }
                },
              },
            },
          };

          $("#prec_table").DataTable({
            retrieve: true,
            order: [],
            pageLength: 50,
            dom: "Blfrtip",
            buttons: [
              $.extend(true, {}, buttonCommonServ, {
                extend: "pdf",
                orientation:'landscape',
                title: "Listado de productos (" + moment().format("DD-MM-YYYY")+')',
              }),
            ],
          });
        });
    },
    eliminar(id, nombre) {
      Swal.fire({
        title: "Eliminar producto",
        text: "¿Estás seguro de eliminar el producto " + nombre + " ?",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#aaa",
        confirmButtonText: "Eliminar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("productos/eliminar/" + id)
            .then((response) => {
              $("#productos-table").DataTable().destroy();
              if (response.data.errors == null) {
                if (response.data == true) {
                  this.obtenerProductos();
                  notificacion("fa fa-trash", "Producto eliminado", nombre.toUpperCase(), "danger");
                } else {
                  notificacion("fa fa-ban", "Error al eliminar producto", nombre.toUpperCase(), "danger");
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
              $("#productos-table").DataTable({
                order: [],
                pageLength: 50,
                aoColumnDefs: [
                  { bSortable: false, aTargets: [7] },
                  { searchable: false, targets: [7] },
                ],
              });
            });
        }
      });
    },
    async woocommerce() {
      let btn_wc = document.getElementById("btn_wc");
      btn_wc.disabled = true;
      btn_wc.classList.add("is-loading");

      if (Object.keys(this.producto_woom).length > 0) {
        for (let item of this.producto_woom) {
          console.log(item.pro_descripcion);
          await axios
            .get("cron/cronProductosWoocommerce/" + item.pro_id)
            .then((response) => {
              notificacion("fa fa-check", "", item.pro_descripcion + " Subido a Woocommerce", "success");
              if (response.data) {
                let total_errores = response.data.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-check", "Informacion", response.data[i], "info");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
              btn_wc.disabled = false;
              btn_wc.classList.remove("is-loading");
            });
        }
      }
    },
    /*
        woocommerce(id, event) {
            status = event.target.className;
            event.target.disabled = true;
            event.target.className = 'loader loader-success';
        
            axios.get('woocommerce/guardar', { params: { id: id } }).then(response => {
                if (response.data == true) {
                    notificacion('fa fa-check', '', 'Subido a Woocommerce', 'success');
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => {
                notificacion()
            }).finally(() => {
                event.target.disabled = false;
                event.target.className = 'btn btn-icon wcicon-woo text-secondary';
            });
        },*/
    modalLineas() {
      this.errorForm = [];
      $("#modal_lineas").modal({ show: true, backdrop: "static", keyboard: false });
      $("#modal_lineas").on("shown.bs.modal", function () {
        $("#input_buscar_lineas").trigger("focus");
      });
    },
    modal_actualizarprecio(){
      this.errorForm = [];
      $("#modal_actualizarprecio").modal({ show: true, backdrop: "static", keyboard: false });
    },
    filtrarPor(num) {
      this.filtro = num;
      document.getElementById("input_buscar_lineas").value = "";
    },
    buscarLineas: function (event) {
      if (event.target.value) {
        if (event.target.value.length > 2) {
          this.cargando_lineas = "is-loading is-loading-lg";
          this.bus_li(event.target.value, this);
        }
      }
    },
    bus_li: _.debounce((value, vm) => {
      axios
        .get("productos/buscarLineas", {
          params: {
            buscar: value,
            filtro: vm.filtro,
          },
        })
        .then((response) => {
          if (response.data.length > 0) {
            vm.lineas = response.data;
          } else {
            vm.lineas = [];
          }
        })
        .catch((e) => notificacion())
        .finally(() => (vm.cargando_lineas = ""));
    }, 350),
  },
});