Vue.component("v-select", VueSelect.VueSelect);
Vue.component('treeselect', VueTreeselect.Treeselect);

new Vue({
  el: "#appEditarProductos",
  data: {
    id_producto: document.getElementById("id_producto").value,
    optionsCategorias: [],
    optionsProveedores: [],
    optionsFabricantes: [],
    optionsProductos: [],
    selectedProvid: [],
    selectedCatid: [],
    selectedFabid: "",
    selectedProd: [],
    productos_stock: [],
    almacenSinProductoEnStock: [],
    stock_fisico_total: 0,
    tarifas: [],
    producto_tarifas: [],
    dataForm: {
      catid: "",
      prod: "",
      provid: "",
      equivalencia: "",
      partnumber: "",
      expedicion: "",
      tipo: "",
      vencimiento: "",
      bloqueado: "",
      fabid: "",
      impid: "",
      descripcion: "",
      nostock: "",
      observaciones: "",
      publico: "",
      codigo: "",
      secompra: "",
      sevende: "",
      stockfis: "",
      ventasinstock: "",
      nombre: "",
    },
    id_producto_editar: "",
    dataFormPrecios: { id: "", precio_venta: 0, precio_costo: 0, impuesto: "" },
    dataFormPeso: { peso: 0, alto: 0, largo: 0, ancho: 0 },
    errorForm: [],
    errorFormCantidad: [],
    errorFormStock: [],
    cargando: false,
    cargando_tabla: 'is-loading is-loading-lg',
    imagen: "",
    imagenes: [],
    tarifasPro: [],
    bitacoraStock: [],
    codBarras: [],
    almacenes_producto: [],
    ubicaciones: [],
    almacenProducto: "",
    ubicacionesProducto: [],
    fecha_factor: "",
    selectedFactor: "",
    selectFactores: [],
    factoresBitacora: [],
    tipo_producto: document.getElementById('tipo').value,
    cheque: [],
    clientes: [],
    dataformchequear: {
      prod: "",
      id: 0
    },
    precioCompuesto: 0,
    ProductosEncontrado: false,
    fecha_desde: moment().format('YYYY-MM-DD'),
    fecha_hasta: moment().format('YYYY-MM-DD'),
    cats: null,
    historial:[],
    options: [{
                id: 'a',
                label: 'a',
                children: [{
                    id: 'aa',
                    label: 'Grapes 🍇',
                }, {
                    id: 'ab',
                    label: 'Apple 🍎',
                }],
            }, {
                id: 'b',
                label: 'Pear 🍐',
            }, {
                id: 'c',
                label: 'Pear 🍐',
            }],
  },
  mounted() {
    this.calcular();
    this.calcularImpuesto();
    this.productoTarifas();
    this.obtenerImagenes();
    $(function () {
      $("#tabla-bitacora").dataTable({
        order: [],
      });
    });
  },
  created() {
    axios
      .get("productos/obtenerDatosCrudForaneos")
      .then((response) => {
        this.optionsProveedores = response.data.proveedores;
        this.optionsCategorias = response.data.categorias;
        this.optionsFabricantes = response.data.fabricantes;
        //this.optionsProductos = response.data.productos;
      })
      .catch((e) => notificacion());
    axios
      .get("productos/obtenerProductoCategoriasProveedores/" + Number(this.id_producto))
      .then((response) => {
        this.selectedCatid = response.data.categorias;
        this.selectedProvid = response.data.proveedores;
        this.selectedFabid = response.data.fabricante.fa_id;
      })
      .catch((e) => notificacion());
    this.obtenerStock();
    this.obtenertTrifasPro();
    this.obtenerCodigosDeBarra();
    this.obtenerAlmacenesSegunProducto();
    this.obtenerUbicacionesProducto();
    this.obtenerClientes();
    if (this.tipo_producto == 2) {
      this.chequearStocks();
     
    }
    this.obtenerHistorialCompra();
  },
  methods: {
       actualizarPeso(){

      this.errorForm = [];

      this.dataFormPeso.peso = document.getElementById("peso").value;
      this.dataFormPeso.alto = document.getElementById("alto").value;
      this.dataFormPeso.ancho = document.getElementById("ancho").value;
      this.dataFormPeso.largo = document.getElementById("largo").value;

      if (this.id_producto && this.errorForm.length == 0) {
        this.dataFormPeso.id = this.id_producto;
        this.cargando = true;

        axios({
          method: "post",
          url: "productos/actualizarPesos",
          data: this.dataFormPeso,
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data !== false) {
                notificacion("fa fa-edit", "Actualizado", "Actualizados correctamente", "info");
                if (response.data.mensaje) {
                  let total_mensaje = response.data.mensaje.length;
                  for (let i = 0; i < total_mensaje; i++) {
                    notificacion("fa fa-info", "Advertencia", response.data.mensaje[i], "info");
                  }
                }
              } else {
                notificacion("fa fa-ban", "Advertencia", "Error al actualizar el producto", "danger");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => (this.cargando = false));
      } else {
        let total_errores = this.errorForm.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion("fa fa-ban", "Advertencia", this.errorForm[i], "warning");
        }
      }

    },
    obtenerHistorialCompra(){
        this.cargando_tabla = 'is-loading is-loading-lg';
        $('#tabla_historial').DataTable().destroy();
        axios.get('productos/obtenerPrecioCompra/'+ Number(this.id_producto)).then(response => {
                this.historial = response.data;
        }).catch(e => notificacion()).finally(() => {
            this.cargando_tabla = '';
            $('#tabla_historial').DataTable({
                retrieve: true,
                order: [[0,"desc"]],
            });
        });
    },
     modal_producto(){
      $('#modal_ticket').modal('show');
    },
    Imprimirsticket(id){
    axios.get('productos/imprimir_sticket', {
      params: {
          prod: this.id_producto,
          id_impresora: id
      }
  }).then(response => {
      console.log(response.data);
      if (response.data.data.errors == null) {
          fetch(response.data.ip_puerto, {
              method: 'POST',
              body: JSON.stringify(response.data.data)
          }).then((j) => {
              if (j.ok) {
                  notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
              } else {
                  notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
              }
          }).catch((error) => {
              notificacion('fa fa-ban', 'Error', 'Hubo un problema con la peticin Fetch:' + error.message, 'danger');
          });
      } else {
          let total_errores = response.data.data.errors.length
          for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
          }
      }
  }).catch(e => notificacion());
  },
    chequearStocks() {
      axios.get("productos/chequearStocks/" + this.id_producto).then((response) => {
        this.cheque = response.data;
        let total = 0;
        for (let i = 0; i < this.cheque.length; i++) {
          total = Number(total) + Number(this.cheque[i].pro_ccprecio);
        }
        this.precioCompuesto = total;
        this.precioProductoCompuesto();
      });
    },
    AgregarproductoCompuesto() {
      this.dataformchequear.prod = JSON.stringify(this.selectedProd.pro_id);
      this.dataformchequear.id = Number(this.id_producto);
      axios({
        method: "post",
        url: "productos/agregarproductoCompuesto",
        data: this.dataformchequear,
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data !== false) {
              this.chequearStocks();
              this.precioProductoCompuesto();
              this.selectedProd = '';
            }
          } else {
            notificacion("fa fa-ban", "Advertencia", response.data.errors, "warning");
          }
        })
        .catch((e) => {
          notificacion();
        })
        .finally(() => (this.cargando = false));
    },
    ModificarPrecioProd(precio) {
      axios({
        method: "post",
        url: "productos/ModificarPrecioProd",
        data: {
          'id': this.id_producto,
          'precio': precio
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data !== false) {

            }
          } else {
            notificacion("fa fa-ban", "Advertencia", response.data.errors, "warning");
          }
        })
        .catch((e) => {
          notificacion();
        })
        .finally(() => (this.cargando = false));
    },
    recargarFabricantes() {
      axios
        .get("productos/fabricantesActivos")
        .then((response) => {
          this.optionsFabricantes = response.data;
        })
        .catch((e) => notificacion());
    },
    recargarProveedores() {
      axios
        .get("productos/proveedoresActivos")
        .then((response) => {
          this.optionsProveedores = response.data;
        })
        .catch((e) => notificacion());
    },
    recargarCategorias() {
      axios
        .get("productos/obtenerCategorias")
        .then((response) => {
          this.optionsCategorias = response.data;
        })
        .catch((e) => notificacion());
    },
    recargarProductos() {
      axios
        .get("productos/obtenerProductosSimples")
        .then((response) => {
          this.optionsProductos = response.data;
        })
        .catch((e) => notificacion());
    },
    obtenerBitacoraStock() {
      $("#tabla-bitacora-stock").DataTable().destroy();
      axios
        .get("productos/obtenerBitacoraStock/" + this.id_producto)
        .then((response) => {
          this.bitacoraStock = response.data.bitacora_stock;
        })
        .finally(() => {
          $("#tabla-bitacora-stock").DataTable({
            retrieve: true,
            order: [],
          });
        });
    },
    obtenertTrifasPro() {
      axios.get("productos/tarifasPro/" + this.id_producto).then((response) => {
        this.tarifasPro = response.data;
      });
    },
    productosCompuestos() {
      axios.get("productos/productosCompuestos/" + this.id_producto).then((response) => {
        this.selectedProd = response.data;

        console.log(response.data);
      });
    },
    handleFileUpload() {
      this.imagen = this.$refs.file.files[0];
    },
    enviarImagen() {
      this.errorForm = [];

      if (!this.imagen) this.errorForm.push("La imagen es obligatorio.");

      if (this.errorForm.length == 0) {
        this.cargando = true;
        axios({
          method: "post",
          url: "productos/imagen",
          data: {
            id_producto: this.id_producto,
            imagen: this.imagen,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data !== false) {
                this.obtenerImagenes();
                notificacion("fa fa-check", "Enviado", response.data, "success");
                if (response.data.mensaje) {
                  let total_mensaje = response.data.mensaje.length;
                  for (let i = 0; i < total_mensaje; i++) {
                    notificacion("fa fa-info", "Advertencia", response.data.mensaje[i], "info");
                  }
                }
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => {
            notificacion();
          })
          .finally(() => (this.cargando = false));
      } else {
        let total_errores = this.errorForm.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion("fa fa-ban", "Advertencia", this.errorForm[i], "warning");
        }
      }
    },
    eliminarSeleccion(id) {
      axios
        .get("productos/eliminarSeleccion/" + id)
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == false) {
              notificacion("fa fa-ban", "Advertencia", "Error al eliminar", "danger");
            } else {
              posicion = this.codBarras.findIndex((item) => item.id == codigo.id);
              this.codBarras.splice(posicion, 1);
              this.chequearStocks();
              notificacion("fa fa-check", "", "Producto eliminado correctamente", "success");
            }
          } else {
            this.errorForm = response.data.errors;
          }
        })
        .catch((e) => notificacion());
    },
    obtenerImagenes() {
      axios.get("productos/obtenerImagenes/" + Number(this.id_producto)).then((response) => {
        this.imagenes = response.data.productos_imagenes;
      });
    },
    eliminarImagen(id) {
      axios.get("productos/eliminarImagen", { params: { id: id } }).then((response) => {
        if (response.data.errors == null) {
          if (response.data == true) {
            this.obtenerImagenes();
            notificacion("fa fa-ban", "Eliminado", "Imagen eliminada", "danger");
          } else {
            notificacion("fa fa-ban", "", "Error al eliminar imagen", "warning");
          }
        } else {
          let total_errores = response.data.errors.length;
          for (let i = 0; i < total_errores; i++) {
            notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
          }
        }
      });
    },
    editarProducto() {
      this.errorForm = [];

      this.dataForm = {
        id_producto: this.id_producto,
        equivalencia: document.getElementById("codigodeequivalencia")
          ? document.getElementById("codigodeequivalencia").value
          : "",
        partnumber: document.getElementById("numerodeparte") ? document.getElementById("numerodeparte").value : "",
        expedicion: document.getElementById("fechadeexpedicion")
          ? document.getElementById("fechadeexpedicion").value
          : "",
        tipo: document.getElementById("tiposel").value,
        vencimiento: document.getElementById("fechadevencimiento")
          ? document.getElementById("fechadevencimiento").value
          : "",
        bloqueado: document.getElementById("pro_bloqueado") ? document.getElementById("pro_bloqueado").checked : false,
        descripcion: document.getElementById("pro_descripcion").value,
        nombre: document.getElementById("pro_nombre").value,
        nostock: document.getElementById("pro_nostock") ? document.getElementById("pro_nostock").checked : false,
        observaciones: document.getElementById("pro_observaciones").value,
        publico: document.getElementById("pro_publico") ? document.getElementById("pro_publico").checked : false,
        codigo: document.getElementById("referencia").value,
        secompra: document.getElementById("pro_secompra") ? document.getElementById("pro_secompra").checked : false,
        sevende: document.getElementById("pro_sevende") ? document.getElementById("pro_sevende").checked : false,
        stockfis: document.getElementById("stock") ? document.getElementById("stock").value : 0,
      };

      if (!this.dataForm.tipo) this.errorForm.push("El campo Tipo es obligatorio.");
      if (!this.dataForm.descripcion) this.errorForm.push("El campo Nombre es obligatorio.");
      if (!this.dataForm.codigo) this.errorForm.push("El campo Referencia es obligatorio.");

      if (this.dataForm.id_producto && this.errorForm.length == 0) {
        this.dataForm.catid = JSON.stringify(this.selectedCatid);
        this.dataForm.prod = JSON.stringify(this.selectedProd);
        this.dataForm.provid = JSON.stringify(this.selectedProvid);
        this.dataForm.fabid = this.selectedFabid;
        this.cargando = true;
        axios({
          method: "post",
          url: "productos/editarProducto",
          data: this.dataForm,
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == false) {
                notificacion("fa fa-ban", "Advertencia", "Error al actualizar el producto", "danger");
              } else {
                document.getElementById("gui_cliente").innerHTML = this.dataForm.descripcion;
                notificacion("fa fa-edit", "Actualizado", "Actualización exitosa", "info");
                if (response.data.mensaje) {
                  let total_mensaje = response.data.mensaje.length;
                  for (let i = 0; i < total_mensaje; i++) {
                    notificacion("fa fa-info", "Advertencia", response.data.mensaje[i], "info");
                  }
                } else {
                  location.href = '';
                }

              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => (this.cargando = false));
      }
    },
    onSearch(search, loading) {
      if (search) {
        loading(true);
        this.search(loading, search, this);
      }
    },
    search: _.debounce((loading, search, vm) => {
      axios.get('productos/buscarProductos', {
        params: {
          'buscar': search
        }
      }).then(response => {
        if (response.data.length > 0) {
          vm.optionsProductos = response.data;
          vm.ProductosEncontrado = true;
        } else {
          vm.optionsProductos = [];
          vm.ProductosEncontrado = false;
        }
      }).catch(e => notificacion()).finally(() => loading(false));
    }, 350),
    actualizarPrecios() {
      this.errorForm = [];

      this.dataFormPrecios.precio_costo = document.getElementById("pro_costo")
        ? document.getElementById("pro_costo").value
        : 0;
      this.dataFormPrecios.precio_venta = document.getElementById("pro_precio").value;
      this.dataFormPrecios.impuesto = document.getElementById("iva") ? document.getElementById("iva").value : 0;

      if (!this.dataFormPrecios.precio_venta) this.errorForm.push("El campo Precio Venta es obligatorio.");

      if (this.id_producto && this.errorForm.length == 0) {
        this.dataFormPrecios.id = this.id_producto;
        this.cargando = true;

        axios({
          method: "post",
          url: "productos/actualizarPreciosProducto",
          data: this.dataFormPrecios,
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data !== false) {
                this.obtenertTrifasPro();
                notificacion("fa fa-edit", "Actualizado", "Precios actualizados correctamente", "info");
                if (response.data.mensaje) {
                  let total_mensaje = response.data.mensaje.length;
                  for (let i = 0; i < total_mensaje; i++) {
                    notificacion("fa fa-info", "Advertencia", response.data.mensaje[i], "info");
                  }
                }
              } else {
                notificacion("fa fa-ban", "Advertencia", "Error al actualizar el producto", "danger");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => (this.cargando = false));
      } else {
        let total_errores = this.errorForm.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion("fa fa-ban", "Advertencia", this.errorForm[i], "warning");
        }
      }
    },
    guardarStock() {
      let form_stock_guardar = document.getElementById("form_stock_guardar");
      let formData = new FormData(form_stock_guardar);
      formData.append("id_producto", this.id_producto);

      if (this.id_producto_editar) {
        formData.append("id", this.id_producto_editar);
      }

      this.errorFormStock = [];

      if (!formData.get("almacen")) this.errorFormStock.push("El campo Almacén es obligatorio.");
      if (!formData.get("max")) this.errorFormStock.push("El campo Stock Máx. es obligatorio.");

      if (this.id_producto && this.errorFormStock.length == 0) {
        this.cargando = true;
        axios({
          method: "post",
          url: "stock/guardar",
          data: formData,
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == false) {
                notificacion("fa fa-ban", "Advertencia", "Error", "danger");
              } else {
                this.obtenerStock();
                form_stock_guardar.reset();
                notificacion("fa fa-check", "Actualizado", "Proceso exitoso", "success");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            this.cargando = false;
            this.obtenerAlmacenesSegunProducto();
          });
      }
    },
    async verStock(id, almid, cantidad, stockmin, stockmax) {
      this.errorFormStock = [];
      this.id_producto_editar = id;
      this.almacenSinProductoEnStock = [];
      document.getElementById("stock_almacen").selectedIndex = almid;

      await axios
        .get("productos/obtenerAlmacen/" + almid)
        .then((response) => {
          if (Array.isArray(response.data)) {
            this.almacenSinProductoEnStock.push(response.data[0]);
          }
        })
        .catch((e) => notificacion());

      document.getElementById("stock_cantidad").value = cantidad;
      document.getElementById("srock_min").value = stockmin;
      document.getElementById("stock_max").value = stockmax;
      $("#formEditStockNewCollapse").collapse();
    },
    obtenerClientes() {
      this.errorForm = [];
      this.cargando = true;
      this.cargando_tabla = 'is-loading is-loading-lg';
      $("#tabla_clients").DataTable().destroy();

      axios.get('productos/obtenerClientesporProductos', {
        params: {
          fecha_desde: this.fecha_desde,
          fecha_hasta: this.fecha_hasta,
          id: this.id_producto
        }
      }).then(response => {
        this.clientes = response.data.productos;
      }).catch(e => notificacion()).finally(() => {
        this.cargando = false;
        this.cargando_tabla = '';

        let buttonCommon = {
          exportOptions: {
            format: {
              body: function (data, row, column, node) {
                if (column === 1 || column === 2 || column === 5 || column === 6 || column === 7) {
                  return convertir_a_float(data)
                } else {
                  return data.replace(/<[^>]*>?/g, '');
                }
              }
            }
          }
        };

        $("#tabla_clients").DataTable({
          order: [],
          dom: 'Blfrtip',
          buttons: [
            $.extend(true, {}, buttonCommon, {
              extend: 'excelHtml5',
              title: 'Producto vendido desde ' +
                moment(this.fecha_desde).format('DD-MM-YYYY') +
                ' hasta ' +
                moment(this.fecha_desde).format('DD-MM-YYYY'),
            }),
          ],
          "footerCallback": function (row, data, start, end, display) {
              var api = this.api(),
                  data;

              pageTotal = api
                  .column(5, { page: 'current' })
                  .data()
                  .reduce(function (a, b) {
                      return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                  }, 0);

              $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

              pageTotal = api
                  .column(6, { page: 'current' })
                  .data()
                  .reduce(function (a, b) {
                      return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                  }, 0);

              $(api.column(6).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
          }
        });
      });
    },
    obtenerStock() {
      this.almacenSinProductoEnStock = [];
      this.id_producto_editar = "";
      this.errorFormStock = [];
      axios
        .get("productos/relacionStock/" + this.id_producto)
        .then((response) => {
          this.productos_stock = response.data.productos_stock;
          this.almacenSinProductoEnStock = response.data.almacenes;
          this.stock_fisico_total = response.data.total_stock;
        })
        .catch((e) => notificacion());
    },
    agregarTarifas: function (event) {
      axios({
        method: "post",
        url: "productos/asignar_tarifas",
        data: {
          id_producto: this.id_producto,
          id_tarifa: event.target.value,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == false) {
              notificacion("fa fa-ban", "Advertencia", "Error", "danger");
            } else {
              this.productoTarifas();
              notificacion("fa fa-check", "", "Tarifas agregadas correctamente", "success");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    productoTarifas() {
      axios
        .get("productos/productoTarifas", {
          params: {
            id: this.id_producto,
          },
        })
        .then((response) => {
          this.producto_tarifas = response.data.tarifas_productos;
          this.tarifas = response.data.tarifas;
        })
        .catch((e) => notificacion());
    },
    obtenerCodigosDeBarra() {
      axios
        .get("productos/obtenerCodigosDeBarra/" + Number(this.id_producto))
        .then((response) => {
          this.codBarras = response.data;
        })
        .catch((e) => notificacion());
    },
    modalCodBarra() {
      this.errorForm = [];
      $("#modal-cod-barra").modal("show");
      $("#modal-cod-barra").on("shown.bs.modal", function () {
        $("#cod-barra").trigger("focus");
      });
    },
    guardarCodBarra(event) {
      this.errorForm = [];
      if (event.target.value) {
        axios
          .get("productos/guardarCodBarra", {
            params: {
              id: this.id_producto,
              codbarra: event.target.value,
            },
          })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == false) {
                notificacion("fa fa-ban", "Advertencia", "Error", "danger");
              } else {
                this.obtenerCodigosDeBarra();
                notificacion("fa fa-check", "", "Codigo agregado correctamente", "success");
              }
            } else {
              this.errorForm = response.data.errors;
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            event.target.value = "";
          });
      }
    },
    eliminarCodBarra(codigo) {
      axios
        .get("productos/eliminarCodBarra/" + codigo.id)
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == false) {
              notificacion("fa fa-ban", "Advertencia", "Error al eliminar", "danger");
            } else {
              posicion = this.codBarras.findIndex((item) => item.id == codigo.id);
              this.codBarras.splice(posicion, 1);
              this.obtenerCodigosDeBarra();
              notificacion("fa fa-check", "", "Codigo agregado correctamente", "success");
            }
          } else {
            this.errorForm = response.data.errors;
          }
        })
        .catch((e) => notificacion());
    },
    modalFactorProducto() {
      this.errorForm = [];
      this.selectFactores = [];
      this.selectedFactor = "";
      this.obtenerFactorProducto();
      $("#modal-factor-producto").modal("show");
      $("#modal-factor-producto").on("shown.bs.modal", function () {
        $("#fecha_factor").trigger("focus");
      });
    },
    buscarFactores() {
      if (this.fecha_factor) {
        axios
          .get("productos/buscarFactores/" + escape(this.fecha_factor))
          .then((response) => {
            if (response.data.errors == null) {
              this.selectFactores = response.data;
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    agregarFactor() {
      if (this.selectedFactor) {
        axios({
          method: "post",
          url: "productos/agregarFactor",
          data: {
            id_factor: Number(this.selectedFactor),
            id_producto: Number(this.id_producto),
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              notificacion("fa fa-check", "", "Agregado", "success");
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            this.selectFactores = [];
            this.selectedFactor = "";
            this.obtenerFactorProducto();
          });
      }
    },
    eliminarFactorProducto() {
      axios
        .get("productos/eliminarFactorProducto/" + Number(this.id_producto))
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              notificacion("fa fa-trash", "", "Eliminado", "danger");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.obtenerFactorProducto();
        });
    },
    obtenerFactorProducto() {
      axios
        .get("productos/obtenerFactorProducto/" + Number(this.id_producto))
        .then((response) => {
          if (response.data.errors == null) {
            this.factoresBitacora = response.data;
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    calcular() {
      let gn = 0;
      let pv = 0;
      let pc = 0;
      let total = 0;

      if (document.getElementById("pro_precio") && document.getElementById("pro_costo")) {
        pv = Number.parseFloat(document.getElementById("pro_precio").value);
        pc = Number.parseFloat(document.getElementById("pro_costo").value);

        if (pc != 0 && pv != 0) {
          gn = pv - pc;
          total = (gn * 100) / pc;
          total = Math.round(total);
        } else {
          total = 0;
        }

        document.getElementById("porcentaje_ganancia").value = total;

        if (pv != 0) {
          this.calcularImpuesto();
        }
      }
    },
    calcularPrecioImpuesto() {
      let gn = 0;
      let pv = 0;
      let pc = 0;
      let iva = 0;
      let pvv = 0;
      let impuesto=0;
      let total = 0;

      if (document.getElementById("pro_costo")) {
        pvv = Number.parseFloat(document.getElementById("venta_impuesto").value);
        pc = Number.parseFloat(document.getElementById("pro_costo").value);
        let id_iva = Number.parseInt(document.getElementById("iva").value);

        if (pc != 0 && pvv != 0) {
          if (id_iva) {
            axios
              .get("impuestos/obtenerImpuesto/" + id_iva)
              .then((response) => {
                if (Object.keys(response.data).length > 0) {
                  iva = Number.parseFloat(response.data.imp_valor);
                  pv =  Number.parseFloat(pvv / ((iva / 100)+1));
                  console.log(pv)
                  impuesto = pv * (iva / 100);

                  gn = pv - pc;
                  total = (gn * 100) / pc;
                  total = Math.round(total);

                  document.getElementById("porcentaje_ganancia").value = total;
                  document.getElementById("pro_precio").value = pv;
                }
              })
              .catch((e) => notificacion());
          }
         
        } else {
          total = 0;
        }

      }
    },
    calcularImpuesto() {
      if (document.getElementById("iva")) {
        let id_iva = Number.parseInt(document.getElementById("iva").value);
        if (id_iva) {
          axios
            .get("impuestos/obtenerImpuesto/" + id_iva)
            .then((response) => {
              if (Object.keys(response.data).length > 0) {
                let iva = 0;
                let pv = 0;
                pv = Number.parseFloat(document.getElementById("pro_precio").value);
                iva = Number.parseFloat(response.data.imp_valor);
                let precio_mas_impuesto = pv + pv * (iva / 100);
                if (document.getElementById("venta_impuesto")) {
                  document.getElementById("venta_impuesto").value = precio_mas_impuesto;
                }
              }
            })
            .catch((e) => notificacion());
        }
      }
    },
    obtenerAlmacenesSegunProducto() {
      axios
        .get("productos/obtenerAlmacenesSegunProducto/" + Number(this.id_producto))
        .then((response) => {
          this.almacenes_producto = response.data;
        })
        .catch((e) => notificacion());
    },
    obtenerUbicaciones(event) {
      if (event.target.value) {
        axios
          .get("almacenes/obtenerUbicaciones/" + Number(event.target.value))
          .then((response) => {
            this.ubicaciones = response.data;
          })
          .catch((e) => notificacion());
      }
    },
    guardarUbicacion(ubicacion) {
      axios({
        method: "post",
        url: "productos/guardarUbicacion",
        data: {
          id_producto: this.id_producto,
          id_almacen: this.almacenProducto,
          id_ubicacion: ubicacion.id,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          this.obtenerUbicacionesProducto();
        })
        .catch((e) => notificacion());
    },
    obtenerUbicacionesProducto() {
      axios
        .get("productos/obtenerUbicacionesProducto/" + Number(this.id_producto))
        .then((response) => {
          this.ubicacionesProducto = response.data;
        })
        .catch((e) => notificacion());
    },
    checkgeneral(event) {
      for (let row of this.tarifasPro) {
        row.checked = event.target.checked;

      }
      console.log(event.target.checked)
      this.actualizarcheckTarifa(event.target.checked);
    },
    actualizarMontTarifas(id) {
      let monto = document.getElementById('precio_tarifa' + id).value;
      axios({
        method: 'post',
        url: 'productos/actualizarMontTarifas',
        data: {
          id_producto: this.id_producto,
          id_tarifa: id,
          monto: monto
        },
        transformRequest: serializar(),
      }).then(response => {
        if (response.data.errors == null) {

        } else {
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());

    },
    actualizarCheckTarifaid(id) {
      axios({
        method: 'post',
        url: 'productos/actualizarCheckTarifaid',
        data: {
          id_producto: this.id_producto,
          id_tarifa: id
        },
        transformRequest: serializar(),
      }).then(response => {
        if (response.data.errors == null) {
          this.obtenertTrifasPro();
        } else {
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());
    },
    actualizarcheckTarifa(check) {

      let id_tarifas = [];

      for (let row of this.tarifasPro) {
        if (row.checked == true) {
          id_tarifas.push(row.id);
        }
      }
      axios({
        method: 'post',
        url: 'productos/actualizarCheckTarifas',
        data: {
          id_producto: this.id_producto,
          check: check
        },
        transformRequest: serializar(),
      }).then(response => {
        if (response.data.errors == null) {
          this.obtenertTrifasPro();
        } else {
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());
    },
    toggleTreeView(event) {
      if (event.target.classList[0] == "encabezado") {
        let toggler = document.getElementsByClassName("fas fa-angle-right");
        for (i = 0; i < toggler.length; i++) {
          toggler[i].classList.remove("active-treeview");
        }
        event.target.classList.toggle("fa-arrow-down");
        event.target.classList.toggle("active-treeview");
        event.target.parentElement.querySelector(".ocultar-treeview").classList.toggle("activar-treeview");
      }
    },
    precioProductoCompuesto() {
      let precio = this.precioCompuesto;
      axios({
        method: 'post',
        url: 'productos/precioProductoCompuesto',
        data: {
          id: this.id_producto,
          precio: precio
        },
        transformRequest: serializar(),
      }).then(response => {
        if (response.data.errors == null) {
          // notificacion("fa fa-edit", "Actualizado", "Actualización exitosa", "info");
        } else {
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());
    },
    precioTotal(id) {
      let precio = document.getElementById('precio-' + id).value;
      axios({
        method: 'post',
        url: 'productos/actualizarPrecioProCompuesto',
        data: {
          id: id,
          precio: precio
        },
        transformRequest: serializar(),
      }).then(response => {
        if (response.data.errors == null) {
          this.chequearStocks();

          notificacion("fa fa-edit", "Actualizado", "Actualización exitosa", "info");
        } else {
          let total_errores = response.data.errors.length
          for (let i = 0; i < total_errores; i++) {
            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
          }
        }
      }).catch(e => notificacion());
    },
    cantidadProdCompuesto(id, stock) {
      let cantidad = document.getElementById('cantidad-' + id).value;
      this.errorFormCantidad = [];

      if (Number(cantidad) > Number(stock)) {
        this.errorFormCantidad.push("La cantidad no puede ser mayor que el stock.");
      }

      if (this.errorFormCantidad.length == 0) {
        axios({
          method: 'post',
          url: 'productos/actualizarCantidadProCompuesto',
          data: {
            id: id,
            cantidad: cantidad
          },
          transformRequest: serializar(),
        }).then(response => {
          if (response.data.errors == null) {
            if (response.data == true) {
              notificacion("fa fa-edit", "Actualizado", "Actualización exitosa", "info");
            }
          } else {
            let total_errores = response.data.errors.length
            for (let i = 0; i < total_errores; i++) {
              notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
            }
          }
        }).catch(e => notificacion());
      } else {
        let total_errores = this.errorFormCantidad.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion('fa fa-ban', 'Advertencia', this.errorFormCantidad[i], 'warning');
        }
        this.chequearStocks();
      }
    }
  },
  computed: {
  }
});

document.addEventListener("click", function (e) {
  if (e.target.classList[0] !== "inputInactive" && e.target.classList[0] !== "agregar") {
    let x = document.getElementsByClassName("inputInactive");
    for (let i = 0; i < x.length; i++) {
      if (e != x[i]) {
        x[i].classList.remove("inputActive");
      }
    }
  }
});
