Vue.component('v-select', VueSelect.VueSelect)
Vue.component('treeselect', VueTreeselect.Treeselect);
new Vue({
    el: '#appCrearProductos',
    data: {
        optionsCategorias: [],
        optionsProveedores: [],
        optionsFabricantes: [],
        selectedProvid: [],
        selectedCatid: [],
        dataForm: { catid: '', provid: '', 'equivalencia': '', 'partnumber': '', 'expedicion': '', 'tipo': 1, 'vencimiento': '', 'bloqueado': false, 'fabid': '', 'impid': '', 'descripcion': '', 'nostock': false, 'observaciones': '', 'publico': false, 'codigo': '', 'secompra': true, 'sevende': true, 'stockfis': 0, 'ventasinstock': false, 'nombrecorto': '' },
        errorForm: [],
        cargando: false,
    },
    created() {
        axios.get('productos/obtenerDatosCrudForaneos').then(response => {
            this.optionsProveedores = response.data.proveedores;
            this.optionsCategorias = response.data.categorias;
            this.optionsFabricantes = response.data.fabricantes;
        }).catch(e => notificacion())
    },
    methods: {
        cambiarFormulario() {
            let capas_form = document.getElementsByClassName('producto_form');
           
            if (this.dataForm.tipo == '1') {
                for (let row of capas_form) {
                    row.style.display = 'block';
                }
            }else {
                for (let row of capas_form) {
                    row.style.display = 'none';
                }
            }
        },
        recargarFabricantes() {
            axios.get('productos/fabricantesActivos').then(response => {
                this.optionsFabricantes = response.data;
            }).catch(e => notificacion())
        },
        recargarProveedores() {
            axios.get('productos/proveedoresActivos').then(response => {
                this.optionsProveedores = response.data;
            }).catch(e => notificacion())
        },
        recargarCategorias() {
            axios.get('productos/obtenerCategorias').then(response => {
                this.optionsCategorias = response.data;
            }).catch(e => notificacion());;
        },
        guardar() {

            this.errorForm = [];

            if (!this.dataForm.tipo)
                this.errorForm.push('El campo Tipo es obligatorio.');
            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Nombre es obligatorio.');
            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Referencia es obligatorio.');

            if (this.errorForm.length == 0) {

                this.dataForm.catid = JSON.stringify(this.selectedCatid);
                this.dataForm.provid = JSON.stringify(this.selectedProvid);
                this.cargando = true;

                axios({
                    method: 'post',
                    url: 'productos/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == false) {
                            notificacion('fa fa-ban', 'Advertencia', 'Error al registrar el producto', 'danger');
                        } else {
                            location.href = response.data;
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            }
        }
    }
});