Vue.component("v-select", VueSelect.VueSelect);

new Vue({
  el: "#appPlanillaOrden",
  data: {
    id_orden: document.getElementById("id_orden").value,
    categorias: [],
    partes: [],
    partesOrden: [],
    orden: [],
    servicios: [],
    serviciosOrdenTodos: [],
    serviciosOrden: [],
    errorForm: [],
    categoria_adicional:'',
    select_empleado: null,
    empleados: [],
    cargando: false,
    trabajosAsignados: [],
    servicio_emp: "",
    motor_id: "",
    motor_nombre: "",
    id_motor: "",
    marcas: [],
    motores: [],
    tipos: [],
    estatus_orden: "",
    repuestos: [],
    emp_bajo_motor: 0,
    emp_desarmo_motor: 0,
    empleados_todos: [],
    medida1: '',
    medida2: '',
    medida3: '',
    norden: 0,
    tot_servicios_asignados:'',
    restante_pago:'',
    abrir_button:0,
    emp_ficha:0,
    monto_tr:0,
    cantidad_tr:0,
    descripcion_tr:'',
    empleado_tr:null,
    observ:'',
    entreg:0,
    searc:'',
    searcp:'',
    catser: false,
    catpart:false,
    trabajos_adicionales:[],
    servicios_adicionales:[],
    servicio_adicional:'',
    empleados_adicional:[]
  },
  computed:{
    filteredServicios:function(){
      return this.servicios.filter((item)=>{
        return item.servicio.toLowerCase().includes(this.searc);
      })
    },
    filteredPartes:function(){
      return this.partes.filter((item)=>{
        return item.parte.toLowerCase().includes(this.searcp);
      })
    }
  },
  created() {
    this.obtenerOrden();
    this.obtenerTrabajosAsignados();
    this.obtenerMotores();
    this.obtenerCategorias();
    this.obtnerRepuestosAsignados();
    this.obtenerComisionesTrabajoAdiccionales();
  },
  mounted() {
    let self = this;
    $("#modal-partes").on("shown.bs.modal", function (e) {
      $("#p_categoria").trigger("focus");
      document.getElementById("p_categoria").selectedIndex = 0;
      document.getElementById("checkbox-todos").checked = false;
    });
    $("#modal-partes").on("shown.bs.modal", function (e) {
      $("#p_categoria").trigger("focus");
      document.getElementById("s_categoria").selectedIndex = 0;
      document.getElementById("checkbox-todos-servicios").checked = false;
    });
    $("#modal-asignar-trabajo").on("shown.bs.modal", function (e) {
      document.getElementById("checkbox-todos-asignar-trabajo").checked = false;
      for (let item of self.serviciosOrdenTodos) {
        item.checked = false;
      }
    });
    $("#modal-partes").on("hidden.bs.modal", function (e) {
      self.partes = [];
    });
    $("#modal-partes").on("hidden.bs.modal", function (e) {
      self.servicios = [];
    });
    this.resetear();
    $("#modal-motores").on("shown.bs.modal", function (e) {
      $("#m_marca").trigger("focus");
      self.obtenerMarcas();
      self.obtenerTipoMotor();
    });
    $("#modal-motores").on("hidden.bs.modal", function (e) {
      self.resetear();
    });
  },
  methods: {

asignarRepuestoAEmpleadoIndividual(id, event) {
      if (event.target.value && id) {
        axios({
          method: "post",
          url: "planilla/asignarRepuestoAEmpleadoIndividual",
          data: {
            id_producto: id,
            id_empleado: event.target.value,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
           // this.obtenerRepuestos();
            if (response.data.errors == null) {
              if (response.data == true) {
                notificacion("fa fa-check", "Actualizacion", "Modificado exitosamente", "success");
                this.obtnerRepuestosAsignados();
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    obtenerOrden() {
      axios
        .get("planilla/obtenerOrden/" + Number(this.id_orden))
        .then((response) => {
          if (response.data.errors == null) {
            this.partesOrden = response.data.partes;
            this.serviciosOrden = response.data.servicios;
            this.motor_id = response.data.motor_id;
            this.motor_nombre = response.data.motor;
            this.estatus_orden = response.data.estatus;
            this.emp_bajo_motor = response.data.emp_bajo_motor;
            this.emp_desarmo_motor = response.data.emp_desarmo_motor;
            this.emp_ficha=response.data.pre_emplficha;

            this.medida1 = response.data.medidas1;
            this.medida2 = response.data.medidas2;
            this.medida3 = response.data.medidas3;
            this.observ = response.data.pre_observacion;
            if (this.emp_desarmo_motor > 0) {
              this.obtenerEmpleadosIdDesarm(this.emp_desarmo_motor)
            }

            if (this.emp_ficha > 0) {
              this.obtenerEmpleadosFicha(this.emp_ficha)
            }

            if (this.emp_bajo_motor > 0) {
              this.obtenerEmpleadosIdBajo(this.emp_bajo_motor)
            }
            this.tot_servicios_asignados=response.data.tot_servicios_asignados;
            this.restante_pago=response.data.restante;

           /* if (this.restante_pago===0 && this.tot_servicios_asignados==='0') {
             this.abrir_button=1;
            }*/

            this.empleados_todos = response.data.empleados_todos;
            document.getElementById("nuevaUbicacionPartes").value = response.data.ubicacion_culminado;
            document.getElementById("respuesto_cliente").value = response.data.observacion_repuestos;
            document.getElementById("taller_planilla").value = response.data.taller;
            document.getElementById("dni_cliente_planilla").innerHTML = response.data.cliente.dni;
            document.getElementById("cliente_planilla").innerHTML = response.data.cliente.cliente;
            document.getElementById("telefono_planilla").innerHTML = response.data.cliente.telefono;
            document.getElementById("motor_planilla").innerHTML = response.data.motor;
            document.getElementById("orden_planilla").innerHTML = response.data.n_orden;

            if (response.data.n_orden != null) {
              this.norden = response.data.n_orden;
            }
            this.entreg=response.data.entrega;

            document.getElementById("fecha_planilla").innerHTML = response.data.fecha;

          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    entegadocompletado(){
      axios
      .get("planilla/entregadocompletado/" + Number(this.id_orden))
      .then((response) => {
        if (response.data.errors == null) {
          this.entreg = response.data;
          if(this.entreg==true){
            this.entreg==1;
          }
          notificacion("fa fa-check", "", "Actualizado correctamente", "info");
          this.cronMsj(0);
        } else {
          let total_errores = response.data.errors.length;
          for (let i = 0; i < total_errores; i++) {
            notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
          }
        }
      })
      .catch((e) => notificacion());
    },
    //GENRAR ORDEN
    generarOrden() {
      axios
        .get("planilla/generarOrden/" + Number(this.id_orden))
        .then((response) => {
          if (response.data.errors == null) {
            document.getElementById("orden_planilla").innerHTML = response.data;
            notificacion("fa fa-check", "", "Orden generada correctamente", "info");
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    //ACTUALIZAR TALLER
    actualizarTaller() {
      let taller = document.getElementById("taller_planilla").value;
      axios({
        method: "post",
        url: "planilla/actualizarTaller",
        data: {
          id_orden: this.id_orden,
          taller: taller,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              notificacion("fa fa-check", "", "Taller actualizado", "info");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
actualizarObserv() {
      let observacion = document.getElementById("observacion").value;
      axios({
        method: "post",
        url: "planilla/actualizarObserv",
        data: {
          id_orden: this.id_orden,
          observ: observacion,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              notificacion("fa fa-check", "", "Observacion actualizada", "info");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    //ACTUALIZAR OBSERVACION DE REPUESTOS
    async actualizarRepuestosClientes() {
      let text_repuesto = document.getElementById("respuesto_cliente").value;
      await axios({
        method: "post",
        url: "planilla/actualizarRepuestosClientes",
        data: {
          id_orden: this.id_orden,
          repuestos: text_repuesto,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              notificacion("fa fa-check", "", "Respuestos actualizados", "info");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    //PARTES
    async selectCategoria(event) {
      if (event.target.value) {
        this.catpart=true;
        await axios
          .get("planilla/obtenerPartesDeCategoria", {
            params: {
              id_orden: this.id_orden,
              id_categoria: event.target.value,
            },
          })
          .then((response) => {
            this.partes = response.data;
          })
          .catch((e) => notificacion());
      }
    },
    checktodos(event) {
      for (let item of this.partes) {
        item.checked = event.target.checked;
      }
    },
    async guardarPartes() {
      await axios({
        method: "post",
        url: "planilla/guardarPartesPreOrden",
        data: {
          id_orden: this.id_orden,
          partes: JSON.stringify(this.partes),
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              this.partes = [];
              this.obtenerPartesDePreOrden();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          document.getElementById("p_categoria").selectedIndex = 0;
          document.getElementById("checkbox-todos").checked = false;
          $("#modal-partes").modal("hide");
        });
    },
    async obtenerPartesDePreOrden() {
      await axios
        .get("planilla/obtenerPartesDePreOrden/" + Number(this.id_orden))
        .then((response) => {
          this.partesOrden = response.data;
        })
        .catch((e) => notificacion());
    },
    async eliminarParteOrden(row) {
      await Swal.fire({
        title: "Eliminar parte",
        text: "¿Estás seguro que deseas eliminar la parte " + row.parte + " ?",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#aaa",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Eliminar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("planilla/eliminarParteOrden/" + Number(row.id))
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  let posicion = this.partesOrden.findIndex((item) => item.id == row.id);
                  this.partesOrden.splice(posicion, 1);
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion());
        }
      });
    },
    async actualizarCantidadParteOrden(row) {
      await axios({
        method: "post",
        url: "planilla/actualizarCantidadParteOrden",
        data: {
          id_parte_orden: row.id,
          cantidad: row.cantidad,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              notificacion("fa fa-check", "", "Actualizacion exitosa", "info");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    async modalObservacionParte(row) {
      await axios
        .get("planilla/obtenerParte/" + row.id)
        .then((response) => {
          document.getElementById("id_parte").value = row.id;
          document.getElementById("cantidad_parte").value = response.data.cantidad;
          document.getElementById("ubicacion_parte").value = response.data.ubicacion;
          document.getElementById("observacion_parte").value = response.data.observacion;
          $("#modal_observacion_parte").modal("show");
        })
        .catch((e) => notificacion());
    },
    async guardarObservacionParte() {
      let id_parte = document.getElementById("id_parte").value;
      let cantidad_parte = document.getElementById("cantidad_parte").value;
      let ubicacion_parte = document.getElementById("ubicacion_parte").value;
      let observacion = document.getElementById("observacion_parte").value;

      await axios({
        method: "post",
        url: "planilla/guardarObservacionParte",
        data: {
          id_parte: id_parte,
          cantidad: cantidad_parte,
          ubicacion: ubicacion_parte,
          observacion: observacion,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              this.obtenerPartesDePreOrden();
              $("#modal_observacion_parte").modal("hide");
              notificacion("fa fa-check", "", "Actualización exitosa", "success");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    //SERVICIOS
    async obtenerCategorias() {
      axios
        .get("planilla/obtenerCategorias")
        .then((response) => {
          this.categorias = response.data;
        })
        .catch((e) => notificacion());
    },
    obtenerCategoriasSegunMotor(event) {
      document.getElementById("s_categoria").selectedIndex = 0;
      this.categorias = [];
      this.servicios = [];
      if (event.target.value) {
        axios
          .get("planilla/obtenerCategoriasSegunMotor/" + Number(this.motor_id))
          .then((response) => {
            this.categorias = response.data;
          })
          .catch((e) => notificacion());
      } else {
        this.obtenerCategorias();
      }
    },
    obtenerComisionesTrabajoAdiccionales() {
      this.trabajos_adicionales = [];
        axios
          .get("planilla/obtenerComisionesTrabajoAdiccionales/" + Number(this.id_orden))
          .then((response) => {
             if (response.data.errors == null) {
            this.trabajos_adicionales = response.data;
            console.log(this.trabajos_adicionales);
		}
          })
          .catch((e) => notificacion());
    },
    selectCategoriaServicio(event) {
      if (event.target.value) {
        this.catser= true;
        const motor = document.getElementById("s_motor");
        axios
          .get("planilla/obtenerServiciosDeCategoria", {
            params: {
              id_orden: this.id_orden,
              id_categoria: event.target.value,
              id_motor: motor.value ?? null,
            },
          })
          .then((response) => {
            this.servicios = response.data;
          })
          .catch((e) => notificacion());
      }
    },
    selectAdicionalEmpleado(event) {
      if (event.target.value) {
        axios
          .get("planilla/selectCategoriaEmpleado/" + event.target.value)
          .then((response) => {
            this.empleados_adicional = response.data;
            this.selectServicioAdicional();
          })
          .catch((e) => notificacion());
      }
    },
    selectServicioAdicional() {
        axios
          .get("planilla/obtenerServiciosDeCategoria", {
            params: {
              id_orden: this.id_orden,
              id_categoria: this.categoria_adicional,
              id_motor:null,
            },
          })
          .then((response) => {
            this.servicios_adicionales = response.data;
          })
          .catch((e) => notificacion());
    },
    checktodosServicios(event) {
      for (let item of this.servicios) {
        item.checked = event.target.checked;
      }
    },
    guardarServiciosPreOrden() {
      axios({
        method: "post",
        url: "planilla/guardarServiciosPreOrden",
        data: {
          id_orden: this.id_orden,
          servicios: JSON.stringify(this.servicios),
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              this.servicios = [];
              this.obtenerServiciosDePreOrden();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          document.getElementById("s_categoria").selectedIndex = 0;
          document.getElementById("checkbox-todos-servicios").checked = false;
          $("#modal-servicios").modal("hide");
        });
    },
    async obtenerServiciosDePreOrden() {
      await axios
        .get("planilla/obtenerServiciosDePreOrden/" + Number(this.id_orden))
        .then((response) => {
          this.serviciosOrden = response.data;
        })
        .catch((e) => notificacion());
    },
    async eliminarServicioOrden(row) {
      await Swal.fire({
        title: "Eliminar servicio",
        text: "¿Estás seguro que deseas eliminar el servicio " + row.servicio + " ?",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#aaa",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Eliminar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("planilla/eliminarServicioOrden/" + Number(row.id))
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  this.obtenerServiciosDePreOrden();
                  notificacion("fa fa-trash", "", "Elimindao", "danger");
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion());
        }
      });
    },
    async actualizarCantidadServicioOrden(row) {
      await axios({
        method: "post",
        url: "planilla/actualizarCantidadServicioOrden",
        data: {
          id_servicio_orden: row.id,
          cantidad: row.cantidad,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              notificacion("fa fa-check", "", "Actualizacion exitosa", "info");
              this.obtenerTrabajosAsignados();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    async chequearEstatusPlanilla() {
      axios
        .get("planilla/chequearEstatusPlanilla/" + this.id_orden)
        .then((response) => {
          this.estatus_orden = response.data;
        })
        .catch((e) => notificacion());
    },
    async cambiarEstatusServicio(row) {
      this.modalAsignarTrabajoEmpleado(row);

    },
    //quien bajo y desarmo motor
    empleadBajoMotor() {
      let empleado = document.getElementById('emp_bajom').value;
      axios({
        method: "post",
        url: "planilla/empleadBajoMotor",
        data: {
          id_orden: this.id_orden,
          id_empleado: empleado,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            notificacion("fa fa-check", "", "Empleado seleccionado", "success");
            this.obtenerOrden();
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    empleadDesarmoMotor() {
      let empleado = document.getElementById('emp_desarmom').value;
      axios({
        method: "post",
        url: "planilla/empleadDesarmoMotor",
        data: {
          id_orden: this.id_orden,
          id_empleado: empleado,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            notificacion("fa fa-check", "", "Empleado seleccionado", "success");
            this.obtenerOrden();
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    obtenerEmpleadosIdDesarm(id) {
      axios({
        method: "post",
        url: "planilla/obtenerEmpleadosId",
        data: {
          id_empleado: id,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            document.getElementById('emp_desarmo_m').value = response.data.empleado;
          }
        })
        .catch((e) => notificacion());
    },
    obtenerEmpleadosIdBajo(id) {
      axios({
        method: "post",
        url: "planilla/obtenerEmpleadosId",
        data: {
          id_empleado: id,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            document.getElementById('emp_bajo_m').value = response.data.empleado;
          }
        })
        .catch((e) => notificacion());
    },
    //ASIGANR TRABAJO
    selectCategoriaEmpleado(event) {
      if (event.target.value) {
        axios
          .get("planilla/selectCategoriaEmpleado/" + event.target.value)
          .then((response) => {
            this.empleados = response.data;
          })
          .catch((e) => notificacion());
      }
    },
    modalAsignarTrabajoEmpleado(row) {
      this.servicio_emp = row.id;
      this.empleados = [];
      document.getElementById("te_categoria").selectedIndex = 0;
      $("#modal-asignar-trabajo-empleado").modal("show");
      $("#modal-partes").on("shown.bs.modal", function (e) {
        $("#te_categoria").trigger("focus");
      });
    },
    asignarTrabajoEmpleado() {
      if (this.select_empleado) {
        axios({
          method: "post",
          url: "planilla/asignarTrabajoEmpleado",
          data: {
            id_orden: this.id_orden,
            id_empleado: this.select_empleado,
            id_servicio: this.servicio_emp,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                $("#modal-asignar-trabajo-empleado").modal("hide");
                notificacion("fa fa-check", "exitoso", "Asignacion exitosa", "success");
                // this.cambiarEstatusServicio();
                this.obtenerOrden();
              } else {
                notificacion("fa fa-check", "exitoso", "Asignacion no", "success");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            document.getElementById("checkbox-todos-asignar-trabajo").checked = false;
            document.getElementById("te_categoria").selectedIndex = 0;
            this.select_empleado = null;
            this.obtenerServiciosDePreOrden();
            this.obtenerTrabajosAsignados();
          });
      }
    },
    async obtenerServiciosDePreOrdenTodos() {
      await axios
        .get("planilla/serviciosOrdenTodos/" + this.id_orden)
        .then((response) => {
          this.serviciosOrdenTodos = response.data;
        })
        .catch((e) => notificacion());
    },
    modalAsignarTrabajoEmpleadoTodos() {
      this.obtenerServiciosDePreOrdenTodos();
      this.serviciosOrdenTodos = "";
      this.empleados = [];
      document.getElementById("e_categoria").selectedIndex = 0;
      $("#modal-asignar-trabajo").modal("show");
      $("#modal-partes").on("shown.bs.modal", function (e) {
        $("#e_categoria").trigger("focus");
      });
    },
    asignarServicioEmpleado() {
      if (this.select_empleado) {
        axios({
          method: "post",
          url: "planilla/asignarServicioEmpleado",
          data: {
            id_orden: this.id_orden,
            id_empleado: this.select_empleado,
            servicios: JSON.stringify(this.serviciosOrdenTodos),
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                notificacion("fa fa-check", "exitoso", "Asignacion exitosa", "success");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            document.getElementById("checkbox-todos-asignar-trabajo").checked = false;
            document.getElementById("e_categoria").selectedIndex = 0;
            this.select_empleado = null;
            this.obtenerServiciosDePreOrdenTodos();
            this.obtenerServiciosDePreOrden();
            this.obtenerTrabajosAsignados();
          });
      }
    },
    estatusServiciosEmpleados(id){
      axios
      .get("planilla/estatusServiciosEmpleados/" + id)
      .then((response) => {
        if (response.data.errors == null) {
            notificacion("fa fa-check", "", "Estatus actualizado", "success");
            this.obtenerTrabajosAsignados();
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
      })
      .catch((e) => notificacion());
    },
    //Trabajos adicionale
    estatusServiciosAdicionales(id,com) {
      axios({
        method: "post",
        url: "planilla/cambiarEstatusServicioAsignadosAdicionales",
        data: {
          id: id,
          com: com,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            notificacion("fa fa-check", "", "Estatus actualizado", "success");
            this.obtenerComisionesTrabajoAdiccionales();
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    asignarServicioEmpleadoAdicionales() {
      if (this.empleado_tr>0 && this.servicio_adicional>0 && this.cantidad_tr>0) {
        axios({
          method: "post",
          url: "planilla/asignarTrabajoEmpleadoSincobrarCliente",
          data: {
            id_orden: this.id_orden,
            id_empleado: this.empleado_tr,
            servicio: this.servicio_adicional,
	          cantidad: this.cantidad_tr,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                notificacion("fa fa-check", "exitoso", "Asignacion exitosa", "success");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            this.obtenerComisionesTrabajoAdiccionales();
          });
      }
    },
    checktodosAsignarTrabajo(event) {
      for (let item of this.serviciosOrdenTodos) {
        item.checked = event.target.checked;
      }
    },
    async obtenerTrabajosAsignados() {
      await axios
        .get("planilla/obtenerTrabajosAsignados/" + Number(this.id_orden))
        .then((response) => {
          this.trabajosAsignados = response.data;
        })
        .catch((e) => notificacion());
    },
    async eliminarTrabajoAsignado(row) {
      Swal.fire({
        title: "<strong>¿Eliminar asignación?</strong>",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios("planilla/eliminarTrabajoAsignado/" + row.id)
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  notificacion("fa fa-trash", "Eliminado", "Asignacion eliminada", "danger");
                  this.obtenerOrden();
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
              this.obtenerTrabajosAsignados();
            });
        }
      });
    },
    async eliminarTrabajosAdicionales(id) {
      Swal.fire({
        title: "<strong>¿Eliminar asignación?</strong>",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios({
            method: "post",
            url: "planilla/eliminarTrabajoAsignadoAdicionales",
            data: {
              id_orden: this.id_orden,
              id: id,
            },
            transformRequest: serializar(),
          })
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  notificacion("fa fa-trash", "Eliminado", "Asignacion eliminada", "danger");
                  this.obtenerComisionesTrabajoAdiccionales();
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion())
            .finally(() => {
            });
        }
      });
    },
    async guardarObservacionCulminado() {
      const form = document.getElementById("nueva_ubicacion_parte");
      let medidas1 = this.medida1;
      let medidas2 = this.medida2;
      let medidas3 = this.medida3;
      const formData = new FormData(form);

      axios({
        method: "post",
        url: "planilla/guardarObservacionCulminado",
        data: {
          id_orden: this.id_orden,
          observacion: formData.get("nuevaUbicacionPartes"),
          medidas_u: medidas1,
          medidas_d: medidas2,
          medidas_t: medidas3
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            notificacion("fa fa-check", "", "Actualización exitosa", "info");
            this.cronMsj(0);
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    async imprimirTicket(id_impresora) {
      const data_ticket = await axios
        .get("planilla/imprimirTicket", {
          params: {
            id_orden: this.id_orden,
            id_impresora: id_impresora,
          },
        })
        .then((response) => {
          return response.data;
        })
        .catch((e) => notificacion());

      if (data_ticket.errors == null) {
        console.log(data_ticket.data);
        fetch(data_ticket.ip_puerto, {
          method: "POST",
          body: JSON.stringify(data_ticket.data),
        })
          .then((j) => {
            console.log(j);
            if (j.ok) {
              notificacion("fa fa-check", "Impreso", "Impresion exitosa", "success");
            } else {
              notificacion("fa fa-ban", "Error", "Respuesta de red OK pero respuesta HTTP no OK", "warning");
            }
          })
          .catch((error) => {
            notificacion("fa fa-ban", "Error", "Hubo un problema con la petición Fetch:" + error.message, "danger");
          });
      } else {
        let total_errores = data_ticket.errors.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion("fa fa-ban", "Advertencia", data_ticket.errors[i], "warning");
        }
      }
    },
    async obtnerRepuestosAsignados() {
      axios.get("planilla/obtnerRepuestosAsignados/" + this.id_orden).then((response) => {
        this.repuestos = response.data;
      });
    },
    //MOTORES
    eliminarTabla() {
      if ($.fn.DataTable.isDataTable("#tabla_motores")) {
        $("#tabla_motores").DataTable().destroy();
      }
    },
    redibujarTabla() {
      $(document).ready(function () {
        $("#tabla_motores").DataTable({
          info: false,
          retrieve: true,
        });
      });
    },
    resetear() {
      this.errorForm = [];
      this.id_motor = "";
      document.getElementById("form_motor").reset();
      document.getElementById("m_marca").selectedIndex = 0;
    },
    guardarMotores() {
      this.errorForm = [];
      let form_motor = document.getElementById("form_motor");
      let formData = new FormData(form_motor);

      if (!formData.get("motor")) this.errorForm.push("EL campo Motor es obligatorio");
      if (!formData.get("m_marca")) this.errorForm.push("EL campo Marca es obligatorio");
      if (!formData.get("m_tipo")) this.errorForm.push("EL campo Tipo es obligatorio");

      if (this.id_motor) {
        formData.append("id", this.id_motor);
      }

      if (this.errorForm.length == 0) {
        this.cargando = true;
        axios({
          method: "post",
          url: "planilla/guardarMotores",
          data: formData,
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.eliminarTabla();
              this.obtenerMotores();
              notificacion("fa fa-check", "Guardado", "Registro exitoso", "success");
            } else {
              this.errorForm = response.data.errors;
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            this.cargando = false;
          });
      }
    },
    obtenerMotores() {
      this.resetear();
      axios
        .get("planilla/obtenerMotores")
        .then((response) => {
          this.motores = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargando = false;
          this.redibujarTabla();
        });
    },
    obtenerMarcas() {
      axios
        .get("planilla/obtenerMarcas")
        .then((response) => {
          this.marcas = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargando = false;
        });
    },
    establecerMotor(motor) {
      document.getElementById("s_motor").selectedIndex = 0;
      axios({
        method: "post",
        url: "planilla/agregarMotorPlantilla",
        data: {
          id_orden: this.id_orden,
          id_motor: motor.id,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              $("#modal-motores").modal("hide");
              const motor_descripcion = motor.motor + " - Marca: " + motor.marca.marca + " - Modelo: " + motor.modelo;
              this.motor_id = motor.id;
              this.motor_nombre = motor_descripcion;
              document.getElementById("motor_planilla").innerHTML = motor_descripcion;
              notificacion("fa fa-check", "", "Actualización exitoso", "info");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargando = false;
        });
    },
    imprimirServiciosPorCategoria(impresora, id_cat) {
      axios("planilla/imprimirServicio", {
        params: {
          orden: this.id_orden,
          cat: id_cat,
          impresora: impresora,
        },
      })
        .then((response) => {
          if (response.data.errors == null) {
            console.log(response.data);
            fetch(response.data.ip_puerto, {
              method: "POST",
              body: JSON.stringify(response.data.data),
            })
              .then((j) => {
                console.log(j);
                if (j.ok) {
                  notificacion("fa fa-check", "Impreso", "Impresion exitosa", "success");
                } else {
                  notificacion("fa fa-ban", "Error", "Respuesta de red OK pero respuesta HTTP no OK", "warning");
                }
              })
              .catch((error) => {
                notificacion("fa fa-ban", "Error", "Hubo un problema con la petición Fetch:" + error.message, "danger");
              });
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargando = false;
        });
    },
    obtenerTipoMotor() {
      axios
        .get("planilla/obtenerTipoMotor")
        .then((response) => {
          this.tipos = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.cargando = false;
        });
    },
    cambiarHostPuerto() {
      alert(this.medida1);

    },
    empleadFicha(){
      let empleado = document.getElementById('emp_ficha').value;
      axios({
        method: "post",
        url: "planilla/empleadFicha",
        data: {
          id_orden: this.id_orden,
          id_empleado: empleado,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data == true) {
            this.emp_ficha=empleado;
            this.obtenerEmpleadosFicha(empleado);
          }
        })
        .catch((e) => notificacion());
    },
    obtenerEmpleadosFicha(id) {
      axios({
        method: "post",
        url: "planilla/obtenerEmpleadosId",
        data: {
          id_empleado: id,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            document.getElementById('emp_fichai').value = response.data.empleado;
          }
        })
        .catch((e) => notificacion());
    },
    cronMsj(tipo) {
      document.getElementById('cronmsj').disabled=true;
      axios({
        method: "post",
        url: "planilla/cronSMS",
        data: {
          id_orden: this.id_orden,
          tipo: tipo,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors) {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          } else {
            notificacion("fa fa-info", "", "Proceso ejecutado", "info");
          }
          document.getElementById('cronmsj').disabled=false;
        })
        .catch((e) => notificacion());
    },
  },
});
