new Vue({
    el: '#appNotificaciones',
    data: {
        notificaciones: '',
        cargando: ''
    },
    created() {
        this.obtenerNotificaciones();
    },
    methods: {
        obtenerNotificaciones() {
            this.cargando = 'is-loading is-loading-lg';
            axios.get('notificaciones/obtenerNotificaciones').then(response => {
                this.notificaciones = response.data;
            }).catch(e => notificacion()).finally(() => {
                this.cargando = '';
                $("#tabla-notificaciones").DataTable({
                    order: []
                });
            });
        },
        fecha: (value) => {
            return moment(value).format('DD/MM/YYYY h:mm A');
        }
    }
});