var currentFocus;

new Vue({
    el: '#appNotasDeEntregaVer',
    data: {
        id_factura: document.getElementById('id_fac').value,
        cliente: document.getElementById('id_cliente_fac').value,
        simbolo_master: '',
        div_nombre_master: '',
        div_locale: '',
        div_simbolo: '',
        div_decimal: 2,
        div_conv_factor: 1,
        factura: [],
        divisa_pagar: '',
        metodo_pagar: '',
        cuenta_pagar: '',
        abonos: [],
        cuentas: [],
        metodos_de_pagos: [],
        formDocumentos: { 'id_factura': '', 'descripcion': '', 'documento': '' },
        documentos: [],
        monto: 0,
        restante_original: 0,
        articulosTotal: 0,
        total_pagado: 0,
        descuento: 0,
        restante: 0,
        subtotal: 0,
        total: 0,
        neto: 0,
        iva: 0,
        divisa_predeterminada: '',
        almacen_predeterminado: '',
        serie_predeterminada: '',
        productos: [],
        carrito: [],
        money: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        moneyPagar: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false
        },
        moneyConver: {
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false
        },
        cargando: false,
        errorForm: [],
        observaciones: '',
        observacion_anular: '',
        loader_correo: false,
        cargando_documento: false,
        creditos: [],
        ver_contenedor_campos_pagar: true,
        select_credito: '',
        impModelosDocumentos: '',
        impModelosImpresoras: '',
        toggleBarcode: true,
        descuento_producto: 0,
        clave: '',
        empleado_autorizado: '',
        unique: '',
        conv_factor: '',
        conv_simbolo: '',
        conv_locale: '',
        conv_precision: '',
        divisa_convertir_p: '',
        divisa_convertir_s: '',
        monto_conv: 0.00,
        diferencia_credito: 0.00,
        divisa_pagar_credito: '',
        metodo_pagar_credito: '',
        cuenta_pagar_credito: '',
        pagar_descripcion_credito: '',
        generar_credito: false,
        creditosFactura: [],
        idCreditoImprimir: ''
    },
    created() {
        axios.get('notasdeentregacajaeditar/obtenerFactura/' + this.id_factura).then(response => {
            this.factura = response.data.factura;
            this.almacen_predeterminado = this.factura.id_almacen;
            this.serie_predeterminada = this.factura.id_serie;
            this.divisa_predeterminada = this.factura.id_divisa;
            this.div_nombre_master = response.data.div_nombre;
            this.div_locale = response.data.div_locale;
            this.div_simbolo = response.data.div_simbolo;
            this.div_decimal = response.data.div_decimal;

            this.moneyPagar.locale = this.money.locale = response.data.divisa.locale;
            this.moneyPagar.prefix = this.money.prefix = response.data.divisa.symbol + ' ';
            this.moneyPagar.decimal = this.money.decimal = response.data.divisa.decimal;
            this.moneyPagar.thousands = this.money.thousands = response.data.divisa.thousands;
            this.moneyPagar.precision = this.money.precision = response.data.divisa.precision;

            this.observaciones = this.factura.observaciones ?? '';

            this.articulosTotal = response.data.articulos_cantidad;
            this.subtotal = Number(response.data.subtotal).toFixed(this.money.precision);
            this.descuento = Number(response.data.descuento).toFixed(this.money.precision);
            this.neto = Number(response.data.neto).toFixed(this.money.precision);
            this.iva = Number(response.data.iva).toFixed(this.money.precision);
            this.total = Number(response.data.total).toFixed(this.money.precision);
            this.restante_original = Number(response.data.restante).toFixed(this.money.precision);
            this.restante = Number(response.data.restante).toFixed(this.money.precision);
            this.total_pagado = Number(response.data.total_pagado).toFixed(this.money.precision);
            this.carrito = response.data.data_carrito;
            this.abonos = response.data.abonos;
            this.creditosFactura = response.data.creditos;
        });

        if (this.total_pagado >= this.total) {
            this.obtenerDocumentos();
        }

        this.obtenerCreditos();
    },
    methods: {
        obtenerCreditos() {
            this.ver_contenedor_campos_pagar = true;
            axios.get('notasdeentregacajaeditar/obtenerCreditos/' + this.cliente).then(response => {
                this.creditos = response.data;
            }).catch(e => notificacion()).finally(() => { });
        },
        obtenerCreditosFactura() {
            axios.get('notasdeentregaeditar/obtenerCreditosFactura/' + Number(this.id_factura)).then(response => {
                this.creditosFactura = response.data;
            }).catch(e => notificacion());
        },
        pagarConCredito() {
            let input_pagar = document.getElementById('pagarmonto');
            if (this.select_credito) {
                axios.get('notasdeentregacajaeditar/obtenerFactor', {
                    params: {
                        id_factura: this.id_factura,
                        id_credito: this.select_credito
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.monto = Number(response.data).toFixed(2);
                        this.ver_contenedor_campos_pagar = false;
                        input_pagar.disabled = true;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => { });
            } else {
                this.monto = 0;
                this.ver_contenedor_campos_pagar = true;
                input_pagar.disabled = false;
            }
        },
        actualizarDetalles() {

            this.errorForm = [];

            let dataFormClienteDetalle = {
                'id': this.cliente,
                'cli_tipodoc': document.getElementById('cli_tipodoc').value,
                'cli_dni': document.getElementById('cli_dni').value,
                'cli_razon_social': document.getElementById('cli_razon_social').value,
                'cli_fecha_nac': '',
                'cli_email': '',
                'cli_telefono': '',
                'cli_telefono_2': '',
                'cli_direccion': document.getElementById('cli_direccion').value,
                'cli_contribuyente': '',
                'cli_estatus': '',
                'cli_fecha_reg': '',
                'cli_genero': '',
                'cli_paisid': document.getElementById('cli_pais').value,
                'cli_estado': document.getElementById('cli_estado').value,
                'cli_ciudad': document.getElementById('cli_ciudad').value,
                'cli_codigopostal': document.getElementById('cli_codigopostal').value,
                'cli_descuento': '',
                'cli_razonsocial': '',
                'cli_natural': '',
                'cli_grupid': '',
                'cli_observaciones': ''
            };

            if (!dataFormClienteDetalle.cli_tipodoc)
                this.errorForm.push('El campo Tipo de Documento es obligatorio');
            if (!dataFormClienteDetalle.cli_dni)
                this.errorForm.push('El campo Número de Documento es obligatorio.');
            if (!dataFormClienteDetalle.cli_direccion)
                this.errorForm.push('El campo Dirección es obligatorio');
            if (!dataFormClienteDetalle.cli_razon_social)
                this.errorForm.push('El campo Razón Social es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/guardarDetallesCliente',
                    data: dataFormClienteDetalle,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            document.getElementById('cabecera_cliente').innerHTML = dataFormClienteDetalle.cli_razon_social + ' ' + dataFormClienteDetalle.cli_dni;
                            notificacion('fa fa-edit', '', 'Actualización exitosa', 'info');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        actualizarEnvio() {

            this.errorForm = [];

            let dataFormClienteEnvio = {
                'id_factura': this.id_factura,
                'env_nombre_opcional': document.getElementById('env_nombre_opcional').value,
                'env_agencia_transporte': document.getElementById('env_agencia_transporte').value,
                'env_codigo_seguimiento': document.getElementById('env_codigo_seguimiento').value,
                'env_direccion': document.getElementById('env_direccion').value,
                'env_pais': document.getElementById('env_pais').value,
                'env_estado': document.getElementById('env_estado').value,
                'env_ciudad': document.getElementById('env_ciudad').value,
                'env_codigopostal': document.getElementById('env_codigopostal').value,
                'env_asegurado': document.getElementById('env_asegurado').checked
            };

            if (!dataFormClienteEnvio.env_agencia_transporte)
                this.errorForm.push('El campo Agencia de Tranporte es obligatorio.');
            if (!dataFormClienteEnvio.env_codigo_seguimiento)
                this.errorForm.push('El campo Código de Seguimiento es obligatorio.');
            if (!dataFormClienteEnvio.env_direccion)
                this.errorForm.push('El campo Dirección obligatorio.');
            if (!dataFormClienteEnvio.env_pais)
                this.errorForm.push('El campo País es obligatorio.');
            if (!dataFormClienteEnvio.env_estado)
                this.errorForm.push('El campo Estado es obligatorio.');
            if (!dataFormClienteEnvio.env_ciudad)
                this.errorForm.push('El campo Ciudad es obligatorio.');
            if (!dataFormClienteEnvio.env_codigopostal)
                this.errorForm.push('El campo Código Postal es obligatorio.');

            if (this.id_factura && this.cliente && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/guardarEnvioCliente',
                    data: dataFormClienteEnvio,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            if (document.getElementById('env_asegurado').checked == true) {
                                notificacion('fa fa-check', '', 'Envío asegurado', 'success');
                            } else {
                                notificacion('fa fa-info', '', 'Envío No asegurado', 'info');
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        predeterminarDivisa(event) {
            axios.get('notasdeentregacajaeditar/predeterminarDivisa', {
                params: {
                    id_divisa: event.target.value,
                    id_factura: this.id_factura,
                    descuento: this.descuento
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.divisa_predeterminada = event.target.value;
                    if (response.data.data_carrito) {
                        this.money.locale = response.data.divisa.locale;
                        this.money.prefix = response.data.divisa.symbol + ' ';
                        this.money.decimal = response.data.divisa.decimal;
                        this.money.thousands = response.data.divisa.thousands;
                        this.money.precision = response.data.divisa.precision;
                        this.articulosTotal = response.data.data_carrito.articulos_cantidad;
                        this.subtotal = response.data.data_carrito.subtotal;
                        this.descuento = response.data.data_carrito.descuento;
                        this.neto = response.data.data_carrito.neto;
                        this.iva = response.data.data_carrito.iva;
                        this.total = response.data.data_carrito.total;
                        this.restante = response.data.data_carrito.total;
                        this.carrito = response.data.data_carrito.carrito;
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());

        },
        actualizarCantidad(unique, event) {
            let cantidad = convertir_a_float(event.target.value);
            if (event.target.value && cantidad > 0 && this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/actualizarCantidad',
                    data: {
                        id_producto: unique,
                        cantidad: event.target.value,
                        descuento_global: this.descuento,
                        id_factura: this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        Object.keys(response.data.carrito).forEach((key, i) => {
                            this.carrito[key].neto = response.data.carrito[key].neto;
                            this.carrito[key].total = response.data.carrito[key].total;
                        });
                    } else {
                        if (response.data.cantidad > 0) {
                            event.target.value = response.data.cantidad;
                        }
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        aplicarNuevoIva(unique, id_iva) {
            this.errorForm = [];
            if (unique && id_iva && this.cliente && this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/aplicarNuevoIva',
                    data: {
                        'id_cliente': this.cliente,
                        'unique': unique,
                        'id_iva': id_iva,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        aplicarDescuentoProducto(unique, event) {
            let descuento_ = convertir_a_float(event.target.value);
            if (unique && this.cliente && this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/aplicarDescuentoProducto',
                    data: {
                        'id_cliente': this.cliente,
                        'unique': unique,
                        'descuento': descuento_,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        aplicarDescuentoAdicional() {
            if (!isNaN(this.descuento) && this.descuento >= 0) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/aplicarDescuentoAdicional',
                    data: {
                        'descuento': this.descuento,
                        'id_cliente': this.cliente,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminarProducto(unique) {
            if (this.cliente && unique) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/eliminarProducto',
                    data: {
                        'id_producto': unique,
                        'id_cliente': this.cliente,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        actualizarDescripcion(unique, event) {

            this.errorForm = [];

            if (!event.target.value)
                this.errorForm.push('La descripción no debe quedar vacia.');

            if (this.cliente && this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/actualizarDescripcion',
                    data: {
                        'id_cliente': this.cliente,
                        'id_factura': this.id_factura,
                        'unique': unique,
                        'descripcion': event.target.value,
                        'descuento_global': this.descuento,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors) {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        guardarFactura() {

            this.errorForm = [];

            if (this.carrito.length == 0)
                this.errorForm.push('No ha seleccinado algún producto para la compra');
            if (!this.serie_predeterminada)
                this.errorForm.push('Debe seleccionar una serie');
            if (!document.getElementById('fecha').value)
                this.errorForm.push('Debe seleccionar una fecha');

            if (this.id_factura && this.cliente && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/ventaEnEsperaEditar',
                    data: {
                        'id_serie': this.serie_predeterminada,
                        'id_cliente': this.cliente,
                        'id_factura': this.id_factura,
                        'fecha': document.getElementById('fecha').value,
                        'observaciones': this.observaciones
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        location.href = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        descontardeEstock() {

            this.errorForm = [];

            if (this.carrito.length == 0)
                this.errorForm.push('No ha seleccinado algún producto para la compra');
            if (!this.serie_predeterminada)
                this.errorForm.push('Debe seleccionar una serie');
            if (!document.getElementById('fecha').value)
                this.errorForm.push('Debe seleccionar una fecha');

            if (this.id_factura && this.cliente && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/ventaEnEsperaEditar',
                    data: {
                        'id_serie': this.serie_predeterminada,
                        'id_cliente': this.cliente,
                        'id_factura': this.id_factura,
                        'fecha': document.getElementById('fecha').value,
                        'observaciones': this.observaciones
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        location.href = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        modalPagar() {
            document.getElementById('modal_form_pagar').reset();
            this.monto = 0.00;
            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
            this.errorForm = [];
            this.divisa_pagar = '';
            this.metodo_pagar = '';
            this.metodos_de_pagos = [];
            this.cuenta_pagar = '';
            this.cuentas = [];
            axios.get('notasdeentregacajaeditar/comprobarFactura/' + this.id_factura).then(response => {
                if (response.data.errors == null) {
                    $('#modal_pagar').modal({ show: true, backdrop: 'static', keyboard: false });
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            });
        },
        obtenerMetodosSegunDivisa(event) {

            this.errorForm = [];
            this.metodo_pagar = '';
            this.metodos_de_pagos = [];
            this.cuenta_pagar = '';
            this.cuentas = [];

            if (!event.target.value)
                this.errorForm.push('La divisa es requerida');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/obtenerMetodosSegunDivisa',
                    data: { 'id_factura': this.id_factura, 'id_divisa': event.target.value },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.moneyPagar.locale = response.data.divisa.locale;
                            this.moneyPagar.prefix = response.data.divisa.symbol + ' ';
                            this.moneyPagar.decimal = response.data.divisa.decimal;
                            this.moneyPagar.thousands = response.data.divisa.thousands;
                            this.moneyPagar.precision = response.data.divisa.precision;
                            this.metodos_de_pagos = response.data.data_metodos;
                            this.div_conv_factor = response.data.factor;
                            this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                            this.restante = parseFloat(response.data.restante * response.data.factor).toFixed(this.moneyPagar.precision);
                            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                            //this.monto = this.restante;
                        }
                    } else {
                        this.divisa_pagar = '';
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        obtenerCuentasSegunMetodo(event) {
            this.errorForm = [];
            this.cuenta_pagar = '';
            this.cuentas = [];

            if (!event.target.value)
                this.errorForm.push('EL Método de Pago es requerido');

            if (this.errorForm.length == 0) {
                axios.get('notasdeentregacajaeditar/obtenerCuentasSegunMetodo/' + event.target.value).then(response => {
                    if (response.data.errors == null) {
                        if (Array.isArray(response.data)) {
                            if (response.data.length > 0) {
                                this.cuentas = response.data;
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        pagar() {

            if (!this.ver_contenedor_campos_pagar) {
                axios.get('notasdeentregacajaeditar/pagarConCredito', {
                    params: {
                        id_fac: this.id_factura,
                        id_credito: this.select_credito
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.monto = 0.00;
                            this.abonos = response.data.abonos;
                            this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                            this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.moneyPagar.precision);
                            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                            this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                            //this.monto = this.restante;
                            if (response.data.pagado) {
                                $('#modal_pagar').modal('hide');
                                notificacion('fa fa-check', 'Advertencia', 'Total de Nota de entrega pagado', 'success');
                            } else {
                                notificacion('fa fa-check', 'Pago', 'Pago exitoso', 'success');
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                    this.obtenerCreditos();
                }).catch(e => notificacion()).finally(() => {
                    let input_pagar = document.getElementById('pagarmonto');
                    input_pagar.disabled = false;
                    input_pagar.value = '';
                });
            } else {

                this.errorForm = [];

                if (!this.divisa_pagar)
                    this.errorForm.push('El campo Divisa es obligatorio');
                if (!this.metodo_pagar)
                    this.errorForm.push('El campo Método es obligatorio');
                if (!this.cuenta_pagar)
                    this.errorForm.push('El campo Cuenta es obligatorio');
                if (!this.monto)
                    this.errorForm.push('El campo Monto es obligatorio');

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'notasdeentregacajaeditar/pagar',
                        data: {
                            id_factura: this.id_factura,
                            id_divisa: this.divisa_pagar,
                            id_metodo_divisa: this.metodo_pagar,
                            id_cuenta_metodo: this.cuenta_pagar,
                            monto: this.monto,
                            credito: this.generar_credito
                        },
                        transformRequest: serializar(),
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data) {
                                this.monto = 0.00;
                                this.abonos = response.data.abonos;
                                this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                                this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.moneyPagar.precision);
                                this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                                this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                                //this.monto = this.restante;
                                if (response.data.pagado) {
                                    $('#modal_pagar').modal('hide');
                                    notificacion('fa fa-check', 'Advertencia', 'Total de nota de entrega pagado', 'success');
                                } else {
                                    notificacion('fa fa-check', 'Pago', 'Pago exitoso', 'success');
                                }
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => {
                        notificacion();
                    }).finally(() => {
                        this.cargando = false;
                        this.monto = 0;
                        this.divisa_pagar = ''
                        this.metodo_pagar = '';
                        this.cuenta_pagar = '';
                        this.obtenerCreditosFactura();
                    });
                } else {
                    let total_errores = this.errorForm.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                    }
                }
            }
        },
        eliminarPago(id) {
            axios({
                method: 'post',
                url: 'notasdeentregacajaeditar/eliminarPago',
                data: { 'id_factura': this.id_factura, 'id': id },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data) {
                        this.abonos = response.data.abonos;
                        this.restante_original = Number(response.data.restante).toFixed(this.money.precision);
                        this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.money.precision);
                        this.total_pagado = Number(response.data.total_pagado).toFixed(this.money.precision);
                        //this.monto = this.restante;
                        notificacion('fa fa-trash', 'Eliminado', 'Pago eliminado', 'danger');
                    }
                } else {
                    this.divisa_pagar = '';
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modalCorreo() {
            $('#modal_correo').modal('show');
            $('#modal_correo').on('shown.bs.modal', function () {
                //$('#nombre_divisa').trigger('focus');
            });
        },
        enviarFactura() {

            this.errorForm = [];

            let de = document.getElementById('cor_emailde').value;
            let para = document.getElementById('cor_emailpara').value;
            let copia = document.getElementById('cor_emailcopia').value;
            let firma = document.getElementById('cor_emailfirma').value;
            let tipo = document.getElementById('cor_tipo').value;

            if (!de)
                this.errorForm.push('El campo De es obligatorio.');
            if (!para)
                this.errorForm.push('El campo Para es obligatorio.');

            if (de && para) {
                if (!validaEmail(de))
                    this.errorForm.push('El Correo Electrónico ' + de + ' no es válido.');
                if (!validaEmail(para))
                    this.errorForm.push('El Correo Electrónico ' + para + ' no es válido.');
            }

            if (this.errorForm.length == 0) {

                this.loader_correo = true;

                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/eniviarFactura',
                    data: {
                        id_factura: this.id_factura,
                        de: de,
                        para: para,
                        copia: copia,
                        firma: firma,
                        tipo: tipo
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.loader_correo = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        handleFileUpload() {
            this.formDocumentos.documento = this.$refs.file.files[0];
        },
        enviarDocumento() {

            this.errorForm = [];

            this.formDocumentos.id_factura = this.id_factura;

            if (!this.formDocumentos.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');

            if (!this.formDocumentos.documento)
                this.errorForm.push('El Documento obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando_documento = true;
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/enviarDocumento',
                    data: this.formDocumentos,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.obtenerDocumentos();
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando_documento = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        obtenerDocumentos() {
            axios.get('notasdeentregacajaeditar/obtnerDocumentos/' + this.id_factura).then(response => {
                if (Array.isArray(response.data)) {
                    this.documentos = response.data;
                }
            });
        },
        moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
            }
        },
        decimal(num, div_locale_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaDecimal(monto_, div_locale_, decimal_);
            }
        },
        modalConvertirDocumento() {
            $('#modal_convertir').modal({ show: true, backdrop: 'static', keyboard: false });
        },
        focusBuuscar() {
            document.getElementById('buscador').focus();
        },
        buscarProducto(event) {
            if (this.almacen_predeterminado && this.divisa_predeterminada) {
                this.searchProducto(event.target.value, event, this);
            }
        },
        searchProducto: _.debounce((search, event, vm) => {

            if (vm.toggleBarcode == false) {

                currentFocus = 0;
                let a, b;
                var x = document.getElementsByClassName("autocomplete-items");

                for (var i = 0; i < x.length; i++) {
                    x[i].parentNode.removeChild(x[i]);
                }

                if (!search) {
                    return false;
                }

                axios.get('notasdeentregacaja/buscarProducto', {
                    params: {
                        'divisa': vm.divisa_predeterminada,
                        'almacen': vm.almacen_predeterminado,
                        'buscar': search.trim(),
                    }
                }).then(response => {
                    vm.productos = response.data;
                }).catch(e => {
                    notificacion();
                }).finally(() => {

                    currentFocus = -1;

                    a = document.createElement("div");
                    a.id = event.target.id + 'autocomplete-list';
                    a.classList.add('autocomplete-items');
                    event.target.parentNode.appendChild(a);

                    let self = vm;

                    vm.productos.forEach((item) => {

                        b = document.createElement("div");

                        if (item.imagen) {
                            b.innerHTML += "<img src='" + item.imagen + "' class='avatar-img rounded-circle' style='width: 50px; height: 50px; margin-right: 15px'>";
                        }

                        if (item.pro_descripcion.substr(0, search.length).toUpperCase() == search.toUpperCase()) {
                            b.innerHTML += "<strong>" + item.pro_descripcion.substr(0, search.length) + "</strong>";
                            b.innerHTML += "<span>" + item.pro_descripcion.substr(search.length) + "</span>";
                        } else {
                            b.innerHTML += "<strong>" + item.pro_descripcion + "</strong>";
                        }

                        b.innerHTML += "<small class='text-primary' style='margin-right: 5px'> stock: " + item.ps_cantidad + "</small> <br>";
                        b.innerHTML += "<small class='text-primary' style='margin-right: 10px'> fabricante: " + item.fabricante + "</small>";
                        b.innerHTML += "<input type='hidden' value='" + item.pro_id + "' data-almacen='" + item.id_almacen + "' data-name='" + item.pro_descripcion + "'>";

                        b.addEventListener("click", function (e) {

                            event.target.value = this.getElementsByTagName("input")[0].getAttribute('data-name');
                            let id_producto = this.getElementsByTagName("input")[0].value;
                            let id_almacen = this.getElementsByTagName("input")[0].getAttribute('data-almacen');

                            self.agregarProducto(id_producto, id_almacen);

                            for (var i = 0; i < x.length; i++) {
                                x[i].parentNode.removeChild(x[i]);
                            }
                        });

                        a.appendChild(b);

                    });
                });
            }
        }, 500),
        agregarProducto(id_producto, id_almacen) {
            if (this.divisa_predeterminada && id_producto && id_almacen && this.cliente) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/agregarProducto',
                    data: {
                        'id_factura': this.id_factura,
                        'id_producto': id_producto,
                        'id_almacen': id_almacen,
                        'id_divisa': this.divisa_predeterminada,
                        'descuento_global': this.descuento,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    document.getElementById('buscador').value = '';
                });
            }
        },
        seleccionarProducto(event) {

            var x = document.getElementById(event.target.id + 'autocomplete-list');

            if (x) x = x.getElementsByTagName("div");

            if (event.key == 'ArrowDown') {
                currentFocus++;
                active(x);
            } else if (event.key == 'ArrowUp') {
                currentFocus--;
                active(x);
            } else if (event.key == 'Enter') {

                event.preventDefault();

                if (this.toggleBarcode == true) {
                    this.agregarProductoBarcode(event.target.value);
                    document.getElementById('buscador').value = '';
                } else {
                    if (currentFocus > -1) {
                        if (x) x[currentFocus].click();
                    }
                }
            }
        },
        agregarProductoBarcode(producto) {
            if (this.divisa_predeterminada && this.id_factura) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/agregarProductoBarcode',
                    data: {
                        'id_factura': this.id_factura,
                        'producto': producto,
                        'id_divisa': this.divisa_predeterminada,
                        'id_almacen': this.almacen_predeterminado,
                        'descuento_global': this.descuento,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        modalAnular() {
            $('#modal_anular').modal();
            $('#modal_anular').on('shown.bs.modal', function () {
                $('#observacion_anular').trigger('focus')
            });
        },
        anular() {
            Swal.fire({
                title: '<strong>¿Anular nota de entrega?</strong>',
                showCloseButton: true,
                showCancelButton: true,
                focusConfirm: false,
                cancelButtonColor: '#aaa',
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Aceptar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('notasdeentregacajaeditar/anularFactura', {
                        params: {
                            id_factura: this.id_factura,
                            descripcion: this.observacion_anular
                        }
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data !== false) {
                                location.href = response.data;
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Error al anular Nota de Entrega', 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion()).finally(() => this.cargando = false);
                }
            });
        },
        modalImprimirCredito(id_credito) {
            this.idCreditoImprimir = id_credito;
            $('#modal-imprimir-credito').modal();
        },
        imprimirCredito(id_impresora) {
            axios.get('poseditar/imprimirCredito', {
                params: {
                    id_credito: Number(this.idCreditoImprimir),
                    id_impresora: id_impresora
                }
            }).then(response => {
                console.log(response.data);
                if (response.data.errors == null) {
                    if (response.data !== false) {
                        fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            console.log(j);
                            if (j.ok) {
                                notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                                axios.get('poseditar/facturaImpresa/' + Number(this.id_factura)).then(response => {
                                    notificacion('fa fa-info', '', response.data, 'info');
                                }).catch(e => {
                                    notificacion('fa fa-ban', 'No impreso', 'debe actualizar manualmente el documento como impreso', 'success');
                                });
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                        });
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modalImprimir(ruta) {
            this.errorForm = [];
            $('#modal-imprimir').modal();
        },
        imprimir(id) {
            axios.get('notasdeentregacajaeditar/imprimir', {
                params: {
                    id_factura: Number(this.id_factura),
                    impresora: id,
                }
            }).then(response => {
                if (response.data.data.errors == null) {
                    fetch(response.data.ip_puerto, {
                        method: 'POST',
                        body: JSON.stringify(response.data.data)
                    }).then((j) => {
                        if (j.ok) {
                            notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                        }
                    }).catch((error) => {
                        notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                    });
                } else {
                    let total_errores = response.data.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modalDescuento(unique, descuento) {
            this.empleado_autorizado = '';
            this.clave = '';
            this.descuento_producto = descuento;
            this.unique = unique;
            $('#modal-descuento').modal();
        },
        autorizarDescuentoProducto() {
            if (this.empleado_autorizado && this.clave && this.id_factura && this.unique) {
                axios({
                    method: 'post',
                    url: 'notasdeentregacajaeditar/autorizarDescuentoProducto',
                    data: {
                        'id_factura': this.id_factura,
                        'unique': this.unique,
                        'empleado': this.empleado_autorizado,
                        'clave': this.clave,
                        'descuento': this.descuento_producto,
                        'descuento_global': this.descuento_global,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.empleado_autorizado = '';
                    this.clave = '';
                    this.unique = '';
                    $('#modal-descuento').modal('hide');
                })
            }
        },
        colocarEnMonto() {
            if (this.ver_contenedor_campos_pagar == true) {
                this.monto_conv = this.monto = Number(this.restante).toFixed(this.moneyPagar.precision);
            }
        },
        conversor() {
            if (this.divisa_convertir_p && this.divisa_convertir_s) {
                axios.get('generico/conversion', {
                    params: {
                        'div_p': this.divisa_convertir_p,
                        'div_s': this.divisa_convertir_s
                    }
                }).then(response => {
                    if (!this.monto_conv) this.monto_conv = 0;
                    this.monto_conv = convertir_a_float(this.monto_conv);
                    this.monto_conv = this.monto_conv.toFixed(response.data.divisa_conv.precision);
                    this.moneyConver.decimal = response.data.divisa_conv.decimal;
                    this.moneyConver.thousands = response.data.divisa_conv.thousands;
                    this.moneyConver.prefix = response.data.divisa_conv.symbol;
                    this.moneyConver.precision = response.data.divisa_conv.precision;
                    this.conv_factor = response.data.factor;
                    this.conv_simbolo = response.data.divisa_result.symbol;
                    this.conv_local = response.data.divisa_result.locale;
                    this.conv_precision = response.data.divisa_result.precision;
                    let total = this.monto_conv * this.conv_factor;
                    total = monedaMoneda(total, this.conv_local, this.conv_simbolo, this.conv_precision);
                    document.getElementById('result_conv').value = total;
                }).catch(e => notificacion()).finally(() => {

                })
            }
        },
        convedorInput() {
            if (this.divisa_convertir_p && this.divisa_convertir_s) {
                let total = convertir_a_float(this.monto_conv) * this.conv_factor;
                total = monedaMoneda(total, this.conv_local, this.conv_simbolo, this.conv_precision);
                document.getElementById('result_conv').value = total;
            }
        },
        modalCrearCredito() {
            this.errorForm = [];
            this.divisa_pagar_credito = '';
            this.metodo_pagar_credito = '';
            this.cuenta_pagar_credito = '';
            this.pagar_descripcion_credito = '';
            this.cuentas = [];
            this.metodos_de_pagos = [];
            $('#modal_crear_credito').modal('show');
        },
        pagarCredito() {

            this.errorForm = [];

            if (!this.serie_predeterminada)
                this.errorForm.push('El campo Serie es obligatorio');
            if (!this.divisa_pagar_credito)
                this.errorForm.push('El campo Divisa es obligatorio');
            if (!this.metodo_pagar_credito)
                this.errorForm.push('El campo Método es obligatorio');
            if (!this.cuenta_pagar_credito)
                this.errorForm.push('El campo Cuenta es obligatorio');
            if (!this.diferencia_credito)
                this.errorForm.push('El campo Monto es obligatorio');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'notasdeentregaeditar/guardarCredito',
                    data: {
                        id_factura: this.id_factura,
                        id_serie: this.serie_predeterminada,
                        monto: this.diferencia_credito,
                        id_divisa: this.divisa_pagar_credito,
                        id_metodo_divisa: this.metodo_pagar_credito,
                        id_cuenta_metodo: this.cuenta_pagar_credito,
                        observacion: this.pagar_descripcion_credito
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    console.log(response.data);
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-check', '', 'Operación exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en la operación', 'danger');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.obtenerCreditosFactura();
                    this.divisa_pagar_credito = '';
                    this.metodo_pagar_credito = '';
                    this.cuenta_pagar_credito = '';
                    this.pagar_descripcion_credito = '';
                    this.cuentas = [];
                    this.metodos_de_pagos = [];
                    $('#modal_crear_credito').modal('hide');
                });
            }
        }
    },
    computed: {
        balance() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            if (balance_ <= 0) {
                balance_ = 0;
            }
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision);
        },
        diferencia_n() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            return balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0;
        },
        diferencia() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision);
        }
    }
});

function active(x) {

    if (!x) return false;

    for (var i = 0; i < x.length; i++) {
        x[i].classList.remove("autocomplete-active");
    }

    if (currentFocus >= x.length) currentFocus = 0;
    if (currentFocus < 0) currentFocus = (x.length - 1);

    x[currentFocus].classList.add("autocomplete-active");
}

function closeAllLists(elmnt) {
    let inp = document.getElementById("buscador");
    let x = document.getElementsByClassName("autocomplete-items");
    for (var i = 0; i < x.length; i++) {
        if (elmnt != x[i] && elmnt != inp) {
            x[i].parentNode.removeChild(x[i]);
        }
    }
}

document.addEventListener("click", function (e) {
    closeAllLists(e.target);
});