new Vue({
    el: '#appMiPerfil',
    data: {
        dataForm: { 'nombres': '', 'apellidos': '', 'telefono': '', 'correo': '', 'direccion_uno': '', 'direccion_dos': '', 'ciudad': '', 'estado': '', agente_de_venta: false },
        dataFormUser: { 'nombre': '', 'password': '', 'repassword': '','autenticacion':false },
        errorForm: [],
        cargando: false,
        imagen: '',
        upload_imagen: '',
        errorImage: [],
        ruta_imagen: '',
        clientes: [],
        comisionesAgentepagadas: [],
        comisionesAgentependientes: [],
        client: [],
        clients:[],
        interesesclientes:[],
        obrero:false,
        google:'',
        qr:''
    },
    created() {
        this.obtenerEmpleado();
        this.obtenerClienteAgente();
        this.obtenerComisionesEmpAgentePendiente();
        this.ComprobarQr();
    },
    methods: {
        generar_qr() {
            axios.get('miperfil/crear_qr').then(response => {
                this.qr = response.data;
            });
        },
        ComprobarQr() {
            axios.get('miperfil/ComprobarQr').then(response => {
                this.google =response.data.emp_googlecode;
            });
        },
        escaneado(){
            this.qr='';
            this.ComprobarQr();
        },
        obtenerEmpleado() {
            axios.get('miperfil/obtener').then(response => {
                this.dataForm.nombres = response.data.info.einfo_nombres;
                this.dataForm.apellidos = response.data.info.einfo_apellidos;
                this.dataForm.telefono = response.data.info.einfo_telefono_movil;
                this.dataForm.correo = response.data.info.einfo_email;
                this.dataForm.direccion_uno = response.data.info.einfo_direccion_1;
                this.dataForm.direccion_dos = response.data.info.einfo_direccion_2;
                this.dataForm.ciudad = response.data.info.einfo_ciudad;
                this.dataForm.estado = response.data.info.einfo_estado;
                this.dataForm.agente_de_venta = (response.data.info.einfo_agente_de_venta == 1) ? true : false;
                this.dataFormUser.nombre = response.data.user.emp_username;
                this.dataFormUser.password = '';
                this.dataFormUser.repassword = ''
                this.obrero = (response.data.user.emp_tipo == 'OBRERO') ? true : false;
                this.dataFormUser.autenticacion=(response.data.user.emp_gauth == 1) ? true : false;
                this.ruta_imagen = imgURL;
                if (response.data.info.einfo_imagen) {
                    this.ruta_imagen = imgURL + 'empleados/' + response.data.info.einfo_imagen;
                } else {
                    this.ruta_imagen = baseURL + 'public/assets/img/default.png';
                }
            }).catch(e => notificacion());
        },
        obtenerClienteAgente() {
            axios.get('miperfil/obtenerClienteAgente').then(response => {
                this.clientes = response.data;
            }).catch(e => notificacion()).finally(() => {
                $('#tabla_clientes').DataTable({
                    "order": [],
                });
            })
        },
        obtenerComisionesEmpAgentePagadas() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#table_comisiones_pagadas').DataTable().destroy();
            axios.get('miperfil/obtenerComisionesEmpAgentePagadas').then(response => {
                this.comisionesAgentepagadas = response.data;
            }).catch(e => notificacion()).finally(() => {
                $('#table_comisiones_pagadas').DataTable({
                    order: [],
                });
            });
        },
        obtenerComisionesEmpAgentePendiente() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#table_comisiones_pendientes').DataTable().destroy();
            axios.get('miperfil/obtenerComisionesEmpAgentePendiente').then(response => {
                this.comisionesAgentependientes = response.data;
            }).catch(e => notificacion()).finally(() => {
                $('#table_comisiones_pendientes').DataTable({
                    order: [],
                });
            });
        },
        editarInfo() {

            this.errorForm = [];

            if (!this.dataForm.nombres)
                this.errorForm.push('El campo Nombres es obligatorio.');
            if (!this.dataForm.apellidos)
                this.errorForm.push('El campo Apellidos es obligatorio.');
            if (!this.dataForm.telefono)
                this.errorForm.push('El campo Teléfono es obligatorio.');
            if (!this.dataForm.correo) {
                this.errorForm.push('El campo Correo Electrónico es obligatorio.');
            } else if (!validaEmail(this.dataForm.correo)) {
                this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
            }
            if (!this.dataForm.direccion_uno)
                this.errorForm.push('El campo Dirección es obligatorio.');
            if (!this.dataForm.ciudad)
                this.errorForm.push('El campo Ciudad es obligatorio.');
            if (!this.dataForm.estado)
                this.errorForm.push('El campo Estado es obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'miperfil/actualizar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-edit', '', 'Actualización exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', '', 'Error al actualizar', 'warning');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion());
            }
        },
        editarUsuario() {

            this.errorForm = [];

            if (!this.dataFormUser.nombre)
                this.errorForm.push('El campo Usuario es obligatorio.');
            if (!this.dataFormUser.password)
                this.errorForm.push('El campo Contraseña es obligatorio.');
            if (this.dataFormUser.password !== this.dataFormUser.repassword)
                this.errorForm.push('La contraseña no conincide.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'miperfil/editarUsuario',
                    data: this.dataFormUser,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-edit', '', 'Usuario actualizado correctamente', 'info');
                        } else {
                            notificacion('fa fa-ban', '', 'Error al actualizar usuario', 'warning');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion());
            }
        },
        handleFileUpload() {

            this.imagen = this.$refs.file.files[0];

            this.errorImage = [];

            if (!this.imagen)
                this.errorImage.push('La imagen es obligatoria.');

            if (this.errorImage.length == 0) {
                this.upload_imagen = 'is-loading is-loading-lg';
                axios({
                    method: 'post',
                    url: 'miperfil/imagenPerfil',
                    data: {
                        id_empleado: this.id_empleado,
                        imagen: this.imagen
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            location.reload();
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        this.errorImage = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => this.upload_imagen = '');
            }
        },
        modalClientsIntereses(cliente) {
            this.client = cliente;
            this.obtenerInteresesCli(cliente.cli_id);
            $('#modal_interes').modal('show');
        },
        guardarInteres() {
            let cliente = this.client.cli_id;
            let descripcion = document.getElementById('descripcioninte').value;
            axios({
                method: 'post',
                url: 'miperfil/guardarInteres',
                data: {
                    idcliente: cliente,
                    descripcion: descripcion
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerInteresesCli(this.client.cli_id);
                        notificacion('fa fa-check', 'Actualizado', 'Registro exitoso', 'success');
                        document.getElementById('descripcioninte').value='';
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());

        },
        modalClientsCaptado(cliente) {
            this.clients.id=cliente.empagent_clientid;
            this.clients.factura=cliente.empagent_docid;
            this.clients.tipo=cliente.empagent_tipo;
            $('#modal_captado').modal('show');
        },
        guardarcaptado() {
            let cliente = this.client.cli_id;
            let captadocli = document.getElementById('captado').value;
            axios({
                method: 'post',
                url: 'miperfil/guardarCaptado',
                data: {
                    idcliente: cliente,
                    captado: captadocli,
                    factura:this.clients.factura,
                    tipo:this.clients.tipo
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-check', 'Actualizado', 'Registro exitoso', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());

        },
       obtenerInteresesCli(id) {
            this.errorForm = [];
            let cliente = id;
            axios.get('miperfil/obtenerInteresesCli/' + cliente).then(response => {
                this.interesesclientes = response.data;
            }).catch(e => notificacion());
        },
        eliminarInteres(id){
            this.errorForm = [];
            Swal.fire({
                title: 'Eliminar intereses del cliente',
                text: "¿Estás seguro de querer eliminar este interes del " + this.client.cli_razon_social + " ?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/eliminarInteres/' + id).then(response => {
                        if (response.data == true) {
                            this.obtenerInteresesCli(this.client.cli_id);
                            notificacion('fa fa-check', 'Interes eliminado','' ,'success');
                        } else {
                            notificacion('fa fa-trash', 'Error al eliminar','' ,'danger');
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});