var fecha = new Date();

new Vue({
    el: '#appIngresosEgresos',
    data: {
        ingresosEgresos: [],
        metodos: [],
        cuentas: [],
        cargando: false,
        cargando_tabla: '',
        dataForm: { 'fecha_incio': '', 'fecha_fin': new Date().toISOString().substr(0, 10), 'select_io': 1, 'select_d': '', 'select_m': '', 'select_c': '' },
        errorForm: [],
    },
    methods: {
        resetearFormulario() {
            document.getElementById('form_busqueda').reset();
            this.dataForm.fecha_incio = '';
            this.dataForm.fecha_fin = new Date().toISOString().substr(0, 10);
            this.dataForm.select_io = 1;
            this.dataForm.select_d = '';
            this.dataForm.select_m = '';
            this.dataForm.select_c = '';
            this.errorForm = [];
        },
        obtenerMetodosSegunDivisa: function (event) {

            this.errorForm = [];
            this.select_m = '';
            this.select_c = [];
            this.metodos = [];
            this.cuentas = [];

            if (!event.target.value && this.errorForm.length == 0) {
                axios.get('ingresosegresos/obtenerMetodosSegunDivisa', {
                    params: {
                        id_divisa: event.target.value
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        if (Array.isArray(response.data)) {
                            if (response.data.length > 0) {
                                this.metodos = response.data;
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => {
                    notificacion()
                });
            }
        },
        obtenerCuentasSegunMetodo: function (event) {

            this.errorForm = [];
            this.select_c = [];
            this.cuentas = [];

            if (!event.target.value && this.errorForm.length == 0) {
                axios.get('ingresosegresos/obtenerCuentasSegunMetodo', {
                    params: {
                        id_metodo: event.target.value
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        if (Array.isArray(response.data)) {
                            if (response.data.length > 0) {
                                this.cuentas = response.data;
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => {
                    notificacion()
                });
            }
        },
        buscar: function () {

            this.errorForm = [];

            if (this.dataForm.fecha_incio)
                this.errorForm.push('El campo Fecha incio es obligatorio');
            if (!this.dataForm.select_io)
                this.errorForm.push('El campo Ingreso / Egreso es obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'ingresosegresos/buscar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {                    
                    if (response.data.errors == null) {
                        if (Array.isArray(response.data))
                            if (response.data.length > 0) {
                                this.ingresosEgresos = response.data;
                            }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => {
                    notificacion()
                });
            }
        }
    }
});