new Vue({
    el: '#appImpresoras',
    data: {
        titulo: '',
        accion: '',
        impresoras: [],
        series: [],
        dataForm: { id: '', codigo: '', descripcion: '', ip: '', puerto: '', tipo: '', serie: '',limite:'',quitardecimal:0,usdticket:0,footer:'' },
        errorForm: [],
        cargando: false,
    },
    created() {
        this.obtenerImpresoras();
        this.obtenerSeries();
    },
    methods: {
        obtenerImpresoras() {
            axios.get('impresoras/obtenerImpresoras').then(response => {
                this.impresoras = response.data;
                console.log(response.data)
            }).catch(e => notificacion());
        },
        obtenerSeries() {
            axios.get('series/obtenerSeries').then(response => {
                this.series = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_impresoras').reset();
            this.dataForm.id = '';
            this.dataForm.codigo = '';
            this.dataForm.descripcion = '';
            this.dataForm.ip = '';
            this.dataForm.puerto = '';
            this.dataForm.tipo = '';
            this.dataForm.limite='';
            this.dataForm.quitardecimal='';
            this.dataForm.usdticket='';
            this.dataForm.footer='';
            this.errorForm = [];
        },
        modalImpresora() {
            this.resetearFormulario();
            this.titulo = 'Guardar Impresora';
            this.accion = 'Guardar';
            $('#modal-impresora').modal('show');
            $('#modal-impresora').on('shown.bs.modal', function() {
                $('#impr-codigo').trigger('focus');
            });
        },
        ver(impresora) {
            this.resetearFormulario();
            this.dataForm.id = impresora.id;
            this.dataForm.codigo = impresora.codigo;
            this.dataForm.descripcion = impresora.descripcion;
            this.dataForm.ip = impresora.ip;
            this.dataForm.puerto = impresora.puerto;
            this.dataForm.tipo = impresora.tipo;
            this.dataForm.serie = impresora.serie_id;
            this.dataForm.quitardecimal=impresora.redondear;
            this.dataForm.limite=impresora.limite;
            this.dataForm.usdticket=impresora.usdticket;
            this.dataForm.footer=impresora.footer;
            console.log(this.dataForm.footer)
            this.titulo = 'Editar Impresora';
            this.accion = 'Actualizar';
            $('#modal-impresora').modal('show');
            $('#modal-impresora').on('shown.bs.modal', function() {
                $('#impr-codigo').trigger('blur');
            });
        },
        guardarEditar() {

            this.errorForm = [];

            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es obligatorio.');
            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');
            if (!this.dataForm.ip)
                this.errorForm.push('El campo Descripción es obligatorio.');
            if (!this.dataForm.puerto)
                this.errorForm.push('El campo Descripción es obligatorio.');
            if (!this.dataForm.serie)
                this.errorForm.push('El campo Serie es obligatorio.');
            if (!this.dataForm.tipo)
                this.errorForm.push('El campo Tipo es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'impresoras/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal-impresora').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Impresora actualizada correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Impresora registrada correctamente', 'success');
                            }
                            this.resetearFormulario();
                            this.obtenerImpresoras();
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en operacion', 'danger');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            }
        },
        cambiarEstatus(impresora) {
            axios.get('impresoras/cambiarEstatus/' + impresora.id).then(response => {
                if (response.data == true) {
                    impresora.estatus = !impresora.estatus;
                    notificacion('fa fa-info', '', 'Operacion exitosa', 'info');
                }
            }).catch(e => notificacion());
        },
        eliminar(impresora) {
            Swal.fire({
                title: '¡Eliminar impresora!',
                text: "¿Estás seguro de eliminar la impresora " + impresora.descripcion + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('impresoras/eliminar/' + impresora.id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                let posicion_lista = this.impresoras.findIndex(element => element.id == impresora.id);
                                this.impresoras.splice(posicion_lista, 1);
                                notificacion('fa fa-trash', 'Impresora eliminada', impresora.descripcion.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', impresora.descripcion.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
    },
});