var divisa = null;
var chartVentasSemanales = '';
var ventasSemanales = document.getElementById('ventasSemanales').getContext('2d');

function obtenerIngresosDiarios() {
    divisa = document.getElementById("divisas").value;
    chartVentasSemanales.destroy();
    _ingresosDiarios(divisa);
}

function _ingresosDiarios(divisa) {

    axios.get('index/obtenerIngresosDiarios/' + divisa).then(response => {

        let ingreso_dsm = response.data.dias_semana;

        let dsm_total = [0, 0, 0, 0, 0, 0, 0];

        Object.keys(ingreso_dsm).forEach(function(k) {
            for (let i = 0; i < 6; i++) {
                if (ingreso_dsm[k].n_dia_semana == i) {
                    dsm_total[i] = ingreso_dsm[k].venta
                }
            }
        });

        chartVentasSemanales = new Chart(ventasSemanales, {
            type: 'bar',
            data: {
                labels: ['Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb', 'Dom'],
                datasets: [{
                    label: "Ventas (Monto Total)",
                    data: dsm_total,
                    backgroundColor: '#54e374',
                    borderColor: '#28a745',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                title: {
                    display: true,
                    text: 'Ventas semanales por día'
                },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, chart) {
                            var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                            return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                        }
                    }
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function(value, index, values) {
                                return monedaMoneda(value, response.data.div_locale, response.data.div_simbolo);
                            }
                        }
                    }]
                }
            }
        });

    });
}

window.onload = _ingresosDiarios();

axios.get('index/obtenerArticulosDiarios').then(response => {

    let articulosSemanales = response.data.dias_semana;

    let articulosSemanalesTotal = [0, 0, 0, 0, 0, 0, 0];

    Object.keys(articulosSemanales).forEach(function(k) {
        for (let i = 0; i < 6; i++) {
            if (articulosSemanales[k].n_dia_semana == i) {
                articulosSemanalesTotal[i] = articulosSemanales[k].cantidad;
            }
        }
    });

    var divArticulosSemanales = document.getElementById('articulosSemanales').getContext('2d');

    new Chart(divArticulosSemanales, {
        type: 'bar',
        data: {
            labels: ['Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb', 'Dom'],
            datasets: [{
                label: 'Artículos (unidades)',
                data: articulosSemanalesTotal,
                backgroundColor: '#007bff',
                borderColor: '#177dff',
                borderWidth: 1
            }]
        },
        options: {
            title: {
                display: true,
                text: 'Cantidad de Artículos Vendidos por día de la semana'
            },
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });

});

$(function() {
    $('#tabla_ultimas_ventas').DataTable({
        order: [],
        info: false,
        "scrollY": "250px",
        "scrollCollapse": false,
        "paging": false,
        "aoColumnDefs": [{
                'bSortable': false,
                'aTargets': [5]
            },
            {
                'searchable': false,
                'targets': [5]
            }
        ]
    });
});

var divisa = null;
var chartVentasMensuales = '';
var ventasMensuales = document.getElementById('ventasMensuales').getContext('2d');

function obtenerVentasMensuales() {
    divisa = document.getElementById("mdivisas").value;
    chartVentasMensuales.destroy();
    _ventaMensual(divisa);
}

function _ventaMensual(divisa) {

    axios.get('index/obtenerVentasMensuales/' + divisa).then(response => {

        let venta_m = response.data.meses;

        let c_total = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        let v_total = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

        Object.keys(venta_m).forEach(function(k) {
            for (let i = 1; i <= 12; i++) {
                if (venta_m[k].mes == i) {
                    c_total[i - 1] = venta_m[k].costo
                    v_total[i - 1] = venta_m[k].venta
                }
            }
        });

        chartVentasMensuales = new Chart(ventasMensuales, {
            type: 'bar',
            data: {
                labels: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
                datasets: [{
                    label: "Costo",
                    data: c_total,
                    backgroundColor: '#f3545d',
                    borderColor: "#c82030",
                    borderWidth: 1
                }, {
                    label: "Venta",
                    data: v_total,
                    backgroundColor: '#54e374',
                    borderColor: '#28a745',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                title: {
                    display: true,
                    text: 'Total de Ventas Mensuales (monto)'
                },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, chart) {
                            var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                            return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                        }
                    }
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function(value, index, values) {
                                return monedaMoneda(value, response.data.div_locale, response.data.div_simbolo);
                            }
                        }
                    }]
                }
            }
        });

    });
}

window.onload = _ventaMensual();