new Vue({
    el: '#appGrupos',
    data: {
        titulo: '',
        accion: '',
        grupos: [],
        dataForm: { 'grup_id': '', 'grup_nombre': '', 'grup_descuento': 0, 'grup_descripcion': '', 'grup_codigo': '' },
        errorForm: []
    },
    created() {
        this.obtenerGrupos();
    },
    methods: {
        obtenerGrupos() {
            axios.get('grupos/obtenerGrupos').then(response => this.grupos = response.data).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_grupos').reset();
            this.dataForm.grup_id = '';
            this.dataForm.grup_nombre = '';
            this.dataForm.grup_descuento = 0;
            this.dataForm.grup_descripcion = '';
            this.dataForm.grup_codigo = '';
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar Grupos';
            this.accion = 'Guardar';
            $('#moda_grupos').modal('show');
            $('#moda_grupos').on('shown.bs.modal', function () {
                $('#grupcodigo').trigger('focus');
            });
        },
        ver(id, codigo, nombre, descripcion, descuento) {
            this.dataForm.grup_id = id;
            this.dataForm.grup_codigo = codigo;
            this.dataForm.grup_nombre = nombre;
            this.dataForm.grup_descripcion = descripcion;
            this.dataForm.grup_descuento = descuento;
            this.titulo = 'Editar Grupos';
            this.accion = 'Actualizar';
            $('#moda_grupos').modal('show');
        },
        pdf(id, grup_nombre){

        },
        guardar() {

            this.errorForm = [];

            if (!this.dataForm.grup_codigo)
                this.errorForm.push('El campo Codigo es obligatorio');
            if (!this.dataForm.grup_nombre)
                this.errorForm.push('El campo Nombre es obligatorio');
            if (!this.dataForm.grup_descripcion)
                this.errorForm.push('El campo Descripción es obligatorio');
            if (Number.isInteger(Number(this.dataForm.grup_descuento))) {
                if (Number.parseInt(this.dataForm.grup_descuento) > 100) {
                    this.errorForm.push('Superado el máximo es 100%');
                } else if (Number.parseInt(this.dataForm.grup_descuento) < 0) {
                    this.errorForm.push('El mínimo es 0%');
                }
            } else if (!Number.isInteger(Number(this.dataForm.grup_descuento))) {
                this.errorForm.push('El campo Descuento es obligatorio');
            }

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'grupos/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerGrupos();
                            this.resetearFormulario();
                            $('#moda_grupos').modal('hide');
                            if (this.dataForm.grup_id !== '') {
                                notificacion('fa fa-edit', 'Actualizado', 'Grupo actualizado correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Grupo registrado correctamente', 'success');
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        modificarEstatus(id, etiqueta) {
            axios.get('grupos/modificarEstatus', { params: { id: id } }).then(response => {
                if (response.data == true) {
                    let eti = document.getElementById(etiqueta);
                    eti.className = (eti.className === 'fa fa-times text-danger') ? 'fa fa-check text-success' : 'fa fa-times text-danger';
                    notificacion('fa fa-check', 'Actualizado', 'Estatus modificado', 'info');
                } else {
                    notificacion('fa fa-times', 'Advertencia', 'Error al procesar', 'warning');
                }
            }).catch(e => notificacion());
        },
        eliminar(id, grup_nombre) {
            Swal.fire({
                title: '¡Eliminar Grupo!',
                text: "¿Estás seguro de eliminar el grupo " + grup_nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('grupos/eliminar', { params: { id: id } }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerGrupos();
                                notificacion('fa fa-trash', 'Grupo eliminado', grup_nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-times', 'Error al eliminar', 'Error al procesar', 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
    }
});