new Vue({
  el: "#appComisiones",
  data: {
    titulo: "",
    accion: "",
    empleados: [],
    dataForm: {},
    errorForm: [],
    cargando: false,
    cargando_tabla: "is-loading is-loading-lg",
    comisionesId: [],
    comisiones: [],
    historial_comisiones: [],
    Idcomision: "",
    picked: "",
    money: {
      decimal: ".",
      thousands: ",",
      prefix: "",
      suffix: "",
      precision: 2,
      masked: false /* doesn't work with directive */,
    },
    seleccion: { selradio: "", id: 0 },
    seleccionError: [],
    dataEditar: { porcentaje: 0, monto: "", divisa: "", total: "" },
    activeItem: "",
    dataPagoComisiones: {
      id: 0,
      tipo: "",
      divisa_seleccionada: 0,
      metodo: "",
      cuenta: "",
      monto_pagar: 0,
      monto_divisa: "",
    },
    documento: "",
    fecha_desde: moment().format("YYYY-MM-DD"),
    fecha_hasta: moment().format("YYYY-MM-DD"),
    pendiente: 0,
    total: 0,
    pagado: 0,
    estatus: 2,
    agente: 0,
    tipo_comision: 0,
    errorFormGlobal: [],
    comisionesGlobal: [],
    comisionesIndv: [],
  },
  methods: {
    buscar() {
      this.cargando_tabla = "is-loading is-loading-lg";
      $("#tabla_historico_com").DataTable().destroy();
      let select_divisa = document.getElementById("vdivisas");
      let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];
      axios({
        method: "post",
        url: "empleados/obtenerComisionesId",
        data: {
          fecha_desde: this.fecha_desde,
          fecha_hasta: this.fecha_hasta,
          documento: this.documento,
          estatus: this.estatus,
          agente: this.agente,
          comision: this.tipo_comision,
          divisa: selectedOptionDiv.value,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            this.historial_comisiones = response.data.comisiones;
            this.pendiente = response.data.total_pendiente;
            this.pagado = response.data.total_pagado;
            this.total = response.data.total;
            document.getElementById(
              "descargarIndvComisionPendiente"
            ).href = 'descargarIndvComisionPendiente/?fd=${response.data.fecha_desde}&fh=${response.data.fecha_hasta}&d=${response.data.divisa}&c=${response.data.comision}&e=${response.data.estatus},&sd=${response.data.select_doc},&a=${response.data.agente}';
            document.getElementById("dataIndvFecha").innerHTML =
              moment(response.data.fecha_desde).format("DD-MM-YYYY") +
              " hasta " +
              moment(response.data.fecha_hasta).format("DD-MM-YYYY");
            this.comisionesGlobal = response.data.comisiones;
            document.getElementById("tipoComisionIndv").innerHTML = response.data.tipo_comision;
            document.getElementById("estatusComisionIndv").innerHTML = response.data.estatusText;
            
            document.getElementById("dataIndvCantidadTotal").innerHTML = response.data.total;
          } else {
            notificacion("fa fa-ban", "Advertencia", response.data.errors, "warning");
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          let buttonCommon = {
            exportOptions: {
              columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
              format: {
                body: function (data, row, column, node) {
                  if (column === 5 || column === 6 || column === 8) {
                    return convertir_a_float(data);
                  } else {
                    return data.replace(/<[^>]*>?/g, "");
                  }
                },
              },
            },
          };

          $("#tabla_historico_com").DataTable({
            retrieve: true,
            order: [],
            dom: "Bfrtip",
            buttons: [
              $.extend(true, {}, buttonCommon, {
                extend: "excelHtml5",
                title: `Comisiones desde ${this.fecha_desde} hasta ${this.fecha_hasta}`,
              }),
            ],
          });
        });
    },
    modalcomision() {
      this.obtenerComisiones();
      $("#modal_comision").modal("show");
    },
    obtenerComisiones() {
      axios
        .get("empleados/obtenerComisiones")
        .then((response) => {
          this.comisiones = response.data;
        })
        .catch((e) => notificacion());
    },
    resetearFormularioComisiones() {
      document.getElementById("form-comision-modal").reset();
      this.seleccion.selradio = "";
      document.getElementById("tipo_comision").selectedIndex = 0;
      document.getElementById("descripcion_comision").value = "";
      document.getElementById("porcentaje_comision").value = 1;
      this.seleccion.id = 0;
      this.seleccionError = [];
    },
    ver(comision) {
      this.seleccionError = [];

      let porcentaje = document.getElementById("porcentaje_comision");
      let descripcion = document.getElementById("descripcion_comision");
      let selectTipo = document.getElementById("tipo_comision");
      let selectFormula = document.getElementById("form_comision");
      selectFormula.value=comision.formula;

      if (comision.estatus == 2) {
        this.seleccion.selradio = 2;
        this.seleccion.id = comision.id;
        descripcion.value = comision.comision;
        porcentaje.value = 1;
        selectTipo.selectedIndex = comision.id_tipo_comision;
      } else {
        this.seleccion.selradio = 1;
        this.seleccion.id = comision.id;
        descripcion.value = comision.comision;
        porcentaje.value = comision.porcentaje;
        selectTipo.selectedIndex = comision.id_tipo_comision;
      }
    },
    editarGuardarComisiones() {
      this.seleccionError = [];

      let descripcion = document.getElementById("descripcion_comision");
      let porcentaje = document.getElementById("porcentaje_comision");
      let selectTipo = document.getElementById("tipo_comision");
      let selectFormula = document.getElementById("form_comision");

      if (this.seleccion.selradio == "") this.seleccionError.push("Debe seleccionar el tipo de comision.");
      if (selectFormula.value == "") this.seleccionError.push("Debe seleccionar una formula.");
      if (porcentaje.value == "" && this.seleccion.selradio == 1)
        this.seleccionError.push("El campo porcentaje es obligatorio.");
      if (descripcion.value == "") this.seleccionError.push("El campo descripcion es obligatorio.");

      if (!selectTipo.value) this.seleccionError.push("El campo Tipo es obligatorio.");

      if (this.seleccionError.length == 0) {
        if (this.seleccion.selradio == 1) {
          porcentaje = porcentaje.value;
        } else {
          porcentaje = 0;
        }

        axios({
          method: "post",
          url: "empleados/editarGuardarComisiones",
          data: {
            id: this.seleccion.id,
            descripcion: descripcion.value,
            porcentaje: porcentaje,
            tipo: this.seleccion.selradio,
            tipo_comision: selectTipo.value,
            formula:  selectFormula.value
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                this.obtenerComisiones();
                this.resetearFormularioComisiones();
                notificacion("fa fa-edit", "", "Operación realizada exitosamente", "info");
              } else {
                notificacion("fa fa-ban", "Advertencia", response.data.errors, "warning");
              }
            } else {
              notificacion("fa fa-ban", "Advertencia", response.data.errors, "warning");
            }
          })
          .catch((e) => notificacion());
      } else {
        let total_errores = this.seleccionError.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion("fa fa-ban", "Advertencia", this.seleccionError[i], "warning");
        }
      }
    },
    modalPendienteeditar(porcentaje, monto, total, divisa, id) {
      $("#modal_pendiente").modal("show");
      this.dataEditar.id = id;
      this.dataEditar.porcentaje = porcentaje;
      this.dataEditar.total = total;
      this.dataEditar.monto = convertir_a_float(String(monto)).toFixed(2);
      this.dataEditar.divisa = divisa;
    },
    editarpendiente() {
      axios({
        method: "post",
        url: "empleados/editarpendiente",
        data: {
          id: this.dataEditar.id,
          porcentaje: this.dataEditar.porcentaje,
          monto: this.dataEditar.monto,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              this.buscar();
              notificacion("fa fa-check", "Actualizacion", "Modificado exitosamente", "success");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    eliminarComision(row) {
      axios
        .get("empleados/eliminarComision/" + row.id)
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              let posision = this.comisiones.findIndex((item) => item.id == row.id);
              this.comisiones.splice(posision, 1);
              notificacion("fa fa-trash", "Comision eliminada", "", "danger");
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    eliminarComisionPendiente(id) {
      if (id > 0) {
        Swal.fire({
          title: "Eliminar Comision",
          text: "¿Estás seguro de querer eliminar esta comision pendiente ?",
          icon: "warning",
          showCancelButton: true,
          confirmButtonColor: "#3085d6",
          cancelButtonColor: "#aaa",
          confirmButtonText: "Eliminar",
        }).then((result) => {
          if (result.value) {
            axios
              .get("empleados/eliminarComisionPendiente/" + id)
              .then((response) => {
                if (response.data == true) {
                  this.obtenerComisionesId();
                  notificacion("fa fa-trash", "Comision eliminada", "", "danger");
                } else {
                  notificacion(
                    "fa fa-ban",
                    "Error al eliminar la dirección de envío",
                    this.dataTipoCom.nombrecom.toUpperCase(),
                    "danger"
                  );
                }
              })
              .catch((e) => notificacion());
          }
        });
      } else {
        notificacion("fa fa-ban", "Advertencia", "Error en la seleccion.", "warning");
      }
    },
    busquedaGlobal() {
      const formGlobal = document.getElementById("form_busqueda_global");
      const formData = new FormData(formGlobal);
      axios({
        method: "post",
        url: "empleados/busquedaGlobal",
        data: formData,
      })
        .then((response) => {
          if (response.data.errors == null) {
            document.getElementById(
              "descargarGlobComisionPendiente"
            ).href = `descargarComisionGlobalPendiente/?fd=${response.data.fecha_desde}&fh=${response.data.fecha_hasta}&d=${response.data.divisa}&c=${response.data.comision}&e=${response.data.estatus}`;
            document.getElementById("dataGlobFecha").innerHTML =
              moment(response.data.fecha_desde).format("DD-MM-YYYY") +
              " hasta " +
              moment(response.data.fecha_hasta).format("DD-MM-YYYY");
            this.comisionesGlobal = response.data.comisiones;
            document.getElementById("tipoComisionGlob").innerHTML = response.data.tipo_comision;
            document.getElementById("estatusComisionGlob").innerHTML = response.data.estatusText;
            document.getElementById("dataGlobCantidadTotal").innerHTML = response.data.total_pendiente;
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
  },
  computed: {
    porcentajemonto: function () {
      let total = parseFloat(this.dataEditar.total);
      let monto = convertir_a_float(String(this.dataEditar.monto)).toFixed(2);
      let Tcomision_ = (monto * 100) / total;
      Tcomision_ = Tcomision_ >= 0 ? Tcomision_ : 0;
      this.dataEditar.porcentaje = Tcomision_;
      return Tcomision_.toFixed(2);
    },
  },
});
