new Vue({
    el: '#appEjercicio',
    data: {
        titulo: '',
        accion: '',
        ejercicios: [],
        dataForm: { 'ej_id': '', 'ej_codigo': '', 'ej_nombre': '', 'ej_fechainicio': '', 'ej_fechafin': '', 'ej_estatus': '' },
        errorForm: {},
    },
    created() {
        this.obtenerEjercicios();
    },
    methods: {
        obtenerEjercicios() {
            axios.get('ejercicios/obtenerEjercicios').then(response => {
                if (Array.isArray(response.data)) {
                    this.ejercicios = response.data;
                }
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('form_modal').reset();
            this.dataForm.ej_id = '';
            this.dataForm.ej_codigo = '';
            this.dataForm.ej_nombre = '';
            this.dataForm.ej_fechainicio = '';
            this.dataForm.ej_fechafin = '';
            this.dataForm.ej_estatus = '';
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Agregar Ejercicio Fiscal';
            this.accion = 'Guardar';
            $('#modalEditarEjercicio').modal('show');
            $('#modalEditarEjercicio').on('shown.bs.modal', function() {
                $('#codigo_ejercicio_u').trigger('focus');
            });
        },
        ver(id, codigo, nombre, fechaini, fechafin, estatus) {
            this.dataForm.ej_id = id;
            this.dataForm.ej_codigo = codigo;
            this.dataForm.ej_nombre = nombre;
            this.dataForm.ej_fechainicio = fechaini;
            this.dataForm.ej_fechafin = fechafin;
            this.dataForm.ej_estatus = estatus;
            this.titulo = 'Editar Ejercicio Fiscal';
            this.accion = 'Actualizar';
            $('#modalEditarEjercicio').modal('show');
        },
        editarGuardar() {
            axios({
                method: 'post',
                url: 'ejercicios/guardar',
                data: this.dataForm,
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        $('#modalEditarEjercicio').modal('hide');
                        notificacion('fa fa-check', 'Actualizado', 'Sucursal actualizada correctamente', 'success');
                        this.obtenerEjercicios();
                        this.resetearFormulario();
                    } else {
                        notificacion('fa fa-ban', 'Error', 'Error en la operación', 'danger');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modificarEstatus(ej_id) {
            axios.get('ejercicios/modificarEstatus/' + ej_id).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerEjercicios();
                        notificacion('fa fa-check', 'Actualizado', 'Estatus modificado correctamente', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        eliminar(ej_id, ej_nombre) {
            Swal.fire({
                title: '¡Eliminar el ejercicio!',
                text: "¿Estás seguro de eliminar el ejercicio " + ej_nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.post('ejercicios/eliminar/' + ej_id).then(response => {
                        if (response.data == true) {
                            this.obtenerEjercicios();
                            notificacion('fa fa-trash', 'Ejercicio Eliminado', ej_nombre.toUpperCase(), 'danger');
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    },
});