new Vue({
    el: '#appDivisasMetodos',
    data: {
        titulo: '',
        accion: '',
        divisas: [],
        metodos: [],
        divmet: [],
        dataForm: { 'id': '', 'divisa': '', 'metodo': '' },
        errorForm: [],
    },
    created() {
        this.obtenerDivisasMetodos();
        this.dm();
    },
    methods: {
        dm() {
            axios.get('DivisasMetodos/obtenerDivisasMetodos').then(response => {
                this.divmet = response.data;
            }).catch(e => notificacion());
        },
        obtenerDivisasMetodos() {
            axios.get('divisas/obtenerDivisasActivas').then(response => this.divisas = response.data).catch(e => notificacion());
            axios.get('metodospago/obtenerMetodosPagoActivos').then(response => this.metodos = response.data).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_divisas_metodos').reset();
            this.dataForm.id = '';
            this.dataForm.divisa = '';
            this.dataForm.metodo = '';
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar Divisa / Método';
            this.accion = 'Guardar';
            $('#modal_divisa_metodo').modal('show');
            $('#modal_divisa_metodo').on('shown.bs.modal', function () {
                $('#dmdivisa').trigger('focus');
            });
        },
        editarGuardar: function (e) {

            this.errorForm = [];

            if (!this.dataForm.divisa)
                this.errorForm.push('El campo Divisa es obligatorio');
            if (!this.dataForm.metodo)
                this.errorForm.push('El campo Método es obligatorio');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'DivisasMetodos/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal_divisa_metodo').modal('hide');
                                notificacion('fa fa-edit', 'Actualización', 'Relación actualizada exitosamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registro', 'Relación creada exitosamente', 'success');
                            }
                            this.dm();
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminar(divisa_metodo) {
            Swal.fire({
                title: 'Eliminar Grupo',
                text: "¿Estás seguro de querer eliminar la relacion entre " + divisa_metodo.div_nombre + " y " + divisa_metodo.mp_nombre + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('DivisasMetodos/eliminar/' + Number(divisa_metodo.md_id)).then(response => {
                        if (response.data == true) {
                            let posicion = this.divmet.findIndex((item) => item.md_id == divisa_metodo.md_id);
                            this.divmet.splice(posicion, 1);
                            notificacion('fa fa-trash', 'Eliminado', 'Relación eliminada', 'danger');
                        } else {
                            notificacion('fa fa-times', 'Error al eliminar', 'Error al procesar', 'danger');
                        }
                    }).catch(e => notificacion())
                }
            });
        },
    },
});