new Vue({
    el: '#appDivisas',
    data: {
        titulo: '',
        accion: '',
        divisas: [],
        dataFormFactor: '',
        divisasDiferentes: [],
        dataForm: { 'id': '', 'nombre': '', 'descripcion': '', 'simbolo': '', 'decimal': 2, 'predeterminado': 0, 'partedecimal': ',' },
        errorForm: [],
        cargando: false,
        errorFormFactor: [],
    },
    created() {
        this.obtenerDivisas();
    },
    methods: {
        obtenerDivisas() {
            axios.get('divisas/obtenerDivisas').then(response => {
                this.divisas = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_divisa').reset();
            this.dataForm.id = '';
            this.dataForm.nombre = '';
            this.dataForm.descripcion = '';
            this.dataForm.simbolo = '';
            this.dataForm.decimal = 2;
            this.dataForm.predeterminado = '0';
            this.dataForm.partedecimal = ',';
            this.errorForm = [];
        },
        modalDivisa() {
            this.resetearFormulario();
            this.titulo = 'Guardar Divisas';
            this.accion = 'Guardar';
            $('#modalDivisa').modal('show');
            $('#modalDivisa').on('shown.bs.modal', function () {
                $('#nombre_divisa').trigger('focus');
            });
        },
        ver(divisa) {
            this.errorForm = [];
            this.dataForm.id = divisa.id;
            this.dataForm.nombre = divisa.nombre;
            this.dataForm.descripcion = divisa.descripcion;
            this.dataForm.simbolo = divisa.simbolo;
            this.dataForm.decimal = divisa.decimal;
            this.dataForm.partedecimal = divisa.partedecimal;
            this.titulo = 'Editar Divisas';
            this.accion = 'Actualizar';
            $('#modalDivisa').modal('show');
        },
        guardarEditar() {

            this.errorForm = [];

            if (!this.dataForm.nombre)
                this.errorForm.push('El campo Nombre es obligatorio');
            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio');
            if (!this.dataForm.simbolo)
                this.errorForm.push('El campo Símbolo es obligatorio');
            if (!Number.isInteger(Number(this.dataForm.decimal)))
                this.errorForm.push('El campo Decimales es obligatorio');
            if (!this.dataForm.partedecimal)
                this.errorForm.push('El campo Signo Decimal es obligatorio');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'divisas/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modalDivisa').modal('hide');
                                notificacion('fa fa-edit', 'Actualización', 'Divisa actualizada exitosamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registro', 'Divisa registrada exitosamente', 'success');
                            }
                            this.obtenerDivisas();
                            this.resetearFormulario();
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en operación', 'danger');
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        modalFactor(id, nombre, descripcion) {
            this.errorFormFactor = [];
            this.titulo = descripcion + ' al cambio';
            axios.get('divisas/obtenerDivisasDiferente/' + Number(id)).then(response => {
                this.dataFormFactor = id;
                this.divisasDiferentes = response.data;
                $('#modal_factor').modal('show');
            }).catch(e => notificacion());
        },
        guardarFactor() {            

            this.errorFormFactor = [];
            this.cargando = true;
            axios({
                method: 'post',
                url: 'divisas/guardarFactores',
                data: {
                    'id_divisa_master': this.dataFormFactor,
                    'divisas': JSON.stringify(this.divisasDiferentes)
                },
                transformRequest: serializar(),
            }).then(response => {
                console.log(response.data);
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-balance-scale', 'Actualizado', 'Factor actualizado correctamente', 'info');
                    } else {
                        notificacion('fa fa-balance-scale', 'Error', 'Error al actualizar factor', 'danger');
                    }
                } else {
                    this.errorFormFactor = response.data.errors;
                }
            }).catch(e => {
                notificacion()
            }).finally(() => this.cargando = false);
        },
        modificarEstatus(divisa) {
            axios('divisas/modificarEstatus/' + Number(divisa.id)).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        divisa.estatus = !divisa.estatus;
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        prederterminado(id) {
            axios.get('divisas/establecerPredeterminado/' + Number(id)).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-check', 'Información', 'Operación realizada exitosamente', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion()).finally(() => {
                this.obtenerDivisas();
            });
        },
        facturar(id) {
            axios.get('divisas/establecerPredeterminadoFactura/' + Number(id)).then(response => {
                console.log(response.data);
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-check', 'Información', 'Operación realizada exitosamente', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion()).finally(() => {
                this.obtenerDivisas();
            });
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Divisa',
                text: "¿Estás seguro de querer eliminar la divisa " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('divisas/eliminar/' + id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                let posicion = this.divisas.findIndex(item => item.id == id);
                                this.divisas.splice(posicion, 1);
                                notificacion('fa fa-trash', 'Divisa eliminada', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    },
});