new Vue({
    el: '#appCuentasMetodoDivisa',
    data: {
        titulo: '',
        accion: '',
        divisasMetodos: [],
        cuentasActivas: [],
        cmd: [],
        dataForm: { 'id': '', 'cuenta': '', 'divisa_metodo': '' },
        errorForm: [],
    },
    created() {
        this.cuentasmd();
        this.cuentasDivisasMetodos();
    },
    methods: {
        cuentasmd() {
            axios.get('cuentasmd/cmd').then(response => {
                this.cmd = response.data;
            }).catch(e => notificacion());
        },
        cuentasDivisasMetodos() {
            axios.get('DivisasMetodos/obtenerDivisasMetodos').then(response => this.divisasMetodos = response.data).catch(e => notificacion());
            axios.get('bancocuentas/cuentasActivas').then(response => this.cuentasActivas = response.data).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_cuenta_divisa_metodo').reset();
            this.dataForm.id = '';
            this.dataForm.cuenta = '';
            this.dataForm.divisa_metodo = '';
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar Cuenta / Divisa / Método';
            this.accion = 'Guardar';
            $('#modal_cuentas_divisa_metodo').modal('show');
            $('#modal_cuentas_divisa_metodo').on('shown.bs.modal', function () {
                $('#cdmcuenta').trigger('focus');
            });
        },
        ver(id, cuenta, divisa_metodo) {
            this.errorForm = [];
            this.dataForm.id = id;
            this.dataForm.cuenta = cuenta;
            this.dataForm.divisa_metodo = divisa_metodo;
            this.titulo = 'Editar Cuenta / Divisa / Método';
            this.accion = 'Actualizar';
            $('#modal_cuentas_divisa_metodo').modal('show');
        },
        editarGuardar() {

            this.errorForm = [];

            if (!this.dataForm.cuenta)
                this.errorForm.push('El campo Cuenta es obligatorio');
            if (!this.dataForm.divisa_metodo)
                this.errorForm.push('El campo Divisa/Método es obligatorio');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'cuentasmd/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal_cuentas_divisa_metodo').modal('hide');
                                notificacion('fa fa-edit', 'Actualización', 'Relación actualizada exitosamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registro', 'Relación creada exitosamente', 'success');
                            }
                            this.resetearFormulario();
                            this.cuentasmd();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminar(id, cuenta, metodo, divisa) {
            Swal.fire({
                title: 'Eliminar Grupo',
                text: "¿Estás seguro de querer eliminar la relación entre " + cuenta + " y " + metodo + " / " + divisa + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('cuentasmd/eliminar/' + id).then(response => {
                        if (response.data == true) {
                            this.cuentasmd();
                            notificacion('fa fa-trash', 'Eliminado', 'Relación eliminada', 'danger');
                        } else {
                            notificacion('fa fa-times', 'Error al eliminar', 'Error al procesar', 'danger');
                        }
                    }).catch(e => {
                        notificacion();
                    });
                }
            });
        },
    },
});