new Vue({
    el: '#appCorrelativos',
    data: {
        titulo: '',
        accion: '',
        series: [],
        documentos: [],
        correlativos_array: [],
        dataForm: { 'id': '', 'serie': '', 'documento': '', 'correlativo': 0 },
        errorForm: [],
    },
    created() {
        this.correlativos();
        this.seriesDocumentos();
    },
    methods: {
        correlativos() {
            axios.get('correlativos/correlativos').then(response => {
                if (Array.isArray(response.data)) {
                    this.correlativos_array = response.data;
                }
            }).catch(e => notificacion());
        },
        seriesDocumentos() {
            axios.get('series/obtenerSeries').then(response => this.series = response.data).catch(e => notificacion());
            axios.get('documentos/documentosActivos').then(response => this.documentos = response.data).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_correlativos').reset();
            this.dataForm.id = '';
            this.dataForm.serie = '';
            this.dataForm.documento = '';
            this.dataForm.correlativo = 0;
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Agregar Correlativo';
            this.accion = 'Guardar';
            $('#modal_correlativos').modal('show');
            $('#modal_correlativos').on('shown.bs.modal', function() {
                $('#coserie').trigger('focus');
            });
        },
        ver(id, serie, documento, correlativo) {
            this.errorForm = [];
            this.dataForm.id = id;
            this.dataForm.serie = serie;
            this.dataForm.documento = documento;
            this.dataForm.correlativo = correlativo;
            this.titulo = 'Editar Correlativo';
            this.accion = 'Actualizar';
            $('#modal_correlativos').modal('show');
            $('#modal_correlativos').on('shown.bs.modal', function() {
                $('#coserie').trigger('blur');
            });
        },
        editarGuardar: function(e) {

            this.errorForm = [];

            if (!this.dataForm.serie)
                this.errorForm.push('El campo Serie es obligatorio');
            if (!this.dataForm.documento)
                this.errorForm.push('El campo Documento es obligatorio');
            if (!Number.isInteger(Number(this.dataForm.correlativo))) {
                this.errorForm.push('El campo Correlativo es obligatorio');
            }

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'correlativos/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            $('#modal_correlativos').modal('hide');
                            if (this.dataForm.id !== '') {
                                notificacion('fa fa-edit', 'Actualización', 'Correlativo actualizado exitosamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registro', 'Correlativo creado exitosamente', 'success');
                            }
                            this.correlativos();
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminar(id, serie, documento) {
            Swal.fire({
                title: 'Eliminar Correlativo',
                text: "¿Estás seguro de eliminar el correlativo " + serie + " y " + documento + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('correlativos/eliminar/' + id).then(response => {
                        if (response.data) {
                            if (response.data == true) {
                                this.correlativos();
                                notificacion('fa fa-trash', 'Eliminado', 'Correlativo eliminado', 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', 'Error', 'danger');
                            }
                        } else {
                            notificacion('fa fa-times', 'Error al eliminar', 'Error al procesar', 'danger');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
    },
});