var currentFocus;

new Vue({
    el: '#appCMPPedidosVer',
    data: {
        id_factura: document.getElementById('id_fac').value,
        proveedor: document.getElementById('id_proveedor_fac').value,
        simbolo_master: '',
        div_nombre_master: '',
        div_locale: '',
        div_simbolo: '',
        div_decimal: 2,
        div_conv_factor: 1,
        factura: [],
        divisa_pagar: '',
        metodo_pagar: '',
        cuenta_pagar: '',
        abonos: [],
        cuentas: [],
        metodos_de_pagos: [],
        formDocumentos: { 'id_factura': '', 'descripcion': '', 'documento': '' },
        documentos: [],
        monto: 0,
        restante_original: 0,
        articulosTotal: 0,
        total_pagado: 0,
        descuento: 0,
        restante: 0,
        subtotal: 0,
        total: 0,
        neto: 0,
        iva: 0,
        divisa_predeterminada: '',
        almacen_predeterminado: '',
        serie_predeterminada: '',
        productos: [],
        carrito: [],
        money: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        moneyPagar: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        cargando: false,
        errorForm: [],
        observaciones: '',
        observacion_anular: '',
        loader_correo: false,
        cargando_documento: false,
        afectar_stock: false,
        afectar_precio: false,
        saldo: 0,
        toggleBarcode: false,
        cant_a_descontar:0,
        cantidad_invent:0,
        referencia:''
    },
    created() {
        axios.get('cmppedidoseditar/obtenerFactura/' + this.id_factura).then(response => {
            this.factura = response.data.factura;
            this.almacen_predeterminado = this.factura.id_almacen;
            this.serie_predeterminada = this.factura.id_serie
            this.divisa_predeterminada = this.factura.id_divisa
            this.div_nombre_master = response.data.div_nombre;
            this.div_locale = response.data.div_locale;
            this.div_simbolo = response.data.div_simbolo;
            this.div_decimal = response.data.div_decimal;
            this.observaciones = this.factura.observaciones ?? '';

            this.moneyPagar.locale = this.money.locale = response.data.divisa.locale;
            this.moneyPagar.prefix = this.money.prefix = response.data.divisa.symbol + ' ';
            this.moneyPagar.decimal = this.money.decimal = response.data.divisa.decimal;
            this.moneyPagar.thousands = this.money.thousands = response.data.divisa.thousands;
            this.moneyPagar.precision = this.money.precision = response.data.divisa.precision;

            this.articulosTotal = response.data.articulos_cantidad;
            this.subtotal = Number(response.data.subtotal).toFixed(this.money.precision);
            this.descuento = Number(response.data.descuento).toFixed(this.money.precision);
            this.neto = Number(response.data.neto).toFixed(this.money.precision);
            this.iva = Number(response.data.iva).toFixed(this.money.precision);
            this.total = Number(response.data.total).toFixed(this.money.precision)
            this.monto = 0.00;//parseFloat(response.data.restante).toFixed(this.money.precision);
            this.restante_original = Number(response.data.restante).toFixed(this.money.precision);
            this.restante = Number(response.data.restante).toFixed(this.money.precision);
            this.carrito = response.data.data_carrito;
            this.abonos = response.data.abonos;
            this.total_pagado = Number(response.data.total_pagado).toFixed(this.money.precision);
        });

        axios.get('cmppedidoseditar/obtenerArticuloProducto/' + this.id_factura).then(response => {
            this.cant_a_descontar = response.data.inventario;
            this.cantidad_invent=response.data.cantidad;
        });
        this.obtenerDocumentos();
    },
    methods: {
       actualizarDetalles() {

            this.errorForm = [];

            let dataFormClienteDetalle = {
                'id': this.proveedor,
                'prov_tipoidfiscal': document.getElementById('prov_tipoidfiscal').value,
                'prov_cifnif': document.getElementById('prov_cifnif').value,
                'prov_razonsocial': document.getElementById('prov_razonsocial').value,
                'prov_email': '',
                'prov_telefono1': '',
                'prov_telefono2': '',
                'prov_direccion': document.getElementById('prov_direccion').value,
                'prov_paisid': document.getElementById('prov_paisid').value,
                'prov_estado': document.getElementById('prov_estado').value,
                'prov_ciudad': document.getElementById('prov_ciudad').value,
                'prov_codigo_postal': document.getElementById('prov_codigo_postal').value,
            };

            if (!dataFormClienteDetalle.prov_tipoidfiscal)
                this.errorForm.push('El campo Tipo de Documento es obligatorio');
            if (!dataFormClienteDetalle.prov_cifnif)
                this.errorForm.push('El campo Número de Documento es obligatorio.');
            if (!dataFormClienteDetalle.prov_direccion)
                this.errorForm.push('El campo Dirección es obligatorio');
            if (!dataFormClienteDetalle.prov_razonsocial)
                this.errorForm.push('El campo Razón Social es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/guardarDetallesCliente',
                    data: dataFormClienteDetalle,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            document.getElementById('cabecera_cliente').innerHTML = dataFormClienteDetalle.prov_razonsocial + ' ' + dataFormClienteDetalle.prov_cifnif;
                            notificacion('fa fa-edit', '', 'Actualización Exitosa', 'info');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        actualizarEnvio() {

            this.errorForm = [];

            let dataFormClienteEnvio = {
                'id_factura': this.id_factura,
                'env_nombre_opcional': document.getElementById('env_nombre_opcional').value,
                'env_agencia_transporte': document.getElementById('env_agencia_transporte').value,
                'env_codigo_seguimiento': document.getElementById('env_codigo_seguimiento').value,
                'env_direccion': document.getElementById('env_direccion').value,
                'env_pais': document.getElementById('env_pais').value,
                'env_estado': document.getElementById('env_estado').value,
                'env_ciudad': document.getElementById('env_ciudad').value,
                'env_codigopostal': document.getElementById('env_codigopostal').value,
                'env_asegurado': document.getElementById('env_asegurado').checked ? true : false
            };

            if (!dataFormClienteEnvio.env_codigo_seguimiento)
                this.errorForm.push('El campo Código de Seguimiento es obligatorio.');
            if (!dataFormClienteEnvio.env_direccion)
                this.errorForm.push('El campo Dirección obligatorio.');
            if (!dataFormClienteEnvio.env_pais)
                this.errorForm.push('El campo País es obligatorio.');
            if (!dataFormClienteEnvio.env_estado)
                this.errorForm.push('El campo Estado es obligatorio.');
            if (!dataFormClienteEnvio.env_ciudad)
                this.errorForm.push('El campo Ciudad es obligatorio.');
            if (!dataFormClienteEnvio.env_codigopostal)
                this.errorForm.push('El campo Código Postal es obligatorio.');

            if (this.id_factura && this.proveedor && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/guardarEnvioCliente',
                    data: dataFormClienteEnvio,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            if (document.getElementById('env_asegurado').checked == true) {
                                notificacion('fa fa-check', '', 'Envío asegurado', 'success');
                            } else {
                                notificacion('fa fa-info', '', 'Envío No asegurado', 'info');
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        predeterminarDivisa(event) {
            axios.get('cmppedidoseditar/predeterminarDivisa', {
                params: {
                    id_divisa: event.target.value,
                    id_factura: this.id_factura,
                    descuento: this.descuento
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.divisa_predeterminada = event.target.value;
                    if (response.data.data_carrito) {
                        this.money.locale = response.data.divisa.locale;
                        this.money.prefix = response.data.divisa.symbol + ' ';
                        this.money.decimal = response.data.divisa.decimal;
                        this.money.thousands = response.data.divisa.thousands;
                        this.money.precision = response.data.divisa.precision;
                        this.articulosTotal = response.data.data_carrito.articulos_cantidad;
                        this.subtotal = response.data.data_carrito.subtotal;
                        this.descuento = response.data.data_carrito.descuento;
                        this.neto = response.data.data_carrito.neto;
                        this.iva = response.data.data_carrito.iva;
                        this.total = response.data.data_carrito.total;
                        this.restante = response.data.data_carrito.total;
                        this.carrito = response.data.data_carrito.carrito;
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        actualizarPrecio(unique, event) {
            let precio = convertir_a_float(event.target.value);
            if (event.target.value && precio > 0 && unique && this.id_factura) {
                this.atc_pre(event.target.value, unique, this)
            }
        },
        atc_pre: _.debounce((value, unique, vm) => {
            axios({
                method: 'post',
                url: 'cmppedidoseditar/actualizarPrecio',
                data: {
                    'id_cliente': vm.cliente,
                    'unique': unique,
                    'precio': value,
                    'descuento_global': vm.descuento,
                    'id_factura': vm.id_factura
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    vm.articulosTotal = response.data.articulos_cantidad;
                    vm.subtotal = response.data.subtotal;
                    vm.descuento = response.data.descuento;
                    vm.neto = response.data.neto;
                    vm.iva = response.data.iva;
                    vm.total = response.data.total;
                    vm.restante = response.data.total;
                    Object.keys(response.data.carrito).forEach((key, i) => {
                        vm.carrito[key].neto = response.data.carrito[key].neto;
                        vm.carrito[key].total = response.data.carrito[key].total;
                    });
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        }, 300),
        actualizarCantidad(unique, event) {
            let cantidad = convertir_a_float(event.target.value);
            if (event.target.value && cantidad > 0) {
                this.debounce_actualizarCantidad(event.target.value, unique, this);
            }
        },
        debounce_actualizarCantidad: _.debounce((value, unique, vm) => {
            axios({
                method: 'post',
                url: 'cmppedidoseditar/actualizarCantidad',
                data: {
                    id_producto: unique,
                    cantidad: value,
                    descuento_global: vm.descuento,
                    id_factura: vm.id_factura
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    vm.articulosTotal = response.data.articulos_cantidad;
                    vm.subtotal = response.data.subtotal;
                    vm.descuento = response.data.descuento;
                    vm.neto = response.data.neto;
                    vm.iva = response.data.iva;
                    vm.total = response.data.total;
                    vm.restante = response.data.total;
                    vm.carrito = response.data.carrito;
                    Object.keys(response.data.carrito).forEach((key, i) => {
                        vm.carrito[key].neto = response.data.carrito[key].neto;
                        vm.carrito[key].total = response.data.carrito[key].total;
                    });
                } else {
                    if (response.data.cantidad > 0) {
                        value = response.data.cantidad;
                    }
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        }, 300),
        aplicarNuevoIva(unique, id_iva) {
            if (unique && id_iva && this.id_factura) {
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/aplicarNuevoIva',
                    data: {
                        'unique': unique,
                        'id_iva': id_iva,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        aplicarDescuentoProducto(unique, event) {
            let descuento_ = convertir_a_float(event.target.value);
            if (unique && this.id_factura) {
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/aplicarDescuentoProducto',
                    data: {
                        'unique': unique,
                        'descuento': descuento_,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        Object.keys(response.data.carrito).forEach((key, i) => {
                            this.carrito[key].neto = response.data.carrito[key].neto;
                            this.carrito[key].total = response.data.carrito[key].total;
                        });
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        aplicarDescuentoAdicional() {
            if (!isNaN(this.descuento) && this.descuento >= 0) {
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/aplicarDescuentoAdicional',
                    data: {
                        'descuento': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminarProducto(unique) {
            if (this.proveedor && unique) {
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/eliminarProducto',
                    data: {
                        'id_producto': unique,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        actualizarDescripcion(unique, event) {

            this.errorForm = [];

            if (!event.target.value)
                this.errorForm.push('La descripción no debe quedar vacia.');

            if (this.proveedor && this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/actualizarDescripcion',
                    data: {
                        'unique': unique,
                        'descripcion': event.target.value,
                        'descuento_global': this.descuento,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors) {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        guardarFactura() {

            this.errorForm = [];

            if (this.carrito.length == 0)
                this.errorForm.push('No ha seleccinado algún producto para la compra');
            if (!this.serie_predeterminada)
                this.errorForm.push('Debe seleccionar una serie');
            if (!document.getElementById('fecha').value)
                this.errorForm.push('Debe seleccionar una fecha');

            if (this.id_factura && this.proveedor && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/ventaEnEsperaEditar',
                    data: {
                        'id_serie': this.serie_predeterminada,
                        'id_factura': this.id_factura,
                        'descontar_inventario': false,
                        'fecha': document.getElementById('fecha').value,
                        'observaciones': this.observaciones
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        location.href = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        afecatarInventario() {

            Swal.mixin({
                input: 'checkbox',
                confirmButtonText: 'Siguiente &rarr;',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                progressSteps: ['1', '2']
            }).queue([{
                title: 'Afectar stock',
                text: 'SI/NO'
            },
            {
                title: 'Afectar precio',
                text: 'SI/NO'
            },
            ]).then((result) => {

                if (result.value) {

                    this.afectar_stock = (result.value[0]) ? true : false;
                    this.afectar_precio = (result.value[1]) ? true : false;

                    result.value.forEach((element, index, array) => {
                        if (element == 1) {
                            result.value[index] = 'SI';
                        } else {
                            result.value[index] = 'NO';
                        }
                    });

                    const answers = JSON.stringify(result.value)
                    Swal.fire({
                        title: '¡Todo listo!',
                        html: `
                          Tus respuestas:
                          <pre><code>${answers}</code></pre>
                        `,
                        showCloseButton: true,
                        showCancelButton: true,
                        focusConfirm: true,
                        confirmButtonText: 'Continuar',
                        confirmButtonAriaLabel: 'Continuar',
                        cancelButtonText: 'Cancelar',
                        cancelButtonAriaLabel: 'Cancelar',
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#aaa'
                    }).then((result) => {

                        if (result.value) {

                            this.errorForm = [];

                            if (this.carrito.length == 0)
                                this.errorForm.push('No ha seleccinado algun producto para la compra');
                            if (!this.serie_predeterminada)
                                this.errorForm.push('Debe seleccionar una serie');
                            if (!document.getElementById('fecha').value)
                                this.errorForm.push('Debe seleccionar una fecha');

                            if (this.proveedor && this.errorForm.length == 0) {
                                if(this.cant_a_descontar!=this.cantidad_invent){
                                    this.cargando = true;
                                    axios({
                                        method: 'post',
                                        url: 'cmppedidoseditar/ventaEnEsperaEditar',
                                        data: {
                                            id_factura: this.id_factura,
                                            'id_serie': this.serie_predeterminada,
                                            'fecha': document.getElementById('fecha').value,
                                            'observaciones': this.observaciones,
                                            afectar_stock: this.afectar_stock,
                                            afectar_precio: this.afectar_precio
                                        },
                                        transformRequest: serializar(),
                                    }).then(response => {
                                        if (response.data.errors == null) {
                                            location.href = response.data;
                                        } else {
                                            let total_errores = response.data.errors.length
                                            for (let i = 0; i < total_errores; i++) {
                                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                                            }
                                        }
                                    }).catch(e => notificacion()).finally(() => this.cargando = false);
                                }else{
                                    notificacion('fa fa-ban', 'Advertencia','Ya fue afectado el inventario', 'warning');
                                }
                               
                            } else {
                                let total_errores = this.errorForm.length
                                for (let i = 0; i < total_errores; i++) {
                                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                                }
                            }
                        }
                    });
                }
            });
        },
        obtenerMetodosSegunDivisa(event) {
            this.saldo = 0;
            this.errorForm = [];
            this.metodo_pagar = '';
            this.metodos_de_pagos = [];
            this.cuenta_pagar = '';
            this.cuentas = [];

            if (!event.target.value)
                this.errorForm.push('La divisa es requerida');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/obtenerMetodosSegunDivisa',
                    data: { 'id_factura': this.id_factura, 'id_divisa': event.target.value },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.monto = 0.00;
                            this.metodos_de_pagos = response.data.data_metodos;
                            this.div_conv_factor = response.data.factor
                            this.moneyPagar.locale = response.data.divisa.locale;
                            this.moneyPagar.prefix = response.data.divisa.symbol + ' ';
                            this.moneyPagar.decimal = response.data.divisa.decimal;
                            this.moneyPagar.thousands = response.data.divisa.thousands;
                            this.moneyPagar.precision = response.data.divisa.precision;
                            this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                            this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.moneyPagar.precision);
                            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                            //this.monto = this.restante;
                        }
                    } else {
                        this.divisa_pagar = '';
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        obtenerCuentasSegunMetodo(event) {
            this.saldo = 0;
            this.errorForm = [];
            this.cuenta_pagar = '';
            this.cuentas = [];

            if (!event.target.value)
                this.errorForm.push('EL Método de Pago es requerido');

            if (this.errorForm.length == 0) {
                axios.get('cmppedidoseditar/obtenerCuentasSegunMetodo/' + event.target.value).then(response => {
                    if (response.data.errors == null) {
                        if (Array.isArray(response.data)) {
                            if (response.data.length > 0) {
                                this.cuentas = response.data;
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        obtenerSaldoSegunCuenta(event) {

            this.errorForm = [];

            if (!event.target.value)
                this.errorForm.push('El campo Cuenta es obligatorio.');

            if (this.errorForm.length == 0) {
                axios.get('cmppedidoseditar/obtenerSaldoSegunCuenta', {
                    params: {
                        id_cuenta: event.target.value
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.saldo = response.data.saldo;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        pagar() {

            this.errorForm = [];

            if (!this.divisa_pagar)
                this.errorForm.push('El campo Divisa es obligatorio');
            if (!this.metodo_pagar)
                this.errorForm.push('El campo Método es obligatorio');
            if (!this.cuenta_pagar)
                this.errorForm.push('El campo Cuenta es obligatorio');
            if (!this.monto)
                this.errorForm.push('El campo Monto es obligatorio');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/pagar',
                    data: {
                        id_factura: this.id_factura,
                        id_divisa: this.divisa_pagar,
                        id_metodo_divisa: this.metodo_pagar,
                        id_cuenta_metodo: this.cuenta_pagar,
                        monto: this.monto,
                        referencia:this.referencia,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.monto = 0.00;
                            this.abonos = response.data.abonos;
                            this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                            this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.moneyPagar.precision);
                            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                            this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                            //this.monto = this.restante;
                            if (response.data.pagado) {
                                $('#modal_pagar').modal('hide');
                                notificacion('fa fa-check', 'Advertencia', 'Total de pedido en compras pagado', 'success');
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => {
                    notificacion();
                }).finally(() => {
                    this.cargando = false;
                    this.saldo = 0;
                    this.monto = 0;
                    this.divisa_pagar = ''
                    this.metodo_pagar = '';
                    this.cuenta_pagar = '';
                });
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        eliminarPago(id) {
            axios({
                method: 'post',
                url: 'cmppedidoseditar/eliminarPago',
                data: { 'id_factura': this.id_factura, 'id': id },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data) {
                        this.monto = 0.00;
                        this.abonos = response.data.abonos;
                        this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                        this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.moneyPagar.precision);
                        this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                        this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                        //this.monto = this.restante;
                        notificacion('fa fa-trash', 'Eliminado', 'Pago eliminado', 'danger');
                    }
                } else {
                    this.divisa_pagar = '';
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modalCorreo() {
            $('#modal_correo').modal('show');
            $('#modal_correo').on('shown.bs.modal', function () {
                //$('#nombre_divisa').trigger('focus');
            });
        },
        modalImprimir() {
            $('#modal-imprimir').modal('show');
            $('#modal-imprimir').on('shown.bs.modal', function () {
                //$('#nombre_divisa').trigger('focus');
            });
        },
        enviarFactura() {

            this.errorForm = [];

            let de = document.getElementById('cor_emailde').value;
            let para = document.getElementById('cor_emailpara').value;
            let copia = document.getElementById('cor_emailcopia').value;
            let firma = document.getElementById('cor_emailfirma').value;

            if (!de)
                this.errorForm.push('El campo De obligatorio.');
            if (!para)
                this.errorForm.push('El campo De obligatorio.');

            if (de && para) {
                if (!validaEmail(de))
                    this.errorForm.push('El Correo Electrónico ' + de + ' no es válido.');
                if (!validaEmail(para))
                    this.errorForm.push('El Correo Electrónico ' + para + ' no es válido.');
            }

            if (this.errorForm.length == 0) {

                this.loader_correo = true;

                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/eniviarFactura',
                    data: {
                        id_factura: this.id_factura,
                        de: de,
                        para: para,
                        copia: copia,
                        firma: firma
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.loader_correo = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        handleFileUpload() {
            this.formDocumentos.documento = this.$refs.file.files[0];
        },
        enviarDocumento() {

            this.errorForm = [];

            this.formDocumentos.id_factura = this.id_factura;

            if (!this.formDocumentos.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');

            if (!this.formDocumentos.documento)
                this.errorForm.push('El Documento obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando_documento = true;
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/enviarDocumento',
                    data: this.formDocumentos,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.obtenerDocumentos();
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando_documento = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        obtenerDocumentos() {
            axios.get('cmppedidoseditar/obtnerDocumentos/' + this.id_factura).then(response => {
                this.documentos = response.data;
            });
        },
        modalConvertirDocumento() {
            $('#modal_convertir').modal({ show: true, backdrop: 'static', keyboard: false });
        },
        buscarProducto(event) {
            this.search(event.target.value, event, this);
        },
        search: _.debounce((search, event, vm) => {

            if (vm.toggleBarcode == false) {

                currentFocus = 0;
                let a, b;
                var x = document.getElementsByClassName("autocomplete-items");

                for (var i = 0; i < x.length; i++) {
                    x[i].parentNode.removeChild(x[i]);
                }

                if (!search) {
                    return false;
                }

                axios.get('cmpnotas/buscarProducto', {
                    params: {
                        'divisa': vm.divisa_predeterminada,
                        'almacen': vm.almacen_predeterminado,
                        'buscar': search.trim(),
                    }
                }).then(response => {
                    vm.productos = response.data;
                }).catch(e => {
                    notificacion();
                }).finally(() => {

                    currentFocus = -1;

                    a = document.createElement("div");
                    a.id = event.target.id + 'autocomplete-list';
                    a.classList.add('autocomplete-items');
                    event.target.parentNode.appendChild(a);

                    let self = vm;

                    vm.productos.forEach((item) => {

                        b = document.createElement("div");

                        if (item.imagen) {
                            b.innerHTML += "<img src='" + item.imagen + "' class='avatar-img rounded-circle' style='width: 50px; height: 50px; margin-right: 15px'>";
                        }

                        if (item.pro_descripcion.substr(0, search.length).toUpperCase() == search.toUpperCase()) {
                            b.innerHTML += "<strong>" + item.pro_descripcion.substr(0, search.length) + "</strong>";
                            b.innerHTML += "<span>" + item.pro_descripcion.substr(search.length) + "</span>";
                        } else {
                            b.innerHTML += "<strong>" + item.pro_descripcion + "</strong>";
                        }

                        b.innerHTML += "<small class='text-primary' style='margin-right: 5px'> stock: " + item.ps_cantidad + "</small> <br>";
                        b.innerHTML += "<small class='text-primary' style='margin-right: 10px'> fabricante: " + item.fabricante + "</small>";
                        b.innerHTML += "<input type='hidden' value='" + item.pro_id + "' data-almacen='" + item.id_almacen + "' data-name='" + item.pro_descripcion + "'>";

                        b.addEventListener("click", function (e) {

                            event.target.value = this.getElementsByTagName("input")[0].getAttribute('data-name');
                            let id_producto = this.getElementsByTagName("input")[0].value;
                            let id_almacen = this.getElementsByTagName("input")[0].getAttribute('data-almacen');

                            self.agregarProducto(id_producto, id_almacen);

                            for (var i = 0; i < x.length; i++) {
                                x[i].parentNode.removeChild(x[i]);
                            }
                        });

                        a.appendChild(b);
                    });
                });
            }
        }, 500),
        agregarProducto(id_producto, id_almacen) {
            if (this.divisa_predeterminada && id_producto && id_almacen && this.proveedor) {
                axios({
                    method: 'post',
                    url: 'cmppedidoseditar/agregarProducto',
                    data: {
                        'id_factura': this.id_factura,
                        'id_producto': id_producto,
                        'id_almacen': id_almacen,
                        'id_divisa': this.divisa_predeterminada,
                        'descuento_global': this.descuento,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    document.getElementById('buscador').value = '';
                });
            }
        },
        seleccionarProducto(event) {

            var x = document.getElementById(event.target.id + 'autocomplete-list');

            if (x) x = x.getElementsByTagName("div");

            if (event.key == 'ArrowDown') {
                currentFocus++;
                active(x);
            } else if (event.key == 'ArrowUp') {
                currentFocus--;
                active(x);
            } else if (event.key == 'Enter') {

                event.preventDefault();

                if (this.toggleBarcode == true) {
                    this.agregarProductoBarcode(event.target.value);
                    document.getElementById('buscador').value = '';
                } else {
                    if (currentFocus > -1) {
                        if (x) x[currentFocus].click();
                    }
                }

            }
        },
        modalAnular() {
            $('#modal_anular').modal();
            $('#modal_anular').on('shown.bs.modal', function () {
                $('#observacion_anular').trigger('focus')
            });
        },
        anular() {

            Swal.fire({
                title: '<strong>¿Anular pedido en compras?</strong>',
                showCloseButton: true,
                showCancelButton: true,
                focusConfirm: false,
                cancelButtonColor: '#aaa',
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Aceptar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('cmppedidoseditar/anularFactura', {
                        params: {
                            id_factura: this.id_factura,
                            descripcion: this.observacion_anular
                        }
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data !== false) {
                                location.href = response.data;
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Error al anular la pedido', 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion()).finally(() => this.cargando = false);
                }
            });
        },
        moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
            }
        },
        decimal(num, div_locale_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaDecimal(monto_, div_locale_, decimal_);
            }
        },
        finalizarNota(estatus) {

            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Finalizado';
            } else if (estatus == 2) {
                estatus_nombre = 'Pendiente';
            } else if (estatus == 3) {
                estatus_nombre = 'Anulado';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro que deseas cambiar el estatus de la pedido a " + estatus_nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('compras/finalizarNota', {
                        params: {
                            id: this.id_factura,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            location.reload();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    },
    computed: {
        balance() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            if (balance_ <= 0) {
                balance_ = 0;
            }
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.money.precision);
        },
        diferencia() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.money.precision);
        },
        saldo_balance() {
            let saldo = convertir_a_float(String(this.saldo));
            let monto = convertir_a_float(String(this.monto).toString());
            let balance_ = (saldo - monto);
            if (balance_ <= 0) {
                balance_ = 0;
            }
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.money.precision);
        }
    }
});

function active(x) {

    if (!x) return false;

    for (var i = 0; i < x.length; i++) {
        x[i].classList.remove("autocomplete-active");
    }

    if (currentFocus >= x.length) currentFocus = 0;
    if (currentFocus < 0) currentFocus = (x.length - 1);

    x[currentFocus].classList.add("autocomplete-active");
}

function closeAllLists(elmnt) {
    let inp = document.getElementById("buscador");
    let x = document.getElementsByClassName("autocomplete-items");
    for (var i = 0; i < x.length; i++) {
        if (elmnt != x[i] && elmnt != inp) {
            x[i].parentNode.removeChild(x[i]);
        }
    }
}

document.addEventListener("click", function (e) {
    closeAllLists(e.target);
});