new Vue({
    el: '#appCMPFacturaAnulada',
    data: {
        id_factura: document.getElementById('id_fac').value,
        cliente: document.getElementById('id_cliente_fac').value,
        simbolo_master: '',
        div_nombre_master: '',
        div_locale: '',
        div_simbolo: '',
        div_decimal: 2,
        div_conv_locale: '',
        div_conv_currency: '',
        div_conv_decimal: 2,
        div_conv_factor: 1,
        factura: [],
        divisa_pagar: '',
        metodo_pagar: '',
        cuenta_pagar: '',
        abonos: [],
        cuentas: [],
        metodos_de_pagos: [],
        formDocumentos: { 'id_factura': '', 'descripcion': '', 'documento': '' },
        documentos: [],
        monto: 0,
        restante_original: 0,
        articulosTotal: 0,
        total_pagado: 0,
        descuento: 0,
        restante: 0,
        subtotal: 0,
        total: 0,
        neto: 0,
        iva: 0,
        divisas: [],
        divisa_predeterminada: '',
        almacenes: [],
        almacen_predeterminado: '',
        series: [],
        serie_predeterminada: '',
        productos: [],
        carrito: [],
        money: {
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        cargando: false,
        errorForm: [],
        observaciones: '',
        proveedores: [],
        proveedorEncontrado: true,
        dataForm: {
            'ruta': '',
            'prov_codigo': '',
            'prov_nombre': '',
            'prov_razonsocial': '',
            'prov_tipoidfiscal': '',
            'prov_cifnif': '',
            'prov_personafisica': false,
            'prov_acreedor': '',
            'prov_idcontacto': '',
            'prov_telefono1': '',
            'prov_telefono2': '',
            'prov_email': '',
            'prov_web': '',
            'prov_serie': '',
            'prov_mpid': '',
            'prov_impid': '',
            'prov_subcuenta': '',
            'prov_regimeniva': '',
            'prov_retencion': '',
            'prov_observaciones': '',
            'prov_creado': '',
            'prov_actualizado': '',
            'prov_estatus': '',
            'prov_eliminado': '',
            'prov_paisid': '',
            'prov_estado': '',
            'prov_ciudad': '',
            'prov_codigo_postal': '',
            'prov_direccion': ''
        },
        icon_buscador: 'fa fa-search',
        icon_buscador_cliente: 'fa fa-search',
        observacion_anular: '',
        loader_correo: false,
    },
    created() {
        axios.get('cmpfacturaeditar/obtenerFactura/' + this.id_factura).then(response => {
            this.factura = response.data.factura;
            this.almacen_predeterminado = this.factura.cmp_almid;
            this.serie_predeterminada = this.factura.cmp_serid
            this.divisa_predeterminada = this.factura.cmp_divid
            this.div_nombre_master = response.data.div_nombre;
            this.div_locale = response.data.div_locale;
            this.div_simbolo = response.data.div_simbolo;
            this.div_decimal = response.data.div_decimal;
            this.div_conv_locale = response.data.div_locale;
            this.div_conv_currency = response.data.div_simbolo;
            this.div_conv_decimal = response.data.div_decimal;
            this.observaciones = this.factura.cmp_observaciones;
            this.div_conv_factor = response.data.factor;

            if (response.data.div_locale == 'de-DE') {
                this.money.decimal = ',';
                this.money.thousands = '.';
                this.money.precision = response.data.div_decimal;
            } else if (response.data.div_locale == 'en-US') {
                this.money.decimal = '.';
                this.money.thousands = ',';
                this.money.precision = response.data.div_decimal;
            }

            this.articulosTotal = response.data.articulos_cantidad;
            this.subtotal = response.data.subtotal;
            this.descuento = response.data.descuento;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total
            this.monto = parseFloat(response.data.restante).toFixed(this.money.precision);
            this.restante_original = response.data.restante;
            this.restante = response.data.restante;
            this.carrito = response.data.data_carrito;
            this.abonos = response.data.abonos;
            this.total_pagado = response.data.total_pagado;
            this.obtenerDocumentos();
        });
    },
    methods: {
        modal_buscar_proveedor(ruta) {
            this.dataForm.ruta = ruta;
            this.errorForm = [];
            $('#modal_buscar_proveedor').modal({ show: true, backdrop: 'static', keyboard: false });
            $('#modal_buscar_proveedor').on('shown.bs.modal', function () {
                $('#buscar_proveedor').trigger('focus')
            });
        },
        buscarProveedor: function (event) {
            if (event.target.value) {
                if (event.target.value.length > 2) {
                    this.icon_buscador = 'is-loading pr-3';
                    this.bus_prov(event.target.value, this);
                }
            }
        },
        bus_prov: _.debounce((value, vm) => {
            axios.get('compras/buscarProveedores', {
                params: {
                    buscar: value
                }
            }).then(response => {
                if (response.data.length > 0) {
                    vm.proveedores = response.data;
                    vm.proveedorEncontrado = true;
                } else {
                    vm.proveedores = [];
                    if (!isNaN(value)) {
                        vm.dataForm.prov_cifnif = value;
                    } else {
                        vm.dataForm.prov_cifnif = '';
                    }
                    vm.proveedorEncontrado = false;
                }
            }).catch(e => notificacion()).finally(() => {
                vm.icon_buscador = 'fa fa-search';
            });
        }, 400),
        modalCorreo() {
            $('#modal_correo').modal('show');
            $('#modal_correo').on('shown.bs.modal', function () {
                //$('#nombre_divisa').trigger('focus');
            });
        },
        enviarFactura() {

            this.errorForm = [];

            let de = document.getElementById('cor_emailde').value;
            let para = document.getElementById('cor_emailpara').value;
            let copia = document.getElementById('cor_emailcopia').value;
            let firma = document.getElementById('cor_emailfirma').value;
            let tipo = document.getElementById('cor_tipo').value;

            if (!de)
                this.errorForm.push('El campo De es obligatorio.');
            if (!para)
                this.errorForm.push('El campo Para es obligatorio.');

            if (de && para) {
                if (!validaEmail(de))
                    this.errorForm.push('El Correo Electrónico ' + de + ' no es valido.');
                if (!validaEmail(para))
                    this.errorForm.push('El Correo Electrónico ' + para + ' no es valido.');
            }

            if (this.errorForm.length == 0) {

                this.loader_correo = true;

                axios({
                    method: 'post',
                    url: 'cmpfacturaeditar/eniviarFactura',
                    data: {
                        id_factura: this.id_factura,
                        de: de,
                        para: para,
                        copia: copia,
                        firma: firma,
                        tipo: tipo
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => {
                    notificacion();
                }).finally(() => this.loader_correo = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        obtenerDocumentos() {
            axios.get('cmpfacturaeditar/obtnerDocumentos/' + this.id_factura).then(response => {
                if (Array.isArray(response.data)) {
                    this.documentos = response.data;
                }
            });
        },
        moneda(num, div_locale_, div_simbolo, decimal_ = 2) {
            if (this.div_conv_locale) {
                let monto_ = convertir_a_float(String(num).toString());
                let m = new Intl.NumberFormat(div_locale_, { minimumFractionDigits: decimal_ }).format(monto_);
                return div_simbolo + '' + m;
            }
        },
        decimal(num, div_locale, decimal = 2) {
            if (this.div_conv_locale) {
                let monto_ = convertir_a_float(String(num).toString());
                return new Intl.NumberFormat(div_locale, { minimumFractionDigits: decimal }).format(monto_);
            }
        }
    }
});