new Vue({
    el: '#appCuentas',
    data: {
        titulo: '',
        accion: '',
        cuentas: [],
        bancos: [],
        dataForm: { 'id': '', 'banco': '', 'tipo': 'AHORRO', 'cuenta': '', 'alias': '' },
        errorForm: [],
    },
    created() {
        this.obtenerCuentas();
        this.obtenerBancos();
    },
    methods: {
        obtenerBancos() {
            axios.get('banco/bancosActivos').then(response => {
                this.bancos = response.data;
            }).catch(e => notificacion());
        },
        obtenerCuentas() {
            axios.get('Bancocuentas/cuentas').then(response => {
                this.cuentas = response.data
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('form_modal_cuentas').reset();
            this.dataForm.id = '';
            this.dataForm.banco = '';
            this.dataForm.cuenta = '';
            this.dataForm.tipo = '';
            this.dataForm.alias = '';
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar Cuenta';
            this.accion = 'Guardar';
            $('#modal_cuentas').modal('show');
            $('#modal_cuentas').on('shown.bs.modal', function () {
                $('#bcbanco').trigger('focus');
            });
        },
        ver(id, banco, tipo, cuenta, alias) {
            this.errorForm = [];
            this.dataForm.id = id;
            this.dataForm.banco = banco;
            this.dataForm.tipo = tipo;
            this.dataForm.cuenta = cuenta;
            this.dataForm.alias = alias;
            this.titulo = 'Editar Cuenta';
            this.accion = 'Actualizar';
            $('#modal_cuentas').modal('show');
        },
        editarGuardar: function () {

            this.errorForm = [];

            if (!this.dataForm.banco)
                this.errorForm.push('El campo Banco es obligatorio.');
            if (!this.dataForm.tipo)
                this.errorForm.push('El campo Tipo es obligatorio.');
            if (!this.dataForm.cuenta) {
                this.errorForm.push('El campo Cuenta es obligatorio.');
            } else {
                if (String(this.dataForm.cuenta).length < 20) {
                    this.errorForm.push('El campo Cuenta debe poseer 20 digitos.');
                }
            }

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'bancocuentas/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal_cuentas').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Cuenta actualizada correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Cuenta registrada correctamente', 'success');
                            }
                            this.obtenerCuentas();
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        modificarEstatus(id, etiqueta) {
            axios.get('bancocuentas/modificarEstatus/' + Number(id)).then(response => {
                if (response.data.errors == null) {
                    this.obtenerCuentas();
                    let eti = document.getElementById(etiqueta);
                    eti.className = (eti.className === 'fa fa-times text-danger') ? 'fa fa-check text-success' : 'fa fa-times text-danger';
                    notificacion('fa fa-check', 'Actualizado', 'Estatus modificado correctamente', 'success');
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Cuenta',
                text: "¿Estás seguro que deseas eliminar la cuenta " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('bancocuentas/eliminar/' + Number(id)).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerCuentas();
                                notificacion('fa fa-trash', 'Cuenta eliminada', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar la cuenta', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});