new Vue({
    el: '#appBancos',
    data: {
        titulo: '',
        accion: '',
        bancos: [],
        dataForm: { 'id': '', 'codigo': '', 'descripcion': '', 'pais': '' },
        errorForm: [],
    },
    created() {
        this.obtenerBancos();
    },
    methods: {
        obtenerBancos() {
            axios.get('banco/bancos').then(response => {
                this.bancos = response.data
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('form_modal_banco').reset();
            this.dataForm.id = '';
            this.dataForm.codigo = '';
            this.dataForm.descripcion = '';
            this.dataForm.pais = '';
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar Banco';
            this.accion = 'Guardar';
            $('#modal_banco').modal('show');
            $('#modal_banco').on('shown.bs.modal', function () {
                $('#bancodigo').trigger('focus');
            });
        },
        ver(id, codigo, descripcion, pais) {
            this.errorForm = [];
            this.dataForm.id = id;
            this.dataForm.codigo = codigo;
            this.dataForm.descripcion = descripcion;
            this.dataForm.pais = pais;
            this.titulo = 'Editar Banco';
            this.accion = 'Actualizar';
            $('#modal_banco').modal('show');
        },
        editarGuardar: function () {

            this.errorForm = [];

            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es obligatorio.');
            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');
            if (!this.dataForm.pais)
                this.errorForm.push('El campo País es obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'banco/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal_banco').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Banco actualizado correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Banco registrado correctamente', 'success');
                            }
                            this.obtenerBancos();
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());

            }
        },
        modificarEstatus(id, etiqueta) {
            axios.get('banco/modificarEstatus/' + Number(id)).then(response => {
                if (response.data.errors == null) {
                    this.obtenerBancos();
                    let eti = document.getElementById(etiqueta);
                    eti.className = (eti.className === 'fa fa-times text-danger') ? 'fa fa-check text-success' : 'fa fa-times text-danger';
                    notificacion('fa fa-check', 'Actualizado', 'Estatus modificado correctamente', 'success');
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Banco',
                text: "¿Estás seguro que deseas eliminar el banco " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('banco/eliminar/' + Number(id)).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerBancos();
                                notificacion('fa fa-trash', 'Banco eliminado', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});