<script>
    new Vue({
        el: '#appFooterptv',
        data: {
            buscar: '',
            filtro: 1,
            cargando_lineas: '',
            cargando_lineas: [],
            lineas: [],
            sucursal_predeterminada: '',
            producto: '',
            productos: [],
            precios: [],
            almacenes: [],
            cargando: ''
        },
        mounted() {
            var self = this;
            $('#modal-precio-global').on('shown.bs.modal', function() {
                $('#producto_cos_generico').trigger('focus')
            });
            $('#modal-precio-global').on('hidden.bs.modal', function(e) {
                self.almacenes = [];
                self.productos = [];
                self.precios = [];
            })
        },
        created() {
              axios
                .get("ptv/obtenerSucursalesEmpleado")
                .then((response) => {
                    this.sucursal_predeterminada = response.data.id;
                })
                .catch((e) => notificacion());
        },
        methods: {
            modalLineas() {
                this.errorForm = [];
                $('#modal_lineas').modal('show');
                $('#modal_lineas').on('shown.bs.modal', function() {
                    $('#input_buscar_lineas').trigger('focus')
                });
            },

            filtrarPor(num) {
                this.filtro = num;
                this.lineas = [];
                document.getElementById('input_buscar_lineas').value = '';
                let nombre = 'En espera';
                if (num == 2) {
                    nombre = 'Pagadas';
                } else if (num == 3) {
                    nombre = 'Articulos';
                } else if (num == 4) {
                    nombre = 'Cliente';
                } else if (num == 5) {
                    nombre = 'Observaciones';
                }
                mostrar_nombre_filtro.innerHTML = nombre;
            },
            buscarLineas(event) {
                this.sucursal_predeterminada=document.getElementById('sucursal').value;
                if (event.target.value) {
                    this.cargando_lineas = 'is-loading is-loading-lg';
                    this.bus_li(event.target.value, this.filtro,this.sucursal_predeterminada);
                }
            },
            bus_li(value, filtro,sucursal) {
                axios.get('ptv/buscarFactNot', {
                    params: {
                        buscar: value,
                        filtro: filtro,
                        sucursal:sucursal
                    }
                }).then(response => {
                    if (response.data.length > 0) {
                        this.lineas = response.data;
                    } else {
                        this.lineas = [];
                    }
                }).catch(e => notificacion()).finally(() => this.cargando_lineas = '');
            },
            seleccionarProducto(producto) {
                document.getElementById('producto_cos_generico').value = '';
                this.productos = [];
                this.producto = producto.descripcion;
                axios.get('generico/obtenerProductoDetallado/' + Number(producto.id)).then(response => {
                    console.log(response.data);
                    this.almacenes = response.data.almacenes;
                    this.precios = response.data.precios
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = '';
                });
            },
            obtenerPrecioProducto(event) {
                this.cargando = 'is-loading is-loading-lg';
                if (event.target.value) {
                    axios.get('generico/obtenerPrecioProducto', {
                        params: {
                            buscar: event.target.value
                        }
                    }).then(response => {
                        this.productos = response.data;
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = '';
                    });
                }
            }
        }
    });
</script>
<div class="modal" tabindex="-1" id="gcalc">
    <div class="modal-dialog">
        <div class="modal-content">
            <div id="idCalculadora"></div>
        </div>
    </div>
</div>

</div>
</div>
</div>
</div>

<script>
    $("#idCalculadora").Calculadora();
</script>
</body>

</html>