axios.defaults.baseURL = baseURL;
axios.defaults.timeout = 1000000000;
axios.defaults.headers = {
  "X-Requested-With": "XMLHttpRequest",
};

axios.defaults.validateStatus = (status) => {
  if (status >= 200 && status < 300) {
    return status;
  } else {
    if (status == 401) {
      window.location = baseURL + "login";
    }
  }
};

function serializar() {
  return [
    (data, headers) => {
      let formData = new FormData();
      Object.keys(data).forEach((attr) => {
        formData.append(attr, data[attr]);
      });
      return formData;
    },
  ];
}

function validaEmail(email) {
  var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
  return re.test(email);
}

function convertir_a_float(num) {
  if (num) {
    let valor = 0;
    let multiplicar = 1;

    if (
      num.charAt() == "-" ||
      num.charAt(1) == "-" ||
      num.charAt(2) == "-" ||
      num.charAt(3) == "-" ||
      num.charAt(4) == "-"
    ) {
      multiplicar = -1;
    }

    let dotPos = String(num).indexOf(".");
    let commaPos = String(num).indexOf(",");

    let sep = dotPos > commaPos && dotPos ? dotPos : commaPos > dotPos && commaPos ? commaPos : false;

    if (!sep) {
      valor = parseFloat(String(num).replace(/[^0-9]/g, ""));
      return valor * multiplicar;
    }

    valor = parseFloat(
      num.substr(0, sep).replace(/[^0-9]/g, "") + "." + num.substr(sep + 1, num.length).replace(/[^0-9]/g, "")
    );

    return valor * multiplicar;
  } else {
    return 0;
  }
}

function monedaMoneda(num, div_locale, div_simbolo, decimal = 2) {
  let m = new Intl.NumberFormat(div_locale, {
    minimumFractionDigits: decimal,
    maximumFractionDigits: decimal,
  }).format(num);
  return div_simbolo + " " + m;
}

function monedaDecimal(num, div_locale, decimal = 2) {
  return new Intl.NumberFormat(div_locale, {
    minimumFractionDigits: decimal,
    maximumFractionDigits: decimal,
  }).format(num);
}

function descargarArchivo(data, filename, mime, bom) {
  var blobData = typeof bom !== "undefined" ? [bom, data] : [data];
  var blob = new Blob(blobData, { type: mime || "application/octet-stream" });

  var blobURL =
    window.URL && window.URL.createObjectURL
      ? window.URL.createObjectURL(blob)
      : window.webkitURL.createObjectURL(blob);

  var tempLink = document.createElement("a");

  tempLink.style.display = "none";
  tempLink.href = blobURL;
  tempLink.setAttribute("download", filename);

  if (typeof tempLink.download === "undefined") {
    tempLink.setAttribute("target", "_blank");
  }

  document.body.appendChild(tempLink);
  tempLink.click();

  setTimeout(function () {
    document.body.removeChild(tempLink);
    window.URL.revokeObjectURL(blobURL);
  }, 200);
}
