<?php

require 'vendor/autoload.php';
require 'core/Helpers/funciones.php';

use Core\Database;
use Core\Vista;

$options = parse_ini_file('config.ini', false);

foreach ($options as $constant => $value) {
    define($constant, $value);
}

ini_set('include_path', constant('APP_DIR'));
$id=$_GET['key'];
$tipo=$_GET['tp'];

$factura_data=[];
$cliente_data=[];
$tipod = '';
$articulos=[];

$newDBIni = new Database();
$empresa_data = $newDBIni->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();

if ($tipo== 1) {
    $factura_data = $newDBIni->consultar("SELECT * 
    FROM app_notas_de_entrega fm 
    JOIN app_series s ON s.ser_id = fm.ne_serid 
    JOIN app_divisas d ON d.div_id = fm.ne_divid 
    WHERE md5(fm.ne_id)='$id'")->row();

    $tipod = "ne";
    $cliente_data       =  $newDBIni->consultar("SELECT * FROM app_clientes WHERE cli_id={$factura_data['ne_cliid']}")->row();
    $articulos=$newDBIni->consultar("SELECT * FROM app_notas_de_entrega_articulos neart 
    LEFT JOIN app_productos p ON p.pro_id=neart.neart_proid 
   LEFT JOIN app_impuestos imp ON imp.imp_id=neart.neart_idiva  
   WHERE neart.neart_neid={$factura_data['ne_id']}")->all();

   $sucursal=$newDBIni->consultar("SELECT * FROM app_sucursales su 
   WHERE su.su_id={$factura_data['ne_surcid']}")->row();

    $mascara = mascara_correlativo('NEV', $factura_data['ser_impuesto'], $factura_data['ne_correlativo']);

    
    $mpdf = new \Mpdf\Mpdf([
        'mode'              => 'utf-8',
        'margin_left'       => 15,
        'margin_right'      => 15,
        'margin_top'        => 35,
        'margin_bottom'     => 30,
        'margin_header'     => 15,
        'margin_footer'     => 30,
        'format'            => 'A4',
        'orientation'       => 'P',
        'default_font_size' => 8,
        'default_font'      => 'helvetica'
    ]);

    $mpdf->SetTitle($mascara);
    $mpdf->SetAuthor($empresa_data['emp_nombre']);
    $mpdf->SetCreator($empresa_data['emp_nombre']);
    $mpdf->SetSubject($mascara);

    $html_header = Vista::viewPDF('pdffacturas/notasdeentrega/header', [
        'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
        'emp_rif'       => $empresa_data['emp_rif'] ?? '',
        'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
        'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
        'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
        'emp_estado'    => $empresa_data['emp_estado'] ?? '',
        'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
    ]);

    $mpdf->SetHTMLHeader($html_header);

    $factCompra = $empresa_data['emp_iva'];
    $html_body = Vista::viewPDF('pdffacturas/notasdeentrega/body_completo', [
        'factura'       => $mascara,
        'sucursal'      => $sucursal['su_nombre'] . '-' . $sucursal['su_direccion'],
        'iva_integrado' => $factCompra,
        'cliente'       => $cliente_data['cli_razon_social'],
        'direccion'     => $cliente_data['cli_direccion'],
        'fecha'         => date('Y-m-d', strtotime($factura_data['ne_fecha'])),
        'cedularif'     => $cliente_data['cli_dni'],
        'telefono'      => $cliente_data['cli_telefono'],
        'div_locale'    => $factura_data['div_locale'],
        'div_simbolo'  => $factura_data['div_simbolo'],
        'articulos'     => $articulos,
        'observaciones' => $factura_data['ne_observaciones']
    ]);

    $mpdf->WriteHTML($html_body);
    if ($factCompra) {

        $subtotal = 0;
        $neto = 0;
        $total = 0;
        foreach ($articulos as $row) {
            $iv = convertir_a_float($row['neart_proprecio'] + ($row['neart_proprecio'] * ($row['imp_valor'] / 100))) ?? 0;
            $descuentoprod = convertir_a_float(($row['neart_procantidad'] * $iv) * ($row['neart_prodescuento'] / 100)) ?? 0;
            $subtotal += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
            $neto += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
            $total += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
        }
        $descuento = convertir_a_float(($total * ($factura_data['ne_descuento'] / 100))) ?? 0;
        $html_footer = Vista::viewPDF('pdffacturas/notasdeentrega/footer', [
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'   => $factura_data['div_simbolo'],
            'total'         => $total - $descuento,
            'iva_integrado' => $factCompra,
            'iva'           => $factura_data['ne_iva'],
            'neto'          => $neto,
            'descuento'     => $factura_data['ne_descuento']
        ]);
    } else {
        $html_footer = Vista::viewPDF('pdffacturas/notasdeentrega/footer', [
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'iva_integrado' => $factCompra,
            'total'         => $factura_data['ne_total'],
            'iva'           => $factura_data['ne_iva'],
            'neto'          => $factura_data['ne_neto'],
            'descuento'     => $factura_data['ne_descuento']
        ]);
    }


    $mpdf->SetHTMLFooter($html_footer);

    $mpdf->Output($mascara . '.pdf', \Mpdf\Output\Destination::INLINE);
    exit;

} else {
    $factura_data = $newDBIni->consultar("SELECT * 
    FROM app_factura_master fm 
    JOIN app_series s ON s.ser_id = fm.fm_serid
    JOIN app_divisas d ON d.div_id = fm.fm_divid
    WHERE md5(fm.fm_id)='$id'")->row();
    $tipod = "fm";
    $cliente_data       =  $newDBIni->consultar("SELECT * FROM app_clientes WHERE cli_id={$factura_data['fm_cliid']}")->row();
    $articulos   = $newDBIni->consultar("SELECT * FROM app_factura_articulos fa  
    LEFT JOIN app_productos p ON p.pro_id=fa.fa_proid 
   LEFT JOIN app_impuestos imp ON imp.imp_id=fa.fa_idiva  
   WHERE fa.fa_fmid={$factura_data['fm_id']}")->all();

    $sucursal=$newDBIni->consultar("SELECT * FROM app_sucursales su 
    WHERE su.su_id={$factura_data['fm_surcid']}")->row();

   
    $mascara = mascara_correlativo('FACV', $factura_data['ser_impuesto'], $factura_data['fm_correlativo']);

    $margin_top = 0;
        $margin_footer = 0;

        if ($factura_data['ser_id'] == 1) {
            $margin_top = 50;
            $margin_footer = 28;
        } else {
            $margin_top = 35;
            $margin_footer = 45;
        }

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => $margin_top,
            'margin_bottom'     => 28,
            'margin_header'     => 50,
            'margin_footer'     => $margin_footer,
            'format'            => 'Letter',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle($mascara);
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject($mascara);
        /*
        $html_header = Vista::viewPDF('pdffacturas/factura/header', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);*/

        $html_body = Vista::viewPDF('pdffacturas/factura/body_completo', [
            'factura'       => $mascara,
            'cliente'       => $cliente_data['cli_razon_social'],
            'direccion'     => $cliente_data['cli_direccion'],
            'fecha'         => date('Y-m-d', strtotime($factura_data['fm_fecha'])),
            'cedularif'     => $cliente_data['cli_dni'],
            'telefono'      => $cliente_data['cli_telefono'],
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'articulos'     => $articulos,
            'observaciones' => $factura_data['fm_observaciones']
        ]);

        $mpdf->WriteHTML($html_body);

        $html_footer = Vista::viewPDF('pdffacturas/factura/footer', [
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'total'         => $factura_data['fm_total'],
            'iva'           => $factura_data['fm_iva'],
            'neto'          => $factura_data['fm_neto'],
            'descuento'     => $factura_data['fm_descuento']
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        $mpdf->Output($mascara . '.pdf', \Mpdf\Output\Destination::INLINE);
        exit;
}

?>
