<?php
require 'vendor/autoload.php';
//require 'core/Helpers/funciones.php';

use App\Modelos\ProductoCategoria;
use App\Modelos\Productos;
use App\Modelos\ProductosImagen;
use Automattic\WooCommerce\Client;
use Automattic\WooCommerce\HttpClient\HttpClientException;
use Core\Database;
use Core\Helpers\Moneda;
use Core\Librerias\Http;


function float_a_string($val): string
{
    preg_match("#^([\+\-]|)([0-9]*)(\.([0-9]*?)|)(0*)$#", trim($val), $o);
    return $o[1] . sprintf('%d', $o[2]) . ($o[3] != '.' ? $o[3] : '');
}

$options = parse_ini_file('config.ini', false);

foreach ($options as $constant => $value) {
    define($constant, $value);
}

ini_set('include_path', constant('APP_DIR'));

$newDBIni = new Database();

$productos        = new Productos();

$array_mensajes = [];

$wc_config = $newDBIni->consultar("SELECT * FROM app_wc")->row();

if ($wc_config) {
    define('WCURL', $wc_config['wc_url']);
    define('WCKEY', $wc_config['wc_key']);
    define('WCSECRECT', $wc_config['wc_secret']);
    define('WCIMG', $wc_config['wc_url_img']);
    define('WCDESCRIPTION', $wc_config['wc_pro']);

    $woocommerce = new Client(
        constant('WCURL'),
        constant('WCKEY'),
        constant('WCSECRECT'),
        [
            'wp_api'    => true,
            'version'   => 'wc/v3',
            'timeout'   => 30
        ]
    );

    $productoImagen     = new ProductosImagen();
    $productoCategoria  = new ProductoCategoria();

    $woocor = $productos->consultar("SELECT * FROM app_wc")->row();

    $list_productos = $productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico, sum(ps.ps_cantidad) as ps_cantidad  
    FROM app_productos pro 
    LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
    LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
    LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
    WHERE pro_tipo != 3 ")->all();

    if (is_countable($list_productos) && count($list_productos)) {

        foreach ($list_productos as $row) {

            $pro_id = $row['pro_id'];
            //echo $pro_id;

            $producto       = $productos->obtenerproImp($pro_id);
            // $pro_imagenes   = $productoImagen->obtenerProductoImagenes($pro_id);
            $pro_categorias = $productoCategoria->obtenerCategoriasProducto($pro_id);

            $data_form = [
                'slug'          => $producto['pro_descripcion'],
                'sku'           => $producto['pro_id'],
                'name'          => $producto['pro_descripcion'],
                //'type'          => 'simple',
                'price'         => ($woocor['wc_precio'] == 1) ? float_a_string($producto['pro_precio'] + ($producto['pro_precio'] * ($producto['imp_valor'] / 100))) : $producto['pro_precio'],
                'regular_price' => ($woocor['wc_precio'] == 1) ? float_a_string($producto['pro_precio'] + ($producto['pro_precio'] * ($producto['imp_valor'] / 100))) : $producto['pro_precio'],
                'status'        => 'private'
            ];
            // 'description'   => $producto['pro_observaciones'],
            if (defined('WCDESCRIPTION') && constant('WCDESCRIPTION') == 0) {
             $data_form['short_description'] = '[wcm_product_discount]';
            }

            if (is_countable($pro_categorias) && count($pro_categorias)) {
                foreach ($pro_categorias as $row) {
                    $data_form['categories'][] = [
                        'id' => $row['cat_wooc']
                    ];
                }
            }

            /* if (is_countable($pro_imagenes) && count($pro_imagenes)) {
                $i = 0;
                foreach ($pro_imagenes as $item) {
                    $i++;
                    $img = constant('WCIMG') . $item['pi_imagen'];
                    $data_form['images'][] = [
                        "src" => $img,
                        "position" => $i
                    ];
                }
            }
    */
            if ($producto['pro_nostock'] == 1 && $producto['pro_publico'] == 1) {
                $data_form['status'] = 'publish';
            } elseif ($producto['pro_nostock'] == 0 && $producto['pro_publico'] == 1) {
                $total_stock = $productos->obtenerTotalStockProducto($pro_id);
                if ($total_stock['total_stock'] > 0) {
                    $data_form['status'] = 'publish';
                } else {
                    $data_form['status'] = 'private';
                }
            }

            try {
                $wcproducto = $woocommerce->get('products', ['sku' => $pro_id]);

                if ($wcproducto !== []) {

                    //ACTUALIZA
                    try {
                        //unset($data_form['slug']);
                        $woocommerce->put('products/' . $wcproducto[0]->id, $data_form);
                        if ($data_form['status'] == 'publish') {
                            $array_mensajes[] = 'Producto publicado en woocommerce';
                        } else {
                            $array_mensajes[] = 'Producto no publicado en woocommerce ya que no cuenta con stock o el status ha sido modificado a privado';
                        }
                    } catch (HttpClientException $e) {
                        $array_mensajes[] = $e->getMessage();
                    }
                    Http::json_response($array_mensajes);
                } else {
                    //CREA if ($data_form['status'] == 'publish' && is_countable($pro_imagenes) && count($pro_imagenes) && is_countable($pro_categorias) && count($pro_categorias)) {


                    if ($data_form['status'] == 'publish'  && is_countable($pro_categorias) && count($pro_categorias)) {
                        try {
                            $woocommerce->post('products', $data_form);
                            $array_mensajes[] = 'Producto publicado en woocommerce';
                        } catch (HttpClientException $e) {
                            $array_mensajes[] = $e->getMessage();
                        }
                        Http::json_response($array_mensajes);
                    } else {
                        $array_mensajes[] = 'Lo siento el producto debe tener precio, imagen, categoria y stock para poder subirlo a woocommerce';
                        Http::json_response($array_mensajes);
                    }
                }
            } catch (HttpClientException $e) {
                $array_mensajes[] = $e->getMessage();
            }

            Http::json_response($array_mensajes);
        }
    }
}
