<?php

namespace Core;

use App\Modelos\Empleado;
use App\Modelos\EmpleadoSucursales;
use Core\Librerias\GoogleAuthenticator;
use Core\Librerias\Seguridad;

final class ManejadorSession
{
    public static function verificarSession()
    {
        if (!isset($_SESSION['logueado']) || !isset($_SESSION['user_data'])) {
            return self::redirecionarlogin();
        }
    }

    public static function verificarSessionAjax()
    {
        if (!isset($_SESSION['logueado']) || !isset($_SESSION['user_data'])) {
            session_unset();
            session_destroy();
            header('HTTP/1.0 401 Unauthorized');
            header('Content-Type: application/json', true);
            echo json_encode('exit');
            exit;
        }
    }

    public static function redirecionarlogin()
    {
        session_unset();
        session_destroy();
        header('Location: ' . ruta_base() . 'login');
        exit();
    }

    public static function procesarLogin($user, $pass)
    {
        if (!empty($user) && !empty($pass)) {
            return self::verificarUserdatos($user, $pass);
        }

        return redireccionar()->mensaje([
            'tipo'    => 'warning',
            'mensaje' => 'Por favor verifique que los datos sean enviado',
        ])->atras();
    }

    public static function verificarUserdatos($user, $pass)
    {
        $empleado_model = new Empleado();

        $usuario        = $empleado_model->getUserInfo($user);

        if (!isset($usuario['emp_id'])) {
            return redireccionar()->mensaje([
                'tipo'    => 'warning',
                'mensaje' => 'Usuario no encontrado',
            ])->atras();
        }

        if ($usuario['emp_estatus'] == 0) {
            return redireccionar()->mensaje([
                'tipo'    => 'warning',
                'mensaje' => 'Usuario Inactivo',
            ])->atras();
        }

        if ($usuario['emp_tipo'] == 'OBRERO') {
            return redireccionar()->mensaje([
                'tipo'    => 'warning',
                'mensaje' => 'Este usuario no tiene el permiso para entrar al sistema.',
            ])->atras();
        }

        $usuario_personales = $empleado_model->getUserPerData($usuario['emp_edatosid']);

        $usuario_datos      = [
            'emp_id'               => $usuario['emp_id'],
            'emp_tipo'             => $usuario['emp_tipo'],
            'einfo_id'             => $usuario_personales['einfo_id'],
            'emp_googlecode'       => $usuario['emp_googlecode'],
            'emp_gauth'            => $usuario['emp_gauth'],
            'emp_username'         => $usuario['emp_username'],
            'einfo_nombres'        => $usuario_personales['einfo_nombres'],
            'einfo_apellidos'      => $usuario_personales['einfo_apellidos'],
            'einfo_email'          => $usuario_personales['einfo_email'],
            'einfo_telefono_movil' => $usuario_personales['einfo_telefono_movil'],
            'einfo_direccion_1'    => $usuario_personales['einfo_direccion_1'],
            'einfo_direccion_2'    => $usuario_personales['einfo_direccion_2'],
            'einfo_ciudad'         => $usuario_personales['einfo_ciudad'],
            'einfo_estado'         => $usuario_personales['einfo_estado'],
            'einfo_imagen'         => $usuario_personales['einfo_imagen'],
        ];

        if (!Seguridad::verificar($pass, $usuario['emp_password'])) {
            return redireccionar()->mensaje([
                'tipo'    => 'warning',
                'mensaje' => 'Contraseña incorrecta',
            ])->atras();
        }


        return self::inicioSession($usuario_datos);
    }

    public static function seleccionarSucursal($id)
    {
        $surcusalesempleado_model = new EmpleadoSucursales();

        if ($id != 0) {
            $sucursal = $surcusalesempleado_model->obtenerSucursal($_SESSION['user_data']['emp_id'], $id);
            $_SESSION['sucursal']['id'] = $id;
            $_SESSION['sucursal']['nombre'] = $sucursal['su_nombre'];
        } else {
            $_SESSION['sucursal']['id'] = 0;
            $_SESSION['sucursal']['nombre'] = 'Todas';
        }
        $_SESSION['logueado']  = '1';
        header('Location: ' . ruta_base());
        exit();
    }

    public static function seleccionargoogleauth($code)
    {
        if ($code) {
            $secret = $_SESSION['user_data']['emp_googlecode'];
            $surcusalesempleado_model = new EmpleadoSucursales();
            $sucursales = $surcusalesempleado_model->obtenerSucursales($_SESSION['user_data']['emp_id']);

            $ga = new GoogleAuthenticator();
            $checkResult = $ga->verifyCode($secret, $code, 2);

            if ($checkResult) {
                if (count($sucursales) > 1) {
                    header('Location: ' . sucursal());
                    exit();
                } else {
                    if (isset($sucursales[0]['su_id'])) {
                        $sucursal = $surcusalesempleado_model->obtenerSucursalEmp($_SESSION['user_data']['emp_id']);
                        $_SESSION['sucursal']['id'] = $sucursal['su_id'];
                        $_SESSION['sucursal']['nombre'] = $sucursal['su_nombre'];
                    }

                    $_SESSION['logueado']  = '1';
                    header('Location: ' . ruta_base());
                    exit();
                }
            } else {
                $_SESSION['error'] = 1;
                return redireccionar()->mensaje([
                    'tipo'    => 'warning',
                    'mensaje' => 'Codigo incorrecto',
                ])->atras();
            }
        } else {
            $_SESSION['error'] = 1;
            return redireccionar()->mensaje([
                'tipo'    => 'warning',
                'mensaje' => 'Ingrese su codigo',
            ])->atras();
        }
    }

    public static function inicioSession($usuario_datos)
    {
        $surcusalesempleado_model = new EmpleadoSucursales();
        $sucursales = $surcusalesempleado_model->obtenerSucursales($usuario_datos['emp_id']);

        if ($usuario_datos['emp_gauth'] == 1) {
            $_SESSION['user_data'] = $usuario_datos;
            $_SESSION['error'] = 0;
            header('Location: ' . google());
            exit();
        } else {
            if (count($sucursales) > 1) {
                $_SESSION['user_data'] = $usuario_datos;
                header('Location: ' . sucursal());
                exit();
            } else {
                if (isset($sucursales[0]['su_id'])) {
                    $sucursal = $surcusalesempleado_model->obtenerSucursalEmp($usuario_datos['emp_id']);
                    $_SESSION['sucursal']['id'] = $sucursal['su_id'];
                    $_SESSION['sucursal']['nombre'] = $sucursal['su_nombre'];
                }

                $_SESSION['logueado']  = '1';
                $_SESSION['user_data'] = $usuario_datos;
                header('Location: ' . ruta_base());
                exit();
            }
        }
    }

    public static function destruirSession()
    {
        return self::redirecionarlogin();
    }
}
