<?php

namespace Core\Librerias;

use Core\Database;
//use Core\ManejadorSession;

final class Module
{
    private $module_id;
    private $db_con;

    public function __construct($module_id = null)
    {
        //ManejadorSession::verificarSession();

        $this->db_con = new Database();

        if (null !== $module_id && !$this->has_module_permission($module_id, $_SESSION['user_data']['emp_id'])) {
            Http::exit_by_forbiden();
        }
    }

    public function has_module_permission($module_id, $emp_id)
    {
        $data = $this->db_con->consultar("SELECT * FROM app_permissions WHERE module_id = '$module_id' AND emp_id = $emp_id")->row();
        return ($data) ? true : false;
    }

    public function getModuleName(string $module_id)
    {
        return $this->db_con->consultar("SELECT * FROM app_modules WHERE module_id = '$module_id'")->row();
    }

    public function getAllModules()
    {
        return $this->db_con->consultar('SELECT * FROM app_modules ORDER BY sort')->all();
    }

    public function getAllowedModules(int $emp_id)
    {
        return $this->db_con->consultar("SELECT * FROM app_modules
        JOIN app_permissions on app_permissions.module_id=app_modules.module_id
        WHERE app_permissions.emp_id = $emp_id and app_modules.block_menu=0
        ORDER BY sort ASC")->all();
    }

    public function getAllowedSubModules(string $emp_id, string $module_parentid)
    {
        return $this->db_con->consultar("SELECT * FROM app_modules
        JOIN app_permissions on app_permissions.module_id=app_modules.module_id
        WHERE app_modules.module_parentid = '{$module_parentid}' AND app_permissions.emp_id = $emp_id ORDER BY sort ASC")->all();
    }

    public function countHaveSubMenu(string $emp_id, string $module_parentid)
    {
        return $this->db_con->consultar("SELECT * FROM app_modules
        JOIN app_permissions on app_permissions.module_id=app_modules.module_id
        WHERE app_modules.module_parentid = '{$module_parentid}' AND app_permissions.emp_id = $emp_id")->count();
    }

    public function check_action_permission(string $action_id)
    {
        if (!$this->has_module_action_permission($this->module_id, $action_id, $_SESSION['user_data']['emp_id'])) {
            header('Location:' . ruta_base() . '403');
            exit;
        }
    }

    public function has_module_action_permission($module_id, string $action_id, int $emp_id)
    {
        $data = $this->db_con->consultar("SELECT * FROM app_permissions_actions WHERE emp_id = $emp_id AND module_id = '$module_id' AND action_id = '$action_id'")->row();
        return ($data) ? true : false;
    }

    public function getModuleUser(string $modulo_id, int $emp_id)
    {
        $data = $this->db_con->consultar("SELECT * FROM app_modules
        JOIN app_permissions on app_permissions.module_id=app_modules.module_id
        WHERE app_permissions.emp_id = $emp_id and app_permissions.module_id='$modulo_id'
         ORDER BY sort ASC")->row();
        return ($data) ? true : false;
    }
}
