<?php

namespace Core\Librerias;

use App\Controladores\TarifasControlador;
use App\Modelos\AlmacenUbicacion;
use App\Modelos\CarritoVentasModel;
use App\Modelos\Cliente;
use App\Modelos\EmpleadoAgente;
use App\Modelos\ProductosCompuestos;
use App\Modelos\ProductoUbicacion;
use Core\Helpers\Moneda;

final class CarritoVentas
{
    private $carrito = [];
    private $array_errors = [];
    private $divisa_master;
    private $carritoModel;

    public function __construct()
    {
        $this->carritoModel = new CarritoVentasModel();
        $this->divisa_master = Moneda::Predeterminada();
    }

    public function obtenerDivisaFacturar(): array
    {
        return $this->carritoModel->obtenerDivisaFacturar();
    }

    public function obtenerUltimaNota()
    {
        return $this->carritoModel->obtenerUltimaNota();
    }

    public function obtenerUltimaFact()
    {
        return $this->carritoModel->obtenerUltimaFact();
    }

    public function obtenerDivisasParaFacturar(): array
    {
        $data_divisa = $this->carritoModel->obtenerDivisaEmpleado($_SESSION['user_data']['emp_id']);
        return $data_divisa ?? $this->carritoModel->obtenerDivisas();
    }

    public function totalDocumentosPendientes(int $id_cliente)
    {
        return $this->carritoModel->totalDocumentosPendientes($id_cliente);
    }

    public function obtenerAlmacen(int $id_almacen)
    {
        return $this->carritoModel->obtenerAlmacen($id_almacen);
    }

    public function chuequearStock(int $id_producto, int $id_almacen)
    {
        return $this->carritoModel->chuequearStock($id_producto, $id_almacen);
    }

    public function obtenerProducto(int $id_producto)
    {
        return $this->carritoModel->obtenerProducto($id_producto);
    }

    public function obtenerDivisa(int $id_divisa)
    {
        return $this->carritoModel->obtenerDivisa($id_divisa);
    }

    public function obtenerSerie(int $id_serie)
    {
        return $this->carritoModel->obtenerSerie($id_serie);
    }

    public function obtenerCliente(int $id_cliente)
    {
        return $this->carritoModel->obtenerCliente($id_cliente);
    }

    public function obtenerEmpleados()
    {
        return $this->carritoModel->obtenerEmpleados();
    }

    public function obtenerDatosEmpresa()
    {
        return $this->carritoModel->obtenerDatosEmpresa();
    }

    public function obternerTiposDeDocumentos()
    {
        return $this->carritoModel->obternerTiposDeDocumentos();
    }

    public function obtenerImpuestos()
    {
        return $this->carritoModel->obtenerImpuestos();
    }

    public function obtenerPaises()
    {
        return $this->carritoModel->obtenerPaises();
    }

    public function obtenerAlmacenesEmpleado()
    {
        return $this->carritoModel->obtenerAlmacenesEmpleado();
    }

    public function obtenerSeriesEmpleado()
    {
        return $this->carritoModel->obtenerSeriesEmpleado();
    }

    public function obtenerSeriesEmpleadoSucursales($id)
    {
        return $this->carritoModel->obtenerSeriesEmpleadoSucursales($id);
    }

    public function obtenerAlmacenesEmpleadoSucursales($id)
    {
        return $this->carritoModel->obtenerAlmacenesEmpleadoSucursales($id);
    }

    public function obtenerAgentesdeVenta()
    {
        return $this->carritoModel->obtenerAgentesdeVenta();
    }

    public function chuequearCorrelativo(int $id_serie, int $id_documento)
    {
        return $this->carritoModel->chuequearCorrelativo($id_serie, $id_documento);
    }

    public function actualizarCorrelativo(int $id_serie, int $id_documento, int $correlativo)
    {
        return $this->carritoModel->actualizarCorrelativo($id_serie, $id_documento, $correlativo);
    }

    public function contenidoCarrito(string $_nombre_carrito_, int $id_cliente)
    {
        $this->carrito = [];
        $this->carrito = $_SESSION["$_nombre_carrito_$id_cliente"];
        unset($this->carrito['articulos_cantidad']);
        unset($this->carrito['subtotal']);
        unset($this->carrito['descuento']);
        unset($this->carrito['neto']);
        unset($this->carrito['iva']);
        unset($this->carrito['total']);
        unset($this->carrito['divisa']);
        unset($this->carrito['id_almacen']);
        return $this->carrito;
    }

    public function predeterminarDivisa(string $_nombre_carrito_, int $id_cliente, int $id_divisa, string $descuento_global)
    {
        $divisa = Moneda::obtenerDivisa($id_divisa);

        if ($divisa) {
            if ($divisa['id'] !== $this->divisa_master['id']) {
                $div_master = $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'] ?? $this->divisa_master['id'];
                if (!$this->carritoModel->obtenerDivisaAlCambio($div_master, $divisa['id'])) {
                    $this->array_errors[] = 'Lo siento no se encuentra algun valor establecido para la conversión con la moneda predetermminada';
                }
            }
        } else {
            $this->array_errors[] = 'Divisa predeterminada no establecida o divisa no enontrada';
        }

        if (empty($this->array_errors)) {

            if (!is_null($_SESSION["$_nombre_carrito_$id_cliente"])) {

                $descuento_global = convertir_a_float($descuento_global);
                $contenido_carrito = $this->contenidoCarrito($_nombre_carrito_, $id_cliente);

                foreach ($contenido_carrito as $row) {

                    $divisa_factor = $this->carritoModel->obtenerProductoFactor($row['id']);

                    if ($divisa_factor) {
                        $precio = $this->obtenerPrecioSegunDivisaFactorProducto($divisa_factor['profac_bifac_serial'], $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['precio'], $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'], $id_divisa);
                        $costo = $this->obtenerPrecioSegunDivisaFactorProducto($divisa_factor['profac_bifac_serial'], $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['costo'], $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'], $id_divisa);
                        $costo_servicio = $this->obtenerPrecioSegunDivisaFactorProducto($divisa_factor['profac_bifac_serial'], $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['costo_servicio'], $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'], $id_divisa);
                    } else {
                        $precio = $this->obtenerPrecioSegunDivisa($_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['precio'], $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'], $id_divisa);
                        $costo = $this->obtenerPrecioSegunDivisa($_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['costo'], $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'], $id_divisa);
                        $costo_servicio = $this->obtenerPrecioSegunDivisa($_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['costo_servicio'], $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'], $id_divisa);
                    }

                    $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['precio'] = $precio['precio'];

                    $pc = $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['cantidad'] * $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['precio'];
                    $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['iva'], 'pvp', $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['descuento']);

                    $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['iva_total']      = $precio['iva'];
                    $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['neto']           = $precio['neto'];
                    $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['total']          = $precio['total'];
                    $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['costo']          = $costo['precio'];
                    $_SESSION["$_nombre_carrito_$id_cliente"][$row['unique']]['costo_servicio'] = $costo_servicio['precio'];
                }

                $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'] = $id_divisa;

                return [
                    'divisa' => $divisa,
                    'data_carrito' => $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global)
                ];
            } else {
                return [
                    'divisa' => $divisa,
                    'data_carrito' => []
                ];
            }
        }

        return ['errors' => $this->array_errors];
    }

    public function buscarProducto(string $producto, int $id_divisa, int $id_almacen, bool $stock = true, bool $caja = false)
    {
        $divisa = Moneda::obtenerDivisa($id_divisa);

        if ($divisa) {
            if ($divisa['id'] !== $this->divisa_master['id']) {
                $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($this->divisa_master['id'], $divisa['id']);
                if (!$divisa_factor) {
                    $this->array_errors[] = 'Lo siento no se encuentra algun valor establecido para la conversión con la moneda predetermminada.';
                } else {
                    $factor = $divisa_factor['df_factor'];
                }
            } else {
                $factor = 1;
            }
        } else {
            $this->array_errors[] = 'Divisa predeterminada no establecisa o divisa no encontrada';
        }

        if (empty($this->array_errors)) {

            $array_productos = [];

            if (strlen($producto) > 0) {

               // if ($caja) {
                 //   $productos = $this->carritoModel->buscarProductosVentasCaja($id_almacen, $producto);
               // } else {
                    if ($stock) {
                        $productos = $this->carritoModel->buscarProductos($id_almacen, $producto);
                    } else {
                        $productos = $this->carritoModel->buscarProductosSinStock($producto);
                    }
               // }

                if (is_countable($productos) && count($productos)) {
                    foreach ($productos as $row) {
                        $imagen = null;
                        if (($row['pi_imagen'] != null || $row['pi_imagen'] != '') && file_exists(constant('UPLOADS_URI') . 'productos/' . $row['pi_imagen'])) {
                            $imagen = constant('IMG_URI') . 'productos/' . $row['pi_imagen'];
                        }
                        $array_productos[] = [
                            'pro_id'            => $row['pro_id'],
                            'pro_descripcion'   => "({$row['pro_codigo']}) {$row['pro_descripcion']}",
                            'pro_precio'        => Moneda::moneda(($row['pro_precio'] * $factor), $divisa['locale'], $divisa['symbol']),
                            'ps_cantidad'       => $row['ps_cantidad'] ?? 0,
                            'id_almacen'        => $id_almacen,
                            'fabricante'        => $row['fa_nombre'],
                            'imagen'            => $imagen
                        ];
                    }
                }
            }

            return $array_productos;
        }

        return ['errors' => $this->array_errors];
    }
    public function todosProducto(int $id_divisa, int $id_almacen)
    {
        $divisa = Moneda::obtenerDivisa($id_divisa);

        if ($divisa) {
            if ($divisa['id'] !== $this->divisa_master['id']) {
                $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($this->divisa_master['id'], $divisa['id']);
                if (!$divisa_factor) {
                    $this->array_errors[] = 'Lo siento no se encuentra algun valor establecido para la conversión con la moneda predetermminada.';
                }                                                                                                                                                                                                                                                                                           else {
                    $factor = $divisa_factor['df_factor'];
                }
            } else {
                $factor = 1;
            }
        } else {
            $this->array_errors[] = 'Divisa predeterminada no establecisa o divisa no encontrada';
        }

        if (empty($this->array_errors)) {

            $array_productos = [];

            $productos = $this->carritoModel->todosProductos($id_almacen);


            if (is_countable($productos) && count($productos)) {
                foreach ($productos as $row) {
                    $imagen = null;
                    if (($row['pi_imagen'] != null || $row['pi_imagen'] != '') && file_exists(constant('UPLOADS_URI') . 'productos/' . $row['pi_imagen'])) {
                        $imagen = constant('IMG_URI') . 'productos/' . $row['pi_imagen'];
                    }
                    $array_productos[] = [
                        'pro_id'            => $row['pro_id'],
                        'pro_descripcion'   => "({$row['pro_codigo']}) {$row['pro_descripcion']}",
                        'pro_precio'        => Moneda::moneda(($row['pro_precio'] * $factor), $divisa['locale'], $divisa['symbol']),
                        'ps_cantidad'       => $row['ps_cantidad'] ?? 0,
                        'id_almacen'        => $id_almacen,
                        'fabricante'        => $row['fa_nombre'],
                        'imagen'            => $imagen
                    ];
                }
            }

            return $array_productos;
        }

        return ['errors' => $this->array_errors];
    }


    public function actualizarPrecioTotalYCantidad(string $_nombre_carrito_, int $id_cliente, $descuento = null)
    {
        $this->carrito = $_SESSION["$_nombre_carrito_$id_cliente"];
        unset($this->carrito['articulos_cantidad']);
        unset($this->carrito['subtotal']);
        unset($this->carrito['descuento']);
        unset($this->carrito['neto']);
        unset($this->carrito['iva']);
        unset($this->carrito['total']);
        unset($this->carrito['divisa']);
        unset($this->carrito['id_almacen']);

        $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

        if (is_null($descuento)) {
            $descuento = $this->carritoModel->obtenerDescuento($id_cliente);
            $descuento = $descuento['cli_descuento'];
        }

        if ($descuento > 0) {
            foreach ($this->carrito as $row) {
                $articulos_cantidad += 1;
                $subtotal += $row['neto'];
                $precio = $this->obtenerDescuentoMasIvaProducto($row['neto'], $row['iva'], 'pvp', $descuento, 0);
                $neto += $precio['neto'];
                $total_iva += $precio['iva'];
                $total += $precio['total'];
            }
        } else {
            foreach ($this->carrito as $row) {
                $articulos_cantidad += 1;
                $neto += $row['neto'];
                $total_iva += $row['iva_total'];
                $total += $row['total'];
            }
            $subtotal = $neto;
        }

        $_SESSION["$_nombre_carrito_$id_cliente"]['articulos_cantidad']   = $articulos_cantidad;
        $_SESSION["$_nombre_carrito_$id_cliente"]['subtotal']             = $subtotal;
        $_SESSION["$_nombre_carrito_$id_cliente"]['descuento']            = $descuento;
        $_SESSION["$_nombre_carrito_$id_cliente"]['neto']                 = $neto;
        $_SESSION["$_nombre_carrito_$id_cliente"]['iva']                  = $total_iva;
        $_SESSION["$_nombre_carrito_$id_cliente"]['total']                = $neto + $total_iva;
    }

    public function obtenerCarritoCliente(string $_nombre_carrito_, int $id_cliente, $descuento = null)
    {
        $this->actualizarPrecioTotalYCantidad($_nombre_carrito_, $id_cliente, $descuento);

        $div_format = Moneda::obtenerDivisa($_SESSION["$_nombre_carrito_$id_cliente"]['divisa']);

        $carrito_c = [];
        $carrito_c = $_SESSION["$_nombre_carrito_$id_cliente"];
        unset($carrito_c['articulos_cantidad']);
        unset($carrito_c['subtotal']);
        unset($carrito_c['descuento']);
        unset($carrito_c['neto']);
        unset($carrito_c['iva']);
        unset($carrito_c['total']);
        unset($carrito_c['divisa']);
        unset($carrito_c['id_almacen']);

        foreach ($carrito_c as $row) {
            $carrito_c[$row['unique']]['precio'] = number_format($row['precio'], $div_format['precision'], $div_format['decimal'], $div_format['thousands']);
            $carrito_c[$row['unique']]['iva'] = number_format($row['iva'], $div_format['precision'], $div_format['decimal'], $div_format['thousands']);
            $carrito_c[$row['unique']]['iva_total'] = number_format($row['iva_total'], $div_format['precision'], $div_format['decimal'], $div_format['thousands']);
            $carrito_c[$row['unique']]['neto'] = number_format($row['neto'], $div_format['precision'], $div_format['decimal'], $div_format['thousands']);
            $carrito_c[$row['unique']]['total'] = number_format($row['total'], $div_format['precision'], $div_format['decimal'], $div_format['thousands']);
        }

        return [
            'articulos_cantidad'    => round($_SESSION["$_nombre_carrito_$id_cliente"]['articulos_cantidad'] ?? 0, 2),
            'subtotal'              => number_format($_SESSION["$_nombre_carrito_$id_cliente"]['subtotal'] ?? 0, $div_format['precision'], $div_format['decimal'], $div_format['thousands']),
            'descuento'             => round($_SESSION["$_nombre_carrito_$id_cliente"]['descuento'] ?? 0, 2),
            'neto'                  => number_format($_SESSION["$_nombre_carrito_$id_cliente"]['neto'] ?? 0, $div_format['precision'], $div_format['decimal'], $div_format['thousands']),
            'iva'                   => number_format($_SESSION["$_nombre_carrito_$id_cliente"]['iva'] ?? 0, $div_format['precision'], $div_format['decimal'], $div_format['thousands']),
            'total'                 => number_format($_SESSION["$_nombre_carrito_$id_cliente"]['total'] ?? 0, $div_format['precision'], $div_format['decimal'], $div_format['thousands']),
            'carrito'               => array_reverse($carrito_c)
        ];
    }

    private function obtenerDescuentoMasIvaProducto(float $precio, float $iva, string $tipo_tarifa, float $tarifa)
    {
        $ivam = $precio * ($iva / 100);

        if ($tarifa > 0) {
            $precio = TarifasControlador::aplicar(null, $precio, $tipo_tarifa, $tarifa, 0,$ivam); //DESCUENTO PRODUCTO
        }

        $ivam = $precio * ($iva / 100);

        return [
            'iva' => $ivam,
            'neto' => $precio,
            'total' => $precio + $ivam,
        ];
    }

    public function obtenerPrecioSegunDivisa(float $precio, int $id_divisa_master, int $id_divisa_buscada)
    {
        $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($id_divisa_master, $id_divisa_buscada);

        if ($divisa_factor) {
            $precio *= $divisa_factor['df_factor'];
            $factor = $divisa_factor['df_factor'];
        } else {
            $factor = 1;
        }

        return [
            'precio' => $precio,
            'factor' => $factor
        ];
    }

    public function obtenerPrecioSegunDivisaFactorProducto(string $serial,  float $precio, int $id_divisa_master, int $id_divisa_buscada)
    {
        $divisa_factor = $this->carritoModel->obtenerDivisaAlCambioProducto($serial, $id_divisa_master, $id_divisa_buscada);

        if ($divisa_factor) {
            $precio *= $divisa_factor['bifac_factor'];
            $factor = $divisa_factor['bifac_factor'];
        } else {
            $factor = 1;
        }

        return [
            'precio' => $precio,
            'factor' => $factor
        ];
    }

    public function agregarProductoBarcode(string $tabla_db, string $_nombre_carrito_, int $id_cliente, string $producto, int $id_almacen, int $id_divisa, string $descuento_global, bool $chequear_stock = true, bool $caja = false)
    {
        if ($caja) {
            $producto = $this->carritoModel->buscarProductoBarcodeVentasCaja($id_almacen, $producto);
        } else {
            $producto = $this->carritoModel->buscarProductoBarcode($id_almacen, $producto);
        }

        $preciot = 0;
        $descuento_producto = 0.00;
        $stockno = [];

       $divisa   = Moneda::obtenerDivisa($id_divisa);
  
      if (!$producto || !$divisa)
            $this->array_errors[] = 'Producto o Divisa no disponibles';


        $modulo = new Module();

        $tarifas_clientes =  $this->carritoModel->consultar("SELECT * FROM app_clientes WHERE cli_id={$id_cliente}")->row();
        $permiso_tarifa = $modulo->has_module_action_permission('facturacion', 'agregar_tarifa', $_SESSION['user_data']['emp_id']);

        if ($producto){
            if ($tarifas_clientes && $permiso_tarifa && $producto) {
                $tarifas =  $this->carritoModel->consultar("SELECT * FROM app_tarifas WHERE tar_id={$tarifas_clientes['cli_gruptarid']}")->row();
                $tarifa_producto =  $this->carritoModel->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$producto['pro_id']} AND pt_tarid={$tarifas_clientes['cli_gruptarid']}")->row();
    
                if ($tarifa_producto) {
                    if ($tarifa_producto['pt_tarprecio'] > 0) {
                        $preciot = $tarifa_producto['pt_tarprecio'];
                    } else {
                        $preciot = $producto['pro_precio'];
                        $descuento_producto = $tarifas['tar_valorx'];
                    }
                } else {
                    $preciot = $producto['pro_precio'];
                }
            } else {
                $preciot = $producto['pro_precio'];
            }
        }

         if ($producto){
           $factor_producto = $this->carritoModel->obtenerProductoFactor($producto['pro_id']);
         }

        if ($tabla_db == 'app_factura_master' || $tabla_db == 'app_notas_de_entrega' || $tabla_db == 'app_pedidos' || $tabla_db == 'app_presupuesto' || $tabla_db == "app_orden_de_entrega") {
            if ($producto) {
                if ($producto['pro_impid'] != null){
                $imp_data = $this->carritoModel->obtenerImpuesto($producto['pro_impid']);
                }
            } else {
                $imp_data = $this->carritoModel->obtenerImpuesto(2);
            }
        } else {
            $imp_data = $this->carritoModel->obtenerImpuesto(2);
        }

      

       
        if ($_SESSION["$_nombre_carrito_$id_cliente"] != null) {
            if ($_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'] != $id_almacen)
                $this->array_errors[] = 'No puede seleccionar otro almacén diferente';
            if ($_SESSION["$_nombre_carrito_$id_cliente"]['divisa'] != $id_divisa)
                $this->array_errors[] = 'No puede seleccionar otra divisa diferente';
        }

           if ($producto){
                if ($producto['pro_tipo'] == 2) {
                    $productoCompuesto = new ProductosCompuestos();
        
                    $productoscomp = $productoCompuesto->obtenerProductosCompuesto($producto['pro_id']);
                    if (!$productoscomp) {
                        $this->array_errors[] = 'Error el producto compuesto ' . $producto['pro_descripcion'] . ' no tiene ningun producto';
                    }
                }
            }

        if ($divisa['id'] !== $this->divisa_master['id']) {
            $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($this->divisa_master['id'], $divisa['id']);
            if (!$divisa_factor)
                $this->array_errors[] = 'Lo siento no se encuentra el valor establecido para la conversión con la moneda predeterminada.';
        }

        if (empty($this->array_errors)) {

            $descuento_global = convertir_a_float($descuento_global);
            $unique = md5($producto['pro_id']);
            $seguir = true;

            if (isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {

                $id_divisa_master   = $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'];
                $precio             = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['precio'];
                $id_iva             = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['id_iva'];
                $iva                = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva'];
                $nombre             = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['nombre'];

                if ($producto['pro_tipo'] == 2) {
                    $productoCompuesto = new ProductosCompuestos();
                    $segui = [];
                    $productos = $productoCompuesto->obtenerProductosCompuesto($producto['pro_id']);

                    if (is_countable($productos) && count($productos)) {
                        foreach ($productos as $row) {
                            $producto['pro_costo'] =
                                $producto_stock = $this->carritoModel->verificarProductoEnStock($row['pro_ccproid'], $id_almacen);
                            if ($producto_stock) {
                                $cantidad = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['cantidad'] + 1;
                                $cant = $cantidad * $row['pro_cccant'];
                                if ($cant > $producto_stock['ps_cantidad']) {
                                    $segui[] = false;
                                    $stockno[] = ['producto' => $row['pro_descripcion']];
                                }
                            } else {
                                $segui[] = false;
                                $stockno[] = ['producto' => $row['pro_descripcion']];
                            }
                        }
                    }
                    if (in_array(false, $segui)) {
                        $seguir = false;
                    }
                }

                /*
                if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                    if ($chequear_stock) {
                        $producto_stock = $this->carritoModel->verificarProductoEnStock($producto['pro_id'], $id_almacen);
                        if ($producto_stock) {
                            $cantidad = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['cantidad'] + 1;
                            if ($cantidad > $producto_stock['ps_cantidad'])
                                $seguir = false;
                        } else {
                            $seguir = false;
                        }
                    }
                }*/
            } else {

                /*
                if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                    if ($chequear_stock) {
                        $producto_stock = $this->carritoModel->verificarProductoEnStock($producto['pro_id'], $id_almacen);
                        if ($producto_stock) {
                            if ($producto_stock['ps_cantidad'] > 0.00)
                                $seguir = false;
                        } else {
                            $seguir = false;
                        }
                    }
                }*/

                if ($producto['pro_tipo'] == 2) {
                    $productoCompuesto = new ProductosCompuestos();
                    $segui = [];
                    $productos = $productoCompuesto->obtenerProductosCompuesto($producto['pro_id']);

                    if (is_countable($productos) && count($productos)) {
                        foreach ($productos as $row) {
                            $producto_stock = $this->carritoModel->verificarProductoEnStock($row['pro_ccproid'], $id_almacen);
                            if ($producto_stock) {
                                $cant = $row['pro_cccant'];
                                if ($cant > $producto_stock['ps_cantidad']) {
                                    $segui[] = false;
                                    $stockno[] = ['producto' => $row['pro_descripcion']];
                                }
                            } else {
                                $segui[] = false;
                                $stockno[] = ['producto' => $row['pro_descripcion']];
                            }
                        }
                    }
                    if (in_array(false, $segui)) {
                        $seguir = false;
                    }
                }

                $id_divisa_master   = $this->divisa_master['id'];
                $precio             = $preciot;
                $id_iva             = $imp_data['imp_id'];
                $iva                = $imp_data['imp_valor'];
                $nombre             = $producto['pro_descripcion'];
            }

            if ($seguir == false) {
                if ($producto['pro_tipo'] == 2 && is_countable($stockno) && count($stockno)) {
                    foreach ($stockno as $row) {
                        $this->array_errors[] = 'El producto ' . $row['producto'] . ' del producto compuesto ha superado el limite de stock';
                    }
                } else {
                    $this->array_errors[] = 'Ha superado el limite de stock';
                }
            } else {

                if ($factor_producto) {
                    $precio = $this->obtenerPrecioSegunDivisaFactorProducto($factor_producto['profac_bifac_serial'], $precio, $id_divisa_master, $divisa['id']);
                    $costo  = $this->obtenerPrecioSegunDivisaFactorProducto($factor_producto['profac_bifac_serial'], $producto['pro_costo'], $id_divisa_master, $divisa['id']);
                    $costo_servicio = $this->obtenerPrecioSegunDivisaFactorProducto($factor_producto['profac_bifac_serial'], $producto['pro_precio'], $id_divisa_master, $divisa['id']);
                } else {
                    $precio = $this->obtenerPrecioSegunDivisa($precio, $id_divisa_master, $divisa['id']);
                    $costo  = $this->obtenerPrecioSegunDivisa($producto['pro_costo'], $id_divisa_master, $divisa['id']);
                    $costo_servicio = $this->obtenerPrecioSegunDivisa($producto['pro_precio'], $id_divisa_master, $divisa['id']);
                }

                $articulo = [
                    'id'                => $producto['pro_id'],
                    'codigo'            => $producto['pro_codigo'],
                    'nombre'            => $nombre,
                    'costo'             => ($producto['pro_tipo'] == 3) ? 0 : $costo['precio'],
                    'costo_servicio'    => ($producto['pro_tipo'] == 3) ? $costo_servicio['precio'] : 0,
                    'precio'            => $precio['precio'],
                    'id_iva'            => $id_iva,
                    'iva'               => $iva,
                    'id_almacen'        => $id_almacen,
                    'descuento'         => $descuento_producto,
                    'cantidad'          => 1.00,
                    'tipo'              => $producto['pro_tipo'],
                    'tarifa'            => ""
                ];

                $articulo['unique'] = $unique;

                $contenido_carrito = $this->contenidoCarrito($_nombre_carrito_, $id_cliente);

                if (!empty($contenido_carrito)) {
                    foreach ($contenido_carrito as $row) {
                        if ($row['id'] === $articulo['id']) {
                            $articulo['cantidad'] += $row['cantidad'];
                        }
                    }
                }

                $precio = $this->obtenerDescuentoMasIvaProducto(($articulo['cantidad'] * $articulo['precio']), $articulo['iva'], 'pvp', $descuento_producto);

                $articulo['iva_total']  = $precio['iva'];
                $articulo['neto']       = $precio['neto'];
                $articulo['total']      = $precio['total'];

                $_SESSION["$_nombre_carrito_$id_cliente"][$unique] = $articulo;
                $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'] = $id_divisa;
                $_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'] = $id_almacen;

                return $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global);
            }
        }

        return ['errors' => $this->array_errors];
    }

    public function agregarProducto(string $tabla_db, string $_nombre_carrito_, int $id_cliente, int $id_producto, int $id_almacen, int $id_divisa, string $descuento_global, bool $chequear_stock = true)
    {
        $producto = $this->carritoModel->obtenerProducto($id_producto);
        $factor_producto = $this->carritoModel->obtenerProductoFactor($id_producto);
        $divisa   = Moneda::obtenerDivisa($id_divisa);

        $preciot = 0;
        $descuento_producto = 0.00;
        $stockno = [];

        $modulo = new Module();

        $tarifas_clientes =  $this->carritoModel->consultar("SELECT * FROM app_clientes WHERE cli_id={$id_cliente}")->row();
        $permiso_tarifa = $modulo->has_module_action_permission('facturacion', 'agregar_tarifa', $_SESSION['user_data']['emp_id']);

        if ($tarifas_clientes && $permiso_tarifa) {
            $tarifas =  $this->carritoModel->consultar("SELECT * FROM app_tarifas WHERE tar_id={$tarifas_clientes['cli_gruptarid']}")->row();
            $tarifa_producto =  $this->carritoModel->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$id_producto} AND pt_tarid={$tarifas_clientes['cli_gruptarid']}")->row();

            if ($tarifa_producto) {
                if ($tarifa_producto['pt_tarprecio'] > 0) {
                    $preciot = $tarifa_producto['pt_tarprecio'];
                } else {
                    $preciot = $producto['pro_precio'];
                    $descuento_producto = $tarifas['tar_valorx'];
                }
            } else {
                $preciot = $producto['pro_precio'];
            }
        } else {
            $preciot = $producto['pro_precio'];
        }

        if ($tabla_db == 'app_factura_master' || $tabla_db == 'app_notas_de_entrega' || $tabla_db == 'app_pedidos' || $tabla_db == 'app_presupuesto' || $tabla_db == "app_orden_de_entrega") {
            if ($producto['pro_impid'] != null) {
                $imp_data = $this->carritoModel->obtenerImpuesto($producto['pro_impid']);
            } else {
                $imp_data = $this->carritoModel->obtenerImpuesto(2);
            }
        } else {
            $imp_data = $this->carritoModel->obtenerImpuesto(2);
        }

        if (!$producto || !$divisa)
            $this->array_errors[] = 'Producto o Divisa no disponibles';

        if ($_SESSION["$_nombre_carrito_$id_cliente"] != null) {
            if ($_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'] != $id_almacen)
                $this->array_errors[] = 'No puede seleccionar otro almacen diferente';
            if ($_SESSION["$_nombre_carrito_$id_cliente"]['divisa'] != $id_divisa)
                $this->array_errors[] = 'No puede seleccionar otra divisa diferente';
        }

        if ($producto['pro_tipo'] == 2) {
            $productoCompuesto = new ProductosCompuestos();

            $productoscomp = $productoCompuesto->obtenerProductosCompuesto($producto['pro_id']);
            if (!$productoscomp) {
                $this->array_errors[] = 'Error el producto compuesto ' . $producto['pro_descripcion'] . ' no tiene ningun producto';
            }
        }

        if ($divisa['id'] !== $this->divisa_master['id']) {
            $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($this->divisa_master['id'], $divisa['id']);
            if (!$divisa_factor)
                $this->array_errors[] = 'Lo siento no se encuentra el valor establecido para la conversión con la moneda predeterminada.';
        }

        if (empty($this->array_errors)) {

            $descuento_global = convertir_a_float($descuento_global);
            $unique = md5($producto['pro_id']);
            $seguir = true;

            if (isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {

                $id_divisa_master   = $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'];
                $precio             = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['precio'];
                $id_iva             = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['id_iva'];
                $iva                = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva'];
                $nombre             = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['nombre'];

                if ($producto['pro_tipo'] == 2) {
                    $productoCompuesto = new ProductosCompuestos();
                    $segui = [];
                    $productos = $productoCompuesto->obtenerProductosCompuesto($id_producto);

                    if (is_countable($productos) && count($productos)) {
                        foreach ($productos as $row) {
                            $producto_stock = $this->carritoModel->verificarProductoEnStock($row['pro_ccproid'], $id_almacen);
                            if ($producto_stock) {
                                $cantidad = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['cantidad'] + 1;
                                $cant = $cantidad * $row['pro_cccant'];
                                if ($cant > $producto_stock['ps_cantidad']) {
                                    $segui[] = false;
                                    $stockno[] = ['producto' => $row['pro_descripcion']];
                                }
                            } else {
                                $segui[] = false;
                                $stockno[] = ['producto' => $row['pro_descripcion']];
                            }
                        }
                    }
                    if (in_array(false, $segui)) {
                        $seguir = false;
                    }
                }

                /*
                if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                    if ($chequear_stock) {
                        $producto_stock = $this->carritoModel->verificarProductoEnStock($producto['pro_id'], $id_almacen);
                        if ($producto_stock) {
                            $cantidad = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['cantidad'] + 1;
                            if ($cantidad > $producto_stock['ps_cantidad'])
                                $seguir = false;
                        } else {
                            $seguir = false;
                        }
                    }
                }*/
            } else {

                /*
                if ($chequear_stock) {
                    if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                        $producto_stock = $this->carritoModel->verificarProductoEnStock($producto['pro_id'], $id_almacen);
                        if ($producto_stock) {
                            if (1 > $producto_stock['ps_cantidad'])
                                $seguir = false;
                        } else {
                            $seguir = false;
                        }
                    }
                }*/

                if ($producto['pro_tipo'] == 2) {
                    $productoCompuesto = new ProductosCompuestos();
                    $segui = [];
                    $productos = $productoCompuesto->obtenerProductosCompuesto($id_producto);

                    if (is_countable($productos) && count($productos)) {
                        foreach ($productos as $row) {
                            $producto_stock = $this->carritoModel->verificarProductoEnStock($row['pro_ccproid'], $id_almacen);
                            if ($producto_stock) {
                                $cant = $row['pro_cccant'];
                                if ($cant > $producto_stock['ps_cantidad']) {
                                    $segui[] = false;
                                    $stockno[] = ['producto' => $row['pro_descripcion']];
                                }
                            } else {
                                $segui[] = false;
                                $stockno[] = ['producto' => $row['pro_descripcion']];
                            }
                        }
                    }

                    if (in_array(false, $segui)) {
                        $seguir = false;
                    }
                }

                $id_divisa_master   = $this->divisa_master['id'];
                $precio             = $preciot;

                $id_iva             = $imp_data['imp_id'];
                $iva                = $imp_data['imp_valor'];
                $nombre             = $producto['pro_descripcion'];
            }

            if ($seguir == false) {
                if ($producto['pro_tipo'] == 2 && is_countable($stockno) && count($stockno)) {
                    foreach ($stockno as $row) {
                        $this->array_errors[] = 'El producto ' . $row['producto'] . ' del producto compuesto ha superado el limite de stock';
                    }
                } else {
                    $this->array_errors[] = 'Ha superado el limite de stock';
                }
            } else {

                if ($factor_producto) {
                    $precio = $this->obtenerPrecioSegunDivisaFactorProducto($factor_producto['profac_bifac_serial'], $precio, $id_divisa_master, $divisa['id']);
                    $costo  = $this->obtenerPrecioSegunDivisaFactorProducto($factor_producto['profac_bifac_serial'], $producto['pro_costo'], $id_divisa_master, $divisa['id']);
                    $costo_servicio = $this->obtenerPrecioSegunDivisaFactorProducto($factor_producto['profac_bifac_serial'], $producto['pro_precio'], $id_divisa_master, $divisa['id']);
                } else {
                    $precio = $this->obtenerPrecioSegunDivisa($precio, $id_divisa_master, $divisa['id']);
                    $costo  = $this->obtenerPrecioSegunDivisa($producto['pro_costo'], $id_divisa_master, $divisa['id']);
                    $costo_servicio = $this->obtenerPrecioSegunDivisa($producto['pro_precio'], $id_divisa_master, $divisa['id']);
                }

                $articulo = [
                    'id'                => $producto['pro_id'],
                    'codigo'            => $producto['pro_codigo'],
                    'nombre'            => $nombre,
                    'costo'             => ($producto['pro_tipo'] == 3) ? 0 : $costo['precio'],
                    'costo_servicio'    => ($producto['pro_tipo'] == 3) ? $costo_servicio['precio'] : 0,
                    'precio'            => $precio['precio'],
                    'id_iva'            => $id_iva,
                    'iva'               => $iva,
                    'id_almacen'        => $id_almacen,
                    'descuento'         => $descuento_producto,
                    'cantidad'          => 1.00,
                    'tipo'              => $producto['pro_tipo'],
                    'tarifa'            => ""
                ];

                $articulo['unique'] = $unique;

                $contenido_carrito = $this->contenidoCarrito($_nombre_carrito_, $id_cliente);

                if (!empty($contenido_carrito)) {
                    foreach ($contenido_carrito as $row) {
                        if ($row['id'] === $articulo['id']) {
                            $articulo['cantidad'] += $row['cantidad'];
                        }
                    }
                }

                $precio = $this->obtenerDescuentoMasIvaProducto(($articulo['cantidad'] * $articulo['precio']), $articulo['iva'], 'pvp', $descuento_producto);

                $articulo['iva_total']  = $precio['iva'];
                $articulo['neto']       = $precio['neto'];
                $articulo['total']      = $precio['total'];

                $_SESSION["$_nombre_carrito_$id_cliente"][$unique] = $articulo;
                $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'] = $id_divisa;
                $_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'] = $id_almacen;

                return $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global);
            }
        }

        return ['errors' => $this->array_errors];
    }

    public function actualizarPrecio(string $_nombre_carrito_, int $id_cliente, string $unique, string $precio, string $descuento_global)
    {
        if (!isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {
            $this->array_errors[] = 'Acción prohibida';
        } else {

            $precio = convertir_a_float($precio);
            $descuento_global = convertir_a_float($descuento_global);
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['precio'] = $precio;
            $pc = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['cantidad'] * $precio;
            $precio = $this->obtenerDescuentoMasIvaProducto($pc, $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva'], 'pvp', $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['descuento']);
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva_total']   = $precio['iva'];
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['neto']        = $precio['neto'];
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['total']       = $precio['total'];

            return $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global);
        }

        return ['errors' => $this->array_errors];
    }

    public function actualizarPrecioTarifa(string $_nombre_carrito_, int $id_cliente, string $unique, int $id_producto, int $id_tarifa, string $descuento_global)
    {
        if (!isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {
            $this->array_errors[] = 'Acción prohibida';
        } else {

            $pro = $this->carritoModel->consultar("SELECT * FROM app_productos WHERE pro_id={$id_producto}")->row();
            $tarifas_productos = $this->carritoModel->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$id_producto} AND pt_tarid={$id_tarifa}")->row();
            $tarifa_data = $this->carritoModel->consultar("SELECT * FROM app_tarifas WHERE tar_id={$id_tarifa}")->row();
            $imp = $this->carritoModel->obtenerImpuesto($pro['pro_impid']);
            if ($tarifas_productos) {
                $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                if ($monto_tarifa > 0) {
                    $precio_total = $monto_tarifa;
                } else {
                    $iv = ($pro['pro_precio'] * ($imp['imp_valor'] / 100));
                    $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iv);
                }

                $precio = convertir_a_float($precio_total);
               
                $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($this->divisa_master['id'], $_SESSION["$_nombre_carrito_$id_cliente"]['divisa']);

                if ($divisa_factor) {
                    $precio *= $divisa_factor['df_factor'];
                    $factor = $divisa_factor['df_factor'];
                } else {
                    $factor = 1;
                }

                $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['precio'] = $precio;
                $pc = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['cantidad'] * $precio;
                $precio = $this->obtenerDescuentoMasIvaProducto($pc, $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva'], 'pvp', $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['descuento']);
                $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva_total']   = $precio['iva'];
                $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['neto']        = $precio['neto'];
                $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['total']       = $precio['total'];
                $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['tarifa']      = $tarifa_data['tar_nombre'];
                return  $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global);
            }
        }
    }

    public function actualizarCantidad(string $_nombre_carrito_, int $id_cliente, int $id_producto, float $cantidad, string $descuento_global, bool $chequear_stock = true)
    {
        $producto = $this->carritoModel->obtenerProducto($id_producto);

        if (!$producto)
            $this->array_errors[] = 'Producto no disponible';

        if (empty($this->array_errors)) {

            $unique = md5($id_producto);
            $seguir = false;
            $stockno = [];

            $cantidad = $cantidad;

            if (!isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {
                $this->array_errors[] = 'Producto no disponible';
            } else {

                if ($producto['pro_tipo'] != 3) {
                    if ($producto['pro_nostock'] == 0) {
                        if ($producto['pro_tipo'] == 2) {
                            if ($chequear_stock) {
                                $producto_stockCompuesto = $this->carritoModel->verificarProductoEnStock($id_producto, $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['id_almacen']);
                                if ($producto_stockCompuesto && $cantidad <= $producto_stockCompuesto['ps_cantidad']) {
                                    $productoCompuesto = new ProductosCompuestos();

                                    $productos = $productoCompuesto->obtenerProductosCompuesto($id_producto);

                                    $segui = [];
                                    if (is_countable($productos) && count($productos)) {
                                        foreach ($productos as $row) {
                                            $producto_stock = $this->carritoModel->verificarProductoEnStock($row['pro_id'], $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['id_almacen']);
                                            if ($producto_stock) {
                                                $cant = convertir_a_float($cantidad * $row['pro_cccant']);
                                                if ($producto_stock && ($cant <= $producto_stock['ps_cantidad'])) {
                                                    $segui[] = true;
                                                } else {
                                                    $segui[] = false;
                                                    $stockno[] = ['producto' => $row['pro_descripcion']];
                                                }
                                            }
                                        }
                                    }
                                    if (in_array(false, $segui)) {
                                        $seguir = false;
                                    } else {
                                        $seguir = true;
                                    }
                                }
                            } else {
                                $seguir = true;
                            }
                        } else {
                            if ($chequear_stock) {
                                $producto_stock = $this->carritoModel->verificarProductoEnStock($id_producto, $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['id_almacen']);
                                if ($producto_stock && $cantidad <= $producto_stock['ps_cantidad']) {
                                    $seguir = true;
                                }
                            } else {
                                $seguir = true;
                            }
                        }
                    } else {
                        $seguir = true;
                    }
                } else {
                    $seguir = true;
                }

                if ($seguir == false) {
                    if ($producto['pro_tipo'] == 2 && is_countable($stockno) && count($stockno)) {
                        foreach ($stockno as $row) {
                            $this->array_errors[] = 'El producto ' . $row['producto'] . ' del producto compuesto ha superado el limite de stock';
                        }
                    } else {
                        $this->array_errors[] = 'Ha superado el limite de stock';
                    }
                } else {
                    $descuento_global = convertir_a_float($descuento_global);
                    $pc = $cantidad * $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['precio'];
                    $precio = $this->obtenerDescuentoMasIvaProducto($pc, $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva'], 'pvp', $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['descuento']);
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['cantidad']    = $cantidad;
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva_total']   = $precio['iva'];
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['neto']        = $precio['neto'];
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['total']       = $precio['total'];
                    return $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global);
                }
            }
        }

        return ['errors' => $this->array_errors];
    }

    public function actualizarDescripcion(string $_nombre_carrito_, int $id_cliente, string $unique, string $descripcion)
    {
        if (!isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {
            $this->array_errors[] = 'Producto no disponible';
        } else {
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['nombre'] = $descripcion;
            return true;
        }

        return ['errors' => $this->array_errors];
    }

    public function aplicarNuevoIva(string $_nombre_carrito_, int $id_cliente, string $unique, int $id_iva, string $descuento_global)
    {
        $iva = $this->carritoModel->obtenerImpuesto($id_iva);

        if (!$iva) {
            $this->array_errors[] = 'IVA no disponible';
        } else {
            if (!isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {
                $this->array_errors[] = 'Producto no disponible';
            } else {

                $descuento_global = convertir_a_float($descuento_global);
                $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['id_iva'] = $iva['imp_id'];
                $iva_total = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['neto'] * ($iva['imp_valor'] / 100);

                if ($iva['imp_valor'] > 0) {
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva']         = $iva['imp_valor'];
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva_total']   = $iva_total;
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['total']       = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['neto'] + $iva_total;
                } else {
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva']         = 0.00;
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva_total']   = 0.00;
                    $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['total']       = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['neto'];
                }

                return $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global);
            }
        }

        return ['errors' => $this->array_errors];
    }

    public function aplicarDescuentoProducto(string $_nombre_carrito_, int $id_cliente, string $unique, string $descuento, string $descuento_global)
    {
        if (!isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {
            $this->array_errors[] = 'Producto no disponible';
        } else {
            $descuento = convertir_a_float($descuento);
            $descuento_global = convertir_a_float($descuento_global);
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['descuento'] = $descuento;
            $precio_total = $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['cantidad'] * $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['precio'];
            $precio = $this->obtenerDescuentoMasIvaProducto($precio_total, $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva'], 'pvp', $descuento);
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['iva_total']   = $precio['iva'];
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['neto']        = $precio['neto'];
            $_SESSION["$_nombre_carrito_$id_cliente"][$unique]['total']       = $precio['total'];
            return $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global);
        }

        return ['errors' => $this->array_errors];
    }

    public function aplicarDescuentoAdicional(string $_nombre_carrito_, int $id_cliente, string $descuento_global)
    {
        $descuento = convertir_a_float($descuento_global);
        return $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento);
    }

    public function eliminarProducto(string $_nombre_carrito_, int $id_cliente, string $unique, string $descuento_global)
    {
        if (!isset($_SESSION["$_nombre_carrito_$id_cliente"][$unique])) {
            $this->array_errors[] = 'Producto no disponible';
        } else {
            $descuento_global = convertir_a_float($descuento_global);
            unset($_SESSION["$_nombre_carrito_$id_cliente"][$unique]);
            return $this->obtenerCarritoCliente($_nombre_carrito_, $id_cliente, $descuento_global);
        }

        return ['errors' => $this->array_errors];
    }

    public function editarDetallesCliente(int $id_cliente, array $data)
    {
        $cliente = new Cliente();

        if ($cliente->cedulaExiste($id_cliente, $data['dni']))
            $this->array_errors[] = 'Lo siento la cedula de identidad ya se encuentra asociada a otro cliente';

        if (empty($this->array_errors)) {
            return $cliente->editar($id_cliente, [
                'cli_tipodocid'     => $data['cli_tipodocid'],
                'cli_dni'           => $data['cli_dni'],
                'cli_razon_social'  => $data['cli_razon_social'],
                'cli_direccion'     => $data['cli_direccion'],
                'cli_paisid'        => $data['cli_paisid'],
                'cli_estado'        => $data['cli_estado'],
                'cli_ciudad'        => $data['cli_ciudad'],
                'cli_codpostal'     => $data['cli_codpostal']
            ]);
        }

        return ['errors' => $this->array_errors];
    }

    public function guardarVenta(string $tabla_db, string $_nombre_carrito_, int $id_cliente, int $id_serie, int $id_sucursal, string $fecha, string $observaciones, bool $descontar, int $agente, int $descuento_global, bool $caja = false)
    {
        $cliente            = $this->carritoModel->obtenerCliente($id_cliente);
        $serie              = $this->carritoModel->obtenerSerie($id_serie);
        $divisa_master      = Moneda::Predeterminada();
        $divisa_facturar    = Moneda::facturarPredeterminada();

        $total_prosimple        = 0;
        $total_proservicio      = 0;
        $cantidad_prosimple     = 0;
        $cantidad_proservicio   = 0;
        $iva_totalsimple = 0;
        $iva_totalservicio = 0;

        switch ($tabla_db) {
            case 'app_factura_master':
                $tipo_doc = 2;
                $tabla_master_id = 'fm_id';
                $tabla_db_articulos = 'app_factura_articulos';
                $uri = $caja ? 'facturacioncajaeditar/verFactura/' : 'poseditar/verFactura/';
                break;
            case 'app_notas_de_entrega':
                $tipo_doc = 1;
                $tabla_master_id = 'ne_id';
                $tabla_db_articulos = 'app_notas_de_entrega_articulos';
                $uri = $caja ? 'notasdeentregacajaeditar/verFactura/' : 'notasdeentregaeditar/verFactura/';
                break;
            case 'app_presupuesto':
                $tipo_doc = 3;
                $tabla_master_id = 'pre_id';
                $tabla_db_articulos = 'app_presupuesto_articulos';
                $uri = 'presupuestoeditar/verFactura/';
                break;
            case 'app_pedidos':
                $tipo_doc = 4;
                $tabla_master_id = 'pe_id';
                $tabla_db_articulos = 'app_pedidos_articulos';
                $uri = 'pedidoseditar/verFactura/';
                break;
            case 'app_orden_de_entrega':
                $tipo_doc = 12;
                $tabla_master_id = 'n_id';
                $tabla_db_articulos = 'app_orden_de_entrega_articulos';
                $uri = 'ordendeentregaeditar/verFactura/';
                break;
        }

        if ($agente == 0) {
            $agente = NULL;
        }

        $contenido_carrito = $this->contenidoCarrito($_nombre_carrito_, $id_cliente);

        $correlativo = $this->carritoModel->chuequearCorrelativo($id_serie, $tipo_doc);

        if (!$correlativo)
            return ['errors' => ['No existe correlativo entre la serie seleccionada y el documento por favor dirijase a Modulo Configuración -> correlativos']];

        foreach ($contenido_carrito as $row) {
            if ($row['precio'] == 0 || $row['total'] == 0) {
                $this->array_errors[] = "Lo siento el total del producto <strong>{$row['nombre']}</strong> no puede quedar en cero";
            }
        }

        //REALIZAR CONVERSION A DIVISA PREDETERMINADA PARA FACTURAR
        if (empty($this->array_errors) && $tabla_db == 'app_factura_master' && $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'] != $divisa_facturar['id']) {
            $result = $this->predeterminarDivisa('factura', $id_cliente, $divisa_facturar['id'], $descuento_global);
            if (isset($result['errors'])) {
                $this->array_errors[] = 'Error al convertir a la divisa predeterminada para facturar';
            }
            $contenido_carrito = $this->contenidoCarrito($_nombre_carrito_, $id_cliente);
        }

        if (empty($this->array_errors)) {

            if ($descontar) {
                foreach ($contenido_carrito as $row) {

                    $data_p = $this->carritoModel->obtenerProducto($row['id']);
                    if ($data_p['pro_nostock'] == 0 && $data_p['pro_tipo'] != 3) {
                        if ($data_p['pro_tipo'] == 2) {
                            $cantidadp = $this->carritoModel->chuequearStock($row['id'], $row['id_almacen']);
                            $productoCompuesto = new ProductosCompuestos();

                            $productos = $productoCompuesto->obtenerProductosCompuesto($row['id']);
                            if ($cantidadp) {
                                if ($cantidadp['ps_cantidad'] < $row['cantidad']) {
                                    $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                } else {
                                    if (is_countable($productos) && count($productos)) {
                                        foreach ($productos as $row2) {
                                            $cantidad = $this->carritoModel->chuequearStock($row2['pro_id'], $row['id_almacen']);
                                            if ($cantidad) {
                                                $cant = convertir_a_float($row['cantidad'] * $row2['pro_cccant']);
                                                if ($cantidad['ps_cantidad'] < $cant) {
                                                    $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row2['pro_nombrecorto']} supera la cantidad existente en Stock del producto compuesto";
                                                }
                                            } else {
                                                $this->array_errors[] = "Lo siento el producto {$row2['pro_nombrecorto']} no tiene existencia en el almacen seleccionado";
                                            }
                                        }
                                    }
                                }
                            } else {
                                $this->array_errors[] = "Lo siento el producto {$row['nombre']} no tiene existencia en el almacen seleccionado";
                            }
                        } else {
                            $cantidad = $this->carritoModel->chuequearStock($row['id'], $row['id_almacen']);
                            if ($cantidad) {
                                if ($cantidad['ps_cantidad'] < $row['cantidad']) {
                                    $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                }
                            } else {
                                $this->array_errors[] = "Lo siento el producto {$row['nombre']} no tiene existencia en el almacen seleccionado";
                            }
                        }
                    }
                }
            }

            if (empty($this->array_errors)) {

                $fecha = date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s');
                $factor = 1;
                $total_procosto = 0;
                $total_costo_servicio = 0;

                if ($divisa_master['id'] != $_SESSION["$_nombre_carrito_$id_cliente"]['divisa']) {
                    $factor_div = $this->carritoModel->obtenerDivisaAlCambio($_SESSION["$_nombre_carrito_$id_cliente"]['divisa'], $divisa_master['id']);
                    $factor = $factor_div['df_factor'];
                }

                switch ($tabla_db) {
                    case 'app_factura_master':
                        $data_form_master = [
                            'fm_subtotal'           => $_SESSION["$_nombre_carrito_$id_cliente"]['subtotal'],
                            'fm_descuento'          => $_SESSION["$_nombre_carrito_$id_cliente"]['descuento'],
                            'fm_neto'               => $_SESSION["$_nombre_carrito_$id_cliente"]['neto'],
                            'fm_iva'                => $_SESSION["$_nombre_carrito_$id_cliente"]['iva'],
                            'fm_total'              => $_SESSION["$_nombre_carrito_$id_cliente"]['total'],
                            'fm_articulos_total'    => $_SESSION["$_nombre_carrito_$id_cliente"]['articulos_cantidad'],
                            'fm_divid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                            'fm_almid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'],
                            'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                            'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                            'fm_serid'              => $serie['ser_id'],
                            'fm_serie'              => $serie['ser_descripcion'],
                            'fm_cliid'              => $cliente['cli_id'],
                            'fm_env_nombres'        => $cliente['cli_razon_social'],
                            'fm_env_direccion'      => $cliente['cli_direccion'],
                            'fm_env_pais'           => $cliente['cli_paisid'],
                            'fm_env_estado'         => $cliente['cli_estado'],
                            'fm_env_ciudad'         => $cliente['cli_ciudad'],
                            'fm_env_codigo_postal'  => $cliente['cli_codpostal'],
                            'fm_empagente'          => $agente,
                            'fm_fecha'              => $fecha,
                            'fm_observaciones'      => $observaciones,
                            'fm_estatus'            => 2,
                            'fm_empresaid'          => 1,
                            'fm_descontado'         => ($descontar) ? 1 : 0,
                            'factor'                => $factor,
                            'fm_surcid'             => $id_sucursal
                        ];
                        $data_form_articulos = [
                            'fa_fmid', 'fa_proid', 'fa_procodigo', 'fa_propnombre', 'fa_procosto',
                            'fa_costo_servicio', 'fa_proprecio', 'fa_procantidad', 'fa_prodescuento',
                            'fa_proneto', 'fa_idiva', 'fa_almid', 'fa_proiva', 'fa_ivatotal',
                            'fa_prototal', 'fa_descontar_inventario','fa_tarifa'
                        ];
                        break;
                    case 'app_notas_de_entrega':
                        $data_form_master = [
                            'ne_subtotal'           => $_SESSION["$_nombre_carrito_$id_cliente"]['subtotal'],
                            'ne_descuento'          => $_SESSION["$_nombre_carrito_$id_cliente"]['descuento'],
                            'ne_neto'               => $_SESSION["$_nombre_carrito_$id_cliente"]['neto'],
                            'ne_iva'                => $_SESSION["$_nombre_carrito_$id_cliente"]['iva'],
                            'ne_total'              => $_SESSION["$_nombre_carrito_$id_cliente"]['total'],
                            'ne_articulos_total'    => $_SESSION["$_nombre_carrito_$id_cliente"]['articulos_cantidad'],
                            'ne_divid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                            'ne_almid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'],
                            'ne_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                            'ne_correlativo'        => $correlativo['cor_correlativo'] + 1,
                            'ne_serid'              => $serie['ser_id'],
                            'ne_serie'              => $serie['ser_descripcion'],
                            'ne_cliid'              => $cliente['cli_id'],
                            'ne_env_nombres'        => $cliente['cli_razon_social'],
                            'ne_env_direccion'      => $cliente['cli_direccion'],
                            'ne_env_pais'           => $cliente['cli_paisid'],
                            'ne_env_estado'         => $cliente['cli_estado'],
                            'ne_env_ciudad'         => $cliente['cli_ciudad'],
                            'ne_env_codigo_postal'  => $cliente['cli_codpostal'],
                            'ne_empagente'          => $agente,
                            'ne_fecha'              => $fecha,
                            'ne_observaciones'      => $observaciones,
                            'ne_estatus'            => 2,
                            'ne_empresaid'          => 1,
                            'ne_descontado'         => ($descontar) ? 1 : 0,
                            'factor'                => $factor,
                            'ne_surcid'             => $id_sucursal
                        ];
                        $data_form_articulos = [
                            'neart_neid', 'neart_proid', 'neart_procodigo', 'neart_propnombre', 'neart_procosto',
                            'neart_costo_servicio', 'neart_proprecio', 'neart_procantidad', 'neart_prodescuento',
                            'neart_proneto', 'neart_idiva', 'neart_almid', 'neart_proiva', 'neart_ivatotal',
                            'neart_prototal', 'neart_descontar_inventario'
                        ];
                        break;
                    case 'app_presupuesto':
                        $data_form_master = [
                            'pre_subtotal'           => $_SESSION["$_nombre_carrito_$id_cliente"]['subtotal'],
                            'pre_descuento'          => $_SESSION["$_nombre_carrito_$id_cliente"]['descuento'],
                            'pre_neto'               => $_SESSION["$_nombre_carrito_$id_cliente"]['neto'],
                            'pre_iva'                => $_SESSION["$_nombre_carrito_$id_cliente"]['iva'],
                            'pre_total'              => $_SESSION["$_nombre_carrito_$id_cliente"]['total'],
                            'pre_articulos_total'    => $_SESSION["$_nombre_carrito_$id_cliente"]['articulos_cantidad'],
                            'pre_divid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                            'pre_almid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'],
                            'pre_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                            'pre_correlativo'        => $correlativo['cor_correlativo'] + 1,
                            'pre_serid'              => $serie['ser_id'],
                            'pre_serie'              => $serie['ser_descripcion'],
                            'pre_cliid'              => $cliente['cli_id'],
                            'pre_env_nombres'        => $cliente['cli_razon_social'],
                            'pre_env_direccion'      => $cliente['cli_direccion'],
                            'pre_env_pais'           => $cliente['cli_paisid'],
                            'pre_env_estado'         => $cliente['cli_estado'],
                            'pre_env_ciudad'         => $cliente['cli_ciudad'],
                            'pre_env_codigo_postal'  => $cliente['cli_codpostal'],
                            'pre_empagente'          => $agente,
                            'pre_fecha'              => $fecha,
                            'pre_observaciones'      => $observaciones,
                            'pre_estatus'            => 2,
                            'pre_empresaid'          => 1,
                            'pre_descontado'         => ($descontar) ? 1 : 0,
                            'pre_surcid'             => $id_sucursal
                        ];
                        $data_form_articulos = [
                            'preart_preid', 'preart_proid', 'preart_procodigo', 'preart_propnombre', 'preart_procosto',
                            'preart_costo_servicio', 'preart_proprecio', 'preart_procantidad', 'preart_prodescuento',
                            'preart_proneto', 'preart_idiva', 'preart_almid', 'preart_proiva', 'preart_ivatotal',
                            'preart_prototal', 'preart_descontar_inventario'
                        ];
                        break;
                    case 'app_pedidos':
                        $data_form_master = [
                            'pe_subtotal'           => $_SESSION["$_nombre_carrito_$id_cliente"]['subtotal'],
                            'pe_descuento'          => $_SESSION["$_nombre_carrito_$id_cliente"]['descuento'],
                            'pe_neto'               => $_SESSION["$_nombre_carrito_$id_cliente"]['neto'],
                            'pe_iva'                => $_SESSION["$_nombre_carrito_$id_cliente"]['iva'],
                            'pe_total'              => $_SESSION["$_nombre_carrito_$id_cliente"]['total'],
                            'pe_articulos_total'    => $_SESSION["$_nombre_carrito_$id_cliente"]['articulos_cantidad'],
                            'pe_divid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                            'pe_almid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'],
                            'pe_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                            'pe_correlativo'        => $correlativo['cor_correlativo'] + 1,
                            'pe_serid'              => $serie['ser_id'],
                            'pe_serie'              => $serie['ser_descripcion'],
                            'pe_cliid'              => $cliente['cli_id'],
                            'pe_env_nombres'        => $cliente['cli_razon_social'],
                            'pe_env_direccion'      => $cliente['cli_direccion'],
                            'pe_env_pais'           => $cliente['cli_paisid'],
                            'pe_env_estado'         => $cliente['cli_estado'],
                            'pe_env_ciudad'         => $cliente['cli_ciudad'],
                            'pe_env_codigo_postal'  => $cliente['cli_codpostal'],
                            'pe_empagente'          => $agente,
                            'pe_fecha'              => $fecha,
                            'pe_observaciones'      => $observaciones,
                            'pe_estatus'            => 2,
                            'pe_empresaid'          => 1,
                            'pe_descontado'         => ($descontar) ? 1 : 0,
                            'pe_surcid'             => $id_sucursal
                        ];
                        $data_form_articulos = [
                            'peart_peid', 'peart_proid', 'peart_procodigo', 'peart_propnombre', 'peart_procosto',
                            'peart_costo_servicio', 'peart_proprecio', 'peart_procantidad', 'peart_prodescuento',
                            'peart_proneto', 'peart_idiva', 'peart_almid', 'peart_proiva', 'peart_ivatotal',
                            'peart_prototal', 'peart_descontar_inventario'
                        ];
                        break;
                    case 'app_orden_de_entrega':
                        $data_form_master = [
                            'n_subtotal'           => $_SESSION["$_nombre_carrito_$id_cliente"]['subtotal'],
                            'n_descuento'          => $_SESSION["$_nombre_carrito_$id_cliente"]['descuento'],
                            'n_neto'               => $_SESSION["$_nombre_carrito_$id_cliente"]['neto'],
                            'n_iva'                => $_SESSION["$_nombre_carrito_$id_cliente"]['iva'],
                            'n_total'              => $_SESSION["$_nombre_carrito_$id_cliente"]['total'],
                            'n_articulos_total'    => $_SESSION["$_nombre_carrito_$id_cliente"]['articulos_cantidad'],
                            'n_divid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                            'n_almid'              => $_SESSION["$_nombre_carrito_$id_cliente"]['id_almacen'],
                            'n_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                            'n_correlativo'        => $correlativo['cor_correlativo'] + 1,
                            'n_serid'              => $serie['ser_id'],
                            'n_serie'              => $serie['ser_descripcion'],
                            'n_cliid'              => $cliente['cli_id'],
                            'n_env_nombres'        => $cliente['cli_razon_social'],
                            'n_env_direccion'      => $cliente['cli_direccion'],
                            'n_env_pais'           => $cliente['cli_paisid'],
                            'n_env_estado'         => $cliente['cli_estado'],
                            'n_env_ciudad'         => $cliente['cli_ciudad'],
                            'n_env_codigo_postal'  => $cliente['cli_codpostal'],
                            'n_empagente'          => $agente,
                            'n_fecha'              => $fecha,
                            'n_observaciones'      => $observaciones,
                            'n_estatus'            => 2,
                            'n_empresaid'          => 1,
                            'n_descontado'         => ($descontar) ? 1 : 0,
                            'factor'                => $factor,
                            'n_surcid'             => $id_sucursal
                        ];
                        $data_form_articulos = [
                            'nart_nid', 'nart_proid', 'nart_procodigo', 'nart_propnombre', 'nart_procosto',
                            'nart_costo_servicio', 'nart_proprecio', 'nart_procantidad', 'nart_prodescuento',
                            'nart_proneto', 'nart_idiva', 'nart_almid', 'nart_proiva', 'nart_ivatotal',
                            'nart_prototal', 'nart_descontar_inventario'
                        ];
                        break;
                }

                try {

                    $this->carritoModel->transactionBegin();

                    $id_venta = $this->carritoModel->guardar($data_form_master, false, $tabla_db);

                    $this->carritoModel->actualizarCorrelativo($serie['ser_id'], $tipo_doc);

                    foreach ($contenido_carrito as $row) {

                        $producto   = $this->carritoModel->obtenerProducto($row['id']);
                        $almacen    = $this->carritoModel->obtenerAlmacen($row['id_almacen']);
                        $cantidad   = $this->carritoModel->chuequearStock($row['id'], $row['id_almacen']);

                        if ($producto['pro_tipo'] == 2) {

                            $productoCompuesto = new ProductosCompuestos();

                            $productos = $productoCompuesto->obtenerProductosCompuesto($row['id']);

                            if (is_countable($productos) && count($productos)) {
                                foreach ($productos as $row1) {
                                    $row['costo'] += $row1['pro_costo'];
                                }
                            }
                        }

                        if($tabla_db=='app_factura_master'){
                            $this->carritoModel->guardar([
                                $data_form_articulos[0] => $id_venta,
                                $data_form_articulos[1] => $row['id'],
                                $data_form_articulos[2] => $row['codigo'],
                                $data_form_articulos[3] => $row['nombre'],
                                $data_form_articulos[4] => $row['costo'],
                                $data_form_articulos[5] => $row['costo_servicio'],
                                $data_form_articulos[6] => $row['precio'],
                                $data_form_articulos[7] => convertir_a_float($row['cantidad']),
                                $data_form_articulos[8] => $row['descuento'],
                                $data_form_articulos[9] => $row['precio']*$row['cantidad'],
                                $data_form_articulos[10] => $row['id_iva'],
                                $data_form_articulos[11] => $row['id_almacen'],
                                $data_form_articulos[12] => $row['iva'],
                                $data_form_articulos[13] => $row['iva_total'],
                                $data_form_articulos[14] => $row['total'],
                                $data_form_articulos[15] => 0,
                                $data_form_articulos[16] => $row['tarifa'],
                            ], true, $tabla_db_articulos);
                        }else{
                            $this->carritoModel->guardar([
                                $data_form_articulos[0] => $id_venta,
                                $data_form_articulos[1] => $row['id'],
                                $data_form_articulos[2] => $row['codigo'],
                                $data_form_articulos[3] => $row['nombre'],
                                $data_form_articulos[4] => $row['costo'],
                                $data_form_articulos[5] => $row['costo_servicio'],
                                $data_form_articulos[6] => $row['precio'],
                                $data_form_articulos[7] => convertir_a_float($row['cantidad']),
                                $data_form_articulos[8] =>  $row['descuento'],
                                $data_form_articulos[9] => $row['precio']*$row['cantidad'],
                                $data_form_articulos[10] => $row['id_iva'],
                                $data_form_articulos[11] => $row['id_almacen'],
                                $data_form_articulos[12] => $row['iva'],
                                $data_form_articulos[13] => $row['iva_total'],
                                $data_form_articulos[14] => $row['total'],
                                $data_form_articulos[15] => 0
                            ], true, $tabla_db_articulos);
                        }
                        

                        if ($producto['pro_tipo'] != 3 && $descontar) {

                            if ($producto['pro_tipo'] == 2) {

                                $productoCompuesto = new ProductosCompuestos();

                                $productos = $productoCompuesto->obtenerProductosCompuesto($row['id']);

                                if (is_countable($productos) && count($productos)) {
                                    foreach ($productos as $row1) {
                                        $cant = convertir_a_float($row['cantidad'] * $row1['pro_cccant']);
                                        $this->carritoModel->descontardeStock($row1['pro_id'], $row['id_almacen'], $cant);
                                        $cantidad   = $this->carritoModel->chuequearStock($row1['pro_id'], $row['id_almacen']);

                                        $this->carritoModel->guardar([
                                            'bsp_proid'     => $row1['pro_id'],
                                            'bsp_almacen'   => $almacen['alm_nombre'],
                                            'bsp_modulo'    => 'ventas',
                                            'bsp_empleado'  => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                            'bsp_habia'     => convertir_a_float($cantidad['ps_cantidad']) ?? 0,
                                            'bsp_sube'      => 0,
                                            'bsp_baja'      => $cant,
                                            'bsp_total'     => convertir_a_float(($cantidad['ps_cantidad'] ?? 0) - $cant),
                                            'bsp_facid'     => $correlativo['cor_correlativo'] + 1,
                                            'bsp_docid'     => $tipo_doc
                                        ], true, 'app_bitacora_stock_producto');

                                        $total_procosto     += $row1['pro_costo'] * $cant;
                                    }
                                }
                                //PRODUCTO COMPUESTO REGISTRO BITACORA
                                $cantidadP   = $this->carritoModel->chuequearStock($row['id'], $row['id_almacen']);
                                $this->carritoModel->descontardeStock($row['id'], $row['id_almacen'], $row['cantidad']);

                                $this->carritoModel->guardar([
                                    'bsp_proid'     => $row['id'],
                                    'bsp_almacen'   => $almacen['alm_nombre'],
                                    'bsp_modulo'    => 'ventas',
                                    'bsp_empleado'  => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                    'bsp_habia'     => convertir_a_float($cantidadP['ps_cantidad']) ?? 0,
                                    'bsp_sube'      => 0,
                                    'bsp_baja'      => convertir_a_float($row['cantidad']),
                                    'bsp_total'     => convertir_a_float(($cantidadP['ps_cantidad'] ?? 0) - $row['cantidad']),
                                    'bsp_facid'     => $correlativo['cor_correlativo'] + 1,
                                    'bsp_docid'     => $tipo_doc
                                ], true, 'app_bitacora_stock_producto');
                            } else {
                                $cantidad   = $this->carritoModel->chuequearStock($row['id'], $row['id_almacen']);
                                $this->carritoModel->descontardeStock($row['id'], $row['id_almacen'], $row['cantidad']);

                                $this->carritoModel->guardar([
                                    'bsp_proid'     => $row['id'],
                                    'bsp_almacen'   => $almacen['alm_nombre'],
                                    'bsp_modulo'    => 'ventas',
                                    'bsp_empleado'  => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                    'bsp_habia'     => convertir_a_float($cantidad['ps_cantidad']) ?? 0,
                                    'bsp_sube'      => 0,
                                    'bsp_baja'      => convertir_a_float($row['cantidad']),
                                    'bsp_total'     => convertir_a_float(($cantidad['ps_cantidad'] ?? 0) - $row['cantidad']),
                                    'bsp_facid'     => $correlativo['cor_correlativo'] + 1,
                                    'bsp_docid'     => $tipo_doc
                                ], true, 'app_bitacora_stock_producto');
                            }
                        }

                        if ($producto['pro_tipo'] == 1 || $producto['pro_tipo'] == 2) {
                            //PRODUCTO SIMPLE
                            //if ($producto['pro_tipo'] == 1) {
                            $total_procosto     += $row['costo'] * $row['cantidad'];
                            // }
                            $iva_totalsimple += $row['iva'];
                            $total_prosimple    += $row['neto'];
                            $cantidad_prosimple += convertir_a_float($row['cantidad']);
                        } else if ($producto['pro_tipo'] == 3) {
                            //SERVICIO
                            $total_costo_servicio   += $row['costo_servicio'] * $row['cantidad'];
                            $total_proservicio      += $row['neto'];
                            $iva_totalservicio += $row['iva'];
                            $cantidad_proservicio   += $row['cantidad'];
                        }
                    }

                    $this->carritoModel->editar($id_venta, [
                        'total_procosto' => $total_procosto,
                        'total_costo_servicio' => $total_costo_servicio,
                    ], $tabla_db, $tabla_master_id);

                    if (constant('EMP_FIGURA_AGENTE') == true) {

                        //REGISTRO DE COMISIONES POR AGENTE
                        if (!$caja && ($tabla_db == 'app_factura_master' || $tabla_db == 'app_notas_de_entrega')) {

                            $comisiones = $this->carritoModel->obtenerComisionesAgente($agente);

                            if (is_countable($comisiones) && count($comisiones)) {

                                //COM_ESTATUS (como aplica el porcentaje)
                                //1 general
                                //2 individual

                                foreach ($comisiones as $row_com) {
                                    if ($row_com['empagentipo_estatus'] == 1) {
                                        if (($row_com['com_tipo'] == 1 || $row_com['com_tipo'] == 2) && $cantidad_prosimple > 0) {
                                            //COMISION POR PRODUCTOS SIMPLES
                                            $temp_porcentaje = $row_com['com_estatus'] == 1 ? $row_com['com_porcentaje'] : $row_com['empagentipo_porcentaje'];
                                            if ($temp_porcentaje > 0) {
                                                $formula = 0;
                                                if ($row_com['com_formula'] == 1) {
                                                    $formula = ($total_prosimple - $total_procosto) * ($temp_porcentaje / 100);
                                                }
                                                if ($row_com['com_formula'] == 2) {
                                                    $formula = (($total_prosimple - $total_procosto) + $iva_totalsimple) * ($temp_porcentaje / 100);
                                                }
                                                if ($row_com['com_formula'] == 3) {
                                                    $formula = $total_prosimple * ($temp_porcentaje / 100);
                                                }

                                                $this->carritoModel->guardar([
                                                    'comagentefn_fnempagente' => $agente,
                                                    'comagentefn_com'         => $row_com['empagentipo_comid'],
                                                    'comagentefn_monto'       => $formula,
                                                    'comagentefn_divid'       => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                                                    'comagentefn_porcentaje'  => $temp_porcentaje,
                                                    'comagentefn_fnid'        => $id_venta,
                                                    'comagentefn_fntipo'      => $tipo_doc,
                                                    'comagentefn_fntotal'     => $total_prosimple,
                                                    'comagentefn_fncantidad'  => $cantidad_prosimple
                                                ], true, 'app_comisiones_agente_fn');
                                            }
                                        } elseif ($row_com['com_tipo'] == 3 && $cantidad_proservicio > 0) {
                                            //COMISION POR SERVICIOS
                                            $temp_porcentaje = $row_com['com_estatus'] == 1 ? $row_com['com_porcentaje'] : $row_com['empagentipo_porcentaje'];
                                            if ($temp_porcentaje > 0) {

                                                $formula = 0;
                                                if ($row_com['com_formula'] == 1) {
                                                    $formula = ($total_proservicio - $total_costo_servicio) * ($temp_porcentaje / 100);
                                                }
                                                if ($row_com['com_formula'] == 2) {
                                                    $formula = (($total_proservicio - $total_costo_servicio) + $iva_totalservicio) * ($temp_porcentaje / 100);
                                                }
                                                if ($row_com['com_formula'] == 3) {
                                                    $formula = $total_proservicio * ($temp_porcentaje / 100);
                                                }
                                                $this->carritoModel->guardar([
                                                    'comagentefn_fnempagente' => $agente,
                                                    'comagentefn_com'         => $row_com['empagentipo_comid'],
                                                    'comagentefn_monto'       => $formula,
                                                    'comagentefn_divid'       => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                                                    'comagentefn_porcentaje'  => $temp_porcentaje,
                                                    'comagentefn_fnid'        => $id_venta,
                                                    'comagentefn_fntipo'      => $tipo_doc,
                                                    'comagentefn_fntotal'     => $total_proservicio,
                                                    'comagentefn_fncantidad'  => $cantidad_proservicio
                                                ], true, 'app_comisiones_agente_fn');
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {

                        $comisiones = $this->carritoModel->obtenerEmpleadosComisionesFijasPorDocumento($tipo_doc);

                        if (is_countable($comisiones) && count($comisiones)) {

                            //COM_ESTATUS (como aplica el porcentaje)
                            //1 general
                            //2 individual

                            foreach ($comisiones as $row_com) {
                                if ($row_com['empagentipo_estatus'] == 1) {
                                    if (($row_com['com_tipo'] == 1 || $row_com['com_tipo'] == 2) && $cantidad_prosimple > 0) {
                                        //COMISION POR PRODUCTOS SIMPLES
                                        $temp_porcentaje = $row_com['com_estatus'] == 1 ? $row_com['com_porcentaje'] : $row_com['empagentipo_porcentaje'];
                                        if ($temp_porcentaje > 0) {

                                            $formula = 0;
                                            if ($row_com['com_formula'] == 1) {
                                                $formula = ($total_prosimple - $total_procosto) * ($temp_porcentaje / 100);
                                            }
                                            if ($row_com['com_formula'] == 2) {
                                                $formula = (($total_prosimple - $total_procosto) + $iva_totalsimple) * ($temp_porcentaje / 100);
                                            }
                                            if ($row_com['com_formula'] == 3) {
                                                $formula = $total_prosimple * ($temp_porcentaje / 100);
                                            }

                                            $this->carritoModel->guardar([
                                                'comagentefn_fnempagente' => $row_com['empagentipo_agente'],
                                                'comagentefn_com'         => $row_com['empagentipo_comid'],
                                                'comagentefn_monto'       => $formula,
                                                'comagentefn_divid'       => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                                                'comagentefn_porcentaje'  => $temp_porcentaje,
                                                'comagentefn_fnid'        => $id_venta,
                                                'comagentefn_fntipo'      => $tipo_doc,
                                                'comagentefn_fntotal'     => $total_prosimple,
                                                'comagentefn_fncantidad'  => $cantidad_prosimple
                                            ], true, 'app_comisiones_agente_fn');
                                        }
                                    } elseif ($row_com['com_tipo'] == 3 && $cantidad_proservicio > 0) {
                                        //COMISION POR SERVICIOS
                                        $temp_porcentaje = $row_com['com_estatus'] == 1 ? $row_com['com_porcentaje'] : $row_com['empagentipo_porcentaje'];
                                        if ($temp_porcentaje > 0) {

                                            $formula = 0;
                                            if ($row_com['com_formula'] == 1) {
                                                $formula = ($total_proservicio - $total_costo_servicio) * ($temp_porcentaje / 100);
                                            }
                                            if ($row_com['com_formula'] == 2) {
                                                $formula = (($total_proservicio - $total_costo_servicio) + $iva_totalservicio) * ($temp_porcentaje / 100);
                                            }
                                            if ($row_com['com_formula'] == 3) {
                                                $formula = $total_proservicio * ($temp_porcentaje / 100);
                                            }

                                            $this->carritoModel->guardar([
                                                'comagentefn_fnempagente' => $row_com['empagentipo_agente'],
                                                'comagentefn_com'         => $row_com['empagentipo_comid'],
                                                'comagentefn_monto'       => $formula,
                                                'comagentefn_divid'       => $_SESSION["$_nombre_carrito_$id_cliente"]['divisa'],
                                                'comagentefn_porcentaje'  => $temp_porcentaje,
                                                'comagentefn_fnid'        => $id_venta,
                                                'comagentefn_fntipo'      => $tipo_doc,
                                                'comagentefn_fntotal'     => $total_proservicio,
                                                'comagentefn_fncantidad'  => $cantidad_proservicio
                                            ], true, 'app_comisiones_agente_fn');
                                        }
                                    }
                                }
                            }
                        }
                    }

                    $this->carritoModel->transactionCommit();
                } catch (\Throwable $th) {
                    $this->carritoModel->transactionRollBack();
                    $this->array_errors[] = 'Error en transacción';
                }

                if (empty($this->array_errors)) {
                    return ruta_base() . $uri . $id_venta;
                }
            }
        }

        return ['errors' => $this->array_errors];
    }

    public function chquearAgente(int $id_cliente, int $id_agente, string $captado_form)
    {
        $newAgent = new EmpleadoAgente();

        $cliente = $this->carritoModel->obtenerCliente($id_cliente);
        $agente = $this->carritoModel->obtenerAgenteDelCliente($id_cliente);
        $comisiones = $this->carritoModel->obtenerComisiones($id_agente);

        if ($agente) {
            $captado = $agente['captado'];
            $tine_agente = true;
            $es_agente = $agente['agente'] == $id_agente ? true : false;
        } else {
            $captado = $captado_form;
            $tine_agente = false;
            $es_agente = false;
            $newAgent->guardar([
                'empagent_empid' => $id_agente,
                'empagent_clientid' => $id_cliente,
                'empagent_captado' => $captado_form,
                'empagent_fecha_registro' => $cliente['cli_fecha_reg'],
            ]);
        }

        $listComisiones = [];

        if (is_countable($comisiones) && count($comisiones)) {
            foreach ($comisiones as $row) {
                $listComisiones[] = [
                    'comision' => $row['empagentipo_comision'],
                    'descripcion' => $row['empagentipo_descripcion']
                ];
            }
        }

        return [
            'captado' => $captado,
            'tine_agente' => $tine_agente,
            'es_agente' => $es_agente,
            'comisiones' => $listComisiones
        ];
    }

    public function obtenerUbicacionesProducto(string $_nombre_carrito_, int $id_cliente)
    {
        $newProUbi = new ProductoUbicacion();
        $newAU = new AlmacenUbicacion();
        $tipo_de_escalon = [];
        $lista = [];
        $array_tipo = [
            'Zonas' => 'Zona',
            'Pasillos' => 'Pasillo',
            'Armarios' => 'Armario',
            'Secciones' => 'Sección',
            'Cajones' => 'Cajón'
        ];

        $contenido_carrito = $this->contenidoCarrito($_nombre_carrito_, $id_cliente);

        if (!empty($contenido_carrito)) {

            foreach ($contenido_carrito as $car) {

                $ubicacion = $newProUbi->obtenerubicacionProductoAlmacen($car['id'], $car['id_almacen']);

                if (is_countable($ubicacion) && count($ubicacion)) {

                    foreach ($ubicacion as $row) {

                        $tipo_de_escalon = [];
                        $padre = $row['au_padre'];

                        $tipo_de_escalon[] = [
                            'id' => $row['au_id'],
                            'tipo' => $array_tipo[$row['au_tipo']],
                            'descripcion' => $row['au_descripcion']
                        ];

                        while ($padre != 0) {
                            $escalon = $newAU->obtenerUbicacion($padre);
                            if ($escalon) {
                                $tipo_de_escalon[] = [
                                    'id' => $escalon['au_id'],
                                    'tipo' => $array_tipo[$escalon['au_tipo']],
                                    'descripcion' => $escalon['au_descripcion']
                                ];
                                $padre = $escalon['au_padre'];
                            } else {
                                $padre = 0;
                            }
                        }

                        $lista[] = [
                            'almacen' => [
                                'id' => $row['alm_id'],
                                'descripcion' => $row['alm_nombre']
                            ],
                            'producto' => [
                                'id' => $row['pro_id'],
                                'codigo' => $row['pro_codigo'],
                                'descripcion' => $row['pro_descripcion']
                            ],
                            'ubicacion' => $tipo_de_escalon
                        ];
                    }
                }
            }
        }

        return $lista;
    }

    public function obtenerDocumentosPendientesPorPagarPorCliente(int $id_cliente)
    {
        $array_factura = [];
        $array_notas = [];
        $array_ordenes = [];
        $ventas_pendientes = 0;
        $totales_divisas = [];
        $facturas_divisas = [];
        $facturas_divisas_id = [];
        $notas_divisas = [];
        $notas_divisas_id = [];
        $ordenes_divisas = [];
        $ordenes_divisas_id = [];
        $totales_divisas = [];
        $total_divisa_id = [];
        $total_p=0;

        $facturas = $this->carritoModel->obtenerFacturasPendientesClient($id_cliente);
        $notas = $this->carritoModel->obtenerNotasdeentregaPendienteClient($id_cliente);
        $ordenes = $this->carritoModel->obtenerOrdendeentregaPendienteClient($id_cliente);

        if (is_countable($facturas) && count($facturas)) {

            foreach ($facturas as $row) {

                $acumulado = $this->carritoModel->obtenerAcumuladofno($row['fm_id'], 2);
                $acumulado_total = ($acumulado['total']) ?? 0;

                $array_factura[] = [
                    'dni'           => $row['cli_dni'],
                    'nombrecompl'   => $row['cli_razon_social'],
                    'id'            => $row['fm_id'],
                    'correlativo'   => $row['fm_correlativo'],
                    'divisa'        => $row['div_nombre'],
                    'div_locale'    => $row['div_locale'],
                    'div_simbolo'   => $row['div_simbolo'],
                    'total'         => $row['fm_total'],
                    'estatus'       => $row['fm_estatus'],
                    'fecha'         => $row['fecha'],
                    'acumulado'     => $acumulado_total,
                    'pendiente'     => $row['fm_total'] - $acumulado_total
                ];

                $ventas_pendientes += 1;

                if (!in_array($row['div_id'], $facturas_divisas_id)) {
                    $facturas_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => round(($row['fm_total'] - $acumulado_total), 2),
                    ];
                    $facturas_divisas_id[] = $row['div_id'];
                } else {
                    $facturas_divisas[$row['div_id']]['total'] += $row['fm_total'] - $acumulado_total;
                }
            }
        }

        if (is_countable($notas) && count($notas)) {

            foreach ($notas as $row) {

                $acumulado = $this->carritoModel->obtenerAcumuladofno($row['ne_id'], 1);
                $acumulado_total = ($acumulado['total']) ?? 0;

                $array_notas[] = [
                    'dni'           => $row['cli_dni'],
                    'nombrecompl'   => $row['cli_razon_social'],
                    'id'            => $row['ne_id'],
                    'correlativo'   => $row['ne_correlativo'],
                    'divisa'        => $row['div_nombre'],
                    'div_locale'    => $row['div_locale'],
                    'div_simbolo'   => $row['div_simbolo'],
                    'total'         => $row['ne_total'],
                    'estatus'       => $row['ne_estatus'],
                    'fecha'         => $row['fecha'],
                    'acumulado'     => $acumulado_total,
                    'pendiente'     => $row['ne_total'] - $acumulado_total
                ];

                $ventas_pendientes += 1;

                if (!in_array($row['div_id'], $notas_divisas_id)) {
                    $notas_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['ne_total'] - $acumulado_total
                    ];
                    $notas_divisas_id[] = $row['div_id'];
                } else {
                    $notas_divisas[$row['div_id']]['total'] += $row['ne_total'] - $acumulado_total;
                }
            }
        }

        if (is_countable($ordenes) && count($ordenes)) {

            foreach ($ordenes as $row) {

                $acumulado = $this->carritoModel->obtenerAcumuladofno($row['n_id'], 12);
                $acumulado_total = ($acumulado['total']) ?? 0;

                $array_ordenes[] = [
                    'dni'           => $row['cli_dni'],
                    'nombrecompl'   => $row['cli_razon_social'],
                    'id'            => $row['n_id'],
                    'correlativo'   => $row['n_correlativo'],
                    'divisa'        => $row['div_nombre'],
                    'div_locale'    => $row['div_locale'],
                    'div_simbolo'   => $row['div_simbolo'],
                    'total'         => $row['n_total'],
                    'estatus'       => $row['n_estatus'],
                    'fecha'         => $row['fecha'],
                    'acumulado'     => $acumulado_total,
                    'pendiente'     => $row['n_total'] - $acumulado_total
                ];

                $ventas_pendientes += 1;

                if (!in_array($row['div_id'], $ordenes_divisas_id)) {
                    $ordenes_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['n_total'] - $acumulado_total
                    ];
                    $ordenes_divisas_id[] = $row['div_id'];
                } else {
                    $ordenes_divisas[$row['div_id']]['total'] += $row['n_total'] - $acumulado_total;
                }
            }
        }

        if (is_countable($facturas_divisas) && count($facturas_divisas)) {
            foreach ($facturas_divisas as $row) {
                if (!in_array($row['div_id'], $total_divisa_id)) {
                    $totales_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['total'],
                    ];
                    $total_divisa_id[] = $row['div_id'];
                } else {
                    $totales_divisas[$row['div_id']]['total'] += $row['total'];
                }
                if ($row['div_id'] !== $this->divisa_master['id']) {
                    $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($row['div_id'],$this->divisa_master['id']);
                    $factor = $divisa_factor['df_factor'];
                } else {
                    $factor = 1;
                }
                $total_p+=$row['total']*$factor;
            }
        }

        if (is_countable($notas_divisas) && count($notas_divisas)) {
            foreach ($notas_divisas as $row) {
                if (!in_array($row['div_id'], $total_divisa_id)) {
                    $totales_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['total'],
                    ];
                    $total_divisa_id[] = $row['div_id'];
                } else {
                    $totales_divisas[$row['div_id']]['total'] += $row['total'];
                }
                if ($row['div_id'] !== $this->divisa_master['id']) {
                    $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($row['div_id'],$this->divisa_master['id']);
                    $factor = $divisa_factor['df_factor'];
                } else {
                    $factor = 1;
                }
                $total_p+=$row['total']*$factor;
            }
        }

        if (is_countable($ordenes_divisas) && count($ordenes_divisas)) {
            foreach ($ordenes_divisas as $row) {
                if (!in_array($row['div_id'], $total_divisa_id)) {
                    $totales_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['total'],
                    ];
                    $total_divisa_id[] = $row['div_id'];
                } else {
                    $totales_divisas[$row['div_id']]['total'] += $row['total'];
                }
                if ($row['div_id'] !== $this->divisa_master['id']) {
                    $divisa_factor = $this->carritoModel->obtenerDivisaAlCambio($row['div_id'],$this->divisa_master['id']);
                    $factor = $divisa_factor['df_factor'];
                } else {
                    $factor = 1;
                }
                $total_p+=$row['total']*$factor;
            }
        }

        return [
            'facturas_pendiente'    => $array_factura,
            'total'                 => $total_p, 
            'notas_pendiente'       => $array_notas,
            'ordenes_pendientes'    => $array_ordenes,
            'totales_divisas_ord'   => $ordenes_divisas,
            'totales_divisas_fac'   => $facturas_divisas,
            'totales_divisas_not'   => $notas_divisas,
            'divisas_totales'       => $totales_divisas,
        ];
    }
}
