<?php

namespace Core\Helpers;

use App\Modelos\BitacoraProductos;
use App\Modelos\BitacoraStock;
use App\Modelos\Notificaciones;

final class Notifica
{
    private static $modulos = [
        'configuraciones', //0
        'empleados', //1
        'proveedores', //2
        'clientes', //3
        'productos', //4
        'ventas', //5
        'compras', //6
        'ingresos/egresos', //7
        'woocommerce', //8
        'servicios' //9
    ];

    public static function crearNotificacion(int $modulo, string $descripcion): bool
    {
        $newNotificacion = new Notificaciones();

        return $newNotificacion->guardar([
            'not_empid' => $_SESSION['user_data']['einfo_id'],
            'not_modulo' => self::$modulos[$modulo],
            'not_descripcion' => $descripcion
        ], true);
    }

    public static function producto(int $modulo, int $id_producto, string $descripcion): bool
    {
        $newBitocora = new BitacoraProductos();

        return $newBitocora->guardar([
            'bit_proid' => $id_producto,
            'bit_modulo' => self::$modulos[$modulo],
            'bit_empid' => $_SESSION['user_data']['einfo_id'],
            'bit_descripcion' => $descripcion
        ], true);
    }

    public static function stock(int $id_producto, string $almacen, string $modulo, float $habia, float $sube, float $baja, float $total, int $idfac = null, int $docid = null): bool
    {
        $newBitocora = new BitacoraStock();

        return $newBitocora->guardar([
            'bsp_proid' => $id_producto,
            'bsp_almacen' => $almacen,
            'bsp_modulo' => $modulo,
            'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
            'bsp_habia'  => $habia,
            'bsp_sube' => $sube,
            'bsp_baja' => $baja,
            'bsp_total' => $total,
            'bsp_facid' => $idfac,
            'bsp_docid' => $docid
        ], true);
    }
}
