<div class="container" id="AppWoocommerce" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Woocommerce</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('woocommerce') ?>">Woocommerce</a>
                </li>
            </ul>
        </div>
        <div class="row row-card-no-pd">
            <div class="col-sm-6 col-md-4">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-box-3 text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Productos</p>
                                    <h4 class="card-title">
                                        <i class="loader loader-success" v-if="loader_productos"></i>
                                        <span v-else>
                                            <button v-if="productos.length == 0" type="button" class="btn btn-icon btn-round" @click="obtenerProductos">
                                                <i class="fas fa-sync-alt"></i>
                                            </button>
                                            <span v-else>
                                                {{ productos.length }}
                                            </span>
                                        </span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-interface-6 text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Pedidos</p>
                                    <h4 class="card-title">
                                        <i class="loader loader-success" v-if="loader_pedidos"></i>
                                        <span v-else>
                                            <button v-if="pedidos.length == 0" type="button" class="btn btn-icon btn-round" @click="obtenerPedidos">
                                                <i class="fas fa-sync-alt"></i>
                                            </button>
                                            <span v-else>
                                                {{ pedidos.length }}
                                            </span>
                                        </span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-users text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Clientes</p>
                                    <h4 class="card-title">
                                        <i class="loader loader-success" v-if="loader_clientes"></i>
                                        <span v-else>
                                            <button v-if="clientes.length == 0" type="button" class="btn btn-icon btn-round" @click="obtenerClientes">
                                                <i class="fas fa-sync-alt"></i>
                                            </button>
                                            <span v-else>
                                                {{ clientes.length }}
                                            </span>
                                        </span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs mb-3 d-print-none" role="tablist">
                    <li class="nav-item">
                        <a href="#ListProducto" class="nav-link active" data-toggle="tab" role="tab" aria-controls="ListProducto">
                            <span class="d-none d-sm-inline-block">Productos</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#ListPedidos" class="nav-link" data-toggle="tab" role="tab" aria-controls="ListPedidos">
                            <span class="d-none d-sm-inline-block">Pedidos</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#ListClientes" class="nav-link" data-toggle="tab" role="tab" aria-controls="ListClientes">
                            <span class="d-none d-sm-inline-block">Clientes</span>
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="ListProducto" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table table-hover" id="tabla_productos">
                                <thead>
                                    <tr>
                                        <th class="text-left">#</th>
                                        <th class="text-left">Descripcion</th>
                                        <th class="text-left">Estatus</th>
                                        <th class="text-left">Precio</th>
                                        <th class="text-left">Total Ventas</th>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in productos">
                                        <td class="text-left">{{ row.sku }}</td>
                                        <td class="text-left">{{ row.name }}</td>
                                        <td class="text-left">{{ row.status }}</td>
                                        <td class="text-left">{{ moneda(row.price, divisa.locale, divisa.symbol, divisa.precision) }}</td>
                                        <td class="text-left">{{ row.total_sales }}</td>
                                        <td class="text-center">
                                            <button type="button" title="Sincronizar producto" class="btn btn-icon btn-round fas fa-sync-alt" @click="sincronizarPedido(row.id, $event)">
                                            </button>
                                        </td>
                                        <td class="text-center">
                                            <button type="button" :title="row.status == 'publish' ? 'Publico' : 'Privado'" :class="['btn btn-icon btn-round', (row.status == 'publish') ? 'fas fa-eye' : 'fas fa-eye-slash']" @click="publicarProducto(row.id, $event)">
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="ListPedidos" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table table-hover" id="tabla_pedidos">
                                <thead>
                                    <tr>
                                        <th class="text-left">Pedido</th>
                                        <th class="text-left">Cliente</th>
                                        <th class="text-left">Contacto</th>
                                        <th class="text-left">Fecha</th>
                                        <th class="text-left">Monto</th>
                                        <th class="text-left">Direccion</th>
                                        <th class="text-left">Nota</th>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(row, index) in pedidos">
                                        <td class="text-left">{{ row.id }} </td>
                                        <td class="text-left">{{ row.billing.first_name + ' ' + row.billing.last_name }}</td>
                                        <td class="text-left">{{ row.billing.phone }}</td>
                                        <td class="text-left">{{ row.date_created }}</td>
                                        <td class="text-left">{{ moneda(row.total, divisa.locale, divisa.symbol, divisa.precision) }}</td>
                                        <td class="text-left">{{ row.billing.address_1}}/{{ row.shipping.address_1}}</td>
                                        <td class="text-left">{{ row.customer_note}}</td>
                                        <td>
                                            <button type="button" title="Recibir pedido" class="btn btn-icon btn-round" @click="modalGuardar(row.id)">
                                                <i class="fas fa-clipboard-list"></i>
                                            </button>
                                        </td>
                                        <td>
                                            <button type="button" title="Ver pedido" class="btn btn-icon btn-round" @click="verPedido(index)">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="ListClientes" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table table-hover" id="tabla_clientes">
                                <thead>
                                    <tr>
                                        <th class="text-left">DNI</th>
                                        <th class="text-left">Email</th>
                                        <th class="text-left">Cliente</th>
                                        <th class="text-left">Direccion</th>
                                        <th class="text-left">Usuario</th>
                                        <th class="text-center">Opciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in clientes">
                                        <td class="text-left">{{ row.billing.company }}</td>
                                        <td class="text-left">{{ row.email }}</td>
                                        <td class="text-left">{{ row.first_name + ' ' + row.last_name }}</td>
                                        <td class="text-left">{{ row.billing.address_1 }}</td>
                                        <td class="text-left">{{ row.username }}</td>
                                        <td class="text-left">
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modalConvertirDocumento.php'; ?>
    <?php include 'modaldetallespedido.php'; ?>
</div>
<script src="<?= ruta_base() ?>public/assetsvuejs/woocommerce/index.js"></script>
