<div class="container" v-cloak id="appVentasCaja">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Ventas</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('ventascaja') ?>">Ventas</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <a href="#" class="btn btn-secondary btn-round btn-sm mr-2" data-toggle="modal" data-target="#modal-precio-global"> <span class="fas fa-question-circle"></span> Consultar Precio</a>
            </div>
        </div>
        <div class="row row-card-no-pd">
            <div class="col-12 col-md-2">
                <div class="nav flex-column nav-pills nav-secondary nav-pills-no-bd nav-pills-icons" role="tablist" aria-orientation="vertical">
                    <a class="nav-link active" data-toggle="pill" href="#Notasentrega" role="tab" aria-controls="Notasentrega" aria-selected="true" @click.prevent="obtenerNotasdeEntrega">
                        Notas de Entrega
                    </a>
                    <a class="nav-link " data-toggle="pill" href="#Facturas" role="tab" aria-controls="Facturas" aria-selected="false" @click.prevent="obtenerFacturas">
                        Facturas
                    </a>
                    <a class="nav-link " data-toggle="pill" href="#Cierre" role="tab" aria-controls="Cierre" aria-selected="false" @click.prevent="obtenerCierreDelDia">
                        Cierre del dia
                    </a>
                </div>
            </div>
            <div class="col-12 col-md-10">
                <div class="tab-content">
                    <div class="tab-pane fade " id="Facturas">
                        <div class="card" :class="cargando_tabla">
                            <div class="card-body" style="padding-top: 5px;">
                                <div class="d-flex align-items-left flex-column">
                                    <div class="nav-scroller d-flex">
                                        <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                            <a class="nav-link active" data-toggle="pill" href="#fac_pendientes" role="tab" aria-controls="fac_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;">Pendientes ({{ facturasNoPagas.length }})</a>
                                            <a class="nav-link " data-toggle="pill" href="#fac_pagas" role="tab" aria-controls="fac_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Pagas ({{ facturasPagas.length }})</a>
                                            <a class="nav-link" data-toggle="pill" href="#fac_anuladas" role="tab" aria-controls="fac_anuladas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Anuladas ({{ facturasAnuladas.length }})</a>
                                        </div>
                                        <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                            <a href="#" class="btn btn-info btn-border btn-round btn-sm" @click.prevent="modal_buscar_cliente('facturacioncaja')"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nueva Factura</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-content mt-4">
                                    <div class="tab-pane fade " id="fac_pagas">
                                        <div class="table-responsive">
                                            <table class="display  table table-striped table-hover dataTable" id="table_facturas_pagadas">
                                                <thead>
                                                    <tr>
                                                        <th class="text-left" style="width: 10%;">Código</th>
                                                        <th class="text-left" style="width: 30%;">Nombre del Cliente</th>
                                                        <th style="width: 20%;">Total</th>
                                                        <th>Fecha</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in facturasPagas">
                                                        <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="row.uri">{{ row.documento }}{{ row.correlativo }}</a></td>
                                                        <td class="text-left" style="width: 40%; font-size: 11px;">{{ row.cliente }}</td>
                                                        <td class="text-right" style="width: 20%; font-size: 12px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="font-size: 12px; width: 15%;">{{ fechaNormal(row.fecha) }}</td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade show active" id="fac_pendientes">
                                        <div class="table-responsive">
                                            <table class="display  table table-striped table-hover dataTable" id="table_facturas_pendientes">
                                                <thead>
                                                    <tr class="text-center">
                                                        <th style="width: 10%;">Código</th>
                                                        <th style="width: 30%;">Cliente</th>
                                                        <th>Acumulado</th>
                                                        <th>Pendiente</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in facturasNoPagas">
                                                        <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="row.uri">{{ row.documento }}{{ row.correlativo }}</a></td>
                                                        <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.cliente }}</td>
                                                        <td class="text-right" style="width: 12%;font-size: 11px;">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 12%;font-size: 11px;">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 12%;font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 10%;font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right" style="font-size: 12px;"></th>
                                                        <th class="text-right" style="font-size: 12px;"></th>
                                                        <th class="text-right" style="font-size: 12px;"></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="fac_anuladas">
                                        <div class="table-responsive">
                                            <table class="display  table table-striped table-hover dataTable" id="table_facturas_anuladas">
                                                <thead>
                                                    <tr class="text-center">
                                                        <th class="text-left" style="width: 10%;">Código</th>
                                                        <th class="text-left" style="width: 30%;">Nombre del Cliente</th>
                                                        <th>Acumulado</th>
                                                        <th>Pendiente</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in facturasAnuladas">
                                                        <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="row.uri">{{ row.documento }}{{ row.correlativo }}</a></td>
                                                        <td class="text-left" style="width: 35%; font-size: 11px;">{{ row.cliente }}</td>
                                                        <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 10%; font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade show active" id="Notasentrega">
                        <div class="card" :class="cargando_tabla">
                            <div class="card-body" style="padding-top: 5px;">
                                <div class="d-flex align-items-left flex-column">
                                    <div class="nav-scroller d-flex">
                                        <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                            <a class="nav-link active" data-toggle="pill" href="#notas_pendientes" role="tab" aria-controls="notas_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;">Pendientes ({{ notasdeentregaNoPagas.length }})</a>
                                            <a class="nav-link " data-toggle="pill" href="#notas_pagas" role="tab" aria-controls="notas_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Pagas ({{ notasdeentregaPagas.length }})</a>
                                            <a class="nav-link" data-toggle="pill" href="#notas_anuladas" role="tab" aria-controls="notas_anuladas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Anuladas ({{ notasdeentregaAnuladas.length }})</a>
                                        </div>
                                        <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                            <a href="#" class="btn btn-info btn-border btn-sm btn-round" @click.prevent="modal_buscar_cliente('notasdeentregacaja')"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nueva Nota de Entrega</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-content mt-4">
                                    <div class="tab-pane fade " id="notas_pagas">
                                        <div class="table-responsive">
                                            <table class="display  table table-striped table-hover dataTable" id="table_notasdeentrega_pagadas">
                                                <thead>
                                                    <tr class="text-center">
                                                        <th style="width: 10%;">Código</th>
                                                        <th style="width: 50%;">Nombre del Cliente</th>
                                                        <th style="width: 20%;">Total</th>
                                                        <th style="width: 10%;">Fecha</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in notasdeentregaPagas">
                                                        <td class="text-center" style="width: 10%; font-size:12px;"><a :href="row.uri">{{ row.documento }}{{ row.correlativo }}</a></td>
                                                        <td class="text-left" style="width: 50%; font-size:11px;">{{ row.cliente }}</td>
                                                        <td class="text-right" style="width: 20%; font-size:12px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="font-size:11px; width: 10%;">{{ fechaNormal(row.fecha) }}</td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade show active" id="notas_pendientes">
                                        <div class="table-responsive">
                                            <table class="display  table table-striped table-hover dataTable" id="table_notasdeentrega_pendientes">
                                                <thead>
                                                    <tr class="text-center">
                                                        <th>Código</th>
                                                        <th>Cliente</th>
                                                        <th>Acumulado</th>
                                                        <th>Pendiente</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in notasdeentregaNoPagas">
                                                        <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="row.uri">{{ row.documento }}{{ row.correlativo }}</a></td>
                                                        <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.cliente }}</td>
                                                        <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 10%;font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="notas_anuladas">
                                        <div class="table-responsive">
                                            <table class="display  table table-striped table-hover dataTable" id="table_notasdeentrega_anuladas">
                                                <thead>
                                                    <tr class="text-center">
                                                        <th>Código</th>
                                                        <th>Cliente</th>
                                                        <th>Acumulado</th>
                                                        <th>Pendiente</th>
                                                        <th>Total</th>
                                                        <th>Fecha</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in notasdeentregaAnuladas">
                                                        <td class="text-center" style="width: 10%; font-size:12px;"><a :href="row.uri">{{ row.documento }}{{ row.correlativo }}</a></td>
                                                        <td class="text-left" style="width: 35%; font-size:11px;">{{ row.cliente }}</td>
                                                        <td class="text-right" style="width: 15%; font-size:11px;">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 15%; font-size:11px;">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 15%; font-size:11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                        <td class="text-right" style="width: 10%; font-size:11px;">{{ fechaNormal(row.fecha) }}</td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>Total:</th>
                                                        <th></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th class="text-right"></th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade " id="Cierre">
                        <div class="row">
                            <div class="col-12">
                                <div class="card-body">
                                    <div class="card-title">Ingresos</div>
                                    <div class="table-responsive">
                                        <table class="table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>CUENTA</th>
                                                    <th>METODO</th>
                                                    <th>DIVISA</th>
                                                    <th>TOTAL</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="row in cierres_del_dia.positivo">
                                                    <td>{{ row.banco.alias }} </td>
                                                    <td>{{ row.banco.metodo }}</td>
                                                    <td>{{ row.div_nombre }}</td>
                                                    <td>{{ row.monto }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="row row-card-no-pd">
                                    <div class="col-sm-6 col-md-4" v-for="row in total_divisas_p">
                                        <div class="card card-stats card-round">
                                            <div class="card-body ">
                                                <div class="row">
                                                    <div class="col-3">
                                                        <div class="icon-big text-center">
                                                            <i class="flaticon-coins text-success"></i>
                                                        </div>
                                                    </div>
                                                    <div class="col-9 col-stats">
                                                        <div class="numbers">
                                                            <p class="card-category">{{ row.divisa.divisa }}</p>
                                                            <h4 class="card-title">
                                                                {{ moneda(row.total, row.divisa.locale, row.divisa.symbol) }}
                                                            </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="card-title">Egresos</div>
                                        <div class="table-responsive">
                                            <table class="table table-striped table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>CUENTA</th>
                                                        <th>METODO</th>
                                                        <th>DIVISA</th>
                                                        <th>TOTAL</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in cierres_del_dia.negativo">
                                                        <td>{{ row.banco.alias }} </td>
                                                        <td>{{ row.banco.metodo }}</td>
                                                        <td>{{ row.div_nombre }}</td>
                                                        <td>{{ row.monto }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="row row-card-no-pd">
                                    <div class="col-sm-6 col-md-4" v-for="row in total_divisas_n">
                                        <div class="card card-stats card-round">
                                            <div class="card-body ">
                                                <div class="row">
                                                    <div class="col-3">
                                                        <div class="icon-big text-center">
                                                            <i class="flaticon-coins text-success"></i>
                                                        </div>
                                                    </div>
                                                    <div class="col-9 col-stats">
                                                        <div class="numbers">
                                                            <p class="card-category">{{ row.divisa.divisa }}</p>
                                                            <h4 class="card-title">
                                                                {{ moneda(row.total, row.divisa.locale, row.divisa.symbol) }}
                                                            </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modalbuscarcliente.php'; ?>
</div>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<script src="<?= asset('assets/vue-select.js') ?>"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assets/moment.min.js') ?>"></script>
<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= asset('assetsvuejs/ventascaja/ventascaja.js') ?>"></script>
