<?php

namespace App\Controladores;

use App\Modelos\Variantes;
use Core\Controller;
use Core\Librerias\Http;
use Core\Vista;

final class VariantesControlador extends Controller
{
    private $variantes;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->variantes = new Variantes();
    }

    public function index()
    {
        return Vista::view('variantes/index', [
            'variantes' => $this->variantes->todos(),
        ]);
    }

    public function crear()
    {
        return Vista::view('variantes/crear');
    }
}
