<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TABAJADORES | <?= constant('DEFAULT_TITLE'); ?></title>
    <link rel="icon" href="<?= asset('assets/img/imageninsta.ico'); ?>" type="image/x-icon" />

    <link rel="stylesheet" href="<?= asset('assets/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="<?= asset('assets/micss/atlantis.css'); ?>">
    <link rel="stylesheet" href="<?= asset('assets/css/animate.min.css'); ?>">
    <link rel="stylesheet" href="<?= asset('assets/style.css'); ?>">

    <link rel="stylesheet" href="<?= asset('assets/DataTables/datatables.min.css') ?>">
    <style>
        @font-face {
            font-family: Lato;
            src: url(<?= asset("assets/Lato/Lato-Regular.ttf") ?>);
            font-weight: 400;
            font-style: normal;

        }

        @font-face {
            font-family: Lato;
            src: url(<?= asset("assets/Lato/Lato-Bold.ttf") ?>);
            font-weight: 700;
            font-style: normal;
        }

        body {
            font-family: Lato;
            font-style: normal;
            line-height: 1;
            text-decoration: inherit;
            text-rendering: optimizeLegibility;
            text-transform: none;
        }

        .trabajos {
            font-family: sans-serif !important;
            background: #f9fbfd;
            background-size: cover;
        }

        .section-box {
            float: right;
            width: 35%;
            height: 100vh;
        }

        .login-box {
            padding: 45px 20px 45px 20px;
            width: 375px;
            height: 90%;
            position: absolute;
            top: 5%;
            left: 65%;
            background: #1572E8;
            border-radius: 15px;
            box-shadow: 0px 0px 5px 5px rgb(229, 231, 252);
            text-align: center;
        }

        .card-header h4 {
            font-family: sans-serif !important;
            font-size: 18px !important;
            color: #fff;
            border-bottom: 3px solid #fff;
            width: 55%;
            margin-top: 5px;
            margin-left: 25%;
            padding: 20px;
        }

        .textbox {
            width: 70%;
            overflow: hidden;
            font-size: 20px;
            padding: 8px 0 4px 0;
            margin: 8px 0;
            margin-left: 15%;
            border-bottom: 1px solid #fff;
        }

        .textbox i {
            width: 26px;
            float: left;
            text-align: center;
            color: #fff;
            margin-right: 5px;
        }

        .textbox input {
            border: none;
            outline: none;
            background: none;
            color: #fff;
            font-size: 16px;
            width: 60%;
            float: left;
            margin-bottom: 5px;
        }

        .login-btn {
            width: 40%;
            background: transparent;
            font-family: sans-serif;
            border: 2px solid #fff;
            border-radius: 20px;
            color: #fff;
            padding: 5px;
            font-size: 12px;
            cursor: pointer;
            margin: 30px 20px 20px 25px;
            font-weight: bold;
        }

        .login-btn:hover {
            color: #1572E8;
            background: #fff;
        }

        ::placeholder {
            color: #fff;
        }

        .fondoderecho {
            float: left;
            width: 100%;
            margin-top: 150px;
            height: 500px;
            background: url(public/assets/img/imagen_login.jpg) no-repeat;
            background-size: cover;
            background-position: center;
        }

        .content {
            float: left;
            width: 100%;
            position: absolute;
            height: 100px;
            font-family: sans-serif !important;
            text-align: center;
            color: #6861CE !important;
            letter-spacing: 2px;
            border-radius: 5px;
            margin-top: 30px;
            padding: 5px;
        }

        .content>h2 {
            font-size: 2rem;
        }

        .content>h3 {
            color: #1572E8;
        }

        .logo {
            float: left;
            position: fixed;
            width: 150px;
            height: 45px;
            border-radius: 5px;
            left: 60%;
            top: 90%;
            padding: 5px;
            background: #6861CE;
            z-index: 1;
        }

        @media screen and (max-width: 986px) {
            .fondo {
                display: none;
            }
        }

        .login-brand {
            margin: 20px 0;
            margin-bottom: 20px;
            margin-bottom: 40px;
            font-size: 24px;
            text-transform: uppercase;
            letter-spacing: 4px;
            color: #666;
            text-align: center;
        }

        .login-brand {
            font-size: 24px;
            text-transform: uppercase;
            letter-spacing: 4px;
            color: #666;
            text-align: center;
        }

        .shadow-light {
            box-shadow: 0 2px 6px #e6ecf1;
        }

        .alert {
            color: #ffad46;
        }

        [v-cloak]>* {
            display: none
        }

        a {
            color: #1572e8;
        }

        .nav-tabs .nav-item.show .nav-link,
        .nav-tabs .nav-link.active {
            color: #fff;
            background-color: #1572e8;
            border-color: #dee2e6 #dee2e6 #fff;
        }

        /* Imagen mecanico */
        .mecanico-img {
            width: 100%;
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center center;
            min-height: 600px;
        }

        @media (max-width: 990px) {
            .mecanico-img {
                display: none;
            }
        }

        .card {
            box-shadow: 0 4px 8px rgba(47, 42, 42, 0.49);
        }
    </style>
    <script src="<?= asset('assets/js/core/jquery.3.2.1.min.js'); ?>"></script>
    <script src="<?= asset('assets/DataTables/datatables.min.js') ?>"></script>
    <script src="<?= asset('assets/js/plugin/webfont/webfont.min.js') ?>"></script>

    <script>
        WebFont.load({
            custom: {
                "families": ["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands"],
                urls: ['<?= asset("assets/css/fonts.min.css") ?>']
            },
            active: function() {
                sessionStorage.fonts = true;
            }
        });
    </script>
    <script src="<?= asset('assets/js/core/popper.min.js'); ?>"></script>
    <script src="<?= asset('assets/js/core/bootstrap.min.js'); ?>"></script>
    <script src="<?= asset('assets/js/plugin/bootstrap-notify/bootstrap-notify.min.js'); ?>"></script>
    <script src="<?= asset('assets/sweetalert2.all.min.js'); ?>"></script>
    <script>
        function notificacion(icono = 'fa fa-times', titulo = 'error', mensaje = 'Lo sentimos ha ocurrido un error porfavor intentelo de nuevo más tarde', tipo = 'danger') {
            $.notify({
                icon: icono,
                title: titulo,
                message: mensaje,
            }, {
                element: 'body',
                position: null,
                type: tipo,
                z_index: 4000,
            });
        }
    </script>
    <script src="<?= asset('assets/axios.min.js'); ?>"></script>
    <script>
        var baseURL = '<?= ruta_base(); ?>';
        var imgURL = '<?= constant('IMG_URI') ?>'
    </script>
    <script src="<?= asset('assets/funciones.js'); ?>"></script>
    <script src="<?= asset('assets/vue.js'); ?>"></script>
</head>


<body class="trabajos">
    <input type="hidden" id="id" value="<?= $_GET['id']; ?>">
    <input type="hidden" id="id2" value="<?= isset($_GET['id2']) ? $_GET['id2'] : 0; ?>">
    <div id="apptrabajos" v-cloak>
        <section class="section">
            <div class="container mt-4">
                <div class="row justify-content-center">
                    <div class="col-md-6 text-center">
                        <h2><strong class="text-danger">RESILCA RECTIFICADORA,CA</strong></h2>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-6" v-for="row in categorias">
                        <div class="card card-primary card-round text-white">
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="icon-big text-center" style="font-size: 43px;">
                                            <i class="flaticon-settings text-white"></i>
                                        </div>
                                    </div>
                                    <div class="col-8 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">TRABAJOS DISPONIBLES <small class="text-warning">{{row.cat_categorias}}</small></p>
                                            <h4 class="card-title text-white">
                                                {{row.servicios}}
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-md-12 col-lg-12">
                        <nav>
                            <div class="nav nav-tabs" role="tablist">
                                <a v-for="row in categorias" @click="updateCategoria(row.cat_id)" :class="(categoria==row.cat_id)?'nav-item nav-link active':'nav-item nav-link'" data-toggle="tab" :href="'#nav-cate'+row.cat_id" role="tab" :aria-controls="'nav-cate'+row.cat_id" aria-selected="true">{{row.cat_categorias}}</a>
                                <!--<a class="nav-item nav-link" data-toggle="tab" href="#nav-trabajo" role="tab" aria-controls="nav-trabajo" aria-selected="false" @click="modal_trabajo()">TRABAJOS PENDIENTE</a>
                                <a class="nav-item nav-link" data-toggle="tab" href="#nav-adicionales" role="tab" aria-controls="nav-adicionales" aria-selected="false" @click="modal_adicionales()">TRABAJOS ADICIONALES</a>-->
				<a class="nav-item nav-link" data-toggle="tab" href="#nav-barrenar" role="tab" aria-controls="nav-barrenar" aria-selected="false" v-if="categoria==2 || categoria==3"  @click="categoriasEmpleadoBarrenar()">BARRENAR</a>
	<a class="nav-item nav-link" data-toggle="tab" href="#nav-cepillar" role="tab" aria-controls="nav-cepillar" aria-selected="false" v-if="categoria==2 || categoria==3" @click="categoriasEmpleadoCepillar()">CEPILLAR</a>
                                <a class="nav-item nav-link"  @click="comision()" data-toggle="tab" href="#nav-comisiones" role="tab" aria-controls="nav-comisiones" aria-selected="false">COMISIONES PENDIENTE</a>
                            </div>
                        </nav>

                        <div style="color:#FFAD46;">
                            <?php echo session_mensaje(); ?>
                        </div>

                        <div class="tab-content mt-2">
                            <div class="tab-pane fade show active" :id="'nav-cate'+categoria" role="tabpanel" :aria-labelledby="'nav-cate'+categoria+'-tab'">
                                <div class="card card animate__animated animate__fadeInRight mt-2">
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="display table table-striped Datatable" :id="'table_categoria'+categoria">
                                                <thead>
                                                    <tr>
                                                        <td width="6%"><strong>#FICHA</strong></td>
                                                        <td width="8%"><strong>FECHA</strong></td>
                                                        <td width="30%"><strong>SERVICIO</strong></td>
                                                        <td width="8%"><strong>CANTIDAD</strong></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row1 in servicios">
                                                        <td width="6%"><a href="#" @click.prevent="modal_detalles(row1.pre_id,row1.pro_descripcion,row1.cat_id)">#{{row1.pre_correlativo}}</a></td>
                                                        <td width="8%">{{row1.n_fecha}}</td>
                                                        <td width="30%">{{row1.pro_descripcion}}
                                                            <a href="#" class="btn btn-outline-warning btn-round m-2" @click.prevent="modal_user(row1)">FINALIZADO</a>
                                                        <td width="8%">{{row1.preserv_cantidad}}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                             <div class="tab-pane fade" v-if="categoria2>0" :id="'nav-cate'+categoria2" role="tabpanel" :aria-labelledby="'nav-'+categoria2+'-tab'">
                                <div class="card card animate__animated animate__fadeInRight mt-2">
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="display table table-striped Datatable" :id="'table_categoria'+categoria2">
                                                <thead>
                                                    <tr>
                                                        <td width="6%"><strong>#FICHA</strong></td>
                                                        <td width="8%"><strong>FECHA</strong></td>
                                                        <td width="30%"><strong>SERVICIO</strong></td>
                                                        <td width="8%"><strong>CANTIDAD</strong></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row1 in servicios2">
                                                        <td width="6%"><a href="#" @click.prevent="modal_detalles(row1.pre_id,row1.pro_descripcion,row1.cat_id)">#{{row1.pre_correlativo}}</a></td>
                                                        <td width="8%">{{row1.n_fecha}}</td>
                                                        <td width="30%">{{row1.pro_descripcion}}
                                                            <a href="#" class="btn btn-outline-warning btn-round m-2" @click.prevent="modal_user(row1)">FINALIZADO</a>
                                                        <td width="8%">{{row1.preserv_cantidad}}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="nav-comisiones" role="tabpanel" aria-labelledby="nav-comisiones-tab">
                               <div class="card card animate__animated animate__fadeInRight mt-2">
                                    <div class="card-body">
                                        <form @submit.prevent="modal_comisiones()" id="form_proven_busqueda">
                                            <div class="form-row">
                                                <div class="col-sm-6">
                                                    <div class="form-group form-floating-label">
                                                        <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                                        <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="form-group input-group form-floating-label">
                                                        <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                                        <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                                                        <div class="input-group-append">
                                                            <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                                        {{ row }}
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-body">
                                        <div class="table-responsive" v-if="comisiones.length>0">
                                            <table class="display table table-striped Datatable" id="table_comisione">
                                                <thead>
                                                    <tr>
                                                        <td width="8%"><strong>FECHA</strong></td>
                                                        <td><strong>SERVICIO</strong></td>
                                                        <td width="8%"><strong>CANTIDAD</strong></td>
                                                        <td><strong>MONTO</strong></td>
                                                        <td><strong>PORCENTAJE</strong></td>
							 <td><strong>FICHA (ORDEN)</strong></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row1 in comisiones">
                                                        <td width="8%">{{row1.comagentefn_fecha}}</td>
                                                        <td>{{row1.pro_descripcion ==null ? row1.comagentefn_descripcion:row1.pro_descripcion}}</td>
                                                        <td width="8%">{{row1.comagentefn_fncantidad}}</td>
                                                        <td>{{row1.comagentefn_monto}} $</td>
                                                        <td>{{row1.comagentefn_porcentaje}} %</td>
                                                        <td>{{row1.pre_correlativo}} </td>
						    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th style="border-style:none !important;"></th>
                                                        <th class="text-right"><strong>TOTAL</strong></th>
                                                        <th class="text-left">{{comisionescantidad}}</th>
                                                        <th class="text-left">{{comisionestotal}} $</th>
                                                        <th style="border-style:none !important;"></th>
                                                        <th style="border-style:none !important;"></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                        <div class="text-center m-2" v-else>
                                            <h4>No tiene ninguna comision asignada o no ha iniciado sesion</h4>
                                            <i style="font-size: 2.2em;" class="fa fa-wrench"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
 <div class="tab-pane fade show active" id="nav-barrenar" role="tabpanel" aria-labelledby="nav-barrenar" v-if="categoria==2 || categoria==3">
                                <div class="card card animate__animated animate__fadeInRight mt-2">
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="display table table-striped Datatable" id="tabl_barrenar">
                                                <thead>
                                                    <tr>
                                                        <td width="6%"><strong>#FICHA</strong></td>
                                                        <td width="8%"><strong>FECHA</strong></td>
                                                        <td width="30%"><strong>SERVICIO</strong></td>
                                                        <td width="8%"><strong>CANTIDAD</strong></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row1 in barrenar">
                                                        <td width="6%"><a href="#" @click.prevent="modal_detalles(row1.pre_id,row1.pro_descripcion,row1.cat_id)">#{{row1.pre_correlativo}}</a></td>
                                                        <td width="8%">{{row1.n_fecha}}</td>
                                                        <td width="30%">{{row1.pro_descripcion}}
                                                            <a href="#" class="btn btn-outline-warning btn-round m-2" @click.prevent="modal_user(row1)">FINALIZADO</a>
                                                        <td width="8%">{{row1.preserv_cantidad}}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
<div class="tab-pane fade show active" id="nav-cepillar" role="tabpanel" aria-labelledby="nav-cepillar" v-if="categoria==2 || categoria==3">
                                <div class="card card animate__animated animate__fadeInRight mt-2">
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="display table table-striped Datatable" id="tabl_cepillar">
                                                <thead>
                                                    <tr>
                                                        <td width="6%"><strong>#FICHA</strong></td>
                                                        <td width="8%"><strong>FECHA</strong></td>
                                                        <td width="30%"><strong>SERVICIO</strong></td>
                                                        <td width="8%"><strong>CANTIDAD</strong></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row1 in cepillar">
                                                        <td width="6%"><a href="#" @click.prevent="modal_detalles(row1.pre_id,row1.pro_descripcion,row1.cat_id)">#{{row1.pre_correlativo}}</a></td>
                                                        <td width="8%">{{row1.n_fecha}}</td>
                                                        <td width="30%">{{row1.pro_descripcion}}
                                                            <a href="#" class="btn btn-outline-warning btn-round m-2" @click.prevent="modal_user(row1)">FINALIZADO</a>
                                                        <td width="8%">{{row1.preserv_cantidad}}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="nav-trabajo" role="tabpanel" aria-labelledby="nav-trabajo-tab">
                                <div class="card card animate__animated animate__fadeInRight mt-2">
                                    <div class="card-body">
                                        <div class="table-responsive" v-if="trabajos_asignados.length>0">
                                            <table class="display table table-striped Datatable" id="table_trabajos">
                                                <thead>
                                                    <tr>
                                                        <td width="6%"><strong>#FICHA</strong></td>
                                                        <td><strong>SERVICIO</strong></td>
                                                        <td width="8%"><strong>CANTIDAD</strong></td>
                                                        <td width="8%"><strong>MONTO</strong></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row1 in trabajos_asignados">
                                                        <td width="6%">#{{row1.correlativo}}</td>
                                                        <td width="8%">{{row1.servicio}}
                                                            <span v-if="row1.estatus==0" class="badge badge-warning m-2" @click="modal_estatus(row1)"><i class="fa fa-times"> PENDIENTE</i></span>
                                                            <span v-if="row1.estatus==2" class="badge badge-info m-2" @click="modal_estatus(row1)"><i class="fa fa-wrench"> EN PROCESO</i></span>
                                                            <span v-if="row1.estatus==1" class="badge badge-success m-2" @click="modal_estatus(row1)"><i class="fa fa-check"> FINALIZADO</i></span>
                                                        <td width="8%">{{row1.cantidad}}</td>
                                                        <td width="8%">{{row1.monto}} $</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="text-center m-2" v-else>
                                            <h4>No tiene ningun trabajo asignado o no ha iniciado sesion</h4>
                                            <i style="font-size: 2.2em;" class="fa fa-wrench"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="nav-adicionales" role="tabpanel" aria-labelledby="nav-adicionales-tab">
                                <div class="card card animate__animated animate__fadeInRight mt-2">
                                    <div class="card-body">
                                        <div class="table-responsive" v-if="trabajos_adicionales.length>0">
                                            <table class="display table table-striped Datatable" id="table_adicionales">
                                                <thead>
                                                    <tr>
                                                        <td><strong>SERVICIO</strong></td>
                                                        <td width="8%"><strong>CANTIDAD</strong></td>
                                                        <td><strong>MONTO</strong></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row1 in trabajos_adicionales">
                                                        <td>{{row1.servicio}}
                                                            <span v-if="row1.estatus==0" class="badge badge-warning m-2" @click="modal_estatusad(row1)"><i class="fa fa-times"> PENDIENTE</i></span>
                                                            <span v-if="row1.estatus==2" class="badge badge-info m-2" @click="modal_estatusad(row1)"><i class="fa fa-wrench"> EN PROCESO</i></span>
                                                            <span v-if="row1.estatus==1" class="badge badge-success m-2" @click="modal_estatusad(row1)"><i class="fa fa-check"> FINALIZADO</i></span>
                                                        </td>
                                                        <td>{{row1.cantidad}}</td>
                                                        <td>{{row1.monto}} $</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="text-center m-2" v-else>
                                            <h4>No hay ningun trabajo adicional</h4>
                                            <i style="font-size: 2.2em;" class="fa fa-wrench"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--<div class="col-md-12 col-lg-4 d-flex align-items-stretch">
                        <div class="mecanico-img" style="background-image: url('<?= ruta_base() ?>public/assets/img/meca.png');">

                        </div>
                    </div>-->
                </div>
            </div>
        </section>
        <?php include 'modal_user.php' ?>
        <?php include 'asignar_varios.php' ?>
        <?php include 'modal_trabajo.php' ?>
        <?php include 'modal_comisiones.php' ?>
        <?php include 'modal_estatus.php' ?>
        <?php include 'modal_adicionales.php' ?>

    </div>
</body>

</html>

<script src="<?= ruta_base() ?>public/assetsvuejs/trabajos/index.js"></script>
