<?php

namespace App\Controladores;

use App\Modelos\CarritoVentasModel;
use App\Modelos\Generico;
use App\Modelos\Motor;
use App\Modelos\PlanillaCategoriaEmpleado;
use App\Modelos\PlanillaOrdenDeEntrega;
use App\Modelos\PlanillaPreOrden;
use App\Modelos\PlanillaPreOrdenPartes;
use App\Modelos\PlanillaPreOrdenServicios;
use App\Modelos\PlanillaPreOrdenServiciosEmpleado;
use App\Modelos\PlanillaServAdicionales;
use Core\Librerias\Solicitud;
use Core\ManejadorSession;
use Core\Vista;
use Automattic\WooCommerce\Client;
use Automattic\WooCommerce\HttpClient\HttpClientException;
use Core\Helpers\Moneda;
use Core\Librerias\Http;
use Core\Librerias\Seguridad;
use DateTime;

final class TrabajosControlador
{

    private $array_errors = [];

    public function index()
    {
        $generico = new Generico();

        if ('GET' === $_SERVER['REQUEST_METHOD']) {
            $lista = [];
            if (isset($_GET['id2'])) {
                $lista = $generico->obtenerEmpleadosObrero2($_GET['id'], $_GET['id2']);
            } else {
                $lista = $generico->obtenerEmpleadosObrero($_GET['id']);
            }

            exit(Vista::viewAJAX('trabajos/index', [
                'id' => $_GET['id'],
                'empleados' => $lista
            ]));
        }
    }

    public function categoriasEmpleado(int $id)
    {

        if ('GET' === $_SERVER['REQUEST_METHOD']) {
            $categoria = new PlanillaPreOrdenServicios();

            $servicios = $categoria->consultar("SELECT DISTINCT apms.preserv_id, c.*,aps.*,ord.*,ap.*,pre.*,apms.* FROM app_preorden_master_servicios apms
            JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
            JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
            JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
            JOIN app_planilla_orden_de_entrega pl ON pl.po_preid=apms.preserv_preid 
            JOIN app_orden_de_entrega ord ON ord.n_id=pl.po_nid 
            JOIN app_preorden_master pre ON pre.pre_id=pl.po_preid 
            WHERE apms.preserv_estatus=0 AND (ord.n_estatus=4 OR ord.n_estatus=1 OR pl.po_estatus=1) AND ord.n_estatus!=3 AND pre.pre_estatus!=3 AND pre.pre_estatus!=4 AND aps.serv_catid={$id}")->all();

            $cate = $categoria->consultar("SELECT * FROM
             app_planilla_categorias
            WHERE cat_id={$id}")->all();

            Http::json_response([
                'servicios' => $servicios,
                'categorias' => $cate
            ]);
        }
    }

public function categoriasEmpleadoBarrenar()
    {

        if ('GET' === $_SERVER['REQUEST_METHOD']) {
            $categoria = new PlanillaPreOrdenServicios();

            $servicios = $categoria->consultar("SELECT DISTINCT apms.preserv_id, c.*,aps.*,ord.*,ap.*,pre.*,apms.* FROM app_preorden_master_servicios apms
            JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
            JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
            JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
            JOIN app_planilla_orden_de_entrega pl ON pl.po_preid=apms.preserv_preid 
            JOIN app_orden_de_entrega ord ON ord.n_id=pl.po_nid 
            JOIN app_preorden_master pre ON pre.pre_id=pl.po_preid 
            WHERE apms.preserv_estatus=0 AND (ord.n_estatus=4 OR ord.n_estatus=1 OR pl.po_estatus=1) AND ord.n_estatus!=3 AND pre.pre_estatus!=3 AND pre.pre_estatus!=4 AND aps.serv_catid=9")->all();

            $cate = $categoria->consultar("SELECT * FROM
             app_planilla_categorias
            WHERE cat_id=9")->all();

            Http::json_response([
                'servicios' => $servicios,
                'categorias' => $cate
            ]);
        }
    }

public function categoriasEmpleadoCepillar()
    {

        if ('GET' === $_SERVER['REQUEST_METHOD']) {
            $categoria = new PlanillaPreOrdenServicios();

            $servicios = $categoria->consultar("SELECT DISTINCT apms.preserv_id, c.*,aps.*,ord.*,ap.*,pre.*,apms.* FROM app_preorden_master_servicios apms
            JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
            JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
            JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
            JOIN app_planilla_orden_de_entrega pl ON pl.po_preid=apms.preserv_preid 
            JOIN app_orden_de_entrega ord ON ord.n_id=pl.po_nid 
            JOIN app_preorden_master pre ON pre.pre_id=pl.po_preid 
            WHERE apms.preserv_estatus=0 AND (ord.n_estatus=4 OR ord.n_estatus=1 OR pl.po_estatus=1) AND ord.n_estatus!=3 AND pre.pre_estatus!=3 AND pre.pre_estatus!=4 AND aps.serv_catid=10")->all();

            $cate = $categoria->consultar("SELECT * FROM
             app_planilla_categorias
            WHERE cat_id=10")->all();

            Http::json_response([
                'servicios' => $servicios,
                'categorias' => $cate
            ]);
        }
    }

    public function categorias()
    {

        if ('POST' === $_SERVER['REQUEST_METHOD']) {
            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $id2 = filter_input(INPUT_POST, 'id2', FILTER_SANITIZE_NUMBER_INT);
            $categoria = new PlanillaPreOrdenServicios();

            $lista = [];
            $servicio1 = [];
            $servicio2 = [];

            $servicio1 = $categoria->consultar("SELECT DISTINCT apms.preserv_id, c.*,aps.*,ord.*,ap.*,pre.*,apms.* FROM app_preorden_master_servicios apms
            JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
            JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
            JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
            JOIN app_planilla_orden_de_entrega pl ON pl.po_preid=apms.preserv_preid 
            JOIN app_orden_de_entrega ord ON ord.n_id=pl.po_nid 
            JOIN app_preorden_master pre ON pre.pre_id=pl.po_preid 
            WHERE apms.preserv_estatus=0 AND (ord.n_estatus=4 OR ord.n_estatus=1 OR pl.po_estatus=1) AND pre.pre_estatus!=3 AND ord.n_estatus!=3 AND pre.pre_estatus!=4 AND aps.serv_catid={$id}")->all();


            if ($id2 > 0) {

                $servicio2 = $categoria->consultar("SELECT DISTINCT apms.preserv_id, c.*,aps.*,ord.*,ap.*,pre.*,apms.* FROM app_preorden_master_servicios apms
                JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
                JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
                JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
                JOIN app_planilla_orden_de_entrega pl ON pl.po_preid=apms.preserv_preid 
                JOIN app_orden_de_entrega ord ON ord.n_id=pl.po_nid 
                JOIN app_preorden_master pre ON pre.pre_id=pl.po_preid 
                WHERE apms.preserv_estatus=0 AND (ord.n_estatus=4 OR ord.n_estatus=1 OR pl.po_estatus=1) AND pre.pre_estatus!=3 AND ord.n_estatus!=3 AND pre.pre_estatus!=4 AND aps.serv_catid={$id2}")->all();

                $cat = $categoria->consultar("SELECT * FROM
                app_planilla_categorias
               WHERE cat_id={$id}")->row();

                $lista[] = [
                    'cat_id' => $cat['cat_id'],
                    'cat_categorias' => $cat['cat_categorias'],
                    'servicios' => count($servicio1)
                ];

                $cat2 = $categoria->consultar("SELECT * FROM
                app_planilla_categorias
               WHERE cat_id={$id2}")->row();

                $lista[] = [
                    'cat_id' => $cat2['cat_id'],
                    'cat_categorias' => $cat2['cat_categorias'],
                    'servicios' => count($servicio2)
                ];
            } else {
                $cat = $categoria->consultar("SELECT * FROM
                app_planilla_categorias
               WHERE cat_id={$id}")->row();
                $lista[] = [
                    'cat_id' => $cat['cat_id'],
                    'cat_categorias' => $cat['cat_categorias'],
                    'servicios' => count($servicio1)
                ];
            }

            Http::json_response([
                'categorias' => $lista
            ]);
        }
    }

    public function asignarTrabajo()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_STRING);
            $clave = filter_input(INPUT_POST, 'clave', FILTER_SANITIZE_NUMBER_INT);
            $empleado   = filter_input(INPUT_POST, 'empleado', FILTER_SANITIZE_NUMBER_INT);

            $generico = new Generico();

            $usuario = $generico->getUserInfoDa($empleado);

            if (!isset($usuario['emp_id'])) {
                $this->array_errors[] = 'Usuario no encontrado';
            } else {
                if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                    $this->array_errors[] = 'Clave incorrecta';
                }
            }
            
            if (empty($this->array_errors)) {

                $servEmp = new PlanillaPreOrdenServiciosEmpleado();

                $data_servicio_orden = $generico->consultar("SELECT * FROM app_preorden_master_servicios WHERE preserv_id = $id")->row();

                if ($data_servicio_orden['preserv_estatus'] == 2)
                    Http::json_response(['errors' => ['Acción prohibida']]);

                if ($data_servicio_orden['preserv_estatus'] == 1) {
                    $data_ser_empleado = $servEmp->where(['preemp_preid' => $data_servicio_orden['preserv_preid'], 'preemp_preservid' => $id], true);
                    if ($data_ser_empleado && !is_null($data_ser_empleado['preemp_empid'])) {
                        $this->array_errors[] = 'Debe eliminar al empleado para cambiar el estatus';
                    }
                }

                if (empty($this->array_errors)) {
                    $empleado_serv = $servEmp->guardar([
                        'preemp_preid' => $data_servicio_orden['preserv_preid'],
                        'preemp_preservid' => $id,
                        'preemp_empid' => $empleado
                    ]);

                    if ($empleado_serv>0) {

                        $this->estatusServiciosEmpleados($empleado_serv);

                        $generico->editar($id, [
                            'preserv_estatus' => 1,
                        ], 'app_preorden_master_servicios', 'preserv_id');

                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    Http::json_response(false);
                }
            } else {
                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function obtenerPlanilla(){
        
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_orden = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $cat = filter_input(INPUT_POST, 'cate', FILTER_SANITIZE_NUMBER_INT);

			$lista_part = [];
			$lista_serv = [];
			$serv_categorias = [];
			$newMotor = new Motor();
            $newPreOrden = new PlanillaPreOrden();
			$newPreOrdenPartes = new PlanillaPreOrdenPartes();
			$newPreOrdenServicios = new PlanillaPreOrdenServicios();
			$newPlanillaOrden = new PlanillaOrdenDeEntrega();
			$newCatEmp = new PlanillaCategoriaEmpleado();
			$orden = $newPreOrden->obtenerPreOrden($id_orden);
			$motor = $orden['pre_motid'] ? $newMotor->obtenerMotor($orden['pre_motid']) : null;
			$partes = $newPreOrdenPartes->obtenerPartes($id_orden);

            $servicios = $newPreOrden->consultar("SELECT DISTINCT apms.preserv_id, c.*,aps.*,ord.*,ap.*,pre.*,apms.* FROM app_preorden_master_servicios apms
            JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
            JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
            JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
            JOIN app_planilla_orden_de_entrega pl ON pl.po_preid=apms.preserv_preid 
            JOIN app_orden_de_entrega ord ON ord.n_id=pl.po_nid 
            JOIN app_preorden_master pre ON pre.pre_id=pl.po_preid 
            WHERE apms.preserv_estatus=0 AND (ord.n_estatus=4 OR ord.n_estatus=1 OR pl.po_estatus=1) AND pre.pre_estatus!=3 AND ord.n_estatus!=3 AND pre.pre_estatus!=4 AND aps.serv_catid={$cat} AND pre.pre_id = {$id_orden}")->all();


            if (is_countable($partes) && count($partes)) {
				foreach ($partes as $row) {
					$lista_part[] = [
						'id' => $row['prepar_id'],
						'cantidad' => $row['prepar_cantidad'],
						'categoria' => $row['cat_categorias'],
						'ubicacion' => $row['prepar_ubicacion'],
						'observacion' => $row['prepar_observacion'],
						'parte' => $row['par_parte']
					];
				}
			}

            
            if (is_countable($servicios) && count($servicios)) {
				foreach ($servicios as $row) {
                    $lista_serv[] = [
						'preserv_id' => $row['preserv_id'],
						'preserv_cantidad' => $row['preserv_cantidad'],
						'pro_descripcion' => $row['pro_descripcion'],
						'checked' =>false,
                        'cat_id'=> $row['cat_id'],
					];
                }
            }

            Http::json_response([
				'orden' => $orden['pre_correlativo'],
				'observacion_repuestos' => $orden['pre_observacion_repuestos'],
				'fecha' => date('d-m-Y', strtotime($orden['pre_creado'])),
				'taller' => $orden['pre_taller'],
				'motor' => ($motor) ? $motor['mot_motor'] . ' - Marca: ' . $motor['m_marca'] . ' - Modelo: ' . $motor['mot_modelo'] : '',
				'emp_bajo_motor' => $orden['pre_empbajo_motor'],
				'emp_desarmo_motor' => $orden['pre_empdesarmo_motor'],
				'pre_emplficha' => $orden['pre_emplficha'],
				'cliente'=> $orden['cli_razon_social'].' ('.$orden['cli_dni'].')',
				'pre_observacion' => ($orden['pre_observacion'] != null) ? $orden['pre_observacion'] : '',
				'partes' => $lista_part,
                'servicios'=>$lista_serv
			]);
        }

    }

    public function obtenerTrabajosAsignados()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $clave = filter_input(INPUT_POST, 'clave', FILTER_SANITIZE_STRING);
            $empleado   = filter_input(INPUT_POST, 'empleado', FILTER_SANITIZE_NUMBER_INT);


            $generico = new Generico();

            $usuario = $generico->getUserInfo($empleado);

            if (!isset($usuario['emp_id'])) {
                $this->array_errors[] = 'Usuario no encontrado';
            } else {
                if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                    $this->array_errors[] = 'Clave incorrecta';
                }
            }
            if (empty($this->array_errors)) {
                $newServEmp = new PlanillaPreOrdenServiciosEmpleado();
                $lista = [];

                $trabajosAsignados = $newServEmp->consultar("SELECT preemp_id, preemp_empid, preemp_preid,preemp_estatus, CONCAT(einfo_nombres, einfo_apellidos) empleado, pro_id, pro_descripcion, pro_precio precio,serv_id,apms.preserv_cantidad cantidad, DATE_FORMAT(preemp_fecha, '%d-%m-%Y') fecha
                FROM app_preorden_master_servicios_empleados preemp 
                JOIN app_preorden_master_servicios apms ON preemp.preemp_preservid = apms.preserv_id 
                JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
                JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
                JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
                JOIN app_empleados e ON e.emp_id = preemp.preemp_empid  
                JOIN app_empleados_info aei ON aei.einfo_id = e.emp_edatosid  
                WHERE preemp.preemp_empid={$empleado} AND (preemp.preemp_estatus=0 OR preemp.preemp_estatus=2)")->all();

                if (is_countable($trabajosAsignados) && count($trabajosAsignados)) {
                    foreach ($trabajosAsignados as $row) {
                        $preorden = $newServEmp->consultar("SELECT pre_correlativo FROM app_preorden_master WHERE pre_id={$row['preemp_preid']}")->row();

                        $comision = $newServEmp->consultar("SELECT * FROM app_empleados_agentes_tipo_comision ct 
                        JOIN app_comision c ON ct.empagentipo_comid=c.com_id 
                        WHERE c.com_id=2 AND ct.empagentipo_agente={$row['preemp_empid']}")->row();

                        $lista[] = [
                            'id' => $row['preemp_id'],
                            'id_empleado' => $row['preemp_empid'],
                            'id_orden' => $row['preemp_preid'],
                            'is_servicio' => $row['serv_id'],
                            'empleado' => $row['empleado'],
                            'servicio' => $row['pro_descripcion'],
                            'precio' => $row['precio'],
                            'monto' => ($comision['empagentipo_porcentaje'] == 0) ? (($row['precio'] * $row['cantidad']) * ($comision['com_porcentaje'] / 100)) : (($row['precio'] * $row['cantidad']) * ($comision['empagentipo_porcentaje'] / 100)),
                            'fecha' => $row['fecha'],
                            'estatus' => $row['preemp_estatus'],
                            'correlativo' => $preorden['pre_correlativo'],
                            'cantidad' => $row['cantidad']
                        ];
                    }
                }
                Http::json_response($lista);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerComisiones()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $orden = new Generico();

            $clave = filter_input(INPUT_POST, 'clave', FILTER_SANITIZE_STRING);
            $empleado   = filter_input(INPUT_POST, 'empleado', FILTER_SANITIZE_NUMBER_INT);
            $fecha_desde    = filter_input(INPUT_POST, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_POST, 'fecha_hasta', FILTER_SANITIZE_STRING);


            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (!validateDate($fecha_desde, 'Y-m-d'))
                $this->array_errors[] = 'La Fecha desde es incorrecta.';
            if (!validateDate($fecha_hasta, 'Y-m-d'))
                $this->array_errors[] = 'La Fecha hasta es incorrecta.';

            $generico = new Generico();

            $usuario = $generico->consultar("SELECT * FROM app_empleados_info c 
                LEFT JOIN app_empleados e ON c.einfo_id=e.emp_edatosid 
                WHERE c.einfo_id={$empleado}")->row();

            if (!isset($usuario['emp_id'])) {
                $this->array_errors[] = 'Usuario no encontrado';
            } else {
                if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                    $this->array_errors[] = 'Clave incorrecta';
                }
            }
            if (empty($this->array_errors)) {

                $comisiones = $orden->consultar("SELECT * FROM app_comisiones_agente_fn c 
                LEFT JOIN app_orden_de_entrega n ON c.comagentefn_fnid=n.n_id AND c.comagentefn_fntipo=12 
                LEFT JOIN app_productos ap ON ap.pro_id = c.comagentefn_planilla_servid  
		LEFT JOIN app_planilla_orden_de_entrega ord ON n.n_id=ord.po_nid 
                LEFT JOIN app_preorden_master ppre ON ppre.pre_id=ord.po_preid 
                WHERE c.comagentefn_estatus=0 AND c.comagentefn_fnempagente={$empleado} AND (DATE(c.comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')")->all();

                $cant = $orden->consultar("SELECT SUM(c.comagentefn_monto) AS total,SUM(c.comagentefn_fncantidad) AS cantidad FROM app_comisiones_agente_fn c 
                LEFT JOIN app_orden_de_entrega n ON c.comagentefn_fnid=n.n_id AND c.comagentefn_fntipo=12 
                LEFT JOIN app_productos ap ON ap.pro_id = c.comagentefn_planilla_servid  
                WHERE c.comagentefn_estatus=0 AND c.comagentefn_fnempagente={$empleado} AND (DATE(c.comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')")->all();

                $total = 0;
                $cantidad = 0;

                foreach ($cant as $row) {
                    $total = $row['total'];
                    $cantidad = $row['cantidad'];
                }

                Http::json_response([
                    'comisiones' => $comisiones,
                    'cantidad' => $cantidad,
                    'total' => round($total,2)
                ]);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function estatusServiciosEmpleados(int $id)
    {
        $estatus = 1;
        $Newservem = new PlanillaPreOrdenServiciosEmpleado();
        if ($Newservem->existe('preemp_id', $id)) {
            $planilla_empleado = $Newservem->consultar("SELECT * FROM app_preorden_master_servicios_empleados e JOIN app_preorden_master_servicios s ON s.preserv_id=e.preemp_preservid AND s.preserv_preid=e.preemp_preid WHERE e.preemp_id={$id}")->row();

            if ($Newservem->editar($id, [
                'preemp_estatus' => $estatus
            ])) {
                $newCarModel = new CarritoVentasModel();
                $newServ = new PlanillaPreOrdenServicios();
                $data_servicio = $newServ->obtenerServicioSimple($planilla_empleado['preserv_id']);


                $div_master = Moneda::Predeterminada();
                $div_master = $div_master['id'];

                $data_comisiones_agente = $newCarModel->obtenerComisionesAgente($planilla_empleado['preemp_empid']);
                $data_comisiones1 = $newCarModel->obtenerComisionesAgente(5);
                $data_comisiones2 = $newCarModel->obtenerComisionesAgente(15);

                $total_proservicio = $data_servicio['nart_procantidad'] * $data_servicio['nart_proprecio'];

                foreach ($data_comisiones_agente as $row) {
                    //COMISION SOLO POR SERVICIO
                    if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
                        $porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
                        if ($porcentaje > 0) {
                            $newServ->guardar([
                                'comagentefn_fnempagente'     => $planilla_empleado['preemp_empid'],
                                'comagentefn_com'             => $row['empagentipo_comid'],
                                'comagentefn_monto'           => $total_proservicio * $porcentaje / 100,
                                'comagentefn_divid'           => $div_master,
                                'comagentefn_porcentaje'      => $porcentaje,
                                'comagentefn_fnid'            => $data_servicio['po_nid'],
                                'comagentefn_fntipo'          => 12,
                                'comagentefn_fntotal'         => $total_proservicio,
                                'comagentefn_fncantidad'      => $planilla_empleado['preserv_cantidad'],
                                'comagentefn_planilla'         => $planilla_empleado['preserv_preid'],
                                'comagentefn_planilla_servid' => $data_servicio['pro_id'],
                                'comagentefn_sobreempid'    => 0
                            ], true, 'app_comisiones_agente_fn');
                        }
                    }
                }

                foreach ($data_comisiones1 as $row) {
                    //COMISION SOLO POR SERVICIO
                    if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
                        $porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
                        if ($porcentaje > 0) {
                            $newServ->guardar([
                                'comagentefn_fnempagente'     => 5,
                                'comagentefn_com'             => $row['empagentipo_comid'],
                                'comagentefn_monto'           => $total_proservicio * $porcentaje / 100,
                                'comagentefn_divid'           => $div_master,
                                'comagentefn_porcentaje'      => $porcentaje,
                                'comagentefn_fnid'            => $data_servicio['po_nid'],
                                'comagentefn_fntipo'          => 12,
                                'comagentefn_fntotal'         => $total_proservicio,
                                'comagentefn_fncantidad'      => $planilla_empleado['preserv_cantidad'],
                                'comagentefn_planilla'         => $planilla_empleado['preserv_preid'],
                                'comagentefn_planilla_servid' => $data_servicio['pro_id'],
                                'comagentefn_sobreempid'    => $planilla_empleado['preemp_empid']
                            ], true, 'app_comisiones_agente_fn');
                        }
                    }
                }

                foreach ($data_comisiones2 as $row) {
                    //COMISION SOLO POR SERVICIO
                    if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
                        $porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
                        if ($porcentaje > 0) {
                            $newServ->guardar([
                                'comagentefn_fnempagente'     => 15,
                                'comagentefn_com'             => $row['empagentipo_comid'],
                                'comagentefn_monto'           => $total_proservicio * $porcentaje / 100,
                                'comagentefn_divid'           => $div_master,
                                'comagentefn_porcentaje'      => $porcentaje,
                                'comagentefn_fnid'            => $data_servicio['po_nid'],
                                'comagentefn_fntipo'          => 12,
                                'comagentefn_fntotal'         => $total_proservicio,
                                'comagentefn_fncantidad'      => $planilla_empleado['preserv_cantidad'],
                                'comagentefn_planilla'         => $planilla_empleado['preserv_preid'],
                                'comagentefn_planilla_servid' => $data_servicio['pro_id'],
                                'comagentefn_sobreempid'    => $planilla_empleado['preemp_empid']
                            ], true, 'app_comisiones_agente_fn');
                        }
                    }
                }

                return true;
            }
        }
        return ['errors' => $this->array_errors];
    }

    /* public function obtenerTrabajosAsignadosAdicionales()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $lista = [];
            $newServEmp = new PlanillaPreOrdenServiciosEmpleado();

            $trabajosAsignados = $newServEmp->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales ad  
			LEFT JOIN app_productos e ON e.pro_id=ad.pread_serv  
			WHERE ad.pread_empid IS NULL")->all();

            if (is_countable($trabajosAsignados) && count($trabajosAsignados)) {
                foreach ($trabajosAsignados as $row) {

                    if (isset($row['pread_preid'])) {
                        $preorden = $newServEmp->consultar("SELECT pre_correlativo,pre_fecha FROM app_preorden_master WHERE pre_id={$row['pread_preid']}")->row();
                        $correlativo = $preorden['pre_correlativo'];
                        $fecha = $preorden['pre_fecha'];
                    }

                    $lista[] = [
                        'id' => $row['pread_id'],
                        'servicio' => $row['pro_descripcion'],
                        'cantidad' => $row['pread_cantidad'],
                        'fecha' =>    $fecha,
                        'estatus' => $row['pread_estatus'],
                        'correlativo' => $correlativo,
                        'preid' =>       $row['pread_preid']
                    ];
                }
            }

            Http::json_response($lista);
        }
    }*/

    public function obtenerTrabajosAsignadosAdicionales()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $clave = filter_input(INPUT_POST, 'clave', FILTER_SANITIZE_STRING);
            $empleado   = filter_input(INPUT_POST, 'empleado', FILTER_SANITIZE_NUMBER_INT);

            $lista = [];

            $generico = new Generico();

            $usuario = $generico->getUserInfoDa($empleado);

            if (!isset($usuario['emp_id'])) {
                $this->array_errors[] = 'Usuario no encontrado';
            } else {
                if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                    $this->array_errors[] = 'Clave incorrecta';
                }
            }
            if (empty($this->array_errors)) {

               // $user = $generico->getUserInfoDa($empleado);

                $trabajosAsignados =  $generico->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales ad  
                LEFT JOIN app_empleados_info e ON e.einfo_id=ad.pread_empid 
                LEFT JOIN app_empleados_agentes_tipo_comision c ON c.empagentipo_agente=ad.pread_empid 
                LEFT JOIN app_comision cm ON c.empagentipo_comid=cm.com_id 
                WHERE ad.pread_empid ={$usuario['emp_id']} AND (ad.pread_estatus=0 OR ad.pread_estatus=2)")->all();

                if (is_countable($trabajosAsignados) && count($trabajosAsignados)) {
                    foreach ($trabajosAsignados as $row) {

                        if ($row['pread_empid'] != NULL && $row['pread_comid'] != NULL && $row['pread_comid'] > 0) {
                            $listac = $generico->consultar("SELECT * FROM app_comisiones_agente_fn cm 
						LEFT JOIN app_preorden_master_servicios_empleados_adicionales ad ON ad.pread_comid=cm.comagentefn_id AND ad.pread_empid=cm.comagentefn_fnempagente AND ad.pread_preid=cm.comagentefn_planilla 
						LEFT JOIN app_empleados_info e ON e.einfo_id=cm.comagentefn_fnempagente 
						WHERE cm.comagentefn_planilla={$row['pread_preid']} AND cm.comagentefn_id ={$row['pread_comid']}")->row();

                            $lista[] = [
                                'id' => $row['pread_id'],
                                'servicio' => $listac['comagentefn_descripcion'],
                                'cantidad' => $listac['comagentefn_fncantidad'],
                                'empleado' => $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'],
                                'monto' =>    $listac['comagentefn_monto'],
                                'estatus' => $row['pread_estatus'],
                                'com' => $listac['comagentefn_id'],
                            ];
                        } else {
                            $productos = $generico->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales ad  
						LEFT JOIN app_productos p ON p.pro_id=ad.pread_serv  
						WHERE ad.pread_id ={$row['pread_id']}")->row();

                            $lista[] = [
                                'id' => $row['pread_id'],
                                'servicio' => $productos['pro_descripcion'],
                                'cantidad' => $row['pread_cantidad'],
                                'empleado' =>  $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'],
                                'monto' => ($row['empagentipo_porcentaje'] == 0) ? (($productos['pro_precio'] * $row['pread_cantidad']) * ($row['com_porcentaje'] / 100)) : (($productos['pro_precio'] * $row['pread_cantidad']) * ($row['empagentipo_porcentaje'] / 100)),
                                'estatus' => $row['pread_estatus'],
                                'com' => 0
                            ];
                        }
                    }
                }

                Http::json_response($lista);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function estatusServiciosEmpleadosAdicionales()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $com = filter_input(INPUT_POST, 'com', FILTER_SANITIZE_NUMBER_INT);
            $estatus   = filter_input(INPUT_POST, 'estatus', FILTER_SANITIZE_NUMBER_INT);

            if (empty($this->array_errors)) {
                $NewservAd = new PlanillaServAdicionales();
                if ($NewservAd->existe('pread_id', $id) && $id > 0) {
                    if ($NewservAd->editar($id, [
                        'pread_estatus' => $estatus
                    ])) {
                        $servAd = $NewservAd->obtener($id);

                        $newCarModel = new CarritoVentasModel();

                        $div_master = Moneda::Predeterminada();
                        $div_master = $div_master['id'];

                        $data_comisiones_agente = $newCarModel->obtenerComisionesAgente($servAd['pread_empid']);

                        if ($servAd['pread_comid'] == 0 || $servAd['pread_comid'] == NULL) {

                            $trabajosAsignados =  $NewservAd->consultar("SELECT * FROM app_preorden_master_servicios_empleados_adicionales ad  
                                LEFT JOIN app_productos p ON p.pro_id=ad.pread_serv  
                                LEFT JOIN app_empleados_info e ON e.einfo_id=ad.pread_empid 
                                LEFT JOIN app_empleados_agentes_tipo_comision c ON c.empagentipo_agente=ad.pread_empid 
                                LEFT JOIN app_comision cm ON c.empagentipo_comid=cm.com_id 
                                WHERE ad.pread_id ={$servAd['pread_id']}")->row();

                            $total_proservicio = $servAd['pread_cantidad'] * $trabajosAsignados['pro_precio'];

                            $presupuesto = $NewservAd->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_preid = {$servAd['pread_preid']}")->row();

                            $id_venta = null;
                            if ($presupuesto) {
                                $id_venta = $presupuesto['po_nid'];
                            } else {
                                $id_venta = null;
                            }
                            foreach ($data_comisiones_agente as $row) {
                                //COMISION SOLO POR SERVICIO
                                if ($row['com_tipo'] == 3 && $row['empagentipo_estatus'] == 1) {
                                    $porcentaje = $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'];
                                    if ($porcentaje > 0) {
                                        $NewservAd->guardar([
                                            'comagentefn_fnempagente'     => $servAd['pread_empid'],
                                            'comagentefn_com'             => $row['empagentipo_comid'],
                                            'comagentefn_monto'           => $total_proservicio * $porcentaje / 100,
                                            'comagentefn_divid'           => $div_master,
                                            'comagentefn_porcentaje'      => $porcentaje,
                                            'comagentefn_fnid'            => $id_venta,
                                            'comagentefn_fntipo'          => 12,
                                            'comagentefn_fntotal'         => $total_proservicio,
                                            'comagentefn_planilla'         => $servAd['pread_preid'],
                                            'comagentefn_planilla_servid' => $servAd['pread_serv'],
                                            'comagentefn_fncantidad'      => $servAd['pread_cantidad'],
                                            'comagentefn_descripcion'     => $trabajosAsignados['pro_descripcion'],
                                            'comagentefn_sobreempid'        => 0
                                        ], true, 'app_comisiones_agente_fn');
                                    }
                                }
                            }
                        }
                        Http::json_response(true);
                    }
                } else {
                    $comision = $NewservAd->consultar("SELECT * FROM app_comisiones_agente_fn WHERE comagentefn_id=$com")->row();

                    if (empty($this->array_errors)) {
                        if ($NewservAd->guardar([
                            'pread_comid'   => $com,
                            'pread_empid'   => $comision['comagentefn_fnempagente'],
                            'pread_preid'   => $comision['comagentefn_planilla'],
                            'pread_estatus' => $estatus,
                        ], true)) {
                            Http::json_response(true);
                        }
                    }
                }
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    /*
    public function categoriasEmpleado()
    {
        $categoria = new PlanillaCategoria();
        $catEmpleado = new PlanillaCategoriaEmpleado();

        $cate = $catEmpleado->consultar("SELECT DISTINCT c.cat_id, c.* FROM app_preorden_master_servicios_empleados preemp 
        JOIN app_preorden_master_servicios apms ON preemp.preemp_preservid = apms.preserv_id 
        JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
        JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
        JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
        JOIN app_empleados_info aei ON aei.einfo_id = preemp.preemp_empid 
        WHERE preemp.preemp_empid={$_SESSION['user_data']['einfo_id']} AND (preemp.preemp_estatus=0 OR preemp.preemp_estatus=2)")->all();

        $n = 0;
        if (is_countable($cate) && count($cate)) {
            foreach ($cate as $row) {
                if ($n == 0) {
                    $n = $row['cat_id'];
                }
            }
        }

        Http::json_response([
            'principal' => $n,
            'categorias' => $cate
        ]);
    }

    public function obtenerTrabajosAsignados(int $categoria)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newServEmp = new PlanillaPreOrdenServiciosEmpleado();
            $lista = [];

            $trabajosAsignados = $newServEmp->consultar("SELECT preemp_id, preemp_empid, preemp_preid,preemp_estatus, CONCAT(einfo_nombres, einfo_apellidos) empleado, pro_id, pro_descripcion, pro_precio precio,serv_id,apms.preserv_cantidad cantidad, DATE_FORMAT(preemp_fecha, '%d-%m-%Y') fecha
            FROM app_preorden_master_servicios_empleados preemp 
            JOIN app_preorden_master_servicios apms ON preemp.preemp_preservid = apms.preserv_id 
            JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
            JOIN app_planilla_categorias c ON c.cat_id=aps.serv_catid 
            JOIN app_productos ap ON ap.pro_id = aps.serv_proid 
            JOIN app_empleados_info aei ON aei.einfo_id = preemp.preemp_empid 
            WHERE preemp.preemp_empid={$_SESSION['user_data']['einfo_id']} AND (preemp.preemp_estatus=0 OR preemp.preemp_estatus=2) AND c.cat_id=$categoria")->all();

            if (is_countable($trabajosAsignados) && count($trabajosAsignados)) {
                foreach ($trabajosAsignados as $row) {
                    $preorden = $newServEmp->consultar("SELECT pre_correlativo FROM app_preorden_master WHERE pre_id={$row['preemp_preid']}")->row();
                    $lista[] = [
                        'id' => $row['preemp_id'],
                        'id_empleado' => $row['preemp_empid'],
                        'id_orden' => $row['preemp_preid'],
                        'is_servicio' => $row['serv_id'],
                        'empleado' => $row['empleado'],
                        'servicio' => $row['pro_descripcion'],
                        'precio' => $row['precio'],
                        'fecha' => $row['fecha'],
                        'estatus' => $row['preemp_estatus'],
                        'correlativo' => $preorden['pre_correlativo'],
                        'cantidad' => $row['cantidad']
                    ];
                }
            }
            Http::json_response($lista);
        }
    }

    public function obtenerTrabajosAsignadosAdicionales()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $lista = [];
            $newServEmp = new PlanillaPreOrdenServiciosEmpleado();

            $trabajosAsignados = $newServEmp->consultar("SELECT * FROM app_comisiones_agente_fn cm 
			LEFT JOIN app_preorden_master_servicios_empleados_adicionales ad ON ad.pread_comid=cm.comagentefn_id AND ad.pread_empid=cm.comagentefn_fnempagente AND ad.pread_preid=cm.comagentefn_planilla 
			LEFT JOIN app_empleados_info e ON e.einfo_id=cm.comagentefn_fnempagente 
			WHERE cm.comagentefn_fnempagente={$_SESSION['user_data']['einfo_id']} AND (ad.pread_estatus=0 OR ad.pread_estatus=2 OR ad.pread_estatus IS NULL) AND cm.comagentefn_planilla_servid IS NULL")->all();

            if (is_countable($trabajosAsignados) && count($trabajosAsignados)) {
                foreach ($trabajosAsignados as $row) {
                    $correlativo = '0000';
                    if (isset($row['comagentefn_planilla'])) {
                        $preorden = $newServEmp->consultar("SELECT pre_correlativo FROM app_preorden_master WHERE pre_id={$row['comagentefn_planilla']}")->row();
                        $correlativo = $preorden['pre_correlativo'];
                    }

                    $lista[] = [
                        'id' => $row['pread_id'],
                        'servicio' => $row['comagentefn_descripcion'],
                        'cantidad' => $row['comagentefn_fncantidad'],
                        'fecha' => $row['comagentefn_fecha'],
                        'estatus' => $row['pread_estatus'],
                        'correlativo' => $correlativo,
                        'com' =>       $row['comagentefn_id']
                    ];
                }
            }

            Http::json_response($lista);
        }
    }

    

    public function estatusServiciosEmpleadosAdicionales()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $com = filter_input(INPUT_POST, 'com', FILTER_SANITIZE_NUMBER_INT);
            $estatus   = filter_input(INPUT_POST, 'estatus', FILTER_SANITIZE_NUMBER_INT);

            if (empty($_POST['com']))
                $this->array_errors[] = 'Acción prohibida';

            if (empty($this->array_errors)) {
                $NewservAd = new PlanillaServAdicionales();
                if ($NewservAd->existe('pread_id', $id)) {
                    if ($NewservAd->editar($id, [
                        'pread_estatus' => $estatus
                    ])) {
                        Http::json_response(true);
                    }
                } else {
                    $comision = $NewservAd->consultar("SELECT * FROM app_comisiones_agente_fn WHERE comagentefn_id=$com")->row();

                    if (empty($this->array_errors)) {
                        if ($NewservAd->guardar([
                            'pread_comid'   => $com,
                            'pread_empid'   => $comision['comagentefn_fnempagente'],
                            'pread_preid'   => $comision['comagentefn_planilla'],
                            'pread_estatus' => $estatus,
                        ], true)) {
                            Http::json_response(true);
                        }
                    }
                }
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerComisiones()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $orden = new Ordendeentrega();

            Http::json_response($orden->consultar("SELECT * FROM app_comisiones_agente_fn c 
        LEFT JOIN app_orden_de_entrega n ON c.comagentefn_fnid=n.n_id AND c.comagentefn_fntipo=12 
        WHERE n.n_estatus=1 AND c.comagentefn_fnempagente={$_SESSION['user_data']['einfo_id']}")->all());
        }
    }
    */
}
