<?php

namespace App\Controladores;

use App\Modelos\Tarifas;
use Core\Controller;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;

final class TarifasControlador extends Controller
{
    private const APPLICAR_COSTO = 'costo';
    private const APPLICAR_PRECIO = 'pvp';
    private $tarifas;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('tarifas');
        $this->tarifas = new Tarifas();
    }

    public function index()
    {
        return Vista::view('tarifas/index');
    }

    public function obtenerTarifas()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->tarifas->todos());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $tar_aplicar    = filter_input(INPUT_POST, 'aplicar', FILTER_SANITIZE_STRING);
            $tar_codigo     = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
            $tar_maxpvp     = ('true' == filter_input(INPUT_POST, 'maxpvp')) ? 1 : 0;
            $tar_mincoste   = ('true' == filter_input(INPUT_POST, 'mincoste')) ? 1 : 0;
            $tar_nombre     = filter_input(INPUT_POST, 'nombre', FILTER_SANITIZE_STRING);
            $tar_valorx     = filter_input(INPUT_POST, 'valorx', FILTER_SANITIZE_STRING);
            $tar_valory     = filter_input(INPUT_POST, 'valory', FILTER_SANITIZE_STRING);

            if (empty($tar_codigo))
                $this->array_errors[] = "El campo Código es obligatorio.";
            if (empty($tar_nombre))
                $this->array_errors[] = "El campo Nombre es obligatorio.";
            if (empty($tar_aplicar))
                $this->array_errors[] = "El campo Formula es obligatorio.";

            if (empty($this->array_errors)) {

                $tar_valorx = convertir_a_float($tar_valorx);
                $tar_valory = convertir_a_float($tar_valory);

                if (empty($_POST['id'])) {
                    header('Content-Type: application/json', true);
                    echo json_encode($this->tarifas->guardar([
                        'tar_aplicar'     => $tar_aplicar,
                        'tar_codigo'     => $tar_codigo,
                        'tar_maxpvp'      => $tar_maxpvp,
                        'tar_mincoste'    => $tar_mincoste,
                        'tar_nombre'      => $tar_nombre,
                        'tar_valorx'      => $tar_valorx,
                        'tar_valory'      => $tar_valory
                    ], true));
                    exit;
                } else {
                    $tar_id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                    header('Content-Type: application/json', true);
                    echo json_encode($this->tarifas->editar($tar_id, [
                        'tar_aplicar'     => $tar_aplicar,
                        'tar_codigo'     => $tar_codigo,
                        'tar_maxpvp'      => $tar_maxpvp,
                        'tar_mincoste'    => $tar_mincoste,
                        'tar_nombre'      => $tar_nombre,
                        'tar_valorx'      => $tar_valorx,
                        'tar_valory'      => $tar_valory
                    ]));
                    exit;
                }
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function visible(int $id_tarifa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_tarifa = filter_var($id_tarifa, FILTER_SANITIZE_NUMBER_INT);

            if ($this->tarifas->existe('tar_id', $id_tarifa)) {

                $tarifa = $this->tarifas->obtener($id_tarifa);

                $this->tarifas->editar($id_tarifa, [
                    'tar_visible' => ($tarifa['tar_visible'] == 1) ? 0 : 1
                ]);

                header('Content-Type: application/json', true);
                echo json_encode(true);
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $id_tarifa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_tarifa = filter_var($id_tarifa, FILTER_SANITIZE_NUMBER_INT);

            if ($this->tarifas->existe('tar_id', $id_tarifa)) {
                header('Content-Type: application/json', true);
                echo json_encode($this->tarifas->eliminar($id_tarifa));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public static function aplicar($costo, $precio, string $aplicar, $valorx, $valory = 0,$iva=0)
    {
        $precio_final = 0.0;
        $precio=$precio;
        $costo=$costo;

        if ($aplicar == self::APPLICAR_COSTO) {
            $precio_final += $costo + ($costo * $valorx) / 100 + $valory;
        }
        if ('costoiva'==$aplicar) {
            $costo=$costo+$iva;
            $precio_final += $costo + ($costo * $valorx) / 100 + $valory;
        }
        if ('pvp' == $aplicar){
            $precio_final += $precio - ($precio * $valorx) / 100 - $valory;
        }
        if ('pvpiva' == $aplicar){
            $precio=$precio+$iva;
            $precio_final = ($precio) - ($precio * $valorx) / 100 - $valory;
        }

        return $precio_final > 0 ? $precio_final : 0.0;
    }

    public function obtenerTarifasProductos(int $pro_id)
    {
        header('Content-Type: application/json', true);
        echo json_encode($this->tarifas->obtenerTarifasProductos($pro_id));
        exit;
    }
}
