<div class="container" v-cloak id="appStockTransferenciaDetalle">
    <input type="hidden" id="id_ptr" value="<?= $ptr_id ?>">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Stock</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url("stock/transferencia_stock") ?>">Transferncia de stock</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url("stock/detalle_transferencia/$ptr_id") ?>">Movimiento #{{ transferencia_detalle.ptr_id }}</a>
                </li>
            </ul>
            <div class="ml-md-auto py-2 py-md-0">
                <a href="<?= url('productos'); ?>" class="btn btn-info btn-border btn-round mr-2">Productos</a>
                <a v-if="transferencia_detalle.ptr_estatus == 1" href="#" @click.prevent="procesarTransferencia" class="btn btn-success btn-round mr-2">Aprobar</a>
                <a v-if="transferencia_detalle.ptr_estatus == 1" @click.prevent="negarTransferencia" class="btn btn-danger btn-round mr-2">Negar</a>
            </div>
        </div>
        <div class="row" :class="cargando">
            <div class="col-12">
                <div class="card card-invoice">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-sm-6">
                                <h1 class="invoice-title">
                                    TRANSFERENCIA DE STOCK
                                </h1>
                            </div>
                            <div class="col-sm-6 text-right">
                                <strong v-if="transferencia_detalle.ptr_estatus == 1"><span class="fa fa-info text-warning"></span> Transferencia en proceso</strong>
                                <strong v-else-if="transferencia_detalle.ptr_estatus == 2"><span class="fa fa-check text-success"></span> Transferencia realizada</strong>
                                <strong v-else><span class="fa fa-ban text-danger"></span> Transferencia negada</strong>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="separator-solid"></div>
                        <div class="row">
                            <div class="col-md-4 info-invoice">
                                <h5 class="sub">Fecha</h5>
                                <p>{{ transferencia_detalle.ptr_creado }}</p>
                            </div>
                            <div class="col-md-4 info-invoice">
                                <h5 class="sub">Movimiento</h5>
                                <p>#{{ transferencia_detalle.ptr_id }}</p>
                            </div>
                            <div class="col-md-4 info-invoice">
                                <h5 class="sub">Procesado por</h5>
                                <p>
                                    {{ transferencia_detalle.einfo_nombres }} {{ transferencia_detalle.einfo_apellidos }}
                                    <br>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="invoice-detail">
                                    <div class="invoice-top">
                                        <h3 class="title"><strong>Listado de productos</strong></h3>
                                    </div>
                                    <div class="invoice-item">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <td><strong>N°</strong></td>
                                                        <td class="text-left"><strong>Código</strong></td>
                                                        <td class="text-center"><strong>Cantidad</strong></td>
                                                        <td class="text-left"><strong>Producto</strong></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in transferencia_producto_detalle">
                                                        <td>{{ row.ptd_id }}</td>
                                                        <td>{{ row.pro_codigo }}</td>
                                                        <td class="text-center">{{ row.ptd_cantidad }}</td>
                                                        <td class="text-left">{{ row.pro_descripcion }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="separator-solid  mb-3"></div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="row">
                            <div class="col-sm-7 col-md-5 mb-3 mb-md-0 transfer-to">
                                <h5 class="sub">Ubicación del producto</h5>
                                <div class="account-transfer">
                                    <div>
                                        <span>Almacén origen:</span>
                                        <span>{{ transferencia_detalle.origen }}</span>
                                    </div>
                                    <div>
                                        <span>Almacén Destino:</span>
                                        <span>{{ transferencia_detalle.destino }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-5 col-md-7 transfer-total">
                                <h5 class="sub">Total de productos</h5>
                                <div class="price">{{ transferencia_producto_detalle.length }}</div>
                            </div>
                        </div>
                        <div class="separator-solid"></div>
                        <h6 class="text-uppercase mt-4 mb-3 fw-bold">
                            Observaciones
                        </h6>
                        <p class="text-muted mb-0">
                            {{ transferencia_detalle.ptr_observacion }}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?= ruta_base() ?>public/assetsvuejs/stock/detalles_transferencia.js"></script>