<?php

namespace App\Modelos;

use Core\Database;

class Stock extends Database
{
    protected $table    = 'app_productos_stocks';
    protected $id       = 'ps_id';

    public function obtenerProductosSegunAlmacen($id_almacen)
    {
        return $this->consultar("SELECT pro_id, pro_codigo, pro_descripcion FROM app_productos p
        JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
        WHERE ps.ps_almid = $id_almacen AND ps.ps_cantidad > 0 AND pro_tipo != 3")->all();
    }

    public function obtenerAlmacenes()
    {
        return $this->consultar('SELECT * FROM app_almacenes')->all();
    }

    public function obtenerProductoSegunStock($id_stock)
    {
        return $this->consultar("SELECT * FROM app_productos_stocks WHERE ps_id=$id_stock")->row();
    }

    public function obtenerTotalStockProducto($id_producto)
    {
        return $this->consultar("SELECT sum(ps_cantidad) as total_stock FROM app_productos_stocks WHERE ps_proid=$id_producto")->row();
    }

    public function obtenerAlmacenesSegunProducto(int $id_producto)
    {
        return $this->consultar("SELECT alm_id id, alm_nombre descripcion FROM app_productos_stocks ps
        INNER JOIN app_almacenes a ON a.alm_id=ps.ps_almid
        WHERE ps.ps_proid=$id_producto")->all();
    }

    public function obtenerProductosStock(int $ps_proid)
    {
        return $this->consultar("SELECT TRUNCATE(ps.ps_cantidad,2) as cantidad, ps.*,p.*,a.* FROM app_productos_stocks ps
        JOIN app_productos p ON p.pro_id=ps.ps_proid
        JOIN app_almacenes a ON a.alm_id=ps.ps_almid
        WHERE ps.ps_proid=$ps_proid")->all();
    }

    public function existeProductoAlmacen($alm_id, $pro_id)
    {
        return $this->consultar("SELECT * FROM app_productos_stocks WHERE ps_proid=$pro_id AND ps_almid=$alm_id")->row();
    }

    public function actualizarEstatus($id)
    {
        return $this->consultar("UPDATE app_productos_transferencia SET ptr_estatus=2 WHERE ptr_id=$id")->run();
    }

    public function obtenerAlmacenSinProductoEnStock($pro_id)
    {
        return $this->consultar("SELECT * FROM app_almacenes WHERE alm_id NOT IN (SELECT ps_almid FROM app_productos_stocks where ps_proid=$pro_id)")->all();
    }

    public function stockEditarGuardarCondicional($condicion)
    {
        return $this->consultar("$condicion")->run();
    }
}
