<form action="" @submit.prevent="guardarContactoMensaje" id="formCliente">
    <input type="hidden" id="cliID" name="cliID">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modalCliente">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h4 class="modal-title"> Cliente / Mensaje</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="cliCliente">Cliente</label>
                        <v-select id="cliCliente" v-model="selected_cli" label="cliente" :filterable="false" :options="clientesBuscar" @search="onSearch" @input="buscarContactos">
                            <template slot="no-options">
                                Escribe para buscar el cliente
                            </template>
                            <template slot="option" slot-scope="option">
                                <div class="d-flex ml-0 pl-0">
                                    <div class="avatar ml-0 pl-0">
                                        <span class="avatar-title rounded-circle border border-white bg-info ml-0 pl-0" style="width: 40px; height: 40px;">{{ option.cliente.charAt() }}</span>
                                    </div>
                                    <div class="flex-1 pt-1 ml-2">
                                        <h6 class="fw-bold mb-1">{{ option.cliente.toUpperCase() }}</h6>
                                        <small>{{ option.dni }}</small>
                                    </div>
                                </div>
                            </template>
                        </v-select>
                    </div>
                    <div class="form-group">
                        <label for="cliContacto">Contactos</label>
                        <select name="cliContacto" id="cliContacto" class="form-control">
                            <option value="" disabled selected>Seleccione una opción</option>
                            <option :value="row.id" v-for="row in contactos">
                                {{ row.nombre }} / {{ row.cargo }}
                            </option>
                        </select>
                    </div>
                    <div class="form-row">
                        <div class="col">
                            <div class="form-group">
                                <label for="cliTipoMensaje">Tipo de mensaje</label>
                                <select name="cliTipoMensaje" id="cliTipoMensaje" class="form-control" @change="vaciarSelectContactoMensaje">
                                    <option value="" disabled selected>Seleccione una opción</option>
                                    <option value="1">SMS</option>
                                    <option value="2">EMAIL</option>
                                </select>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-group">
                                <label for="cliModulo">Módulo</label>
                                <select name="cliModulo" id="cliModulo" class="form-control" @click="buscarMensajesSegunTipo">
                                    <option value="" disabled selected>Seleccione una opción</option>
                                    <option value="1">Mensajes</option>
                                    <option value="2">Servicios</option>
                                    <option value="3">Documentos</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="cliMensaje">Mensajes</label>
                        <select name="cliMensaje" id="cliMensaje" class="form-control">
                            <option value="" disabled selected>Seleccione una opción</option>
                            <option :value="row.id" v-for="row in mensajes">
                                {{ row.titulo }}
                            </option>
                        </select>
                    </div>
                    <div v-if="mostrarRangosFechaIntervalos">
                        <div class="form-row">
                            <div class="col">
                                <div class="form-group">
                                    <label for="cliFechaDesde">Fecha desde</label>
                                    <input type="date" id="cliFechaDesde" name="cliFechaDesde" class="form-control">
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="cliFechaHasta">Fecha hasta</label>
                                    <input type="date" id="cliFechaHasta" name="cliFechaHasta" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-group">
                                <label for="cliIntervalo"><span id="cliIntervaloNum">1</span> SMS/EMAIL dia</label>
                                <input type="range" min="1" max="30" value="0" id="cliIntervalo" name="cliIntervalo" oninput="document.getElementById('cliIntervaloNum').innerHTML = this.value" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="form-group pull-right">
                        <button type="submit" class="btn btn-sm btn-info">Guardar</button>
                    </div>
                </div>
                <div class="modal-footer">
                    <div id="divTiempo"></div>
                    <ul>
                        <li v-for="row in intervalos">{{ row }}</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</form>