<?php

namespace App\Modelos;

use Core\Database;

class SmsModel extends Database
{
    protected $table    = 'app_sms';
    protected $id       = 'sms_id';

    public function buscarCliente($buscar)
    {
        $trozos = explode(" ", $buscar);
        $numero = count($trozos);
        if ($numero == 1) {
            $sql = "SELECT DISTINCT(cli_id) id, cli_dni dni, cli_razon_social cliente 
            FROM app_clientes c
            JOIN app_clientes_contactos cc ON c.cli_id = cc.ccon_cliid
            WHERE c.cli_estatus = 1 AND ((LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%')) LIMIT 50";
        } elseif ($numero > 1) {
            $sql = "SELECT DISTINCT(cli_id) id, cli_dni dni, cli_razon_social cliente, MATCH(cli_razon_social) AGAINST('$buscar') AS puntuacion 
            FROM app_clientes c JOIN app_clientes_contactos cc ON c.cli_id = cc.ccon_cliid 
            WHERE cli_estatus = 1 AND MATCH(cli_razon_social) AGAINST('$buscar') ORDER BY puntuacion DESC LIMIT 50";
        }
        return $this->consultar("$sql")->all();
    }

    public function obtenerSMSTipo(int $id_tipo)
    {
        return $this->consultar("SELECT sms_id id, sms_titulo titulo FROM app_sms WHERE sms_tipo = $id_tipo")->all();
    }

    public function obtenerMsjEmail($tipo)
    {
        return $this->consultar("SELECT * 
        FROM app_sms WHERE sms_estatus<3 AND sms_tipo=$tipo")->all();
    }
}
