<div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal_buscar_cliente">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Buscar o registrar clientes</h5>&nbsp;&nbsp;
                <button type="button" class="btn btn-sm" @click="clienteEncontrado = !clienteEncontrado">
                    registrar
                </button>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="#" autocomplete="off" @submit.prevent="guardarCliente" id="form_cliente">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="tipodoc">Tipo de documento:</label>
                                <select class="form-control" id="tipodoc" name="cli_tipodoc" v-model="tipoci">
                                    <option value="" disabled>selecione un documento</option>
                                    <?php foreach ($tipos_de_documentos as $row) : ?>
                                        <option value="<?= $row['tipodoc_id'] ?>"><?= $row['tipodoc_codigo'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="dni">Nº de documento:</label>
                                <div class="input-group">
                                    <input type="text" id="cli_dni" v-if="tipoci==2" name="cli_dni" class="form-control" v-mask="'A########'" v-model="clidni" @keyup="clidni=clidni.toUpperCase()">
                                    <input type="text" id="cli_dni" v-else name="cli_dni" class="form-control" v-mask="'A#########'" v-model="clidni" @keyup="clidni=clidni.toUpperCase()">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" id="btncne" @click="cne()">CNE</button>
                                    </div>
                                </div>
                                <small class="form-text text-muted" v-if="tipoci==2">V00000000</small>
                                <small class="form-text text-muted" v-if="tipoci==3">J000000000</small>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="razon_social">Razón social:</label>
                        <input type="text" id="razon_social" name="cli_razon_social" class="form-control" maxlength="150" onkeyup="this.value=this.value.toUpperCase()">
                    </div>
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="telefono">Teléfono:</label>
                                <input type="tel" v-mask="'(####) ###-####'" id="telefono" name="cli_telefono" class="form-control">
                                <small class="form-text text-muted">(0000) 000-0000</small>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="correo">Correo electrónico:</label>
                                <input type="text" id="correo" name="cli_email" class="form-control">
                                <small class="form-text text-muted">usuario@ejemplo.com</small>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="direccion_uno">Dirección:</label>
                        <input type="text" id="direccion_uno" name="cli_direccion" class="form-control">
                    </div>
                    <div class="form-check">
                        <label class="form-check-label" for="natural">
                            <input class="form-check-input" id="natural" name="cli_natural" type="checkbox" v-model="natural" checked>
                            <span class="form-check-sign">Persona natural (no jurídica)</span>
                        </label>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                    <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                        <i class="loader loader-info"></i>
                    </button>
                    <button v-else type="submit" class="btn btn-primary  btn-sm">Registrar</button>
                </div>
            </form>
        </div>
    </div>
</div>