<style>
    .upload-btn-wrapper {
        position: relative;
        overflow: hidden;
        display: block;
    }

    .upload-btn-wrapper input[type=file] {
        font-size: 100px;
        position: absolute;
        left: 0;
        top: 0;
        opacity: 0;
    }

    .scroll {
        max-height: 400px;
        width: 100%;
        overflow-y: scroll;
        overflow-x: hidden;
        scrollbar-color: rgba(103, 110, 117, 0.15) rgba(122, 128, 134, 0.05);
        scrollbar-width: thin;
    }

    .scroll::-webkit-scrollbar {
        -webkit-appearance: none;
    }

    .scroll::-webkit-scrollbar:vertical {
        width: 6px;
    }

    .scroll::-webkit-scrollbar-thumb {
        background: #ccc;
    }

    .kanban-board {
        cursor: move;
    }

    .titulo_lista {
        cursor: text;
    }
</style>
<div class="container container-full" id="appListas" v-cloak>
    <input type="hidden" value="<?= $id ?>" id="id_tab">
    <input type="hidden" value="<?= $tarea ?>" id="id_tarea_html">
    <input type="hidden" value="<?= $favorite ?>" id="id_favorito">
    <input type="hidden" value="<?= $modalpres ?>" id="abrirModal">
    <div class="page-inner mb-0 pb-0 mt-1 pt-1">
        <div class="page-header mb-0 pb-0 mt-0 pt-0">
            <h4 class="page-title" style="color: <?= $color ?>; text-transform: uppercase;"><?= $nombre ?></h4>
            <div class="ml-md-auto" style="display: flex;margin-right: 1.3rem;">
                <a href="<?= url('servicios'); ?>" class="text-white btn" style="background-color: <?= $color ?>;">Tableros</a>
                <a href="#" class="nav-link quick-sidebar-toggler" style="padding: 0.5rem 1rem; color: <?= $color ?>;" :title="'Histórico del Tablero'">
                    <i class="fas fa-history" style="font-size: 25px;"></i>
                </a>
                <a href="#" class="nav-link" style="padding: 0.5rem 1rem; color: <?= $color ?>;" title="Favorito" @click.prevent="cambiarFavorite()">
                    <i :class="this.icon" style="font-size: 25px;"></i>
                </a>
            </div>
        </div>
    </div>
    <div class="page-inner page-inner-fill mt-0 pt-0">
        <div class="row my-0 py-0">
            <div class="col-12 my-0 py-0">
                <div class="board my-0 py-0" id="listas_tareas" style="white-space: normal;">
                    <div class="my-2 kanban-board" v-for="(lista, index) in listas" :key="lista.id">
                        <header class="kanban-board-header">
                            <div class="kanban-title-board" style="color: <?= $color ?>;">
                                <span class="titulo_lista" @click="preEditarLista(lista, $event)">{{ lista.nombre }}</span>
                                <input type="text" class="form-control" style="display: none" :value="lista.nombre" :id="'titulo_lista_hidden' + lista.id" @keyup.enter="editarLista(lista, $event)">
                            </div>
                            <div class="kanban-title-button d-inline-flex">
                                <div class="dropdown dropdown-kanban">
                                    <button class="dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i class="fas fa-ellipsis-h"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="#" @click.prevent="eliminarLista(lista)">Eliminar</a>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <input type="text" class="form-control my-2 " @keyup.enter="agregarTarea(lista, $event)" placeholder="+ Añada una Tarjeta">
                            </div>
                        </header>
                        <main class="tareas-drag scroll p-1" :data-lista="lista.id">
                            <div class="kanban-item" v-for="tarea in lista.tareas" :key="tarea.id" :data-lista-posicion="index" @click.prevent="modalTarjeta(tarea.id, $event)">
                                <a href="#" class="kanban-title" :id="'titulo_tarea' + tarea.id">{{ tarea.nombre }}</a>
                                <input type="text" class="form-control" style="display: none" :value="tarea.nombre" :id="'titulo_tarea_hidden' + tarea.id" @keyup.enter="editarTarea(tarea, $event)">
                                <div class="kanban-badges">
                                    <div class="kanban-badge mb-2" v-if="tarea.total_comentarios > 0" :title="'# de Comentarios'">
                                        <i class="far fa-comment-alt"></i>
                                        <span class="badge-text">{{ tarea.total_comentarios }}</span>
                                    </div>
                                    <div class="kanban-badge mb-2" v-if="tarea.fecha_ven" :title="'Fecha de Vencimiento'">
                                        <i class="far fa-clock"></i>
                                        <span class="badge-text">{{ tarea.fecha_ven }}</span>
                                    </div>
                                    <div class="kanban-badge mb-2" v-if="Object.keys(tarea.cliente).length > 0" title="Cliente">
                                        <i class="far fa-user"></i>
                                        <span class="badge-text">{{ tarea.cliente.nombre }}</span>
                                    </div>
                                    <div v-if="tarea.check.total > 0" class="kanban-badge" :class="[(tarea.check.listos == tarea.check.total) ? 'bg-success': '']" :title="'# de tareas completadas'">
                                        <i class="far fa-check-square"></i>
                                        <span class="badge-text">{{ tarea.check.listos }}/{{ tarea.check.total }}</span>
                                    </div>
                                </div>
                                <div class="kanban-edit">
                                    <i class="fa fa-pencil-alt" @click="preEditarTarea(tarea)" :title="'Editar Título'"></i>
                                </div>
                                <div class="kanban-borrar">
                                    <i class="fa fa-trash" @click="eliminarTarea(tarea, lista)" :title="'Eliminar'"></i>
                                </div>
                            </div>
                        </main>
                    </div>
                    <div class="my-2 kanban-board" style="display: inline-block; background-color: hsla(0,0%,100%,.24);">
                        <header class="kanban-board-header success">
                            <div class="kanban-title-board"><i class="fa fa-plus"></i> Añada otra lista</div>
                        </header>
                        <main class="kanban-drag">
                            <input type="text" class="form-control" id="nueva_lista" v-model="nueva_lista" @keyup.enter="agregarLista" placeholder="Introduzca el título de la lista...">
                        </main>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modal_tarjeta_tarea.php' ?>
    <?php include 'modal_correo.php' ?>
    <div class="quick-sidebar">
        <a href="#" class="close-quick-sidebar">
            <i class="flaticon-cross"></i>
        </a>
        <div class="quick-sidebar-wrapper">
            <ul class="nav nav-tabs nav-line nav-color-secondary" role="tablist">
                <li class="nav-item"> <a class="nav-link nav-link active show" data-toggle="tab" href="#tasks" role="tab" aria-selected="true">Historial de Eventos del Tablero</a></li>
                <!--<li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#settings" role="tab" aria-selected="false">Acciones</a></li>-->
            </ul>
            <div class="tab-content mt-3">
                <div class="tab-pane fade show active" id="tasks" role="tabpanel">
                    <div class="quick-wrapper tasks-wrapper">
                        <div class="scroll scroll-scrolly_visible" style="max-height: 545px;">
                            <div class="tasks-content" v-for="row in historicoTablero">
                                <span class="category-title mt-0">{{ fechaHistorico(row.fecha) }}</span>
                                <div class="list-group list-group-messages list-group-flush p-0 m-0">
                                    <div class="list-group-item unread p-1 m-1 " v-for="actividad in row.actividades" style="border: 0px;">
                                        <div class="list-group-item-figure">
                                            <div class="avatar" :title="actividad.emp_nombre + ' ' + actividad.emp_apellido">
                                                <span class="avatar-title rounded-circle text-uppercase bg-info" style="width: 80%; height: 80%; font-size: 13px">{{ actividad.emp_nombre.charAt(0) }}{{ actividad.emp_apellido.charAt(0) }}</span>
                                            </div>
                                        </div>
                                        <div class="list-group-item-body pl-1">
                                            <small class="text-muted" v-html="actividad.descripcion"></small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="settings" role="tabpanel">
                    <div class="quick-wrapper settings-wrapper">
                        <div class="scroll-wrapper quick-scroll scrollbar-outer">
                            <div class="quick-scroll scrollbar-outer">
                                <div class="quick-content settings-content">
                                    <span class="category-title mt-0">General Settings</span>
                                    <ul class="settings-list">
                                        <li>
                                            <span class="item-label">Enable Notifications</span>
                                            <div class="item-control">
                                                <div class="toggle btn btn-primary btn-round" data-toggle="toggle" style="width: 0px; height: 0px;"><input type="checkbox" checked="" data-toggle="toggle" data-onstyle="primary" data-style="btn-round" data-size="">
                                                    <div class="toggle-group"><label class="btn btn-primary toggle-on">On</label><label class="btn btn-black active toggle-off">Off</label><span class="toggle-handle btn btn-black"></span></div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <span class="item-label">Signin with social media</span>
                                            <div class="item-control">
                                                <div class="toggle btn btn-black off btn-round" data-toggle="toggle" style="width: 0px; height: 0px;"><input type="checkbox" data-toggle="toggle" data-onstyle="primary" data-style="btn-round">
                                                    <div class="toggle-group"><label class="btn btn-primary toggle-on">On</label><label class="btn btn-black active toggle-off">Off</label><span class="toggle-handle btn btn-black"></span></div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <span class="item-label">Backup storage</span>
                                            <div class="item-control">
                                                <div class="toggle btn btn-black off btn-round" data-toggle="toggle" style="width: 0px; height: 0px;"><input type="checkbox" data-toggle="toggle" data-onstyle="primary" data-style="btn-round">
                                                    <div class="toggle-group"><label class="btn btn-primary toggle-on">On</label><label class="btn btn-black active toggle-off">Off</label><span class="toggle-handle btn btn-black"></span></div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <span class="item-label">SMS Alert</span>
                                            <div class="item-control">
                                                <div class="toggle btn btn-primary btn-round" data-toggle="toggle" style="width: 0px; height: 0px;"><input type="checkbox" checked="" data-toggle="toggle" data-onstyle="primary" data-style="btn-round">
                                                    <div class="toggle-group"><label class="btn btn-primary toggle-on">On</label><label class="btn btn-black active toggle-off">Off</label><span class="toggle-handle btn btn-black"></span></div>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?= asset('assets/moment.min.js') ?>"></script>
<script src="<?= asset('assets/js/plugin/sortable/sortable.min.js') ?>"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assetsvuejs/proyectos/listas.js') ?>"></script>