<?php

namespace App\Modelos;

use Core\Database;

class TablerosListasTareasComentarios extends Database
{
    protected $table    = 'app_tableros_listas_tareas_comentarios';
    protected $id       = 'com_id';

    public function obtenerComentarios(int $id_tarea)
    {
        return $this->consultar("SELECT com.com_id, com.com_descripcion, com.com_empid, info.einfo_nombres, info.einfo_apellidos, DATE_FORMAT(com.com_actualizado, '%d/%m/%y a las %h:%i %p') actualizado
        FROM app_tableros_listas_tareas_comentarios com
        JOIN app_empleados_info info on info.einfo_id = com.com_empid
        WHERE com.com_tarid = $id_tarea")->all();
    }

    public function cantidadDeComentarios($id_tarea)
    {
        return $this->consultar("SELECT *
        FROM app_tableros_listas_tareas_comentarios com
        WHERE com_tarid = $id_tarea")->count();
    }
}
